/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepository;
import com.bigdata.rdf.sail.QuadsTestCase;
import com.bigdata.rdf.sparql.ast.eval.service.OpenrdfNativeMockServiceFactory;
import com.bigdata.rdf.sparql.ast.service.ServiceFactory;
import com.bigdata.rdf.sparql.ast.service.ServiceRegistry;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Properties;
import java.util.UUID;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.repository.sail.SailRepositoryConnection;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;

public class TestTicket632
extends QuadsTestCase {
    public TestTicket632() {
    }

    public TestTicket632(String arg0) {
        super(arg0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testServiceWithBindingArg() throws Exception {
        URIImpl serviceURI = new URIImpl("http://www.bigdata.com/mockService/" + this.getName());
        LinkedList serviceSolutions = new LinkedList();
        ServiceRegistry.getInstance().add((URI)serviceURI, (ServiceFactory)new OpenrdfNativeMockServiceFactory(serviceSolutions));
        BigdataSail sail = this.getSail();
        try {
            this.executeQuery((URI)serviceURI, (SailRepository)new BigdataSailRepository(sail));
        }
        finally {
            ServiceRegistry.getInstance().remove((URI)serviceURI);
            sail.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeQuery(URI serviceUri, SailRepository repo) throws RepositoryException, MalformedQueryException, QueryEvaluationException, RDFParseException, IOException, RDFHandlerException {
        try {
            repo.initialize();
            SailRepositoryConnection conn = repo.getConnection();
            ValueFactory vf = conn.getValueFactory();
            conn.setAutoCommit(false);
            try {
                String query = "SELECT ?x { SERVICE <" + serviceUri.stringValue() + "> { ?x <u:1> ?bool1 } }";
                TupleQuery q = conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
                q.setBinding("bool1", (Value)vf.createLiteral(true));
                try (TupleQueryResult tqr = q.evaluate();){
                    tqr.hasNext();
                }
            }
            finally {
                conn.close();
            }
        }
        finally {
            repo.shutDown();
        }
    }

    @Override
    public Properties getProperties() {
        Properties properties = this.getOurDelegate().getProperties();
        properties.setProperty(BigdataSail.Options.NAMESPACE, "freshNamespace-" + UUID.randomUUID());
        return properties;
    }
}

