/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepository;
import com.bigdata.rdf.sail.BigdataSailRepositoryConnection;
import com.bigdata.rdf.sail.QuadsTestCase;
import com.bigdata.rdf.vocab.NoVocabulary;
import java.util.LinkedList;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.BNodeImpl;
import org.openrdf.model.impl.ContextStatementImpl;
import org.openrdf.model.impl.GraphImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.repository.sail.SailTupleQuery;
import org.openrdf.sail.Sail;
import org.openrdf.sail.memory.MemoryStore;

public class TestTicket647
extends QuadsTestCase {
    protected static final Logger log = Logger.getLogger(TestTicket647.class);

    @Override
    public Properties getProperties() {
        Properties props = super.getProperties();
        props.setProperty(BigdataSail.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        props.setProperty(BigdataSail.Options.VOCABULARY_CLASS, NoVocabulary.class.getName());
        props.setProperty(BigdataSail.Options.TRUTH_MAINTENANCE, "false");
        props.setProperty(BigdataSail.Options.JUSTIFY, "false");
        props.setProperty(BigdataSail.Options.TEXT_INDEX, "false");
        return props;
    }

    public TestTicket647() {
    }

    public TestTicket647(String arg0) {
        super(arg0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug() throws Exception {
        MemoryStore sesameSail = new MemoryStore();
        BigdataSail bigdataSail = this.getSail();
        String update = "INSERT DATA { <http://example.com/book1> a <http://example.com/Book> . <http://example.com/book2> a <http://example.com/Book> . <http://example.com/book3> a <http://example.com/Book> . }";
        String nested = "SELECT ?s WHERE {   SELECT ?s WHERE { ?s ?p ?o} LIMIT 1 }";
        String doubleNested = "SELECT ?s WHERE {   SELECT ?s WHERE {     SELECT ?s WHERE { ?s ?p ?o} LIMIT 1   } }";
        String tripleNested = "SELECT ?s WHERE {   SELECT ?s WHERE {   SELECT ?s WHERE {     SELECT ?s WHERE { ?s ?p ?o} LIMIT 1   }   } }";
        String query = "select ?a ?b ?c ?src where {       GRAPH ?sid {?a ?b ?c }       ?sid <http://example.com/source> ?src . } ";
        try {
            sesameSail.initialize();
            bigdataSail.initialize();
            SailRepository sesameRepo = new SailRepository((Sail)sesameSail);
            BigdataSailRepository bigdataRepo = new BigdataSailRepository(bigdataSail);
            URIImpl book1 = new URIImpl("http://example.com/book1");
            URIImpl book2 = new URIImpl("http://example.com/book2");
            URIImpl book3 = new URIImpl("http://example.com/book3");
            URIImpl book = new URIImpl("http://example.com/book");
            BNodeImpl sid1 = new BNodeImpl("sid1");
            BNodeImpl sid2 = new BNodeImpl("sid2");
            BNodeImpl sid3 = new BNodeImpl("sid3");
            URIImpl source = new URIImpl("http://example.com/source");
            URIImpl theSource = new URIImpl("http://example.com");
            GraphImpl data = new GraphImpl();
            data.add((Object)new ContextStatementImpl((Resource)book1, RDF.TYPE, (Value)book, (Resource)sid1));
            data.add((Object)new ContextStatementImpl((Resource)book2, RDF.TYPE, (Value)book, (Resource)sid2));
            data.add((Object)new ContextStatementImpl((Resource)book3, RDF.TYPE, (Value)book, (Resource)sid3));
            data.add((Resource)sid1, (URI)source, (Value)theSource, new Resource[0]);
            data.add((Resource)sid2, (URI)source, (Value)theSource, new Resource[0]);
            data.add((Resource)sid3, (URI)source, (Value)theSource, new Resource[0]);
            try (BigdataSailRepositoryConnection cxn = bigdataRepo.getConnection();){
                cxn.setAutoCommit(false);
                cxn.add((Iterable)data, new Resource[0]);
                cxn.commit();
            }
            LinkedList answer = new LinkedList();
            try (BigdataSailRepositoryConnection cxn = bigdataRepo.getReadOnlyConnection();){
                SailTupleQuery tupleQuery = (SailTupleQuery)cxn.prepareTupleQuery(QueryLanguage.SPARQL, "select ?a ?b ?c ?src where {       GRAPH ?sid {?a ?b ?c }       ?sid <http://example.com/source> ?src . } ");
                tupleQuery.setIncludeInferred(false);
                if (log.isInfoEnabled()) {
                    TupleQueryResult result = tupleQuery.evaluate();
                    log.info((Object)"bigdata results:");
                    if (!result.hasNext()) {
                        log.info((Object)"no results.");
                    }
                    while (result.hasNext()) {
                        log.info(result.next());
                    }
                }
            }
        }
        finally {
            bigdataSail.__tearDownUnitTest();
            sesameSail.shutDown();
        }
    }
}

