/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepository;
import com.bigdata.rdf.sail.QuadsTestCase;
import com.bigdata.rdf.vocab.NoVocabulary;
import java.util.LinkedList;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.openrdf.model.Resource;
import org.openrdf.model.Value;
import org.openrdf.model.impl.GraphImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.repository.sail.SailTupleQuery;
import org.openrdf.sail.Sail;
import org.openrdf.sail.memory.MemoryStore;

public class TestTicket669
extends QuadsTestCase {
    protected static final Logger log = Logger.getLogger(TestTicket669.class);

    @Override
    public Properties getProperties() {
        Properties props = super.getProperties();
        props.setProperty(BigdataSail.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        props.setProperty(BigdataSail.Options.VOCABULARY_CLASS, NoVocabulary.class.getName());
        props.setProperty(BigdataSail.Options.TRUTH_MAINTENANCE, "false");
        props.setProperty(BigdataSail.Options.JUSTIFY, "false");
        props.setProperty(BigdataSail.Options.TEXT_INDEX, "false");
        return props;
    }

    public TestTicket669() {
    }

    public TestTicket669(String arg0) {
        super(arg0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug() throws Exception {
        MemoryStore sesameSail = new MemoryStore();
        BigdataSail bigdataSail = this.getSail();
        String update = "INSERT DATA { <http://example.com/book1> a <http://example.com/Book> . <http://example.com/book2> a <http://example.com/Book> . <http://example.com/book3> a <http://example.com/Book> . }";
        String nested = "SELECT ?s WHERE {   SELECT ?s WHERE { ?s ?p ?o} LIMIT 1 }";
        String doubleNested = "SELECT ?s WHERE {   SELECT ?s WHERE {     SELECT ?s WHERE { ?s ?p ?o} LIMIT 1   } }";
        String query = "SELECT ?s WHERE {   SELECT ?s WHERE {     SELECT ?s WHERE { ?s ?p ?o} LIMIT 1   } }";
        try {
            TupleQueryResult result;
            SailTupleQuery tupleQuery;
            sesameSail.initialize();
            bigdataSail.initialize();
            SailRepository sesameRepo = new SailRepository((Sail)sesameSail);
            BigdataSailRepository bigdataRepo = new BigdataSailRepository(bigdataSail);
            URIImpl book1 = new URIImpl("http://example.com/book1");
            URIImpl book2 = new URIImpl("http://example.com/book2");
            URIImpl book3 = new URIImpl("http://example.com/book3");
            URIImpl book = new URIImpl("http://example.com/book");
            GraphImpl data = new GraphImpl();
            data.add((Resource)book1, RDF.TYPE, (Value)book, new Resource[0]);
            data.add((Resource)book2, RDF.TYPE, (Value)book, new Resource[0]);
            data.add((Resource)book3, RDF.TYPE, (Value)book, new Resource[0]);
            try (RepositoryConnection cxn = sesameRepo.getConnection();){
                cxn.setAutoCommit(false);
                cxn.add((Iterable)data, new Resource[0]);
                cxn.commit();
            }
            cxn = bigdataRepo.getConnection();
            try {
                cxn.setAutoCommit(false);
                cxn.add((Iterable)data, new Resource[0]);
                cxn.commit();
            }
            finally {
                cxn.close();
            }
            LinkedList<BindingSet> answer = new LinkedList<BindingSet>();
            try (RepositoryConnection cxn = sesameRepo.getConnection();){
                tupleQuery = (SailTupleQuery)cxn.prepareTupleQuery(QueryLanguage.SPARQL, "SELECT ?s WHERE {   SELECT ?s WHERE {     SELECT ?s WHERE { ?s ?p ?o} LIMIT 1   } }");
                tupleQuery.setIncludeInferred(false);
                result = tupleQuery.evaluate();
                if (log.isInfoEnabled()) {
                    log.info((Object)"sesame results:");
                    if (!result.hasNext()) {
                        log.info((Object)"no results.");
                    }
                }
                while (result.hasNext()) {
                    BindingSet bs = (BindingSet)result.next();
                    answer.add(bs);
                    if (!log.isInfoEnabled()) continue;
                    log.info((Object)bs);
                }
            }
            cxn = bigdataRepo.getReadOnlyConnection();
            try {
                tupleQuery = (SailTupleQuery)cxn.prepareTupleQuery(QueryLanguage.SPARQL, "SELECT ?s WHERE {   SELECT ?s WHERE {     SELECT ?s WHERE { ?s ?p ?o} LIMIT 1   } }");
                tupleQuery.setIncludeInferred(false);
                if (log.isInfoEnabled()) {
                    result = tupleQuery.evaluate();
                    log.info((Object)"bigdata results:");
                    if (!result.hasNext()) {
                        log.info((Object)"no results.");
                    }
                    while (result.hasNext()) {
                        log.info(result.next());
                    }
                }
                result = tupleQuery.evaluate();
                this.compare(result, answer);
            }
            finally {
                cxn.close();
            }
        }
        finally {
            bigdataSail.__tearDownUnitTest();
            sesameSail.shutDown();
        }
    }
}

