/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import com.bigdata.rdf.sail.BigdataSailRepository;
import com.bigdata.rdf.sail.QuadsTestCase;
import java.io.IOException;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.repository.sail.SailRepositoryConnection;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.sail.Sail;
import org.openrdf.sail.memory.MemoryStore;

public class TestTicket967
extends QuadsTestCase {
    public TestTicket967() {
    }

    public TestTicket967(String arg0) {
        super(arg0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug() throws Exception {
        this.executeTest(new SailRepository((Sail)new MemoryStore()));
        try {
            this.executeTest((SailRepository)new BigdataSailRepository(this.getSail()));
        }
        finally {
            this.getSail().__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeTest(SailRepository repo) throws RepositoryException, MalformedQueryException, QueryEvaluationException, RDFParseException, RDFHandlerException, IOException {
        try {
            repo.initialize();
            try (SailRepositoryConnection conn = repo.getConnection();){
                conn.setAutoCommit(false);
                ValueFactory vf = conn.getValueFactory();
                URI uri = vf.createURI("os:/elem/example");
                this.addDuringQueryExec((RepositoryConnection)conn, (Resource)uri, RDF.TYPE, (Value)vf.createURI("os:class/Clazz"), new Resource[0]);
                try (RepositoryResult stats = conn.getStatements(null, null, null, false, new Resource[0]);){
                    stats.next();
                }
                conn.rollback();
            }
        }
        finally {
            repo.shutDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDuringQueryExec(RepositoryConnection conn, Resource subj, URI pred, Value obj, Resource ... ctx) throws RepositoryException, MalformedQueryException, QueryEvaluationException {
        TupleQuery tq = conn.prepareTupleQuery(QueryLanguage.SPARQL, "select distinct ?s ?p ?o where{?s ?p ?t . ?t <http://www.w3.org/2000/01/rdf-schema#subClassOf> ?o }");
        tq.setBinding("s", (Value)subj);
        tq.setBinding("p", (Value)pred);
        tq.setBinding("o", obj);
        try (TupleQueryResult tqr = tq.evaluate();){
            if (!tqr.hasNext()) {
                conn.add(subj, pred, obj, ctx);
            }
        }
    }
}

