/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepository;
import com.bigdata.rdf.sail.BigdataSailRepositoryConnection;
import com.bigdata.rdf.sail.QuadsTestCase;
import info.aduna.xml.XMLWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.BNodeImpl;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.impl.BindingImpl;
import org.openrdf.query.resultio.sparqlxml.SPARQLResultsXMLWriter;

public class TestUnions
extends QuadsTestCase {
    protected static final Logger log = Logger.getLogger(TestUnions.class);
    final String DC10 = "http://purl.org/dc/elements/1.0/";
    final String DC11 = "http://purl.org/dc/elements/1.1/";
    final URI DC10_TITLE = new URIImpl("http://purl.org/dc/elements/1.0/title");
    final URI DC10_CREATOR = new URIImpl("http://purl.org/dc/elements/1.0/creator");
    final URI DC11_TITLE = new URIImpl("http://purl.org/dc/elements/1.1/title");
    final URI DC11_CREATOR = new URIImpl("http://purl.org/dc/elements/1.1/creator");

    public TestUnions() {
    }

    public TestUnions(String arg0) {
        super(arg0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUnions() throws Exception {
        BigdataSail sail = this.getSail();
        sail.initialize();
        BigdataSailRepository repo = new BigdataSailRepository(sail);
        BigdataSailRepositoryConnection cxn = repo.getConnection();
        cxn.setAutoCommit(false);
        try {
            BNodeImpl a = new BNodeImpl("_:a");
            BNodeImpl b = new BNodeImpl("_:b");
            BNodeImpl c = new BNodeImpl("_:c");
            cxn.add((Resource)a, this.DC10_TITLE, (Value)new LiteralImpl("A"), new Resource[0]);
            cxn.add((Resource)a, this.DC10_CREATOR, (Value)new LiteralImpl("A"), new Resource[0]);
            cxn.add((Resource)b, this.DC11_TITLE, (Value)new LiteralImpl("B"), new Resource[0]);
            cxn.add((Resource)b, this.DC11_CREATOR, (Value)new LiteralImpl("B"), new Resource[0]);
            cxn.add((Resource)c, this.DC10_TITLE, (Value)new LiteralImpl("C"), new Resource[0]);
            cxn.add((Resource)c, this.DC11_CREATOR, (Value)new LiteralImpl("C"), new Resource[0]);
            cxn.commit();
            if (log.isInfoEnabled()) {
                log.info((Object)cxn.getTripleStore().dumpStore());
            }
            String query = "SELECT ?title ?creator WHERE {   { ?book <" + this.DC10_TITLE + "> ?title . " + "    ?book <" + this.DC10_CREATOR + "> ?creator . " + "  } " + "  UNION " + "  { ?book <" + this.DC11_TITLE + "> ?title ." + "    ?book <" + this.DC11_CREATOR + "> ?creator . " + "  } " + "}";
            TupleQuery tupleQuery = cxn.prepareTupleQuery(QueryLanguage.SPARQL, query);
            tupleQuery.setIncludeInferred(true);
            TupleQueryResult result = tupleQuery.evaluate();
            LinkedList<BindingSet> answer = new LinkedList<BindingSet>();
            answer.add(this.createBindingSet(new Binding[]{new BindingImpl("title", (Value)new LiteralImpl("A")), new BindingImpl("creator", (Value)new LiteralImpl("A"))}));
            answer.add(this.createBindingSet(new Binding[]{new BindingImpl("title", (Value)new LiteralImpl("B")), new BindingImpl("creator", (Value)new LiteralImpl("B"))}));
            this.compare(result, answer);
        }
        finally {
            cxn.close();
            sail.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSesameFilters() throws Exception {
        BigdataSail sail = this.getSail();
        sail.initialize();
        BigdataSailRepository repo = new BigdataSailRepository(sail);
        BigdataSailRepositoryConnection cxn = repo.getConnection();
        cxn.setAutoCommit(false);
        try {
            URIImpl jack = new URIImpl("_:Jack");
            URIImpl jill = new URIImpl("_:Jill");
            URIImpl person = new URIImpl("_:Person");
            URIImpl age = new URIImpl("_:age");
            URIImpl integer = new URIImpl("http://www.w3.org/2001/XMLSchema#integer");
            cxn.add((Resource)jack, RDF.TYPE, (Value)person, new Resource[0]);
            cxn.add((Resource)jill, RDF.TYPE, (Value)person, new Resource[0]);
            cxn.add((Resource)jack, (URI)age, (Value)new LiteralImpl("40", (URI)integer), new Resource[0]);
            cxn.add((Resource)jill, (URI)age, (Value)new LiteralImpl("30", (URI)integer), new Resource[0]);
            cxn.flush();
            log.info((Object)"hello");
            if (log.isInfoEnabled()) {
                log.info((Object)cxn.getTripleStore().dumpStore());
            }
            String query = "SELECT * WHERE {   {     ?x <" + RDF.TYPE + "> <" + person + "> . " + "    ?x <" + age + "> ?age1 . " + "    FILTER( ?age1 > 35 ) . " + "  } " + "  UNION " + "  { " + "    ?x <" + RDF.TYPE + "> <" + person + "> . " + "    ?x <" + age + "> ?age2 . " + "    FILTER( ?age2 > 25 ) . " + "  } " + "}";
            StringWriter sw = new StringWriter();
            TupleQuery tupleQuery = cxn.prepareTupleQuery(QueryLanguage.SPARQL, query);
            tupleQuery.setIncludeInferred(true);
            tupleQuery.evaluate((TupleQueryResultHandler)new SPARQLResultsXMLWriter(new XMLWriter((Writer)sw)));
            if (log.isInfoEnabled()) {
                log.info((Object)sw.toString());
            }
        }
        finally {
            cxn.close();
            sail.__tearDownUnitTest();
        }
    }
}

