/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.graph;

import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepository;
import com.bigdata.rdf.sail.BigdataSailRepositoryConnection;
import com.bigdata.rdf.sail.ProxyBigdataSailTestCase;
import com.bigdata.rdf.vocab.NoVocabulary;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.openrdf.model.Resource;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.rio.RDFFormat;

public class TestPaths
extends ProxyBigdataSailTestCase {
    protected static final Logger log = Logger.getLogger(TestPaths.class);
    protected static final boolean INFO = log.isInfoEnabled();

    @Override
    public Properties getProperties() {
        Properties props = super.getProperties();
        props.setProperty(BigdataSail.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        props.setProperty(BigdataSail.Options.VOCABULARY_CLASS, NoVocabulary.class.getName());
        props.setProperty(BigdataSail.Options.TRUTH_MAINTENANCE, "false");
        props.setProperty(BigdataSail.Options.JUSTIFY, "false");
        props.setProperty(BigdataSail.Options.TEXT_INDEX, "false");
        return props;
    }

    public TestPaths() {
    }

    public TestPaths(String arg0) {
        super(arg0);
    }

    protected void load(BigdataSailRepositoryConnection cxn, String resource) throws Exception {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(resource);
        cxn.add(is, "", RDFFormat.TURTLE, new Resource[0]);
    }

    protected InputStream open(String resource) throws Exception {
        return ((Object)((Object)this)).getClass().getResourceAsStream(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSimpleSSSP() throws Exception {
        BigdataSail sail = this.getSail();
        sail.initialize();
        BigdataSailRepository repo = new BigdataSailRepository(sail);
        BigdataSailRepositoryConnection cxn = repo.getConnection();
        cxn.setAutoCommit(false);
        try {
            cxn.add(this.open("sssp.ttl"), "", RDFFormat.TURTLE, new Resource[0]);
            cxn.commit();
            log.trace((Object)("\n" + cxn.getTripleStore().dumpStore()));
            String query = IOUtils.toString((InputStream)this.open("sssp.rq"));
            log.trace((Object)("\n" + query));
            TupleQuery tqr = cxn.prepareTupleQuery(QueryLanguage.SPARQL, query);
            TupleQueryResult result = tqr.evaluate();
            while (result.hasNext()) {
                log.trace(result.next());
            }
            result.close();
        }
        finally {
            cxn.close();
            sail.__tearDownUnitTest();
        }
    }
}

