/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.sparql;

import com.bigdata.journal.BufferMode;
import com.bigdata.journal.IIndexManager;
import com.bigdata.journal.Journal;
import com.bigdata.journal.Options;
import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.sail.sparql.Bigdata2ASTSPARQLParser;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.LocalTripleStore;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.parser.ParsedOperation;
import org.openrdf.query.parser.sparql.manifest.SPARQL11SyntaxTest;

public class Bigdata2ASTSPARQL11SyntaxTest
extends SPARQL11SyntaxTest {
    private static final boolean useBigdataParser = true;
    private AbstractTripleStore tripleStore;
    private static final Collection<String> knownBadTests = Arrays.asList("http://www.w3.org/2009/sparql/docs/tests/data-sparql11/syntax-query/manifest#test_60", "http://www.w3.org/2009/sparql/docs/tests/data-sparql11/syntax-query/manifest#test_61a", "http://www.w3.org/2009/sparql/docs/tests/data-sparql11/syntax-query/manifest#test_62a", "http://www.w3.org/2009/sparql/docs/tests/data-sparql11/syntax-query/manifest#test_65", "http://www.w3.org/2009/sparql/docs/tests/data-sparql11/syntax-update-1/manifest#test_25", "http://www.w3.org/2009/sparql/docs/tests/data-sparql11/syntax-update-1/manifest#test_31", "http://www.w3.org/2009/sparql/docs/tests/data-sparql11/syntax-update-1/manifest#test_54");

    public Bigdata2ASTSPARQL11SyntaxTest(String testURI, String name, String queryFileURL, boolean positiveTest) {
        super(testURI, name, queryFileURL, positiveTest);
    }

    protected Properties getProperties() {
        Properties properties = new Properties();
        properties.setProperty(AbstractTripleStore.Options.QUADS, "true");
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        properties.setProperty(Options.BUFFER_MODE, BufferMode.Transient.toString());
        return properties;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.tripleStore = this.getStore(this.getProperties());
    }

    protected AbstractTripleStore getStore(Properties properties) {
        String namespace = "kb";
        Journal journal = new Journal(properties);
        LocalTripleStore lts = new LocalTripleStore((IIndexManager)journal, "kb", Long.valueOf(0L), properties);
        lts.create();
        return lts;
    }

    protected void tearDown() throws Exception {
        if (this.tripleStore != null) {
            this.tripleStore.__tearDownUnitTest();
            this.tripleStore = null;
        }
        super.tearDown();
    }

    protected ParsedOperation parseOperation(String query, String queryFileURL) throws MalformedQueryException {
        try {
            return new Bigdata2ASTSPARQLParser().parseOperation(query, queryFileURL);
        }
        catch (MalformedQueryException ex) {
            throw new MalformedQueryException((Object)((Object)ex) + ": query=" + query + ", queryFileURL=" + queryFileURL, (Throwable)ex);
        }
    }

    public static Test suite() throws Exception {
        SPARQL11SyntaxTest.Factory factory = new SPARQL11SyntaxTest.Factory(){

            public SPARQL11SyntaxTest createSPARQLSyntaxTest(String testURI, String testName, String testAction, boolean positiveTest) {
                return new Bigdata2ASTSPARQL11SyntaxTest(testURI, testName, testAction, positiveTest);
            }
        };
        TestSuite suite = new TestSuite();
        suite.addTest(SPARQL11SyntaxTest.suite((SPARQL11SyntaxTest.Factory)factory, (boolean)false));
        suite = Bigdata2ASTSPARQL11SyntaxTest.filterOutTests(suite, knownBadTests);
        return suite;
    }

    static TestSuite filterOutTests(TestSuite suite1, Collection<String> testURIs) {
        TestSuite suite2 = new TestSuite(suite1.getName());
        Enumeration e = suite1.tests();
        while (e.hasMoreElements()) {
            Test aTest = (Test)e.nextElement();
            if (aTest instanceof TestSuite) {
                TestSuite aTestSuite = (TestSuite)aTest;
                suite2.addTest((Test)Bigdata2ASTSPARQL11SyntaxTest.filterOutTests(aTestSuite, testURIs));
                continue;
            }
            if (!(aTest instanceof Bigdata2ASTSPARQL11SyntaxTest)) continue;
            Bigdata2ASTSPARQL11SyntaxTest test = (Bigdata2ASTSPARQL11SyntaxTest)aTest;
            if (testURIs.contains(test.testURI)) continue;
            suite2.addTest((Test)test);
        }
        return suite2;
    }
}

