/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.sparql;

import com.bigdata.journal.BufferMode;
import com.bigdata.journal.IIndexManager;
import com.bigdata.journal.Journal;
import com.bigdata.journal.Options;
import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.sail.sparql.Bigdata2ASTSPARQLParser;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.LocalTripleStore;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.parser.sparql.manifest.SPARQLSyntaxTest;

public class Bigdata2ASTSPARQLSyntaxTest
extends SPARQLSyntaxTest {
    private AbstractTripleStore tripleStore;

    public Bigdata2ASTSPARQLSyntaxTest(String testURI, String name, String queryFileURL, boolean positiveTest) {
        super(testURI, name, queryFileURL, positiveTest);
    }

    protected Properties getProperties() {
        Properties properties = new Properties();
        properties.setProperty(AbstractTripleStore.Options.QUADS, "true");
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        properties.setProperty(Options.BUFFER_MODE, BufferMode.Transient.toString());
        return properties;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.tripleStore = this.getStore(this.getProperties());
    }

    protected AbstractTripleStore getStore(Properties properties) {
        String namespace = "kb";
        Journal journal = new Journal(properties);
        LocalTripleStore lts = new LocalTripleStore((IIndexManager)journal, "kb", Long.valueOf(0L), properties);
        lts.create();
        return lts;
    }

    protected void tearDown() throws Exception {
        if (this.tripleStore != null) {
            this.tripleStore.__tearDownUnitTest();
            this.tripleStore = null;
        }
        super.tearDown();
    }

    protected void parseQuery(String query, String queryFileURL) throws MalformedQueryException {
        new Bigdata2ASTSPARQLParser().parseQuery(query, queryFileURL);
    }

    public static Test suite() throws Exception {
        SPARQLSyntaxTest.Factory factory = new SPARQLSyntaxTest.Factory(){

            public SPARQLSyntaxTest createSPARQLSyntaxTest(String testURI, String testName, String testAction, boolean positiveTest) {
                return new Bigdata2ASTSPARQLSyntaxTest(testURI, testName, testAction, positiveTest);
            }
        };
        TestSuite suite = new TestSuite();
        suite.addTest(SPARQLSyntaxTest.suite((SPARQLSyntaxTest.Factory)factory));
        return suite;
    }
}

