/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.sparql;

import com.bigdata.BigdataStatics;
import com.bigdata.rdf.sail.sparql.Bigdata2ASTSPARQLParser;
import com.bigdata.rdf.sparql.AbstractBigdataExprBuilderTestCase;
import org.openrdf.query.MalformedQueryException;

public class BigdataSPARQL2ASTParserTest
extends AbstractBigdataExprBuilderTestCase {
    private static final boolean useBigdataParser = true;

    public BigdataSPARQL2ASTParserTest() {
    }

    public BigdataSPARQL2ASTParserTest(String name) {
        super(name);
    }

    public void test_qname_escape_01() throws MalformedQueryException {
        if (!BigdataStatics.runKnownBadTests) {
            return;
        }
        String query = "PREFIX og: <http://ogp.me/ns#>\n SELECT * WHERE {\n    ?page og:audio\\:title ?title\n}";
        this.parseOperation("PREFIX og: <http://ogp.me/ns#>\n SELECT * WHERE {\n    ?page og:audio\\:title ?title\n}");
    }

    public void test_qname_escape_01b() throws MalformedQueryException {
        if (!BigdataStatics.runKnownBadTests) {
            return;
        }
        String query = "PREFIX og: <http://ogp.me/ns#>\nSELECT ( og:audio\\:title as ?x )WHERE {?page og:foo ?title}";
        this.parseOperation("PREFIX og: <http://ogp.me/ns#>\nSELECT ( og:audio\\:title as ?x )WHERE {?page og:foo ?title}");
    }

    public void test_qname_escape_02() throws MalformedQueryException {
        String query = "PREFIX og: <http://ogp.me/ns#>\nSELECT * WHERE { ?page og:audio%3Atitle ?title }";
        this.parseOperation("PREFIX og: <http://ogp.me/ns#>\nSELECT * WHERE { ?page og:audio%3Atitle ?title }");
    }

    public void test_syntax_update_01() throws MalformedQueryException {
        String query = "BASE <http://example/base#>\nPREFIX : <http://example/>\nLOAD <http://example.org/faraway>";
        this.parseOperation("BASE <http://example/base#>\nPREFIX : <http://example/>\nLOAD <http://example.org/faraway>");
    }

    public void test_agg08() throws MalformedQueryException {
        String query = "PREFIX : <http://www.example.org/>\nSELECT ((?O1 + ?O2) AS ?O12) (COUNT(?O1) AS ?C)\nWHERE { ?S :p ?O1; :q ?O2 } GROUP BY (?O1 + ?O2)\nORDER BY ?O12";
        this.negativeTest("PREFIX : <http://www.example.org/>\nSELECT ((?O1 + ?O2) AS ?O12) (COUNT(?O1) AS ?C)\nWHERE { ?S :p ?O1; :q ?O2 } GROUP BY (?O1 + ?O2)\nORDER BY ?O12");
    }

    public void test_agg09() throws MalformedQueryException {
        String query = "PREFIX : <http://www.example.org/>\nSELECT ?P (COUNT(?O) AS ?C)\nWHERE { ?S ?P ?O } GROUP BY ?S";
        this.negativeTest("PREFIX : <http://www.example.org/>\nSELECT ?P (COUNT(?O) AS ?C)\nWHERE { ?S ?P ?O } GROUP BY ?S");
    }

    public void test_agg10() throws MalformedQueryException {
        String query = "PREFIX : <http://www.example.org/>\nSELECT ?P (COUNT(?O) AS ?C)\nWHERE { ?S ?P ?O }";
        this.negativeTest("PREFIX : <http://www.example.org/>\nSELECT ?P (COUNT(?O) AS ?C)\nWHERE { ?S ?P ?O }");
    }

    public void test_agg11() throws MalformedQueryException {
        String query = "PREFIX : <http://www.example.org/>\nSELECT ((?O1 + ?O2) AS ?O12) (COUNT(?O1) AS ?C)\nWHERE { ?S :p ?O1; :q ?O2 } GROUP BY (?S)";
        this.negativeTest("PREFIX : <http://www.example.org/>\nSELECT ((?O1 + ?O2) AS ?O12) (COUNT(?O1) AS ?C)\nWHERE { ?S :p ?O1; :q ?O2 } GROUP BY (?S)");
    }

    public void test_agg12() throws MalformedQueryException {
        String query = "PREFIX : <http://www.example.org/>\nSELECT ?O1 (COUNT(?O2) AS ?C)\nWHERE { ?S :p ?O1; :q ?O2 } GROUP BY (?O1 + ?O2)";
        this.negativeTest("PREFIX : <http://www.example.org/>\nSELECT ?O1 (COUNT(?O2) AS ?C)\nWHERE { ?S :p ?O1; :q ?O2 } GROUP BY (?O1 + ?O2)");
    }

    public void test_group06() throws MalformedQueryException {
        String query = "PREFIX : <http://example/>\nSELECT ?s ?v\n{\n  ?s :p ?v .\n}\nGROUP BY ?s";
        this.negativeTest("PREFIX : <http://example/>\nSELECT ?s ?v\n{\n  ?s :p ?v .\n}\nGROUP BY ?s");
    }

    public void test_group07() throws MalformedQueryException {
        String query = "prefix lode: <http://linkedevents.org/ontology/>\nprefix dc: <http://purl.org/dc/elements/1.1/>\nprefix rdfs: <http://www.w3.org/2000/01/rdf-schema#>\nselect ?event ?eventName ?venue ?photo\nwhere {\n   ?photo lode:illustrate ?event .\n   {\n   select ?event ?eventName ?venue\n   where {\n         ?event dc:title ?eventName .\n         ?event lode:atPlace ?venue .\n         ?venue rdfs:label \"Live Music Hall\" .\n         }\n   }\n}\nGROUP BY ?event\n";
        this.negativeTest("prefix lode: <http://linkedevents.org/ontology/>\nprefix dc: <http://purl.org/dc/elements/1.1/>\nprefix rdfs: <http://www.w3.org/2000/01/rdf-schema#>\nselect ?event ?eventName ?venue ?photo\nwhere {\n   ?photo lode:illustrate ?event .\n   {\n   select ?event ?eventName ?venue\n   where {\n         ?event dc:title ?eventName .\n         ?event lode:atPlace ?venue .\n         ?venue rdfs:label \"Live Music Hall\" .\n         }\n   }\n}\nGROUP BY ?event\n");
    }

    public void test_syn_bad_01() throws MalformedQueryException {
        String query = "SELECT * { ?s ?p ?o } GROUP BY ?s";
        this.negativeTest("SELECT * { ?s ?p ?o } GROUP BY ?s");
    }

    public void test_syn_bad_02() throws MalformedQueryException {
        String query = "SELECT ?o { ?s ?p ?o } GROUP BY ?s";
        this.negativeTest("SELECT ?o { ?s ?p ?o } GROUP BY ?s");
    }

    public void test_syn_bad_03() throws MalformedQueryException {
        String query = "SELECT (1 AS ?X) (1 AS ?X) {}";
        this.negativeTest("SELECT (1 AS ?X) (1 AS ?X) {}");
    }

    public void test_syntax_update_38() throws MalformedQueryException {
        String query = "# Empty\n";
        this.parseOperation("# Empty\n");
    }

    public void test_syntax_update_39() throws MalformedQueryException {
        String query = "BASE <http://example/>\n# Otherwise empty\n";
        this.parseOperation("BASE <http://example/>\n# Otherwise empty\n");
    }

    public void test_syntax_update_30() throws MalformedQueryException {
        String query = "PREFIX : <http://example/>\n# Otherwise empty\n";
        this.parseOperation("PREFIX : <http://example/>\n# Otherwise empty\n");
    }

    public void test_syntax_update_bad_03() throws MalformedQueryException {
        String query = "DELETE DATA { ?s <:p> <:o> }";
        this.negativeTest("DELETE DATA { ?s <:p> <:o> }");
    }

    public void test_syntax_update_bad_04() throws MalformedQueryException {
        String query = "INSERT DATA { GRAPH ?g {<:s> <:p> <:o> } }";
        this.negativeTest("INSERT DATA { GRAPH ?g {<:s> <:p> <:o> } }");
    }

    public void test_syntax_update_bad_08() throws MalformedQueryException {
        String query = "CREATE GRAPH <:g> ;; LOAD <:remote> into GRAPH <:g>";
        this.negativeTest("CREATE GRAPH <:g> ;; LOAD <:remote> into GRAPH <:g>");
    }

    public void test_syntax_update_bad_09() throws MalformedQueryException {
        String query = "CREATE GRAPH <:g> ; LOAD <:remote> into GRAPH <:g> ;;";
        this.negativeTest("CREATE GRAPH <:g> ; LOAD <:remote> into GRAPH <:g> ;;");
    }

    public void test_syntax_update_bad_10() throws MalformedQueryException {
        String query = "DELETE WHERE { _:a <:p> <:o> }";
        this.negativeTest("DELETE WHERE { _:a <:p> <:o> }");
    }

    private void negativeTest(String query) {
        try {
            this.parseOperation(query);
            BigdataSPARQL2ASTParserTest.fail((String)"Negative test - should fail");
        }
        catch (MalformedQueryException malformedQueryException) {
            // empty catch block
        }
    }

    private void parseOperation(String query) throws MalformedQueryException {
        new Bigdata2ASTSPARQLParser().parseOperation(query, this.baseURI);
    }
}

