/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.sparql;

import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.sail.sparql.PrefixDeclProcessor;
import com.bigdata.rdf.sail.sparql.ast.ParseException;
import com.bigdata.rdf.sail.sparql.ast.TokenMgrError;
import com.bigdata.rdf.sparql.AbstractBigdataExprBuilderTestCase;
import com.bigdata.rdf.sparql.ast.AssignmentNode;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.ConstructNode;
import com.bigdata.rdf.sparql.ast.DatasetNode;
import com.bigdata.rdf.sparql.ast.FunctionNode;
import com.bigdata.rdf.sparql.ast.FunctionRegistry;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.GroupByNode;
import com.bigdata.rdf.sparql.ast.HavingNode;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.IValueExpressionNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.OrderByExpr;
import com.bigdata.rdf.sparql.ast.OrderByNode;
import com.bigdata.rdf.sparql.ast.ProjectionNode;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.bigdata.rdf.sparql.ast.SliceNode;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.ValueExpressionNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.vocab.decls.FOAFVocabularyDecl;
import java.util.LinkedHashMap;
import org.openrdf.model.URI;
import org.openrdf.model.vocabulary.DC;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.query.Dataset;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.algebra.StatementPattern;
import org.openrdf.query.impl.DatasetImpl;

public class TestBigdataExprBuilder
extends AbstractBigdataExprBuilderTestCase {
    public TestBigdataExprBuilder() {
    }

    public TestBigdataExprBuilder(String name) {
        super(name);
    }

    public void test_select_s_where_s_p_o() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "select ?s where {?s ?p ?o}";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        LinkedHashMap prefixDecls = new LinkedHashMap(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("s"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        expected.setWhereClause((GraphPatternGroup)whereClause);
        QueryRoot actual = this.parse("select ?s where {?s ?p ?o}", this.baseURI);
        TestBigdataExprBuilder.assertSameAST((String)"select ?s where {?s ?p ?o}", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_select_distinct() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "select DISTINCT ?s where {?s ?p ?o}";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        LinkedHashMap prefixDecls = new LinkedHashMap(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("s"));
        projection.setDistinct(true);
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        expected.setWhereClause((GraphPatternGroup)whereClause);
        QueryRoot actual = this.parse("select DISTINCT ?s where {?s ?p ?o}", this.baseURI);
        TestBigdataExprBuilder.assertSameAST((String)"select DISTINCT ?s where {?s ?p ?o}", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_select_reduced() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "select REDUCED ?s where {?s ?p ?o}";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        LinkedHashMap prefixDecls = new LinkedHashMap(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("s"));
        projection.setReduced(true);
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        expected.setWhereClause((GraphPatternGroup)whereClause);
        QueryRoot actual = this.parse("select REDUCED ?s where {?s ?p ?o}", this.baseURI);
        TestBigdataExprBuilder.assertSameAST((String)"select REDUCED ?s where {?s ?p ?o}", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_groupBy_bareVar() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "SELECT ?s where {?s ?p ?o} GROUP BY ?o";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        LinkedHashMap prefixDecls = new LinkedHashMap(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("s"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        GroupByNode groupBy = new GroupByNode();
        expected.setGroupBy(groupBy);
        groupBy.addExpr((IValueExpressionNode)new AssignmentNode(new VarNode("o"), (IValueExpressionNode)new VarNode("o")));
    }

    public void test_groupBy_bindExpr() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "SELECT ?s where {?s ?p ?o} GROUP BY (?o AS ?z)";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        LinkedHashMap prefixDecls = new LinkedHashMap(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("s"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        GroupByNode groupBy = new GroupByNode();
        expected.setGroupBy(groupBy);
        groupBy.addExpr((IValueExpressionNode)new AssignmentNode(new VarNode("z"), (IValueExpressionNode)new VarNode("o")));
    }

    public void test_groupBy_functionCall() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "SELECT ?s where {?s ?p ?o} GROUP BY str(?o)";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        LinkedHashMap prefixDecls = new LinkedHashMap(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("s"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        GroupByNode groupBy = new GroupByNode();
        expected.setGroupBy(groupBy);
        FunctionNode funct = new FunctionNode(FunctionRegistry.STR, null, new ValueExpressionNode[]{new VarNode("o")});
        VarNode anonvar1 = new VarNode("-groupBy-1");
        anonvar1.setAnonymous(true);
        groupBy.addExpr((IValueExpressionNode)new AssignmentNode(anonvar1, (IValueExpressionNode)funct));
    }

    public void test_having() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "SELECT ?s where {?s ?p ?o} HAVING (?o > ?s)";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        LinkedHashMap prefixDecls = new LinkedHashMap(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("s"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        HavingNode having = new HavingNode();
        expected.setHaving(having);
        having.addExpr((IValueExpressionNode)new FunctionNode(FunctionRegistry.GT, null, new ValueExpressionNode[]{new VarNode("o"), new VarNode("s")}));
    }

    public void test_orderBy() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "SELECT ?s where {?s ?p ?o} ORDER BY DESC(?s)";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        LinkedHashMap prefixDecls = new LinkedHashMap(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("s"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        OrderByNode orderBy = new OrderByNode();
        expected.setOrderBy(orderBy);
        orderBy.addExpr(new OrderByExpr((IValueExpressionNode)new VarNode("s"), false));
        QueryRoot actual = this.parse("SELECT ?s where {?s ?p ?o} ORDER BY DESC(?s)", this.baseURI);
        TestBigdataExprBuilder.assertSameAST((String)"SELECT ?s where {?s ?p ?o} ORDER BY DESC(?s)", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_orderBy_expr() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "SELECT ?s where {?s ?p ?o} ORDER BY DESC(str(?s))";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        LinkedHashMap prefixDecls = new LinkedHashMap(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("s"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        OrderByNode orderBy = new OrderByNode();
        expected.setOrderBy(orderBy);
        FunctionNode funct = new FunctionNode(FunctionRegistry.STR, null, new ValueExpressionNode[]{new VarNode("s")});
        orderBy.addExpr(new OrderByExpr((IValueExpressionNode)funct, false));
        QueryRoot actual = this.parse("SELECT ?s where {?s ?p ?o} ORDER BY DESC(str(?s))", this.baseURI);
        TestBigdataExprBuilder.assertSameAST((String)"SELECT ?s where {?s ?p ?o} ORDER BY DESC(str(?s))", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_select_star() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "select * where {?s ?p ?o}";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        LinkedHashMap prefixDecls = new LinkedHashMap(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("*"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        expected.setWhereClause((GraphPatternGroup)whereClause);
        QueryRoot actual = this.parse("select * where {?s ?p ?o}", this.baseURI);
        TestBigdataExprBuilder.assertSameAST((String)"select * where {?s ?p ?o}", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_slice() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "select ?s where {?s ?p ?o} limit 10 offset 5";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        LinkedHashMap prefixDecls = new LinkedHashMap(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("s"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        expected.setWhereClause((GraphPatternGroup)whereClause);
        SliceNode slice = new SliceNode();
        expected.setSlice(slice);
        slice.setLimit(10L);
        slice.setOffset(5L);
        QueryRoot actual = this.parse("select ?s where {?s ?p ?o} limit 10 offset 5", this.baseURI);
        TestBigdataExprBuilder.assertSameAST((String)"select ?s where {?s ?p ?o} limit 10 offset 5", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_ask() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "ask where {?s ?p ?o}";
        QueryRoot expected = new QueryRoot(QueryType.ASK);
        LinkedHashMap prefixDecls = new LinkedHashMap(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        expected.setSlice(new SliceNode(0L, 1L));
        QueryRoot actual = this.parse("ask where {?s ?p ?o}", this.baseURI);
        TestBigdataExprBuilder.assertSameAST((String)"ask where {?s ?p ?o}", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_describe() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "describe ?s where {?s ?p ?o}";
        QueryRoot expected = new QueryRoot(QueryType.DESCRIBE);
        LinkedHashMap prefixDecls = new LinkedHashMap(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("s"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        QueryRoot actual = this.parse("describe ?s where {?s ?p ?o}", this.baseURI);
        TestBigdataExprBuilder.assertSameAST((String)"describe ?s where {?s ?p ?o}", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_describe_star() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "describe * where {?s ?p ?o}";
        QueryRoot expected = new QueryRoot(QueryType.DESCRIBE);
        LinkedHashMap prefixDecls = new LinkedHashMap(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("*"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        expected.setWhereClause((GraphPatternGroup)whereClause);
        QueryRoot actual = this.parse("describe * where {?s ?p ?o}", this.baseURI);
        TestBigdataExprBuilder.assertSameAST((String)"describe * where {?s ?p ?o}", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_describe_iri() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "describe <http://www.bigdata.com>";
        QueryRoot expected = new QueryRoot(QueryType.DESCRIBE);
        LinkedHashMap prefixDecls = new LinkedHashMap(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        expected.setProjection(projection);
        VarNode anonvar = new VarNode("-iri-1");
        anonvar.setAnonymous(true);
        projection.addProjectionExpression(new AssignmentNode(anonvar, (IValueExpressionNode)new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://www.bigdata.com")))));
        QueryRoot actual = this.parse("describe <http://www.bigdata.com>", this.baseURI);
        TestBigdataExprBuilder.assertSameAST((String)"describe <http://www.bigdata.com>", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_describe_vars_and_iris() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "describe ?s <http://www.bigdata.com> where {?s ?p ?o}";
        QueryRoot expected = new QueryRoot(QueryType.DESCRIBE);
        LinkedHashMap prefixDecls = new LinkedHashMap(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        expected.setProjection(projection);
        projection.addProjectionVar(new VarNode("s"));
        VarNode anonvar = new VarNode("-iri-1");
        anonvar.setAnonymous(true);
        projection.addProjectionExpression(new AssignmentNode(anonvar, (IValueExpressionNode)new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://www.bigdata.com")))));
        JoinGroupNode whereClause = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        expected.setWhereClause((GraphPatternGroup)whereClause);
        QueryRoot actual = this.parse("describe ?s <http://www.bigdata.com> where {?s ?p ?o}", this.baseURI);
        TestBigdataExprBuilder.assertSameAST((String)"describe ?s <http://www.bigdata.com> where {?s ?p ?o}", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_construct() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "construct { ?s ?p ?o } where {?s ?p ?o}";
        QueryRoot expected = new QueryRoot(QueryType.CONSTRUCT);
        LinkedHashMap prefixDecls = new LinkedHashMap(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        ConstructNode construct = new ConstructNode();
        expected.setConstruct(construct);
        construct.addChild(new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        QueryRoot actual = this.parse("construct { ?s ?p ?o } where {?s ?p ?o}", this.baseURI);
        TestBigdataExprBuilder.assertSameAST((String)"construct { ?s ?p ?o } where {?s ?p ?o}", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_construct_with_ground_terms() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "PREFIX rdf:  <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nconstruct { ?s rdf:type ?o }\nwhere {?s rdf:type ?o}";
        QueryRoot expected = new QueryRoot(QueryType.CONSTRUCT);
        LinkedHashMap<String, String> prefixDecls = new LinkedHashMap<String, String>(PrefixDeclProcessor.defaultDecls);
        prefixDecls.put("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        expected.setPrefixDecls(prefixDecls);
        ConstructNode construct = new ConstructNode();
        expected.setConstruct(construct);
        construct.addChild(new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI(RDF.TYPE.toString()))), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI(RDF.TYPE.toString()))), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        QueryRoot actual = this.parse("PREFIX rdf:  <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nconstruct { ?s rdf:type ?o }\nwhere {?s rdf:type ?o}", this.baseURI);
        TestBigdataExprBuilder.assertSameAST((String)"PREFIX rdf:  <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nconstruct { ?s rdf:type ?o }\nwhere {?s rdf:type ?o}", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_construct_where_shortcut() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "PREFIX rdf:  <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nconstruct where {?s rdf:type ?o}";
        QueryRoot expected = new QueryRoot(QueryType.CONSTRUCT);
        LinkedHashMap<String, String> prefixDecls = new LinkedHashMap<String, String>(PrefixDeclProcessor.defaultDecls);
        prefixDecls.put("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        expected.setPrefixDecls(prefixDecls);
        ConstructNode construct = new ConstructNode();
        expected.setConstruct(construct);
        construct.addChild(new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI(RDF.TYPE.toString()))), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI(RDF.TYPE.toString()))), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        QueryRoot actual = this.parse("PREFIX rdf:  <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nconstruct where {?s rdf:type ?o}", this.baseURI);
        TestBigdataExprBuilder.assertSameAST((String)"PREFIX rdf:  <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nconstruct where {?s rdf:type ?o}", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_from_and_from_named() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "PREFIX foaf: <http://xmlns.com/foaf/0.1/>\nPREFIX dc: <http://purl.org/dc/elements/1.1/>\nSELECT ?who ?g ?mbox\nFROM <http://example.org/dft.ttl>\nFROM NAMED <http://example.org/alice>\nFROM NAMED <http://example.org/bob>\nWHERE {\n    ?g dc:publisher ?who .\n    GRAPH ?g { ?x foaf:mbox ?mbox } \n}";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        LinkedHashMap<String, String> prefixDecls = new LinkedHashMap<String, String>(PrefixDeclProcessor.defaultDecls);
        prefixDecls.put("foaf", "http://xmlns.com/foaf/0.1/");
        prefixDecls.put("dc", "http://purl.org/dc/elements/1.1/");
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        expected.setProjection(projection);
        projection.addProjectionVar(new VarNode("who"));
        projection.addProjectionVar(new VarNode("g"));
        projection.addProjectionVar(new VarNode("mbox"));
        BigdataURI uri1 = this.valueFactory.createURI("http://example.org/dft.ttl");
        BigdataURI uri2 = this.valueFactory.createURI("http://example.org/alice");
        BigdataURI uri3 = this.valueFactory.createURI("http://example.org/bob");
        BigdataValue[] values = new BigdataValue[]{uri1, uri2, uri3};
        this.tripleStore.getLexiconRelation().addTerms(values, values.length, false);
        DatasetImpl dataset = new DatasetImpl();
        dataset.addDefaultGraph((URI)uri1);
        dataset.addNamedGraph((URI)uri2);
        dataset.addNamedGraph((URI)uri3);
        DatasetNode datasetNode = new DatasetNode((Dataset)dataset, false);
        expected.setDataset(datasetNode);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("g"), (TermNode)new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI(DC.PUBLISHER.toString()))), (TermNode)new VarNode("who"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        JoinGroupNode group = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)group);
        group.setContext((TermNode)new VarNode("g"));
        group.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI(FOAFVocabularyDecl.mbox.toString()))), (TermNode)new VarNode("mbox"), (TermNode)new VarNode("g"), StatementPattern.Scope.NAMED_CONTEXTS));
        QueryRoot actual = this.parse("PREFIX foaf: <http://xmlns.com/foaf/0.1/>\nPREFIX dc: <http://purl.org/dc/elements/1.1/>\nSELECT ?who ?g ?mbox\nFROM <http://example.org/dft.ttl>\nFROM NAMED <http://example.org/alice>\nFROM NAMED <http://example.org/bob>\nWHERE {\n    ?g dc:publisher ?who .\n    GRAPH ?g { ?x foaf:mbox ?mbox } \n}", this.baseURI);
        TestBigdataExprBuilder.assertSameAST((String)"PREFIX foaf: <http://xmlns.com/foaf/0.1/>\nPREFIX dc: <http://purl.org/dc/elements/1.1/>\nSELECT ?who ?g ?mbox\nFROM <http://example.org/dft.ttl>\nFROM NAMED <http://example.org/alice>\nFROM NAMED <http://example.org/bob>\nWHERE {\n    ?g dc:publisher ?who .\n    GRAPH ?g { ?x foaf:mbox ?mbox } \n}", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_from_and_from_named_with_unknown_graph() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "PREFIX foaf: <http://xmlns.com/foaf/0.1/>\nPREFIX dc: <http://purl.org/dc/elements/1.1/>\nSELECT ?who ?g ?mbox\nFROM <http://example.org/dft.ttl>\nFROM NAMED <http://example.org/alice>\nFROM NAMED <http://example.org/bob>\nWHERE {\n    ?g dc:publisher ?who .\n    GRAPH ?g { ?x foaf:mbox ?mbox } \n}";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        LinkedHashMap<String, String> prefixDecls = new LinkedHashMap<String, String>(PrefixDeclProcessor.defaultDecls);
        prefixDecls.put("foaf", "http://xmlns.com/foaf/0.1/");
        prefixDecls.put("dc", "http://purl.org/dc/elements/1.1/");
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        expected.setProjection(projection);
        projection.addProjectionVar(new VarNode("who"));
        projection.addProjectionVar(new VarNode("g"));
        projection.addProjectionVar(new VarNode("mbox"));
        BigdataURI uri1 = this.valueFactory.createURI("http://example.org/dft.ttl");
        BigdataURI uri2 = this.valueFactory.createURI("http://example.org/alice");
        BigdataURI uri3 = this.valueFactory.createURI("http://example.org/bob");
        BigdataValue[] values = new BigdataValue[]{uri1, uri2};
        this.tripleStore.getLexiconRelation().addTerms(values, values.length, false);
        DatasetImpl dataset = new DatasetImpl();
        dataset.addDefaultGraph((URI)uri1);
        dataset.addNamedGraph((URI)uri2);
        dataset.addNamedGraph((URI)uri3);
        DatasetNode datasetNode = new DatasetNode((Dataset)dataset, false);
        expected.setDataset(datasetNode);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("g"), (TermNode)new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI(DC.PUBLISHER.toString()))), (TermNode)new VarNode("who"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        JoinGroupNode group = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)group);
        group.setContext((TermNode)new VarNode("g"));
        group.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI(FOAFVocabularyDecl.mbox.toString()))), (TermNode)new VarNode("mbox"), (TermNode)new VarNode("g"), StatementPattern.Scope.NAMED_CONTEXTS));
        QueryRoot actual = this.parse("PREFIX foaf: <http://xmlns.com/foaf/0.1/>\nPREFIX dc: <http://purl.org/dc/elements/1.1/>\nSELECT ?who ?g ?mbox\nFROM <http://example.org/dft.ttl>\nFROM NAMED <http://example.org/alice>\nFROM NAMED <http://example.org/bob>\nWHERE {\n    ?g dc:publisher ?who .\n    GRAPH ?g { ?x foaf:mbox ?mbox } \n}", this.baseURI);
        TestBigdataExprBuilder.assertSameAST((String)"PREFIX foaf: <http://xmlns.com/foaf/0.1/>\nPREFIX dc: <http://purl.org/dc/elements/1.1/>\nSELECT ?who ?g ?mbox\nFROM <http://example.org/dft.ttl>\nFROM NAMED <http://example.org/alice>\nFROM NAMED <http://example.org/bob>\nWHERE {\n    ?g dc:publisher ?who .\n    GRAPH ?g { ?x foaf:mbox ?mbox } \n}", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_bnode_bracket_syntax_05() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "PREFIX foaf: <http://xmlns.com/foaf/0.1/>\n SELECT * {\n   [ foaf:name ?name ;\n     foaf:mbox <mailto:alice@example.org>\n   ]\n }";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        LinkedHashMap<String, String> prefixDecls = new LinkedHashMap<String, String>(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        prefixDecls.put("foaf", "http://xmlns.com/foaf/0.1/");
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("*"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        ConstantNode foaf_name = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI(FOAFVocabularyDecl.name.stringValue())));
        ConstantNode foaf_mbox = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI(FOAFVocabularyDecl.mbox.stringValue())));
        ConstantNode mailto = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("mailto:alice@example.org")));
        VarNode bnode = new VarNode("-anon-11");
        bnode.setAnonymous(true);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)bnode, (TermNode)foaf_name, (TermNode)new VarNode("name"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)bnode, (TermNode)foaf_mbox, (TermNode)mailto, null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        QueryRoot actual = this.parse("PREFIX foaf: <http://xmlns.com/foaf/0.1/>\n SELECT * {\n   [ foaf:name ?name ;\n     foaf:mbox <mailto:alice@example.org>\n   ]\n }", this.baseURI);
        TestBigdataExprBuilder.assertSameAST((String)"PREFIX foaf: <http://xmlns.com/foaf/0.1/>\n SELECT * {\n   [ foaf:name ?name ;\n     foaf:mbox <mailto:alice@example.org>\n   ]\n }", (IQueryNode)expected, (IQueryNode)actual);
    }
}

