/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.sparql;

import com.bigdata.bop.Constant;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.Var;
import com.bigdata.bop.bindingSet.ListBindingSet;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.sail.sparql.PrefixDeclProcessor;
import com.bigdata.rdf.sail.sparql.ast.ParseException;
import com.bigdata.rdf.sail.sparql.ast.TokenMgrError;
import com.bigdata.rdf.sail.sparql.ast.VisitorException;
import com.bigdata.rdf.sparql.AbstractBigdataExprBuilderTestCase;
import com.bigdata.rdf.sparql.ast.BindingsClause;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.ProjectionNode;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.util.InnerCause;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.algebra.StatementPattern;

public class TestBindingsClause
extends AbstractBigdataExprBuilderTestCase {
    private static final Logger log = Logger.getLogger(TestBindingsClause.class);

    public TestBindingsClause() {
    }

    public TestBindingsClause(String name) {
        super(name);
    }

    public void test_bindings_001() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "PREFIX :     <http://example.org/book/>\nSELECT ?title ?price\n{\n    ?book :title ?title ; \n          :price ?price . \n}\nBINDINGS ?book {\n  (:book1)\n}";
        IV title = this.makeIV((BigdataValue)this.valueFactory.createURI("http://example.org/book/title"));
        IV price = this.makeIV((BigdataValue)this.valueFactory.createURI("http://example.org/book/price"));
        IV book1 = this.makeIV((BigdataValue)this.valueFactory.createURI("http://example.org/book/book1"));
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        LinkedHashMap<String, String> prefixDecls = new LinkedHashMap<String, String>(PrefixDeclProcessor.defaultDecls);
        prefixDecls.put("", "http://example.org/book/");
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("title"));
        projection.addProjectionVar(new VarNode("price"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("book"), (TermNode)new ConstantNode((IConstant)new Constant((Object)title)), (TermNode)new VarNode("title"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("book"), (TermNode)new ConstantNode((IConstant)new Constant((Object)price)), (TermNode)new VarNode("price"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        LinkedHashSet<Var> declaredVars = new LinkedHashSet<Var>();
        declaredVars.add(Var.var((String)"book"));
        LinkedList<ListBindingSet> bindings = new LinkedList<ListBindingSet>();
        ListBindingSet bset = new ListBindingSet();
        bset.set((IVariable)Var.var((String)"book"), (IConstant)new Constant((Object)book1));
        bindings.add(bset);
        BindingsClause bindingsClause = new BindingsClause(declaredVars, bindings);
        expected.setBindingsClause(bindingsClause);
        QueryRoot actual = this.parse("PREFIX :     <http://example.org/book/>\nSELECT ?title ?price\n{\n    ?book :title ?title ; \n          :price ?price . \n}\nBINDINGS ?book {\n  (:book1)\n}", this.baseURI);
        TestBindingsClause.assertSameAST((String)"PREFIX :     <http://example.org/book/>\nSELECT ?title ?price\n{\n    ?book :title ?title ; \n          :price ?price . \n}\nBINDINGS ?book {\n  (:book1)\n}", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_bindings_002() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "PREFIX :     <http://example.org/book/>\nSELECT ?title ?price\n{\n    ?book :title ?title ; \n          :price ?price . \n}\nBINDINGS ?book {\n  (UNDEF)\n}";
        IV title = this.makeIV((BigdataValue)this.valueFactory.createURI("http://example.org/book/title"));
        IV price = this.makeIV((BigdataValue)this.valueFactory.createURI("http://example.org/book/price"));
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        LinkedHashMap<String, String> prefixDecls = new LinkedHashMap<String, String>(PrefixDeclProcessor.defaultDecls);
        prefixDecls.put("", "http://example.org/book/");
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("title"));
        projection.addProjectionVar(new VarNode("price"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("book"), (TermNode)new ConstantNode((IConstant)new Constant((Object)title)), (TermNode)new VarNode("title"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("book"), (TermNode)new ConstantNode((IConstant)new Constant((Object)price)), (TermNode)new VarNode("price"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        LinkedHashSet<Var> declaredVars = new LinkedHashSet<Var>();
        declaredVars.add(Var.var((String)"book"));
        LinkedList<ListBindingSet> bindings = new LinkedList<ListBindingSet>();
        ListBindingSet bset = new ListBindingSet();
        bindings.add(bset);
        BindingsClause bindingsClause = new BindingsClause(declaredVars, bindings);
        expected.setBindingsClause(bindingsClause);
        QueryRoot actual = this.parse("PREFIX :     <http://example.org/book/>\nSELECT ?title ?price\n{\n    ?book :title ?title ; \n          :price ?price . \n}\nBINDINGS ?book {\n  (UNDEF)\n}", this.baseURI);
        TestBindingsClause.assertSameAST((String)"PREFIX :     <http://example.org/book/>\nSELECT ?title ?price\n{\n    ?book :title ?title ; \n          :price ?price . \n}\nBINDINGS ?book {\n  (UNDEF)\n}", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_bindings_003() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "PREFIX :     <http://example.org/book/>\nSELECT ?title ?price\n{\n    ?book :title ?title ; \n          :price ?price . \n}\nBINDINGS ?book {\n  (:book1)\n  (UNDEF)\n}";
        IV title = this.makeIV((BigdataValue)this.valueFactory.createURI("http://example.org/book/title"));
        IV price = this.makeIV((BigdataValue)this.valueFactory.createURI("http://example.org/book/price"));
        IV book1 = this.makeIV((BigdataValue)this.valueFactory.createURI("http://example.org/book/book1"));
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        LinkedHashMap<String, String> prefixDecls = new LinkedHashMap<String, String>(PrefixDeclProcessor.defaultDecls);
        prefixDecls.put("", "http://example.org/book/");
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("title"));
        projection.addProjectionVar(new VarNode("price"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("book"), (TermNode)new ConstantNode((IConstant)new Constant((Object)title)), (TermNode)new VarNode("title"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("book"), (TermNode)new ConstantNode((IConstant)new Constant((Object)price)), (TermNode)new VarNode("price"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        LinkedHashSet<Var> declaredVars = new LinkedHashSet<Var>();
        declaredVars.add(Var.var((String)"book"));
        LinkedList<ListBindingSet> bindings = new LinkedList<ListBindingSet>();
        ListBindingSet bset = new ListBindingSet();
        bset.set((IVariable)Var.var((String)"book"), (IConstant)new Constant((Object)book1));
        bindings.add(bset);
        bset = new ListBindingSet();
        bindings.add(bset);
        BindingsClause bindingsClause = new BindingsClause(declaredVars, bindings);
        expected.setBindingsClause(bindingsClause);
        QueryRoot actual = this.parse("PREFIX :     <http://example.org/book/>\nSELECT ?title ?price\n{\n    ?book :title ?title ; \n          :price ?price . \n}\nBINDINGS ?book {\n  (:book1)\n  (UNDEF)\n}", this.baseURI);
        TestBindingsClause.assertSameAST((String)"PREFIX :     <http://example.org/book/>\nSELECT ?title ?price\n{\n    ?book :title ?title ; \n          :price ?price . \n}\nBINDINGS ?book {\n  (:book1)\n  (UNDEF)\n}", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_bindings_004() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "PREFIX :     <http://example.org/book/>\nSELECT ?title ?price\n{\n    ?book :title ?title ; \n          :price ?price . \n}\nBINDINGS ?book ?title {\n  (:book1 :title1)\n  (:book2   UNDEF)\n}";
        IV title = this.makeIV((BigdataValue)this.valueFactory.createURI("http://example.org/book/title"));
        IV price = this.makeIV((BigdataValue)this.valueFactory.createURI("http://example.org/book/price"));
        IV book1 = this.makeIV((BigdataValue)this.valueFactory.createURI("http://example.org/book/book1"));
        IV book2 = this.makeIV((BigdataValue)this.valueFactory.createURI("http://example.org/book/book2"));
        IV title1 = this.makeIV((BigdataValue)this.valueFactory.createURI("http://example.org/book/title1"));
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        LinkedHashMap<String, String> prefixDecls = new LinkedHashMap<String, String>(PrefixDeclProcessor.defaultDecls);
        prefixDecls.put("", "http://example.org/book/");
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("title"));
        projection.addProjectionVar(new VarNode("price"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("book"), (TermNode)new ConstantNode((IConstant)new Constant((Object)title)), (TermNode)new VarNode("title"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("book"), (TermNode)new ConstantNode((IConstant)new Constant((Object)price)), (TermNode)new VarNode("price"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        LinkedHashSet<Var> declaredVars = new LinkedHashSet<Var>();
        declaredVars.add(Var.var((String)"book"));
        declaredVars.add(Var.var((String)"title"));
        LinkedList<ListBindingSet> bindings = new LinkedList<ListBindingSet>();
        ListBindingSet bset = new ListBindingSet();
        bset.set((IVariable)Var.var((String)"book"), (IConstant)new Constant((Object)book1));
        bset.set((IVariable)Var.var((String)"title"), (IConstant)new Constant((Object)title1));
        bindings.add(bset);
        bset = new ListBindingSet();
        bset.set((IVariable)Var.var((String)"book"), (IConstant)new Constant((Object)book2));
        bindings.add(bset);
        BindingsClause bindingsClause = new BindingsClause(declaredVars, bindings);
        expected.setBindingsClause(bindingsClause);
        QueryRoot actual = this.parse("PREFIX :     <http://example.org/book/>\nSELECT ?title ?price\n{\n    ?book :title ?title ; \n          :price ?price . \n}\nBINDINGS ?book ?title {\n  (:book1 :title1)\n  (:book2   UNDEF)\n}", this.baseURI);
        TestBindingsClause.assertSameAST((String)"PREFIX :     <http://example.org/book/>\nSELECT ?title ?price\n{\n    ?book :title ?title ; \n          :price ?price . \n}\nBINDINGS ?book ?title {\n  (:book1 :title1)\n  (:book2   UNDEF)\n}", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_bindings_005() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "PREFIX :     <http://example.org/book/>\nSELECT ?title ?price\n{\n    ?book :title ?title ; \n          :price ?price . \n}\nBINDINGS {\n}";
        IV title = this.makeIV((BigdataValue)this.valueFactory.createURI("http://example.org/book/title"));
        IV price = this.makeIV((BigdataValue)this.valueFactory.createURI("http://example.org/book/price"));
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        LinkedHashMap<String, String> prefixDecls = new LinkedHashMap<String, String>(PrefixDeclProcessor.defaultDecls);
        prefixDecls.put("", "http://example.org/book/");
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("title"));
        projection.addProjectionVar(new VarNode("price"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("book"), (TermNode)new ConstantNode((IConstant)new Constant((Object)title)), (TermNode)new VarNode("title"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("book"), (TermNode)new ConstantNode((IConstant)new Constant((Object)price)), (TermNode)new VarNode("price"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        QueryRoot actual = this.parse("PREFIX :     <http://example.org/book/>\nSELECT ?title ?price\n{\n    ?book :title ?title ; \n          :price ?price . \n}\nBINDINGS {\n}", this.baseURI);
        TestBindingsClause.assertSameAST((String)"PREFIX :     <http://example.org/book/>\nSELECT ?title ?price\n{\n    ?book :title ?title ; \n          :price ?price . \n}\nBINDINGS {\n}", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_bindings_006() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "PREFIX :     <http://example.org/book/>\nSELECT ?title ?price\n{\n    ?book :title ?title ; \n          :price ?price . \n}\nBINDINGS {\n  (:book1)\n}";
        try {
            this.parse("PREFIX :     <http://example.org/book/>\nSELECT ?title ?price\n{\n    ?book :title ?title ; \n          :price ?price . \n}\nBINDINGS {\n  (:book1)\n}", this.baseURI);
            TestBindingsClause.fail((String)("Expecting: " + VisitorException.class));
        }
        catch (Throwable t) {
            if (InnerCause.isInnerCause((Throwable)t, VisitorException.class)) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Ignoring expected exception: " + t), t);
                }
                return;
            }
            TestBindingsClause.fail((String)("Expecting: " + VisitorException.class));
        }
    }

    public void test_bindings_007() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "PREFIX :     <http://example.org/book/>\nSELECT ?title ?price\n{\n    ?book :title ?title ; \n          :price ?price . \n}\nBINDINGS ?book ?book {\n  (:book1 :book2)\n}";
        try {
            this.parse("PREFIX :     <http://example.org/book/>\nSELECT ?title ?price\n{\n    ?book :title ?title ; \n          :price ?price . \n}\nBINDINGS ?book ?book {\n  (:book1 :book2)\n}", this.baseURI);
            TestBindingsClause.fail((String)("Expecting: " + VisitorException.class));
        }
        catch (Throwable t) {
            if (InnerCause.isInnerCause((Throwable)t, VisitorException.class)) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Ignoring expected exception: " + t), t);
                }
                return;
            }
            TestBindingsClause.fail((String)("Expecting: " + VisitorException.class));
        }
    }

    public void test_bindings_008() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "PREFIX :     <http://example.org/book/>\nSELECT ?title ?price\n{\n    ?book :title ?title ; \n          :price ?price . \n}\nBINDINGS ?book ?book {\n}";
        try {
            this.parse("PREFIX :     <http://example.org/book/>\nSELECT ?title ?price\n{\n    ?book :title ?title ; \n          :price ?price . \n}\nBINDINGS ?book ?book {\n}", this.baseURI);
            TestBindingsClause.fail((String)("Expecting: " + VisitorException.class));
        }
        catch (Throwable t) {
            if (InnerCause.isInnerCause((Throwable)t, VisitorException.class)) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Ignoring expected exception: " + t), t);
                }
                return;
            }
            TestBindingsClause.fail((String)("Expecting: " + VisitorException.class));
        }
    }

    public void test_bindings_009() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "PREFIX :     <http://example.org/book/>\nSELECT ?title ?price\n{\n    ?book :title ?title ; \n          :price ?price . \n}\nBINDINGS ?book {\n (:book1) \n (:book1 :book2) \n}";
        try {
            this.parse("PREFIX :     <http://example.org/book/>\nSELECT ?title ?price\n{\n    ?book :title ?title ; \n          :price ?price . \n}\nBINDINGS ?book {\n (:book1) \n (:book1 :book2) \n}", this.baseURI);
            TestBindingsClause.fail((String)("Expecting: " + VisitorException.class));
        }
        catch (Throwable t) {
            if (InnerCause.isInnerCause((Throwable)t, VisitorException.class)) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Ignoring expected exception: " + t), t);
                }
                return;
            }
            TestBindingsClause.fail((String)("Expecting: " + VisitorException.class));
        }
    }

    public void test_bindings_010() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "PREFIX :     <http://example.org/book/>\nSELECT ?title ?price\n{\n    ?book :title ?title ; \n          :price ?price . \n}\nBINDINGS ?book ?title {\n (:book1 :title1) \n (:book1) \n}";
        try {
            this.parse("PREFIX :     <http://example.org/book/>\nSELECT ?title ?price\n{\n    ?book :title ?title ; \n          :price ?price . \n}\nBINDINGS ?book ?title {\n (:book1 :title1) \n (:book1) \n}", this.baseURI);
            TestBindingsClause.fail((String)("Expecting: " + VisitorException.class));
        }
        catch (Throwable t) {
            if (InnerCause.isInnerCause((Throwable)t, VisitorException.class)) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Ignoring expected exception: " + t), t);
                }
                return;
            }
            TestBindingsClause.fail((String)("Expecting: " + VisitorException.class));
        }
    }
}

