/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.sparql;

import com.bigdata.bop.BOp;
import com.bigdata.rdf.internal.ILexiconConfiguration;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.XSD;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.sail.sparql.PrefixDeclProcessor;
import com.bigdata.rdf.sail.sparql.ast.ParseException;
import com.bigdata.rdf.sail.sparql.ast.TokenMgrError;
import com.bigdata.rdf.sparql.AbstractBigdataExprBuilderTestCase;
import com.bigdata.rdf.sparql.ast.AssignmentNode;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.FilterNode;
import com.bigdata.rdf.sparql.ast.FunctionNode;
import com.bigdata.rdf.sparql.ast.FunctionRegistry;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.IValueExpressionNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.ProjectionNode;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.UnionNode;
import com.bigdata.rdf.sparql.ast.ValueExpressionNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.service.ServiceNode;
import java.util.LinkedHashMap;
import org.openrdf.model.Value;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.algebra.StatementPattern;

public class TestGroupGraphPatternBuilder
extends AbstractBigdataExprBuilderTestCase {
    public TestGroupGraphPatternBuilder() {
    }

    public TestGroupGraphPatternBuilder(String name) {
        super(name);
    }

    public void test_empty_group() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "select ?s where { }";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        LinkedHashMap prefixDecls = new LinkedHashMap(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("s"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        QueryRoot actual = this.parse("select ?s where { }", this.baseURI);
        TestGroupGraphPatternBuilder.assertSameAST((String)"select ?s where { }", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_named_graph_pattern() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "select ?s where {GRAPH ?src {?s ?p ?o}}";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        LinkedHashMap prefixDecls = new LinkedHashMap(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("s"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        JoinGroupNode graphGroup = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)graphGroup);
        graphGroup.setContext((TermNode)new VarNode("src"));
        graphGroup.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), (TermNode)new VarNode("src"), StatementPattern.Scope.NAMED_CONTEXTS));
        QueryRoot actual = this.parse("select ?s where {GRAPH ?src {?s ?p ?o}}", this.baseURI);
        TestGroupGraphPatternBuilder.assertSameAST((String)"select ?s where {GRAPH ?src {?s ?p ?o}}", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_named_graph_pattern_graphConstant() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "select ?s where {GRAPH <http://www.bigdata.com> {?s ?p ?o}}";
        IV graphConst = this.makeIV((BigdataValue)this.valueFactory.createURI("http://www.bigdata.com"));
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        LinkedHashMap prefixDecls = new LinkedHashMap(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("s"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        JoinGroupNode graphGroup = new JoinGroupNode();
        graphGroup.setContext((TermNode)new ConstantNode(graphConst));
        graphGroup.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), (TermNode)new ConstantNode(graphConst), StatementPattern.Scope.NAMED_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)graphGroup);
        expected.setWhereClause((GraphPatternGroup)whereClause);
        QueryRoot actual = this.parse("select ?s where {GRAPH <http://www.bigdata.com> {?s ?p ?o}}", this.baseURI);
        TestGroupGraphPatternBuilder.assertSameAST((String)"select ?s where {GRAPH <http://www.bigdata.com> {?s ?p ?o}}", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_triple_pattern_with_simple_join_group() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "select ?s where {?s ?p ?o . { ?o ?p2 ?s } }";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        LinkedHashMap prefixDecls = new LinkedHashMap(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("s"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        JoinGroupNode joinGroup = new JoinGroupNode();
        joinGroup.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("o"), (TermNode)new VarNode("p2"), (TermNode)new VarNode("s"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)joinGroup);
        QueryRoot actual = this.parse("select ?s where {?s ?p ?o . { ?o ?p2 ?s } }", this.baseURI);
        TestGroupGraphPatternBuilder.assertSameAST((String)"select ?s where {?s ?p ?o . { ?o ?p2 ?s } }", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_triple_pattern_with_named_graph_group() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "select ?s where {?s ?p ?o . GRAPH ?src { ?o ?p2 ?s } }";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        LinkedHashMap prefixDecls = new LinkedHashMap(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("s"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        JoinGroupNode joinGroup = new JoinGroupNode();
        joinGroup.setContext((TermNode)new VarNode("src"));
        joinGroup.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("o"), (TermNode)new VarNode("p2"), (TermNode)new VarNode("s"), (TermNode)new VarNode("src"), StatementPattern.Scope.NAMED_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)joinGroup);
        QueryRoot actual = this.parse("select ?s where {?s ?p ?o . GRAPH ?src { ?o ?p2 ?s } }", this.baseURI);
        TestGroupGraphPatternBuilder.assertSameAST((String)"select ?s where {?s ?p ?o . GRAPH ?src { ?o ?p2 ?s } }", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_two_simple_join_groups() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "select ?s where { { ?s ?p ?o } .  { ?o ?p2 ?s } }";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        LinkedHashMap prefixDecls = new LinkedHashMap(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("s"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        JoinGroupNode group1 = new JoinGroupNode();
        JoinGroupNode group2 = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)group1);
        whereClause.addChild((IGroupMemberNode)group2);
        group1.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        group2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("o"), (TermNode)new VarNode("p2"), (TermNode)new VarNode("s"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        QueryRoot actual = this.parse("select ?s where { { ?s ?p ?o } .  { ?o ?p2 ?s } }", this.baseURI);
        TestGroupGraphPatternBuilder.assertSameAST((String)"select ?s where { { ?s ?p ?o } .  { ?o ?p2 ?s } }", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_union_two_groups() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "select ?s where {   {     ?s ?p ?o   } UNION {     ?o ?p2 ?s   } }";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        LinkedHashMap prefixDecls = new LinkedHashMap(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("s"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        UnionNode union = new UnionNode();
        whereClause.addChild((IGroupMemberNode)union);
        union.addChild(new JoinGroupNode((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS)));
        union.addChild(new JoinGroupNode((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("o"), (TermNode)new VarNode("p2"), (TermNode)new VarNode("s"), null, StatementPattern.Scope.DEFAULT_CONTEXTS)));
        QueryRoot actual = this.parse("select ?s where {   {     ?s ?p ?o   } UNION {     ?o ?p2 ?s   } }", this.baseURI);
        TestGroupGraphPatternBuilder.assertSameAST((String)"select ?s where {   {     ?s ?p ?o   } UNION {     ?o ?p2 ?s   } }", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_union_three_groups() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "select ?s where {   {     ?s ?p1 ?o   } UNION {     ?s ?p2 ?o   } UNION {     ?s ?p3 ?o   } }";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        VarNode s = new VarNode("s");
        VarNode p1 = new VarNode("p1");
        VarNode p2 = new VarNode("p2");
        VarNode p3 = new VarNode("p3");
        VarNode o = new VarNode("o");
        LinkedHashMap prefixDecls = new LinkedHashMap(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("s"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        UnionNode union1 = new UnionNode();
        whereClause.addChild((IGroupMemberNode)union1);
        union1.addChild(new JoinGroupNode((IGroupMemberNode)new StatementPatternNode((TermNode)s, (TermNode)p1, (TermNode)o, null, StatementPattern.Scope.DEFAULT_CONTEXTS)));
        union1.addChild(new JoinGroupNode((IGroupMemberNode)new StatementPatternNode((TermNode)s, (TermNode)p2, (TermNode)o, null, StatementPattern.Scope.DEFAULT_CONTEXTS)));
        union1.addChild(new JoinGroupNode((IGroupMemberNode)new StatementPatternNode((TermNode)s, (TermNode)p3, (TermNode)o, null, StatementPattern.Scope.DEFAULT_CONTEXTS)));
        QueryRoot actual = this.parse("select ?s where {   {     ?s ?p1 ?o   } UNION {     ?s ?p2 ?o   } UNION {     ?s ?p3 ?o   } }", this.baseURI);
        TestGroupGraphPatternBuilder.assertSameAST((String)"select ?s where {   {     ?s ?p1 ?o   } UNION {     ?s ?p2 ?o   } UNION {     ?s ?p3 ?o   } }", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_union_four_groups() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "select ?s where {   {     ?s ?p1 ?o   } UNION {     ?s ?p2 ?o   } UNION {     ?s ?p3 ?o   } UNION {     ?s ?p4 ?o   } }";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        VarNode s = new VarNode("s");
        VarNode p1 = new VarNode("p1");
        VarNode p2 = new VarNode("p2");
        VarNode p3 = new VarNode("p3");
        VarNode p4 = new VarNode("p4");
        VarNode o = new VarNode("o");
        LinkedHashMap prefixDecls = new LinkedHashMap(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("s"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        UnionNode union1 = new UnionNode();
        whereClause.addChild((IGroupMemberNode)union1);
        union1.addChild(new JoinGroupNode((IGroupMemberNode)new StatementPatternNode((TermNode)s, (TermNode)p1, (TermNode)o, null, StatementPattern.Scope.DEFAULT_CONTEXTS)));
        union1.addChild(new JoinGroupNode((IGroupMemberNode)new StatementPatternNode((TermNode)s, (TermNode)p2, (TermNode)o, null, StatementPattern.Scope.DEFAULT_CONTEXTS)));
        union1.addChild(new JoinGroupNode((IGroupMemberNode)new StatementPatternNode((TermNode)s, (TermNode)p3, (TermNode)o, null, StatementPattern.Scope.DEFAULT_CONTEXTS)));
        union1.addChild(new JoinGroupNode((IGroupMemberNode)new StatementPatternNode((TermNode)s, (TermNode)p4, (TermNode)o, null, StatementPattern.Scope.DEFAULT_CONTEXTS)));
        QueryRoot actual = this.parse("select ?s where {   {     ?s ?p1 ?o   } UNION {     ?s ?p2 ?o   } UNION {     ?s ?p3 ?o   } UNION {     ?s ?p4 ?o   } }", this.baseURI);
        TestGroupGraphPatternBuilder.assertSameAST((String)"select ?s where {   {     ?s ?p1 ?o   } UNION {     ?s ?p2 ?o   } UNION {     ?s ?p3 ?o   } UNION {     ?s ?p4 ?o   } }", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_union_two_groups_with_embedded_union() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "select ?s where {   {     ?s ?p1 ?o   } UNION {       {       ?s ?p2 ?o       } UNION {       ?s ?p3 ?o       }   } }";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        VarNode s = new VarNode("s");
        VarNode p1 = new VarNode("p1");
        VarNode p2 = new VarNode("p2");
        VarNode p3 = new VarNode("p3");
        VarNode o = new VarNode("o");
        LinkedHashMap prefixDecls = new LinkedHashMap(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("s"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        UnionNode union1 = new UnionNode();
        UnionNode union2 = new UnionNode();
        whereClause.addChild((IGroupMemberNode)union1);
        union1.addChild(new JoinGroupNode((IGroupMemberNode)new StatementPatternNode((TermNode)s, (TermNode)p1, (TermNode)o, null, StatementPattern.Scope.DEFAULT_CONTEXTS)));
        union1.addChild(new JoinGroupNode((IGroupMemberNode)union2));
        union2.addChild(new JoinGroupNode((IGroupMemberNode)new StatementPatternNode((TermNode)s, (TermNode)p2, (TermNode)o, null, StatementPattern.Scope.DEFAULT_CONTEXTS)));
        union2.addChild(new JoinGroupNode((IGroupMemberNode)new StatementPatternNode((TermNode)s, (TermNode)p3, (TermNode)o, null, StatementPattern.Scope.DEFAULT_CONTEXTS)));
        QueryRoot actual = this.parse("select ?s where {   {     ?s ?p1 ?o   } UNION {       {       ?s ?p2 ?o       } UNION {       ?s ?p3 ?o       }   } }", this.baseURI);
        TestGroupGraphPatternBuilder.assertSameAST((String)"select ?s where {   {     ?s ?p1 ?o   } UNION {       {       ?s ?p2 ?o       } UNION {       ?s ?p3 ?o       }   } }", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_minus() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "select ?s where {?s ?p ?o MINUS { ?o ?p2 ?s }}";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        LinkedHashMap prefixDecls = new LinkedHashMap(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("s"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        JoinGroupNode joinGroup = new JoinGroupNode();
        joinGroup.setMinus(true);
        joinGroup.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("o"), (TermNode)new VarNode("p2"), (TermNode)new VarNode("s"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)joinGroup);
        QueryRoot actual = this.parse("select ?s where {?s ?p ?o MINUS { ?o ?p2 ?s }}", this.baseURI);
        TestGroupGraphPatternBuilder.assertSameAST((String)"select ?s where {?s ?p ?o MINUS { ?o ?p2 ?s }}", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_join_with_optional_triple_pattern() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "select ?s where {?s ?p ?o OPTIONAL { ?o ?p2 ?s }}";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        LinkedHashMap prefixDecls = new LinkedHashMap(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("s"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        JoinGroupNode joinGroup = new JoinGroupNode();
        joinGroup.setOptional(true);
        joinGroup.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("o"), (TermNode)new VarNode("p2"), (TermNode)new VarNode("s"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)joinGroup);
        QueryRoot actual = this.parse("select ?s where {?s ?p ?o OPTIONAL { ?o ?p2 ?s }}", this.baseURI);
        TestGroupGraphPatternBuilder.assertSameAST((String)"select ?s where {?s ?p ?o OPTIONAL { ?o ?p2 ?s }}", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_simple_triple_pattern_with_filter() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "select ?s where {?s ?p ?o . FILTER (?s = ?o) }";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        LinkedHashMap prefixDecls = new LinkedHashMap(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("s"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        FunctionNode ve = new FunctionNode(FunctionRegistry.EQ, null, new ValueExpressionNode[]{new VarNode("s"), new VarNode("o")});
        whereClause.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)ve));
        QueryRoot actual = this.parse("select ?s where {?s ?p ?o . FILTER (?s = ?o) }", this.baseURI);
        TestGroupGraphPatternBuilder.assertSameAST((String)"select ?s where {?s ?p ?o . FILTER (?s = ?o) }", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_empty_group_with_filter() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "select * where { FILTER (?a >= \"1\"^^xsd:unsignedLong) FILTER (?b >= \"1\"^^xsd:unsignedLong) }";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        LinkedHashMap prefixDecls = new LinkedHashMap(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("*"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        ILexiconConfiguration lexiconConfiguration = this.tripleStore.getLexiconRelation().getLexiconConfiguration();
        FunctionNode ve1 = new FunctionNode(FunctionRegistry.GE, null, new ValueExpressionNode[]{new VarNode("a"), new ConstantNode(lexiconConfiguration.createInlineIV((Value)new LiteralImpl("1", XSD.UNSIGNED_LONG)))});
        whereClause.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)ve1));
        FunctionNode ve2 = new FunctionNode(FunctionRegistry.GE, null, new ValueExpressionNode[]{new VarNode("b"), new ConstantNode(lexiconConfiguration.createInlineIV((Value)new LiteralImpl("1", XSD.UNSIGNED_LONG)))});
        whereClause.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)ve2));
        QueryRoot actual = this.parse("select * where { FILTER (?a >= \"1\"^^xsd:unsignedLong) FILTER (?b >= \"1\"^^xsd:unsignedLong) }", this.baseURI);
        TestGroupGraphPatternBuilder.assertSameAST((String)"select * where { FILTER (?a >= \"1\"^^xsd:unsignedLong) FILTER (?b >= \"1\"^^xsd:unsignedLong) }", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_simple_triple_pattern_with_bind_and_filter() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "select ?s where {?s ?p ?o . BIND(?o AS ?x) FILTER (?s = ?o) }";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        LinkedHashMap prefixDecls = new LinkedHashMap(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("s"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new AssignmentNode(new VarNode("x"), (IValueExpressionNode)new VarNode("o")));
        FunctionNode ve = new FunctionNode(FunctionRegistry.EQ, null, new ValueExpressionNode[]{new VarNode("s"), new VarNode("o")});
        whereClause.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)ve));
        QueryRoot actual = this.parse("select ?s where {?s ?p ?o . BIND(?o AS ?x) FILTER (?s = ?o) }", this.baseURI);
        TestGroupGraphPatternBuilder.assertSameAST((String)"select ?s where {?s ?p ?o . BIND(?o AS ?x) FILTER (?s = ?o) }", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_simple_triple_pattern_with_let_and_filter() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "select ?s where {?s ?p ?o . LET(?x := ?o) FILTER (?s = ?o) }";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        LinkedHashMap prefixDecls = new LinkedHashMap(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("s"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new AssignmentNode(new VarNode("x"), (IValueExpressionNode)new VarNode("o")));
        FunctionNode ve = new FunctionNode(FunctionRegistry.EQ, null, new ValueExpressionNode[]{new VarNode("s"), new VarNode("o")});
        whereClause.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)ve));
        QueryRoot actual = this.parse("select ?s where {?s ?p ?o . LET(?x := ?o) FILTER (?s = ?o) }", this.baseURI);
        TestGroupGraphPatternBuilder.assertSameAST((String)"select ?s where {?s ?p ?o . LET(?x := ?o) FILTER (?s = ?o) }", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_simple_triple_pattern_with_IN_filter() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "SELECT ?s where {?s ?p ?o. FILTER (?s IN())}";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        LinkedHashMap prefixDecls = new LinkedHashMap(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("s"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)new FunctionNode(FunctionRegistry.IN, null, new ValueExpressionNode[]{new VarNode("s")})));
        QueryRoot actual = this.parse("SELECT ?s where {?s ?p ?o. FILTER (?s IN())}", this.baseURI);
        TestGroupGraphPatternBuilder.assertSameAST((String)"SELECT ?s where {?s ?p ?o. FILTER (?s IN())}", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_simple_triple_pattern_with_IN_filter_singletonSet() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "SELECT ?s where {?s ?p ?o. FILTER (?s IN(?o))}";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        LinkedHashMap prefixDecls = new LinkedHashMap(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("s"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)new FunctionNode(FunctionRegistry.IN, null, new ValueExpressionNode[]{new VarNode("s"), new VarNode("o")})));
        QueryRoot actual = this.parse("SELECT ?s where {?s ?p ?o. FILTER (?s IN(?o))}", this.baseURI);
        TestGroupGraphPatternBuilder.assertSameAST((String)"SELECT ?s where {?s ?p ?o. FILTER (?s IN(?o))}", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_simple_triple_pattern_with_IN_filter_variables() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "SELECT ?s where {?s ?p ?o. FILTER (?s IN(?p,?o))}";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        LinkedHashMap prefixDecls = new LinkedHashMap(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("s"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)new FunctionNode(FunctionRegistry.IN, null, new ValueExpressionNode[]{new VarNode("s"), new VarNode("p"), new VarNode("o")})));
        QueryRoot actual = this.parse("SELECT ?s where {?s ?p ?o. FILTER (?s IN(?p,?o))}", this.baseURI);
        TestGroupGraphPatternBuilder.assertSameAST((String)"SELECT ?s where {?s ?p ?o. FILTER (?s IN(?p,?o))}", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_simple_triple_pattern_with_IN_filter_constants() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "SELECT ?s where {?s ?p ?o. FILTER (?s IN(1,2))}";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        LinkedHashMap prefixDecls = new LinkedHashMap(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("s"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)new FunctionNode(FunctionRegistry.IN, null, new ValueExpressionNode[]{new VarNode("s"), new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createLiteral("1", XSD.INTEGER))), new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createLiteral("2", XSD.INTEGER)))})));
        QueryRoot actual = this.parse("SELECT ?s where {?s ?p ?o. FILTER (?s IN(1,2))}", this.baseURI);
        TestGroupGraphPatternBuilder.assertSameAST((String)"SELECT ?s where {?s ?p ?o. FILTER (?s IN(1,2))}", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_service_001() throws MalformedQueryException, TokenMgrError, ParseException {
        String serviceExpr = "SERVICE <http://bigdata.com/myService> {?s ?p ?o}";
        String sparql = "SELECT ?s where {?s ?p ?o. SERVICE <http://bigdata.com/myService> {?s ?p ?o}}";
        IV serviceRefIV = this.makeIV((BigdataValue)this.valueFactory.createURI("http://bigdata.com/myService"));
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        expected.setPrefixDecls(PrefixDeclProcessor.defaultDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("s"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        JoinGroupNode groupNode = new JoinGroupNode();
        groupNode.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        ServiceNode serviceNode = new ServiceNode((TermNode)new ConstantNode(serviceRefIV), (GraphPatternGroup)groupNode);
        serviceNode.setExprImage("SERVICE <http://bigdata.com/myService> {?s ?p ?o}");
        serviceNode.setPrefixDecls(PrefixDeclProcessor.defaultDecls);
        whereClause.addArg((BOp)serviceNode);
        QueryRoot actual = this.parse("SELECT ?s where {?s ?p ?o. SERVICE <http://bigdata.com/myService> {?s ?p ?o}}", this.baseURI);
        TestGroupGraphPatternBuilder.assertSameAST((String)"SELECT ?s where {?s ?p ?o. SERVICE <http://bigdata.com/myService> {?s ?p ?o}}", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_service_002() throws MalformedQueryException, TokenMgrError, ParseException {
        String serviceExpr = "SERVICE SILENT <http://bigdata.com/myService> {?s ?p ?o}";
        String sparql = "SELECT ?s where {?s ?p ?o. SERVICE SILENT <http://bigdata.com/myService> {?s ?p ?o}}";
        IV serviceRefIV = this.makeIV((BigdataValue)this.valueFactory.createURI("http://bigdata.com/myService"));
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        LinkedHashMap prefixDecls = new LinkedHashMap(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("s"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        JoinGroupNode groupNode = new JoinGroupNode();
        groupNode.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        ServiceNode serviceNode = new ServiceNode((TermNode)new ConstantNode(serviceRefIV), (GraphPatternGroup)groupNode);
        serviceNode.setSilent(true);
        serviceNode.setExprImage("SERVICE SILENT <http://bigdata.com/myService> {?s ?p ?o}");
        serviceNode.setPrefixDecls(PrefixDeclProcessor.defaultDecls);
        whereClause.addArg((BOp)serviceNode);
        QueryRoot actual = this.parse("SELECT ?s where {?s ?p ?o. SERVICE SILENT <http://bigdata.com/myService> {?s ?p ?o}}", this.baseURI);
        TestGroupGraphPatternBuilder.assertSameAST((String)"SELECT ?s where {?s ?p ?o. SERVICE SILENT <http://bigdata.com/myService> {?s ?p ?o}}", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_service_003() throws MalformedQueryException, TokenMgrError, ParseException {
        String serviceExpr = "SERVICE ?o {?s ?p ?o}";
        String sparql = "SELECT ?s where {?s ?p ?o. SERVICE ?o {?s ?p ?o}}";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        LinkedHashMap prefixDecls = new LinkedHashMap(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("s"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        JoinGroupNode groupNode = new JoinGroupNode();
        groupNode.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        ServiceNode serviceNode = new ServiceNode((TermNode)new VarNode("o"), (GraphPatternGroup)groupNode);
        serviceNode.setExprImage("SERVICE ?o {?s ?p ?o}");
        serviceNode.setPrefixDecls(PrefixDeclProcessor.defaultDecls);
        whereClause.addArg((BOp)serviceNode);
        QueryRoot actual = this.parse("SELECT ?s where {?s ?p ?o. SERVICE ?o {?s ?p ?o}}", this.baseURI);
        TestGroupGraphPatternBuilder.assertSameAST((String)"SELECT ?s where {?s ?p ?o. SERVICE ?o {?s ?p ?o}}", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_service_004() throws MalformedQueryException, TokenMgrError, ParseException {
        String serviceExpr = "SERVICE ?o {?s ?p ?o}";
        String sparql = "PREFIX : <http://www.bigdata.com/>\nSELECT ?s where {?s ?p ?o. SERVICE ?o {?s ?p ?o}}";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        LinkedHashMap<String, String> prefixDecls = new LinkedHashMap<String, String>(PrefixDeclProcessor.defaultDecls);
        prefixDecls.put("", "http://www.bigdata.com/");
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("s"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        JoinGroupNode groupNode = new JoinGroupNode();
        groupNode.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        ServiceNode serviceNode = new ServiceNode((TermNode)new VarNode("o"), (GraphPatternGroup)groupNode);
        serviceNode.setExprImage("SERVICE ?o {?s ?p ?o}");
        serviceNode.setPrefixDecls(prefixDecls);
        whereClause.addArg((BOp)serviceNode);
        QueryRoot actual = this.parse("PREFIX : <http://www.bigdata.com/>\nSELECT ?s where {?s ?p ?o. SERVICE ?o {?s ?p ?o}}", this.baseURI);
        TestGroupGraphPatternBuilder.assertSameAST((String)"PREFIX : <http://www.bigdata.com/>\nSELECT ?s where {?s ?p ?o. SERVICE ?o {?s ?p ?o}}", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_optional_SERVICE() throws MalformedQueryException, TokenMgrError, ParseException {
        String serviceExpr = "service ?s { ?s ?p ?o  }";
        String sparql = "select ?s where { optional { service ?s { ?s ?p ?o  } } }";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        LinkedHashMap prefixDecls = new LinkedHashMap(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("s"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        JoinGroupNode serviceGraph = new JoinGroupNode();
        serviceGraph.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        ServiceNode service = new ServiceNode((TermNode)new VarNode("s"), (GraphPatternGroup)serviceGraph);
        service.setExprImage("service ?s { ?s ?p ?o  }");
        service.setPrefixDecls(PrefixDeclProcessor.defaultDecls);
        JoinGroupNode wrapperGroup = new JoinGroupNode(true);
        whereClause.addChild((IGroupMemberNode)wrapperGroup);
        wrapperGroup.addChild((IGroupMemberNode)service);
        QueryRoot actual = this.parse("select ?s where { optional { service ?s { ?s ?p ?o  } } }", this.baseURI);
        TestGroupGraphPatternBuilder.assertSameAST((String)"select ?s where { optional { service ?s { ?s ?p ?o  } } }", (IQueryNode)expected, (IQueryNode)actual);
    }
}

