/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.sparql;

import com.bigdata.rdf.sail.sparql.PrefixDeclProcessor;
import junit.framework.TestCase;
import org.junit.Test;

public class TestPrefixDeclProcessor
extends TestCase {
    @Test
    public void testValidAdditionalPrefixes() {
        String fileURL = ((Object)((Object)this)).getClass().getResource("additional-decls-valid.txt").getFile();
        String decl = "wdref";
        String declUri = "http://www.wikidata.org/reference/";
        PrefixDeclProcessor.defaultDecls.remove("wdref");
        int cnt = PrefixDeclProcessor.defaultDecls.size();
        TestPrefixDeclProcessor.assertTrue((!PrefixDeclProcessor.defaultDecls.containsKey("wdref") ? 1 : 0) != 0);
        System.setProperty(PrefixDeclProcessor.Options.ADDITIONAL_DECLS_FILE, fileURL);
        PrefixDeclProcessor.processAdditionalDecls();
        TestPrefixDeclProcessor.assertTrue((boolean)PrefixDeclProcessor.defaultDecls.containsKey("wdref"));
        TestPrefixDeclProcessor.assertTrue((boolean)((String)PrefixDeclProcessor.defaultDecls.get("wdref")).equals("http://www.wikidata.org/reference/"));
        TestPrefixDeclProcessor.assertTrue((cnt + 2 == PrefixDeclProcessor.defaultDecls.size() ? 1 : 0) != 0);
    }

    @Test
    public void testInvalidAdditionalPrefixes() {
        String fileURL = ((Object)((Object)this)).getClass().getResource("additional-decls-invalid.txt").getFile();
        String decl = "wdref";
        PrefixDeclProcessor.defaultDecls.remove("wdref");
        int cnt = PrefixDeclProcessor.defaultDecls.size();
        TestPrefixDeclProcessor.assertTrue((!PrefixDeclProcessor.defaultDecls.containsKey("wdref") ? 1 : 0) != 0);
        System.setProperty(PrefixDeclProcessor.Options.ADDITIONAL_DECLS_FILE, fileURL);
        PrefixDeclProcessor.processAdditionalDecls();
        TestPrefixDeclProcessor.assertTrue((cnt == PrefixDeclProcessor.defaultDecls.size() ? 1 : 0) != 0);
    }

    @Test
    public void testFileDoesNotExist() {
        String fileURL = "/no/such/file/exists";
        String decl = "wdref";
        PrefixDeclProcessor.defaultDecls.remove("wdref");
        int cnt = PrefixDeclProcessor.defaultDecls.size();
        TestPrefixDeclProcessor.assertTrue((!PrefixDeclProcessor.defaultDecls.containsKey("wdref") ? 1 : 0) != 0);
        System.setProperty(PrefixDeclProcessor.Options.ADDITIONAL_DECLS_FILE, "/no/such/file/exists");
        PrefixDeclProcessor.processAdditionalDecls();
        TestPrefixDeclProcessor.assertTrue((!PrefixDeclProcessor.defaultDecls.containsKey("wdref") ? 1 : 0) != 0);
        TestPrefixDeclProcessor.assertTrue((cnt == PrefixDeclProcessor.defaultDecls.size() ? 1 : 0) != 0);
    }
}

