/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.sparql;

import com.bigdata.BigdataStatics;
import com.bigdata.journal.BufferMode;
import com.bigdata.journal.Options;
import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.model.BigdataBNode;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataStatement;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.sail.sparql.PrefixDeclProcessor;
import com.bigdata.rdf.sail.sparql.ast.ParseException;
import com.bigdata.rdf.sail.sparql.ast.TokenMgrError;
import com.bigdata.rdf.sparql.AbstractBigdataExprBuilderTestCase;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.InsertData;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.ProjectionNode;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.UpdateRoot;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.vocab.NoVocabulary;
import java.util.LinkedHashMap;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.algebra.StatementPattern;

public class TestReificationDoneRightParser
extends AbstractBigdataExprBuilderTestCase {
    private static final Logger log = Logger.getLogger(TestReificationDoneRightParser.class);

    public TestReificationDoneRightParser() {
    }

    public TestReificationDoneRightParser(String name) {
        super(name);
    }

    protected Properties getProperties() {
        Properties properties = new Properties();
        properties.setProperty(AbstractTripleStore.Options.QUADS, "false");
        properties.setProperty(AbstractTripleStore.Options.STATEMENT_IDENTIFIERS, "true");
        properties.setProperty(AbstractTripleStore.Options.VOCABULARY_CLASS, NoVocabulary.class.getName());
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        properties.setProperty(Options.BUFFER_MODE, BufferMode.Transient.toString());
        return properties;
    }

    public void test_triple_ref_pattern_var_const_const() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "prefix : <http://example.com/>\nprefix dc: <http://purl.org/dc/elements/1.1/>\nselect ?src ?who {\n  BIND( <<?who :bought :sybase>> AS ?sid ) . \n  ?sid dc:source ?src .\n}";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        IV dcSource = this.makeIV((BigdataValue)this.valueFactory.createURI("http://purl.org/dc/elements/1.1/source"));
        IV bought = this.makeIV((BigdataValue)this.valueFactory.createURI("http://example.com/bought"));
        IV sybase = this.makeIV((BigdataValue)this.valueFactory.createURI("http://example.com/sybase"));
        LinkedHashMap<String, String> prefixDecls = new LinkedHashMap<String, String>(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        prefixDecls.put("", "http://example.com/");
        prefixDecls.put("dc", "http://purl.org/dc/elements/1.1/");
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("src"));
        projection.addProjectionVar(new VarNode("who"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        StatementPatternNode sp1 = new StatementPatternNode((TermNode)new VarNode("who"), (TermNode)new ConstantNode(bought), (TermNode)new ConstantNode(sybase), null, StatementPattern.Scope.DEFAULT_CONTEXTS);
        VarNode sid1 = new VarNode("sid");
        sp1.setSid(sid1);
        StatementPatternNode sp2 = new StatementPatternNode((TermNode)new VarNode("sid"), (TermNode)new ConstantNode(dcSource), (TermNode)new VarNode("src"), null, StatementPattern.Scope.DEFAULT_CONTEXTS);
        whereClause.addChild((IGroupMemberNode)sp1);
        whereClause.addChild((IGroupMemberNode)sp2);
        QueryRoot actual = this.parse("prefix : <http://example.com/>\nprefix dc: <http://purl.org/dc/elements/1.1/>\nselect ?src ?who {\n  BIND( <<?who :bought :sybase>> AS ?sid ) . \n  ?sid dc:source ?src .\n}", this.baseURI);
        TestReificationDoneRightParser.assertSameAST((String)"prefix : <http://example.com/>\nprefix dc: <http://purl.org/dc/elements/1.1/>\nselect ?src ?who {\n  BIND( <<?who :bought :sybase>> AS ?sid ) . \n  ?sid dc:source ?src .\n}", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_triple_ref_pattern_blankNodesAreNotAllowed_subjectPosition() throws MalformedQueryException, TokenMgrError, ParseException {
        block2: {
            String sparql = "prefix : <http://example.com/>\nprefix dc: <http://purl.org/dc/elements/1.1/>\nselect ?src ?who {\n  BIND( <<_:a :bought :sybase>> AS ?sid ) . \n  ?sid dc:source ?src .\n}";
            try {
                this.parse("prefix : <http://example.com/>\nprefix dc: <http://purl.org/dc/elements/1.1/>\nselect ?src ?who {\n  BIND( <<_:a :bought :sybase>> AS ?sid ) . \n  ?sid dc:source ?src .\n}", this.baseURI);
                TestReificationDoneRightParser.fail((String)"This construction is not legal.");
            }
            catch (MalformedQueryException ex) {
                if (!log.isInfoEnabled()) break block2;
                log.info((Object)("Ignoring expected exception: " + (Object)((Object)ex)));
            }
        }
    }

    public void test_triple_ref_pattern_blankNodesAreNotAllowed_objectPosition() throws MalformedQueryException, TokenMgrError, ParseException {
        block2: {
            String sparql = "prefix : <http://example.com/>\nprefix dc: <http://purl.org/dc/elements/1.1/>\nselect ?src ?who {\n  BIND( <<:SAP :bought _:c>> AS ?sid ) . \n  ?sid dc:source ?src .\n}";
            try {
                this.parse("prefix : <http://example.com/>\nprefix dc: <http://purl.org/dc/elements/1.1/>\nselect ?src ?who {\n  BIND( <<:SAP :bought _:c>> AS ?sid ) . \n  ?sid dc:source ?src .\n}", this.baseURI);
                TestReificationDoneRightParser.fail((String)"This construction is not legal.");
            }
            catch (MalformedQueryException ex) {
                if (!log.isInfoEnabled()) break block2;
                log.info((Object)("Ignoring expected exception: " + (Object)((Object)ex)));
            }
        }
    }

    public void test_triple_ref_pattern_no_vars() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "prefix : <http://example.com/>\nprefix dc: <http://purl.org/dc/elements/1.1/>\nselect ?src ?who {\n  <<:SAP :bought :sybase>> dc:source ?src \n}";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        IV dcSource = this.makeIV((BigdataValue)this.valueFactory.createURI("http://purl.org/dc/elements/1.1/source"));
        IV SAP = this.makeIV((BigdataValue)this.valueFactory.createURI("http://example.com/SAP"));
        IV bought = this.makeIV((BigdataValue)this.valueFactory.createURI("http://example.com/bought"));
        IV sybase = this.makeIV((BigdataValue)this.valueFactory.createURI("http://example.com/sybase"));
        LinkedHashMap<String, String> prefixDecls = new LinkedHashMap<String, String>(PrefixDeclProcessor.defaultDecls);
        prefixDecls.put("", "http://example.com/");
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("src"));
        projection.addProjectionVar(new VarNode("who"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        StatementPatternNode sp1 = new StatementPatternNode((TermNode)new ConstantNode(SAP), (TermNode)new ConstantNode(bought), (TermNode)new ConstantNode(sybase), null, StatementPattern.Scope.DEFAULT_CONTEXTS);
        VarNode sid1 = new VarNode("-sid-1");
        sp1.setSid(sid1);
        StatementPatternNode sp2 = new StatementPatternNode((TermNode)sid1, (TermNode)new ConstantNode(dcSource), (TermNode)new VarNode("src"), null, StatementPattern.Scope.DEFAULT_CONTEXTS);
        whereClause.addChild((IGroupMemberNode)sp1);
        whereClause.addChild((IGroupMemberNode)sp2);
        QueryRoot actual = this.parse("prefix : <http://example.com/>\nprefix dc: <http://purl.org/dc/elements/1.1/>\nselect ?src ?who {\n  <<:SAP :bought :sybase>> dc:source ?src \n}", this.baseURI);
        TestReificationDoneRightParser.assertSameAST((String)"prefix : <http://example.com/>\nprefix dc: <http://purl.org/dc/elements/1.1/>\nselect ?src ?who {\n  <<:SAP :bought :sybase>> dc:source ?src \n}", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_triple_ref_pattern_nested_in_subject_position() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "prefix : <http://example.com/>\nselect ?a ?e {\n BIND( << <<?a :b :c>> :d ?e>> AS ?sid) \n}";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        VarNode sid1 = new VarNode("-sid-1");
        VarNode sid2 = new VarNode("sid");
        IV b = this.makeIV((BigdataValue)this.valueFactory.createURI("http://example.com/b"));
        IV c = this.makeIV((BigdataValue)this.valueFactory.createURI("http://example.com/c"));
        IV d = this.makeIV((BigdataValue)this.valueFactory.createURI("http://example.com/d"));
        LinkedHashMap<String, String> prefixDecls = new LinkedHashMap<String, String>(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        prefixDecls.put("", "http://example.com/");
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("a"));
        projection.addProjectionVar(new VarNode("e"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        StatementPatternNode sp1 = new StatementPatternNode((TermNode)new VarNode("a"), (TermNode)new ConstantNode(b), (TermNode)new ConstantNode(c), null, StatementPattern.Scope.DEFAULT_CONTEXTS);
        sp1.setSid(sid1);
        StatementPatternNode sp2 = new StatementPatternNode((TermNode)sid1, (TermNode)new ConstantNode(d), (TermNode)new VarNode("e"), null, StatementPattern.Scope.DEFAULT_CONTEXTS);
        sp2.setSid(sid2);
        whereClause.addChild((IGroupMemberNode)sp1);
        whereClause.addChild((IGroupMemberNode)sp2);
        QueryRoot actual = this.parse("prefix : <http://example.com/>\nselect ?a ?e {\n BIND( << <<?a :b :c>> :d ?e>> AS ?sid) \n}", this.baseURI);
        TestReificationDoneRightParser.assertSameAST((String)"prefix : <http://example.com/>\nselect ?a ?e {\n BIND( << <<?a :b :c>> :d ?e>> AS ?sid) \n}", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_triple_ref_pattern_nested_in_object_position() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "prefix : <http://example.com/>\nselect ?a ?e {\n BIND( << ?a :d <<?e :b :c>> >> AS ?sid) \n}";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        VarNode sid1 = new VarNode("-sid-1");
        VarNode sid2 = new VarNode("sid");
        IV b = this.makeIV((BigdataValue)this.valueFactory.createURI("http://example.com/b"));
        IV c = this.makeIV((BigdataValue)this.valueFactory.createURI("http://example.com/c"));
        IV d = this.makeIV((BigdataValue)this.valueFactory.createURI("http://example.com/d"));
        LinkedHashMap<String, String> prefixDecls = new LinkedHashMap<String, String>(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        prefixDecls.put("", "http://example.com/");
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("a"));
        projection.addProjectionVar(new VarNode("e"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        StatementPatternNode sp1 = new StatementPatternNode((TermNode)new VarNode("e"), (TermNode)new ConstantNode(b), (TermNode)new ConstantNode(c), null, StatementPattern.Scope.DEFAULT_CONTEXTS);
        sp1.setSid(sid1);
        StatementPatternNode sp2 = new StatementPatternNode((TermNode)new VarNode("a"), (TermNode)new ConstantNode(d), (TermNode)sid1, null, StatementPattern.Scope.DEFAULT_CONTEXTS);
        sp2.setSid(sid2);
        whereClause.addChild((IGroupMemberNode)sp1);
        whereClause.addChild((IGroupMemberNode)sp2);
        QueryRoot actual = this.parse("prefix : <http://example.com/>\nselect ?a ?e {\n BIND( << ?a :d <<?e :b :c>> >> AS ?sid) \n}", this.baseURI);
        TestReificationDoneRightParser.assertSameAST((String)"prefix : <http://example.com/>\nselect ?a ?e {\n BIND( << ?a :d <<?e :b :c>> >> AS ?sid) \n}", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_triple_ref_pattern_is_constant() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "prefix : <http://example.com/>\nselect ?a {\n  BIND( <<:e :b :c>> AS ?sid) .\n  ?a :d ?sid.\n}";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        VarNode sid = new VarNode("sid");
        IV b = this.makeIV((BigdataValue)this.valueFactory.createURI("http://example.com/b"));
        IV c = this.makeIV((BigdataValue)this.valueFactory.createURI("http://example.com/c"));
        IV d = this.makeIV((BigdataValue)this.valueFactory.createURI("http://example.com/d"));
        IV e = this.makeIV((BigdataValue)this.valueFactory.createURI("http://example.com/e"));
        LinkedHashMap<String, String> prefixDecls = new LinkedHashMap<String, String>(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        prefixDecls.put("", "http://example.com/");
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("a"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        StatementPatternNode sp1 = new StatementPatternNode((TermNode)new ConstantNode(e), (TermNode)new ConstantNode(b), (TermNode)new ConstantNode(c), null, StatementPattern.Scope.DEFAULT_CONTEXTS);
        sp1.setSid(sid);
        StatementPatternNode sp2 = new StatementPatternNode((TermNode)new VarNode("a"), (TermNode)new ConstantNode(d), (TermNode)sid, null, StatementPattern.Scope.DEFAULT_CONTEXTS);
        whereClause.addChild((IGroupMemberNode)sp1);
        whereClause.addChild((IGroupMemberNode)sp2);
        QueryRoot actual = this.parse("prefix : <http://example.com/>\nselect ?a {\n  BIND( <<:e :b :c>> AS ?sid) .\n  ?a :d ?sid.\n}", this.baseURI);
        TestReificationDoneRightParser.assertSameAST((String)"prefix : <http://example.com/>\nselect ?a {\n  BIND( <<:e :b :c>> AS ?sid) .\n  ?a :d ?sid.\n}", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_triple_ref_pattern_all_vars() throws MalformedQueryException, TokenMgrError, ParseException {
        if (!BigdataStatics.runKnownBadTests) {
            return;
        }
        String sparql = "prefix : <http://example.com/>\nselect ?a {\n  ?d ?e <<?a ?b ?c>> .\n}";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        VarNode a = new VarNode("a");
        VarNode b = new VarNode("b");
        VarNode c = new VarNode("c");
        VarNode d = new VarNode("d");
        VarNode e = new VarNode("e");
        VarNode sid = new VarNode("-sid-1");
        LinkedHashMap<String, String> prefixDecls = new LinkedHashMap<String, String>(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        prefixDecls.put("", "http://example.com/");
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("a"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        StatementPatternNode sp1 = new StatementPatternNode((TermNode)a, (TermNode)b, (TermNode)c, null, StatementPattern.Scope.DEFAULT_CONTEXTS);
        sp1.setSid(sid);
        StatementPatternNode sp2 = new StatementPatternNode((TermNode)d, (TermNode)e, (TermNode)sid, null, StatementPattern.Scope.DEFAULT_CONTEXTS);
        whereClause.addChild((IGroupMemberNode)sp1);
        whereClause.addChild((IGroupMemberNode)sp2);
        QueryRoot actual = this.parse("prefix : <http://example.com/>\nselect ?a {\n  ?d ?e <<?a ?b ?c>> .\n}", this.baseURI);
        TestReificationDoneRightParser.assertSameAST((String)"prefix : <http://example.com/>\nselect ?a {\n  ?d ?e <<?a ?b ?c>> .\n}", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_triple_ref_pattern_all_vars2() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "prefix : <http://example.com/>\nselect ?a {\n  <<?a ?b ?c>> ?d ?e .\n}";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        VarNode a = new VarNode("a");
        VarNode b = new VarNode("b");
        VarNode c = new VarNode("c");
        VarNode d = new VarNode("d");
        VarNode e = new VarNode("e");
        VarNode sid = new VarNode("-sid-1");
        LinkedHashMap<String, String> prefixDecls = new LinkedHashMap<String, String>(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        prefixDecls.put("", "http://example.com/");
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("a"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        StatementPatternNode sp1 = new StatementPatternNode((TermNode)a, (TermNode)b, (TermNode)c, null, StatementPattern.Scope.DEFAULT_CONTEXTS);
        sp1.setSid(sid);
        StatementPatternNode sp2 = new StatementPatternNode((TermNode)sid, (TermNode)d, (TermNode)e, null, StatementPattern.Scope.DEFAULT_CONTEXTS);
        whereClause.addChild((IGroupMemberNode)sp1);
        whereClause.addChild((IGroupMemberNode)sp2);
        QueryRoot actual = this.parse("prefix : <http://example.com/>\nselect ?a {\n  <<?a ?b ?c>> ?d ?e .\n}", this.baseURI);
        TestReificationDoneRightParser.assertSameAST((String)"prefix : <http://example.com/>\nselect ?a {\n  <<?a ?b ?c>> ?d ?e .\n}", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_triple_ref_pattern_all_vars_with_explicit_bind() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "prefix : <http://example.com/>\nselect ?a {\n  BIND( <<?a ?b ?c>> AS ?sid) .\n  ?d ?e ?sid.\n}";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        VarNode a = new VarNode("a");
        VarNode b = new VarNode("b");
        VarNode c = new VarNode("c");
        VarNode d = new VarNode("d");
        VarNode e = new VarNode("e");
        VarNode sid = new VarNode("sid");
        LinkedHashMap<String, String> prefixDecls = new LinkedHashMap<String, String>(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        prefixDecls.put("", "http://example.com/");
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("a"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        StatementPatternNode sp1 = new StatementPatternNode((TermNode)a, (TermNode)b, (TermNode)c, null, StatementPattern.Scope.DEFAULT_CONTEXTS);
        sp1.setSid(sid);
        StatementPatternNode sp2 = new StatementPatternNode((TermNode)d, (TermNode)e, (TermNode)sid, null, StatementPattern.Scope.DEFAULT_CONTEXTS);
        whereClause.addChild((IGroupMemberNode)sp1);
        whereClause.addChild((IGroupMemberNode)sp2);
        QueryRoot actual = this.parse("prefix : <http://example.com/>\nselect ?a {\n  BIND( <<?a ?b ?c>> AS ?sid) .\n  ?d ?e ?sid.\n}", this.baseURI);
        TestReificationDoneRightParser.assertSameAST((String)"prefix : <http://example.com/>\nselect ?a {\n  BIND( <<?a ?b ?c>> AS ?sid) .\n  ?d ?e ?sid.\n}", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_update_insert_data_RDR() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "PREFIX : <http://example/>\nINSERT DATA {\n   :s :p \"d\" . \n   << :s :p \"d\" >> :order \"5\"^^xsd:int . \n}";
        UpdateRoot expected = new UpdateRoot();
        InsertData op = new InsertData();
        expected.addChild((IGroupMemberNode)op);
        BigdataURI s = this.valueFactory.createURI("http://example/s");
        BigdataURI p = this.valueFactory.createURI("http://example/p");
        BigdataURI order = this.valueFactory.createURI("http://example/order");
        BigdataLiteral d = this.valueFactory.createLiteral("d");
        BigdataLiteral five = this.valueFactory.createLiteral(5);
        BigdataStatement s1 = this.valueFactory.createStatement((Resource)s, (URI)p, (Value)d);
        BigdataBNode sid1 = this.valueFactory.createBNode(s1);
        BigdataStatement s2 = this.valueFactory.createStatement((Resource)sid1, (URI)order, (Value)five);
        BigdataStatement[] data = new BigdataStatement[]{s1, s2};
        op.setData(data);
        UpdateRoot actual = this.parseUpdate("PREFIX : <http://example/>\nINSERT DATA {\n   :s :p \"d\" . \n   << :s :p \"d\" >> :order \"5\"^^xsd:int . \n}", this.baseURI);
        TestReificationDoneRightParser.assertSameAST((String)"PREFIX : <http://example/>\nINSERT DATA {\n   :s :p \"d\" . \n   << :s :p \"d\" >> :order \"5\"^^xsd:int . \n}", (IQueryNode)expected, (IQueryNode)actual);
    }
}

