/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.sparql;

import com.bigdata.rdf.internal.XSD;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.sail.sparql.PrefixDeclProcessor;
import com.bigdata.rdf.sail.sparql.ast.ParseException;
import com.bigdata.rdf.sail.sparql.ast.TokenMgrError;
import com.bigdata.rdf.sparql.AbstractBigdataExprBuilderTestCase;
import com.bigdata.rdf.sparql.ast.AssignmentNode;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.ExistsNode;
import com.bigdata.rdf.sparql.ast.FilterNode;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.IValueExpressionNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueriesNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueryInclude;
import com.bigdata.rdf.sparql.ast.NamedSubqueryRoot;
import com.bigdata.rdf.sparql.ast.NotExistsNode;
import com.bigdata.rdf.sparql.ast.ProjectionNode;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.SubqueryRoot;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import java.util.LinkedHashMap;
import org.openrdf.model.vocabulary.FOAF;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.algebra.StatementPattern;

public class TestSubqueryPatterns
extends AbstractBigdataExprBuilderTestCase {
    public TestSubqueryPatterns() {
    }

    public TestSubqueryPatterns(String name) {
        super(name);
    }

    public void test_subSelect() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "select ?s where { {select ?s where { ?s ?p ?o  } } }";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        LinkedHashMap prefixDecls = new LinkedHashMap(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("s"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        SubqueryRoot subSelect = new SubqueryRoot(QueryType.SELECT);
        JoinGroupNode wrapperGroup = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)wrapperGroup);
        wrapperGroup.addChild((IGroupMemberNode)subSelect);
        ProjectionNode projection2 = new ProjectionNode();
        projection2.addProjectionVar(new VarNode("s"));
        subSelect.setProjection(projection2);
        JoinGroupNode whereClause2 = new JoinGroupNode();
        subSelect.setWhereClause((GraphPatternGroup)whereClause2);
        whereClause2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        QueryRoot actual = this.parse("select ?s where { {select ?s where { ?s ?p ?o  } } }", this.baseURI);
        TestSubqueryPatterns.assertSameAST((String)"select ?s where { {select ?s where { ?s ?p ?o  } } }", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_optional_subSelect() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "select ?s where { optional {select ?s where { ?s ?p ?o  } } }";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        LinkedHashMap prefixDecls = new LinkedHashMap(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("s"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        SubqueryRoot subSelect = new SubqueryRoot(QueryType.SELECT);
        JoinGroupNode wrapperGroup = new JoinGroupNode(true);
        whereClause.addChild((IGroupMemberNode)wrapperGroup);
        wrapperGroup.addChild((IGroupMemberNode)subSelect);
        ProjectionNode projection2 = new ProjectionNode();
        projection2.addProjectionVar(new VarNode("s"));
        subSelect.setProjection(projection2);
        JoinGroupNode whereClause2 = new JoinGroupNode();
        subSelect.setWhereClause((GraphPatternGroup)whereClause2);
        whereClause2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        QueryRoot actual = this.parse("select ?s where { optional {select ?s where { ?s ?p ?o  } } }", this.baseURI);
        TestSubqueryPatterns.assertSameAST((String)"select ?s where { optional {select ?s where { ?s ?p ?o  } } }", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_triplePattern_join_subSelect() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "select ?s { ?s ?x ?o  {   select ?x where { ?x ?p ?x }  }}";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        LinkedHashMap prefixDecls = new LinkedHashMap(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("s"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("x"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        SubqueryRoot subSelect = new SubqueryRoot(QueryType.SELECT);
        JoinGroupNode wrapperGroup = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)wrapperGroup);
        wrapperGroup.addChild((IGroupMemberNode)subSelect);
        ProjectionNode projection2 = new ProjectionNode();
        projection2.addProjectionVar(new VarNode("x"));
        subSelect.setProjection(projection2);
        JoinGroupNode whereClause2 = new JoinGroupNode();
        subSelect.setWhereClause((GraphPatternGroup)whereClause2);
        whereClause2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new VarNode("p"), (TermNode)new VarNode("x"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        QueryRoot actual = this.parse("select ?s { ?s ?x ?o  {   select ?x where { ?x ?p ?x }  }}", this.baseURI);
        TestSubqueryPatterns.assertSameAST((String)"select ?s { ?s ?x ?o  {   select ?x where { ?x ?p ?x }  }}", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_select_star_select_star_s_p_o() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "select * { select * { ?s ?p ?o } }";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        LinkedHashMap prefixDecls = new LinkedHashMap(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("*"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        SubqueryRoot subSelect = new SubqueryRoot(QueryType.SELECT);
        JoinGroupNode wrapperGroup = new JoinGroupNode((IGroupMemberNode)subSelect);
        whereClause.addChild((IGroupMemberNode)wrapperGroup);
        ProjectionNode projection2 = new ProjectionNode();
        projection2.addProjectionVar(new VarNode("*"));
        subSelect.setProjection(projection2);
        JoinGroupNode whereClause2 = new JoinGroupNode();
        subSelect.setWhereClause((GraphPatternGroup)whereClause2);
        whereClause2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        QueryRoot actual = this.parse("select * { select * { ?s ?p ?o } }", this.baseURI);
        TestSubqueryPatterns.assertSameAST((String)"select * { select * { ?s ?p ?o } }", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_bind_join_subSelect() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "select ?s where {   bind( <http://www.bigdata.com> as ?o )   {     select ?s where { ?s ?p ?o  }   }}";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        LinkedHashMap prefixDecls = new LinkedHashMap(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("s"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new AssignmentNode(new VarNode("o"), (IValueExpressionNode)new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://www.bigdata.com")))));
        JoinGroupNode wrapperGroup = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)wrapperGroup);
        SubqueryRoot subSelect = new SubqueryRoot(QueryType.SELECT);
        wrapperGroup.addChild((IGroupMemberNode)subSelect);
        ProjectionNode projection2 = new ProjectionNode();
        projection2.addProjectionVar(new VarNode("s"));
        subSelect.setProjection(projection2);
        JoinGroupNode whereClause2 = new JoinGroupNode();
        subSelect.setWhereClause((GraphPatternGroup)whereClause2);
        whereClause2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        QueryRoot actual = this.parse("select ?s where {   bind( <http://www.bigdata.com> as ?o )   {     select ?s where { ?s ?p ?o  }   }}", this.baseURI);
        TestSubqueryPatterns.assertSameAST((String)"select ?s where {   bind( <http://www.bigdata.com> as ?o )   {     select ?s where { ?s ?p ?o  }   }}", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_subSubSelect() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "select ?s \n where { \n   bind( <http://www.bigdata.com> as ?o ) \n   { \n     select ?s \n      where { \n        ?s ?p ?o . \n        { select ?o { bind( 12 as ?o ) } } \n      } \n   }\n}";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        VarNode s = new VarNode("s");
        VarNode p = new VarNode("p");
        VarNode o = new VarNode("o");
        ConstantNode const1 = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://www.bigdata.com")));
        ConstantNode const2 = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createLiteral("12", XSD.INTEGER)));
        LinkedHashMap prefixDecls = new LinkedHashMap(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(s);
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new AssignmentNode(o, (IValueExpressionNode)const1));
        JoinGroupNode wrapperGroup = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)wrapperGroup);
        SubqueryRoot subSelect1 = new SubqueryRoot(QueryType.SELECT);
        wrapperGroup.addChild((IGroupMemberNode)subSelect1);
        SubqueryRoot subSelect2 = new SubqueryRoot(QueryType.SELECT);
        projection = new ProjectionNode();
        projection.addProjectionVar(o);
        subSelect2.setProjection(projection);
        whereClause = new JoinGroupNode();
        subSelect2.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new AssignmentNode(o, (IValueExpressionNode)const2));
        projection = new ProjectionNode();
        projection.addProjectionVar(s);
        subSelect1.setProjection(projection);
        whereClause = new JoinGroupNode();
        subSelect1.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)s, (TermNode)p, (TermNode)o, null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        wrapperGroup = new JoinGroupNode();
        wrapperGroup.addChild((IGroupMemberNode)subSelect2);
        whereClause.addChild((IGroupMemberNode)wrapperGroup);
        QueryRoot actual = this.parse("select ?s \n where { \n   bind( <http://www.bigdata.com> as ?o ) \n   { \n     select ?s \n      where { \n        ?s ?p ?o . \n        { select ?o { bind( 12 as ?o ) } } \n      } \n   }\n}", this.baseURI);
        TestSubqueryPatterns.assertSameAST((String)"select ?s \n where { \n   bind( <http://www.bigdata.com> as ?o ) \n   { \n     select ?s \n      where { \n        ?s ?p ?o . \n        { select ?o { bind( 12 as ?o ) } } \n      } \n   }\n}", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_exists() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "PREFIX  rdf:    <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \nPREFIX  foaf:   <http://xmlns.com/foaf/0.1/> \nSELECT ?person \n WHERE { \n       ?person rdf:type  foaf:Person . \n       FILTER EXISTS { ?person foaf:name ?name } \n}";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ConstantNode rdfType = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI(RDF.TYPE.stringValue())));
        ConstantNode foafPerson = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI(FOAF.PERSON.stringValue())));
        ConstantNode foafName = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI(FOAF.NAME.stringValue())));
        VarNode person = new VarNode("person");
        VarNode name = new VarNode("name");
        VarNode anonvar = this.mockAnonVar("-exists-1");
        LinkedHashMap<String, String> prefixDecls = new LinkedHashMap<String, String>(PrefixDeclProcessor.defaultDecls);
        prefixDecls.put("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        prefixDecls.put("foaf", "http://xmlns.com/foaf/0.1/");
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        expected.setProjection(projection);
        projection.addProjectionVar(person);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)person, (TermNode)rdfType, (TermNode)foafPerson, null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        JoinGroupNode existsPattern = new JoinGroupNode();
        existsPattern.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)person, (TermNode)foafName, (TermNode)name, null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)new ExistsNode(anonvar, (GraphPatternGroup)existsPattern)));
        QueryRoot actual = this.parse("PREFIX  rdf:    <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \nPREFIX  foaf:   <http://xmlns.com/foaf/0.1/> \nSELECT ?person \n WHERE { \n       ?person rdf:type  foaf:Person . \n       FILTER EXISTS { ?person foaf:name ?name } \n}", this.baseURI);
        TestSubqueryPatterns.assertSameAST((String)"PREFIX  rdf:    <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \nPREFIX  foaf:   <http://xmlns.com/foaf/0.1/> \nSELECT ?person \n WHERE { \n       ?person rdf:type  foaf:Person . \n       FILTER EXISTS { ?person foaf:name ?name } \n}", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_not_exists() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "PREFIX  rdf:    <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \nPREFIX  foaf:   <http://xmlns.com/foaf/0.1/> \nSELECT ?person \n WHERE { \n       ?person rdf:type  foaf:Person . \n       FILTER NOT EXISTS { ?person foaf:name ?name } \n}";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ConstantNode rdfType = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI(RDF.TYPE.stringValue())));
        ConstantNode foafPerson = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI(FOAF.PERSON.stringValue())));
        ConstantNode foafName = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI(FOAF.NAME.stringValue())));
        VarNode person = new VarNode("person");
        VarNode name = new VarNode("name");
        VarNode anonvar = this.mockAnonVar("-exists-1");
        LinkedHashMap<String, String> prefixDecls = new LinkedHashMap<String, String>(PrefixDeclProcessor.defaultDecls);
        prefixDecls.put("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        prefixDecls.put("foaf", "http://xmlns.com/foaf/0.1/");
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        expected.setProjection(projection);
        projection.addProjectionVar(person);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)person, (TermNode)rdfType, (TermNode)foafPerson, null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        JoinGroupNode existsPattern = new JoinGroupNode();
        existsPattern.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)person, (TermNode)foafName, (TermNode)name, null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)new NotExistsNode(anonvar, (GraphPatternGroup)existsPattern)));
        QueryRoot actual = this.parse("PREFIX  rdf:    <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \nPREFIX  foaf:   <http://xmlns.com/foaf/0.1/> \nSELECT ?person \n WHERE { \n       ?person rdf:type  foaf:Person . \n       FILTER NOT EXISTS { ?person foaf:name ?name } \n}", this.baseURI);
        TestSubqueryPatterns.assertSameAST((String)"PREFIX  rdf:    <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \nPREFIX  foaf:   <http://xmlns.com/foaf/0.1/> \nSELECT ?person \n WHERE { \n       ?person rdf:type  foaf:Person . \n       FILTER NOT EXISTS { ?person foaf:name ?name } \n}", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_namedSubquery() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "\nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\nSELECT ?p2\n WITH {\n         SELECT DISTINCT ?p\n         WHERE {\n                 ?s ?p ?o\n          }\n } AS %namedSet1\n WHERE {\n        bind ( rdfs:subPropertyOf as ?x )\n        ?p ?x ?p2\n        INCLUDE %namedSet1\n}";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        String namedSet = "%namedSet1";
        VarNode s = new VarNode("s");
        VarNode p = new VarNode("p");
        VarNode o = new VarNode("o");
        VarNode p2 = new VarNode("p2");
        VarNode x = new VarNode("x");
        ConstantNode subPropertyOf = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI(RDFS.SUBPROPERTYOF.stringValue())));
        LinkedHashMap<String, String> prefixDecls = new LinkedHashMap<String, String>(PrefixDeclProcessor.defaultDecls);
        prefixDecls.put("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(p2);
        expected.setProjection(projection);
        NamedSubqueriesNode namedSubqueries = new NamedSubqueriesNode();
        expected.setNamedSubqueries(namedSubqueries);
        NamedSubqueryRoot namedSubqueryRoot = new NamedSubqueryRoot(QueryType.SELECT, "%namedSet1");
        ProjectionNode projection2 = new ProjectionNode();
        namedSubqueryRoot.setProjection(projection2);
        projection2.addProjectionVar(p);
        projection2.setDistinct(true);
        JoinGroupNode whereClause = new JoinGroupNode();
        namedSubqueryRoot.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)s, (TermNode)p, (TermNode)o, null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        namedSubqueries.add((IQueryNode)namedSubqueryRoot);
        JoinGroupNode whereClause2 = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        whereClause2.addChild((IGroupMemberNode)new AssignmentNode(x, (IValueExpressionNode)subPropertyOf));
        whereClause2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)p, (TermNode)x, (TermNode)p2, null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        NamedSubqueryInclude includeNode = new NamedSubqueryInclude("%namedSet1");
        whereClause2.addChild((IGroupMemberNode)includeNode);
        QueryRoot actual = this.parse("\nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\nSELECT ?p2\n WITH {\n         SELECT DISTINCT ?p\n         WHERE {\n                 ?s ?p ?o\n          }\n } AS %namedSet1\n WHERE {\n        bind ( rdfs:subPropertyOf as ?x )\n        ?p ?x ?p2\n        INCLUDE %namedSet1\n}", this.baseURI);
        TestSubqueryPatterns.assertSameAST((String)"\nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\nSELECT ?p2\n WITH {\n         SELECT DISTINCT ?p\n         WHERE {\n                 ?s ?p ?o\n          }\n } AS %namedSet1\n WHERE {\n        bind ( rdfs:subPropertyOf as ?x )\n        ?p ?x ?p2\n        INCLUDE %namedSet1\n}", (IQueryNode)expected, (IQueryNode)actual);
    }
}

