/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.sparql;

import com.bigdata.rdf.internal.XSD;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.sail.sparql.PrefixDeclProcessor;
import com.bigdata.rdf.sail.sparql.ast.ParseException;
import com.bigdata.rdf.sail.sparql.ast.TokenMgrError;
import com.bigdata.rdf.sparql.AbstractBigdataExprBuilderTestCase;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.ProjectionNode;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.vocab.decls.DCElementsVocabularyDecl;
import com.bigdata.rdf.vocab.decls.FOAFVocabularyDecl;
import java.util.LinkedHashMap;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.algebra.StatementPattern;

public class TestTriplePatternBuilder
extends AbstractBigdataExprBuilderTestCase {
    private static final boolean baseURIBusted = true;

    public TestTriplePatternBuilder() {
    }

    public TestTriplePatternBuilder(String name) {
        super(name);
    }

    public void test_triple_pattern_var_var_var() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "select ?s where {?s ?p ?o}";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        LinkedHashMap prefixDecls = new LinkedHashMap(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("s"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        expected.setWhereClause((GraphPatternGroup)whereClause);
        QueryRoot actual = this.parse("select ?s where {?s ?p ?o}", this.baseURI);
        TestTriplePatternBuilder.assertSameAST((String)"select ?s where {?s ?p ?o}", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_triple_pattern_const_var_var() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "select ?p where {<http://www.bigdata.com/s> ?p ?o}";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ConstantNode s = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://www.bigdata.com/s")));
        VarNode p = new VarNode("p");
        VarNode o = new VarNode("o");
        LinkedHashMap prefixDecls = new LinkedHashMap(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(p);
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)s, (TermNode)p, (TermNode)o, null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        expected.setWhereClause((GraphPatternGroup)whereClause);
        QueryRoot actual = this.parse("select ?p where {<http://www.bigdata.com/s> ?p ?o}", this.baseURI);
        TestTriplePatternBuilder.assertSameAST((String)"select ?p where {<http://www.bigdata.com/s> ?p ?o}", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_triple_pattern_var_const_var() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "select ?s where {?s <http://www.bigdata.com/p> ?o}";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        VarNode s = new VarNode("s");
        ConstantNode p = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://www.bigdata.com/p")));
        VarNode o = new VarNode("o");
        LinkedHashMap prefixDecls = new LinkedHashMap(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(s);
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)s, (TermNode)p, (TermNode)o, null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        expected.setWhereClause((GraphPatternGroup)whereClause);
        QueryRoot actual = this.parse("select ?s where {?s <http://www.bigdata.com/p> ?o}", this.baseURI);
        TestTriplePatternBuilder.assertSameAST((String)"select ?s where {?s <http://www.bigdata.com/p> ?o}", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_triple_pattern_var_var_const() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "select ?s where {?s ?p <http://www.bigdata.com/o> }";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        VarNode s = new VarNode("s");
        VarNode p = new VarNode("p");
        ConstantNode o = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://www.bigdata.com/o")));
        LinkedHashMap prefixDecls = new LinkedHashMap(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(s);
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)s, (TermNode)p, (TermNode)o, null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        expected.setWhereClause((GraphPatternGroup)whereClause);
        QueryRoot actual = this.parse("select ?s where {?s ?p <http://www.bigdata.com/o> }", this.baseURI);
        TestTriplePatternBuilder.assertSameAST((String)"select ?s where {?s ?p <http://www.bigdata.com/o> }", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_triple_pattern_const_var_const() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "select ?p where { <http://www.bigdata.com/s> ?p <http://www.bigdata.com/o> }";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ConstantNode s = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://www.bigdata.com/s")));
        VarNode p = new VarNode("p");
        ConstantNode o = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://www.bigdata.com/o")));
        LinkedHashMap prefixDecls = new LinkedHashMap(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(p);
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)s, (TermNode)p, (TermNode)o, null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        expected.setWhereClause((GraphPatternGroup)whereClause);
        QueryRoot actual = this.parse("select ?p where { <http://www.bigdata.com/s> ?p <http://www.bigdata.com/o> }", this.baseURI);
        TestTriplePatternBuilder.assertSameAST((String)"select ?p where { <http://www.bigdata.com/s> ?p <http://www.bigdata.com/o> }", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_triple_pattern_const_const_var() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "select ?o where { <http://www.bigdata.com/s> <http://www.bigdata.com/p> ?o }";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ConstantNode s = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://www.bigdata.com/s")));
        ConstantNode p = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://www.bigdata.com/p")));
        VarNode o = new VarNode("o");
        LinkedHashMap prefixDecls = new LinkedHashMap(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(o);
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)s, (TermNode)p, (TermNode)o, null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        expected.setWhereClause((GraphPatternGroup)whereClause);
        QueryRoot actual = this.parse("select ?o where { <http://www.bigdata.com/s> <http://www.bigdata.com/p> ?o }", this.baseURI);
        TestTriplePatternBuilder.assertSameAST((String)"select ?o where { <http://www.bigdata.com/s> <http://www.bigdata.com/p> ?o }", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_triple_pattern_const_const_const() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "select ?x where { <http://www.bigdata.com/s> <http://www.bigdata.com/p> <http://www.bigdata.com/o> }";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ConstantNode s = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://www.bigdata.com/s")));
        ConstantNode p = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://www.bigdata.com/p")));
        ConstantNode o = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://www.bigdata.com/o")));
        VarNode x = new VarNode("x");
        LinkedHashMap prefixDecls = new LinkedHashMap(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(x);
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)s, (TermNode)p, (TermNode)o, null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        expected.setWhereClause((GraphPatternGroup)whereClause);
        QueryRoot actual = this.parse("select ?x where { <http://www.bigdata.com/s> <http://www.bigdata.com/p> <http://www.bigdata.com/o> }", this.baseURI);
        TestTriplePatternBuilder.assertSameAST((String)"select ?x where { <http://www.bigdata.com/s> <http://www.bigdata.com/p> <http://www.bigdata.com/o> }", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_simple_join() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "select ?s where {?s ?p ?o . ?o ?p2 ?s}";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        LinkedHashMap prefixDecls = new LinkedHashMap(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("s"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("o"), (TermNode)new VarNode("p2"), (TermNode)new VarNode("s"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        QueryRoot actual = this.parse("select ?s where {?s ?p ?o . ?o ?p2 ?s}", this.baseURI);
        TestTriplePatternBuilder.assertSameAST((String)"select ?s where {?s ?p ?o . ?o ?p2 ?s}", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_predicate_list() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "select ?s where {?s ?p ?o ; ?p2 ?o2 }";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        LinkedHashMap prefixDecls = new LinkedHashMap(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("s"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p2"), (TermNode)new VarNode("o2"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        QueryRoot actual = this.parse("select ?s where {?s ?p ?o ; ?p2 ?o2 }", this.baseURI);
        TestTriplePatternBuilder.assertSameAST((String)"select ?s where {?s ?p ?o ; ?p2 ?o2 }", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_predicate_list_where_predicate_is_constant() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "select ?s \n where { \n  ?s <http://www.bigdata.com/foo> ?o    ; <http://www.bigdata.com/bar> ?o2 }";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ConstantNode foo = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://www.bigdata.com/foo")));
        ConstantNode bar = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://www.bigdata.com/bar")));
        LinkedHashMap prefixDecls = new LinkedHashMap(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("s"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)foo, (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)bar, (TermNode)new VarNode("o2"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        QueryRoot actual = this.parse("select ?s \n where { \n  ?s <http://www.bigdata.com/foo> ?o    ; <http://www.bigdata.com/bar> ?o2 }", this.baseURI);
        TestTriplePatternBuilder.assertSameAST((String)"select ?s \n where { \n  ?s <http://www.bigdata.com/foo> ?o    ; <http://www.bigdata.com/bar> ?o2 }", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_object_list() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "select ?s where {?s ?p ?o , ?o2 , ?o3 . }";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        LinkedHashMap prefixDecls = new LinkedHashMap(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("s"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o2"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o3"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        QueryRoot actual = this.parse("select ?s where {?s ?p ?o , ?o2 , ?o3 . }", this.baseURI);
        TestTriplePatternBuilder.assertSameAST((String)"select ?s where {?s ?p ?o , ?o2 , ?o3 . }", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_object_list_where_objects_are_constants() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "select ?s where {?s ?p <http://www.bigdata.com/foo> , <http://www.bigdata.com/bar> , <http://www.bigdata.com/goo> . }";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ConstantNode foo = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://www.bigdata.com/foo")));
        ConstantNode bar = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://www.bigdata.com/bar")));
        ConstantNode goo = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://www.bigdata.com/goo")));
        LinkedHashMap prefixDecls = new LinkedHashMap(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("s"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)foo, null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)bar, null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)goo, null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        QueryRoot actual = this.parse("select ?s where {?s ?p <http://www.bigdata.com/foo> , <http://www.bigdata.com/bar> , <http://www.bigdata.com/goo> . }", this.baseURI);
        TestTriplePatternBuilder.assertSameAST((String)"select ?s where {?s ?p <http://www.bigdata.com/foo> , <http://www.bigdata.com/bar> , <http://www.bigdata.com/goo> . }", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_with_predicate_list_and_object_list() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "select ?s where {?s ?p ?o ; ?p2 ?o2 , ?o3}";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        LinkedHashMap prefixDecls = new LinkedHashMap(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("s"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p2"), (TermNode)new VarNode("o2"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p2"), (TermNode)new VarNode("o3"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        QueryRoot actual = this.parse("select ?s where {?s ?p ?o ; ?p2 ?o2 , ?o3}", this.baseURI);
        TestTriplePatternBuilder.assertSameAST((String)"select ?s where {?s ?p ?o ; ?p2 ?o2 , ?o3}", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_bnode_bracket_syntax_01() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "PREFIX  : <http://example.org/>\nSELECT * { [] :p \"v\" }";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        LinkedHashMap<String, String> prefixDecls = new LinkedHashMap<String, String>(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        prefixDecls.put("", "http://example.org/");
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("*"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        ConstantNode p = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://example.org/p")));
        ConstantNode v = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createLiteral("v")));
        VarNode s = new VarNode("-anon-1");
        s.setAnonymous(true);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)s, (TermNode)p, (TermNode)v, null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        QueryRoot actual = this.parse("PREFIX  : <http://example.org/>\nSELECT * { [] :p \"v\" }", this.baseURI);
        TestTriplePatternBuilder.assertSameAST((String)"PREFIX  : <http://example.org/>\nSELECT * { [] :p \"v\" }", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_bnode_bracket_syntax_02() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "PREFIX  : <http://example.org/>\nSELECT * { [ :p \"v\" ] }";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        LinkedHashMap<String, String> prefixDecls = new LinkedHashMap<String, String>(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        prefixDecls.put("", "http://example.org/");
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("*"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        ConstantNode p = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://example.org/p")));
        ConstantNode v = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createLiteral("v")));
        VarNode s = new VarNode("-anon-11");
        s.setAnonymous(true);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)s, (TermNode)p, (TermNode)v, null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        QueryRoot actual = this.parse("PREFIX  : <http://example.org/>\nSELECT * { [ :p \"v\" ] }", this.baseURI);
        TestTriplePatternBuilder.assertSameAST((String)"PREFIX  : <http://example.org/>\nSELECT * { [ :p \"v\" ] }", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_bnode_bracket_syntax_03() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "PREFIX  : <http://example.org/>\nSELECT * { [ :p \"v\" ] :q \"w\" }";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        LinkedHashMap<String, String> prefixDecls = new LinkedHashMap<String, String>(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        prefixDecls.put("", "http://example.org/");
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("*"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        ConstantNode p = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://example.org/p")));
        ConstantNode q = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://example.org/q")));
        ConstantNode v = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createLiteral("v")));
        ConstantNode w = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createLiteral("w")));
        VarNode s = new VarNode("-anon-11");
        s.setAnonymous(true);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)s, (TermNode)p, (TermNode)v, null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)s, (TermNode)q, (TermNode)w, null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        QueryRoot actual = this.parse("PREFIX  : <http://example.org/>\nSELECT * { [ :p \"v\" ] :q \"w\" }", this.baseURI);
        TestTriplePatternBuilder.assertSameAST((String)"PREFIX  : <http://example.org/>\nSELECT * { [ :p \"v\" ] :q \"w\" }", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_bnode_bracket_syntax_04() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "PREFIX  : <http://example.org/>\nSELECT * { :x :q [ :p \"v\" ] }";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        LinkedHashMap<String, String> prefixDecls = new LinkedHashMap<String, String>(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        prefixDecls.put("", "http://example.org/");
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("*"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        ConstantNode x = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://example.org/x")));
        ConstantNode p = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://example.org/p")));
        ConstantNode q = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://example.org/q")));
        ConstantNode v = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createLiteral("v")));
        VarNode bnode = new VarNode("-anon-11");
        bnode.setAnonymous(true);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)bnode, (TermNode)p, (TermNode)v, null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)x, (TermNode)q, (TermNode)bnode, null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        QueryRoot actual = this.parse("PREFIX  : <http://example.org/>\nSELECT * { :x :q [ :p \"v\" ] }", this.baseURI);
        TestTriplePatternBuilder.assertSameAST((String)"PREFIX  : <http://example.org/>\nSELECT * { :x :q [ :p \"v\" ] }", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_bnode_bracket_syntax_05() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "PREFIX foaf: <http://xmlns.com/foaf/0.1/>\n SELECT * {\n   [ foaf:name ?name ;\n     foaf:mbox <mailto:alice@example.org>\n   ]\n }";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        LinkedHashMap<String, String> prefixDecls = new LinkedHashMap<String, String>(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        prefixDecls.put("foaf", "http://xmlns.com/foaf/0.1/");
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("*"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        ConstantNode foaf_name = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI(FOAFVocabularyDecl.name.stringValue())));
        ConstantNode foaf_mbox = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI(FOAFVocabularyDecl.mbox.stringValue())));
        ConstantNode mailto = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("mailto:alice@example.org")));
        VarNode bnode = new VarNode("-anon-11");
        bnode.setAnonymous(true);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)bnode, (TermNode)foaf_name, (TermNode)new VarNode("name"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)bnode, (TermNode)foaf_mbox, (TermNode)mailto, null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        QueryRoot actual = this.parse("PREFIX foaf: <http://xmlns.com/foaf/0.1/>\n SELECT * {\n   [ foaf:name ?name ;\n     foaf:mbox <mailto:alice@example.org>\n   ]\n }", this.baseURI);
        TestTriplePatternBuilder.assertSameAST((String)"PREFIX foaf: <http://xmlns.com/foaf/0.1/>\n SELECT * {\n   [ foaf:name ?name ;\n     foaf:mbox <mailto:alice@example.org>\n   ]\n }", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_rdf_collections_01() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "PREFIX  : <http://example.org/ns#>\nPREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nSELECT * { (1 ?x 3 4) :p \"w\" . }";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        LinkedHashMap<String, String> prefixDecls = new LinkedHashMap<String, String>(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        prefixDecls.put("", "http://example.org/ns#");
        prefixDecls.put("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("*"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        VarNode x = new VarNode("x");
        VarNode b0 = this.makeAnon(new VarNode("-anon-11"));
        VarNode b1 = this.makeAnon(new VarNode("-anon-1-12"));
        VarNode b2 = this.makeAnon(new VarNode("-anon-1-23"));
        VarNode b3 = this.makeAnon(new VarNode("-anon-1-34"));
        ConstantNode rdfFirst = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI(RDF.FIRST.stringValue())));
        ConstantNode rdfRest = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI(RDF.REST.stringValue())));
        ConstantNode rdfNil = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI(RDF.NIL.stringValue())));
        ConstantNode ONE = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createLiteral("1", XSD.INTEGER)));
        ConstantNode THREE = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createLiteral("3", XSD.INTEGER)));
        ConstantNode FOUR = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createLiteral("4", XSD.INTEGER)));
        ConstantNode p = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://example.org/ns#p")));
        ConstantNode w = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createLiteral("w")));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)b0, (TermNode)rdfFirst, (TermNode)ONE, null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)b0, (TermNode)rdfRest, (TermNode)b1, null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)b1, (TermNode)rdfFirst, (TermNode)x, null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)b1, (TermNode)rdfRest, (TermNode)b2, null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)b2, (TermNode)rdfFirst, (TermNode)THREE, null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)b2, (TermNode)rdfRest, (TermNode)b3, null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)b3, (TermNode)rdfFirst, (TermNode)FOUR, null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)b3, (TermNode)rdfRest, (TermNode)rdfNil, null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)b0, (TermNode)p, (TermNode)w, null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        QueryRoot actual = this.parse("PREFIX  : <http://example.org/ns#>\nPREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nSELECT * { (1 ?x 3 4) :p \"w\" . }", this.baseURI);
        TestTriplePatternBuilder.assertSameAST((String)"PREFIX  : <http://example.org/ns#>\nPREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nSELECT * { (1 ?x 3 4) :p \"w\" . }", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_rdf_collections_02() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "PREFIX  : <http://example.org/ns#>\nPREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nSELECT * { ( 1 [:p :q] ( 2 ) ) }";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        LinkedHashMap<String, String> prefixDecls = new LinkedHashMap<String, String>(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        prefixDecls.put("", "http://example.org/ns#");
        prefixDecls.put("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("*"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        VarNode b0 = this.makeAnon(new VarNode("-anon-11"));
        VarNode b1 = this.makeAnon(new VarNode("-anon-1-12"));
        VarNode b2 = this.makeAnon(new VarNode("-anon-23"));
        VarNode b3 = this.makeAnon(new VarNode("-anon-1-24"));
        VarNode b4 = this.makeAnon(new VarNode("-anon-35"));
        ConstantNode rdfFirst = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI(RDF.FIRST.stringValue())));
        ConstantNode rdfRest = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI(RDF.REST.stringValue())));
        ConstantNode rdfNil = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI(RDF.NIL.stringValue())));
        ConstantNode ONE = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createLiteral("1", XSD.INTEGER)));
        ConstantNode TWO = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createLiteral("2", XSD.INTEGER)));
        ConstantNode p = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://example.org/ns#p")));
        ConstantNode q = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://example.org/ns#q")));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)b0, (TermNode)rdfFirst, (TermNode)ONE, null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)b0, (TermNode)rdfRest, (TermNode)b1, null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)b2, (TermNode)p, (TermNode)q, null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)b1, (TermNode)rdfFirst, (TermNode)b2, null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)b1, (TermNode)rdfRest, (TermNode)b3, null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)b4, (TermNode)rdfFirst, (TermNode)TWO, null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)b4, (TermNode)rdfRest, (TermNode)rdfNil, null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)b3, (TermNode)rdfFirst, (TermNode)b4, null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)b3, (TermNode)rdfRest, (TermNode)rdfNil, null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        QueryRoot actual = this.parse("PREFIX  : <http://example.org/ns#>\nPREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nSELECT * { ( 1 [:p :q] ( 2 ) ) }", this.baseURI);
        TestTriplePatternBuilder.assertSameAST((String)"PREFIX  : <http://example.org/ns#>\nPREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nSELECT * { ( 1 [:p :q] ( 2 ) ) }", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_rdf_collections_03() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "PREFIX  xsd: <http://www.w3.org/2001/XMLSchema#>\nPREFIX  : <http://example.org/ns#>\nSELECT ?p { :x ?p (1) . }";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        LinkedHashMap<String, String> prefixDecls = new LinkedHashMap<String, String>(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        prefixDecls.put("xsd", "http://www.w3.org/2001/XMLSchema#");
        prefixDecls.put("", "http://example.org/ns#");
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("p"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        VarNode p = new VarNode("p");
        VarNode b0 = this.makeAnon(new VarNode("-anon-11"));
        ConstantNode rdfFirst = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI(RDF.FIRST.stringValue())));
        ConstantNode rdfRest = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI(RDF.REST.stringValue())));
        ConstantNode rdfNil = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI(RDF.NIL.stringValue())));
        ConstantNode x = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://example.org/ns#x")));
        ConstantNode ONE = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createLiteral("1", XSD.INTEGER)));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)b0, (TermNode)rdfFirst, (TermNode)ONE, null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)b0, (TermNode)rdfRest, (TermNode)rdfNil, null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)x, (TermNode)p, (TermNode)b0, null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        QueryRoot actual = this.parse("PREFIX  xsd: <http://www.w3.org/2001/XMLSchema#>\nPREFIX  : <http://example.org/ns#>\nSELECT ?p { :x ?p (1) . }", this.baseURI);
        TestTriplePatternBuilder.assertSameAST((String)"PREFIX  xsd: <http://www.w3.org/2001/XMLSchema#>\nPREFIX  : <http://example.org/ns#>\nSELECT ?p { :x ?p (1) . }", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_rdf_collections_04() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "PREFIX  : <http://example.org/ns#>\nSELECT ?p ?v { :x ?p (?v) . }";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        LinkedHashMap<String, String> prefixDecls = new LinkedHashMap<String, String>(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        prefixDecls.put("", "http://example.org/ns#");
        ProjectionNode projection = new ProjectionNode();
        expected.setProjection(projection);
        projection.addProjectionVar(new VarNode("p"));
        projection.addProjectionVar(new VarNode("v"));
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        VarNode p = new VarNode("p");
        VarNode v = new VarNode("v");
        VarNode b0 = this.makeAnon(new VarNode("-anon-11"));
        ConstantNode rdfFirst = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI(RDF.FIRST.stringValue())));
        ConstantNode rdfRest = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI(RDF.REST.stringValue())));
        ConstantNode rdfNil = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI(RDF.NIL.stringValue())));
        ConstantNode x = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://example.org/ns#x")));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)b0, (TermNode)rdfFirst, (TermNode)v, null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)b0, (TermNode)rdfRest, (TermNode)rdfNil, null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)x, (TermNode)p, (TermNode)b0, null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        QueryRoot actual = this.parse("PREFIX  : <http://example.org/ns#>\nSELECT ?p ?v { :x ?p (?v) . }", this.baseURI);
        TestTriplePatternBuilder.assertSameAST((String)"PREFIX  : <http://example.org/ns#>\nSELECT ?p ?v { :x ?p (?v) . }", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_rdf_collections_05() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "PREFIX  : <http://example.org/ns#>\nSELECT ?p ?v ?w { :x ?p (?v ?w) . }";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        LinkedHashMap<String, String> prefixDecls = new LinkedHashMap<String, String>(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        prefixDecls.put("", "http://example.org/ns#");
        ProjectionNode projection = new ProjectionNode();
        expected.setProjection(projection);
        projection.addProjectionVar(new VarNode("p"));
        projection.addProjectionVar(new VarNode("v"));
        projection.addProjectionVar(new VarNode("w"));
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        VarNode p = new VarNode("p");
        VarNode v = new VarNode("v");
        VarNode w = new VarNode("w");
        VarNode b0 = this.makeAnon(new VarNode("-anon-11"));
        VarNode b1 = this.makeAnon(new VarNode("-anon-1-12"));
        ConstantNode rdfFirst = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI(RDF.FIRST.stringValue())));
        ConstantNode rdfRest = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI(RDF.REST.stringValue())));
        ConstantNode rdfNil = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI(RDF.NIL.stringValue())));
        ConstantNode x = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://example.org/ns#x")));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)b0, (TermNode)rdfFirst, (TermNode)v, null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)b0, (TermNode)rdfRest, (TermNode)b1, null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)b1, (TermNode)rdfFirst, (TermNode)w, null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)b1, (TermNode)rdfRest, (TermNode)rdfNil, null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)x, (TermNode)p, (TermNode)b0, null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        QueryRoot actual = this.parse("PREFIX  : <http://example.org/ns#>\nSELECT ?p ?v ?w { :x ?p (?v ?w) . }", this.baseURI);
        TestTriplePatternBuilder.assertSameAST((String)"PREFIX  : <http://example.org/ns#>\nSELECT ?p ?v ?w { :x ?p (?v ?w) . }", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_base_01() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "BASE <http://example.org/book/>\nPREFIX dc: <http://purl.org/dc/elements/1.1/>\nSELECT $title\nWHERE { <book1> dc:title ?title }";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        LinkedHashMap<String, String> prefixDecls = new LinkedHashMap<String, String>(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        prefixDecls.put("dc", "http://purl.org/dc/elements/1.1/");
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("title"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        ConstantNode book1 = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://example.org/book/book1")));
        ConstantNode dc_title = new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI(DCElementsVocabularyDecl.title.stringValue())));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)book1, (TermNode)dc_title, (TermNode)new VarNode("title"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        QueryRoot actual = this.parse("BASE <http://example.org/book/>\nPREFIX dc: <http://purl.org/dc/elements/1.1/>\nSELECT $title\nWHERE { <book1> dc:title ?title }", this.baseURI);
        TestTriplePatternBuilder.assertSameAST((String)"BASE <http://example.org/book/>\nPREFIX dc: <http://purl.org/dc/elements/1.1/>\nSELECT $title\nWHERE { <book1> dc:title ?title }", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_base_02() throws MalformedQueryException, TokenMgrError, ParseException {
    }

    public void test_base_03() throws MalformedQueryException, TokenMgrError, ParseException {
    }

    public void test_base_04() throws MalformedQueryException, TokenMgrError, ParseException {
    }
}

