/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.sparql;

import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.XSD;
import com.bigdata.rdf.model.BigdataBNode;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataResource;
import com.bigdata.rdf.model.BigdataStatement;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.StatementEnum;
import com.bigdata.rdf.rio.RDFParserOptions;
import com.bigdata.rdf.sail.sparql.ast.ParseException;
import com.bigdata.rdf.sail.sparql.ast.TokenMgrError;
import com.bigdata.rdf.sparql.AbstractBigdataExprBuilderTestCase;
import com.bigdata.rdf.sparql.ast.AddGraph;
import com.bigdata.rdf.sparql.ast.ClearGraph;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.CopyGraph;
import com.bigdata.rdf.sparql.ast.CreateGraph;
import com.bigdata.rdf.sparql.ast.DatasetNode;
import com.bigdata.rdf.sparql.ast.DeleteData;
import com.bigdata.rdf.sparql.ast.DeleteInsertGraph;
import com.bigdata.rdf.sparql.ast.DropGraph;
import com.bigdata.rdf.sparql.ast.FilterNode;
import com.bigdata.rdf.sparql.ast.FunctionNode;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.IStatementContainer;
import com.bigdata.rdf.sparql.ast.IValueExpressionNode;
import com.bigdata.rdf.sparql.ast.InsertData;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.LoadGraph;
import com.bigdata.rdf.sparql.ast.MoveGraph;
import com.bigdata.rdf.sparql.ast.ProjectionNode;
import com.bigdata.rdf.sparql.ast.QuadData;
import com.bigdata.rdf.sparql.ast.QuadsDataOrNamedSolutionSet;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.SubqueryRoot;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.UpdateRoot;
import com.bigdata.rdf.sparql.ast.ValueExpressionNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.algebra.StatementPattern;
import org.openrdf.rio.RDFParser;

public class TestUpdateExprBuilder
extends AbstractBigdataExprBuilderTestCase {
    public TestUpdateExprBuilder() {
    }

    public TestUpdateExprBuilder(String name) {
        super(name);
    }

    public void test_load_graph() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "load <http://www.bigdata.com/data>";
        UpdateRoot expected = new UpdateRoot();
        LoadGraph op = new LoadGraph();
        expected.addChild((IGroupMemberNode)op);
        RDFParserOptions options = new RDFParserOptions();
        op.setSourceGraph(new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://www.bigdata.com/data"))));
        UpdateRoot actual = this.parseUpdate("load <http://www.bigdata.com/data>", this.baseURI);
        TestUpdateExprBuilder.assertSameAST((String)"load <http://www.bigdata.com/data>", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_load_silent_graph() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "load silent <http://www.bigdata.com/data>";
        UpdateRoot expected = new UpdateRoot();
        LoadGraph op = new LoadGraph();
        expected.addChild((IGroupMemberNode)op);
        op.setSilent(true);
        RDFParserOptions options = new RDFParserOptions();
        op.setSourceGraph(new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://www.bigdata.com/data"))));
        UpdateRoot actual = this.parseUpdate("load silent <http://www.bigdata.com/data>", this.baseURI);
        TestUpdateExprBuilder.assertSameAST((String)"load silent <http://www.bigdata.com/data>", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_load_silent_graph_into_graph() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "load silent <http://www.bigdata.com/data> into graph <http://www.bigdata.com/graph1>";
        UpdateRoot expected = new UpdateRoot();
        LoadGraph op = new LoadGraph();
        expected.addChild((IGroupMemberNode)op);
        op.setSilent(true);
        RDFParserOptions options = new RDFParserOptions();
        op.setSourceGraph(new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://www.bigdata.com/data"))));
        op.setTargetGraph(new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://www.bigdata.com/graph1"))));
        UpdateRoot actual = this.parseUpdate("load silent <http://www.bigdata.com/data> into graph <http://www.bigdata.com/graph1>", this.baseURI);
        TestUpdateExprBuilder.assertSameAST((String)"load silent <http://www.bigdata.com/data> into graph <http://www.bigdata.com/graph1>", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_load_graphs() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "load <http://www.bigdata.com/data>;\nload <http://www.bigdata.com/data1>;load <http://www.bigdata.com/data2>";
        UpdateRoot expected = new UpdateRoot();
        LoadGraph op = new LoadGraph();
        expected.addChild((IGroupMemberNode)op);
        RDFParserOptions options = new RDFParserOptions();
        op.setSourceGraph(new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://www.bigdata.com/data"))));
        op = new LoadGraph();
        expected.addChild((IGroupMemberNode)op);
        options = new RDFParserOptions();
        op.setSourceGraph(new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://www.bigdata.com/data1"))));
        op = new LoadGraph();
        expected.addChild((IGroupMemberNode)op);
        options = new RDFParserOptions();
        op.setSourceGraph(new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://www.bigdata.com/data2"))));
        UpdateRoot actual = this.parseUpdate("load <http://www.bigdata.com/data>;\nload <http://www.bigdata.com/data1>;load <http://www.bigdata.com/data2>", this.baseURI);
        TestUpdateExprBuilder.assertSameAST((String)"load <http://www.bigdata.com/data>;\nload <http://www.bigdata.com/data1>;load <http://www.bigdata.com/data2>", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_load_nonStandard_verifyData_true() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "load verifyData=true <http://www.bigdata.com/data>";
        UpdateRoot expected = new UpdateRoot();
        LoadGraph op = new LoadGraph();
        expected.addChild((IGroupMemberNode)op);
        RDFParserOptions options = new RDFParserOptions();
        options.setVerifyData(true);
        op.setSourceGraph(new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://www.bigdata.com/data"))));
        UpdateRoot actual = this.parseUpdate("load verifyData=true <http://www.bigdata.com/data>", this.baseURI);
        TestUpdateExprBuilder.assertSameAST((String)"load verifyData=true <http://www.bigdata.com/data>", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_load_nonStandard_verifyData_false() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "load verifyData=false <http://www.bigdata.com/data>";
        UpdateRoot expected = new UpdateRoot();
        LoadGraph op = new LoadGraph();
        expected.addChild((IGroupMemberNode)op);
        RDFParserOptions options = new RDFParserOptions();
        options.setVerifyData(false);
        op.setSourceGraph(new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://www.bigdata.com/data"))));
        UpdateRoot actual = this.parseUpdate("load verifyData=false <http://www.bigdata.com/data>", this.baseURI);
        TestUpdateExprBuilder.assertSameAST((String)"load verifyData=false <http://www.bigdata.com/data>", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_load_nonStandard_stopAtFirstError_true() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "load stopAtFirstError=true <http://www.bigdata.com/data>";
        UpdateRoot expected = new UpdateRoot();
        LoadGraph op = new LoadGraph();
        expected.addChild((IGroupMemberNode)op);
        RDFParserOptions options = new RDFParserOptions();
        options.setStopAtFirstError(true);
        op.setSourceGraph(new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://www.bigdata.com/data"))));
        UpdateRoot actual = this.parseUpdate("load stopAtFirstError=true <http://www.bigdata.com/data>", this.baseURI);
        TestUpdateExprBuilder.assertSameAST((String)"load stopAtFirstError=true <http://www.bigdata.com/data>", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_load_nonStandard_stopAtFirstError_false() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "load stopAtFirstError=false <http://www.bigdata.com/data>";
        UpdateRoot expected = new UpdateRoot();
        LoadGraph op = new LoadGraph();
        expected.addChild((IGroupMemberNode)op);
        RDFParserOptions options = new RDFParserOptions();
        options.setStopAtFirstError(false);
        op.setSourceGraph(new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://www.bigdata.com/data"))));
        UpdateRoot actual = this.parseUpdate("load stopAtFirstError=false <http://www.bigdata.com/data>", this.baseURI);
        TestUpdateExprBuilder.assertSameAST((String)"load stopAtFirstError=false <http://www.bigdata.com/data>", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_load_nonStandard_preserveBNodeIDs_true() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "load preserveBNodeIDs=true <http://www.bigdata.com/data>";
        UpdateRoot expected = new UpdateRoot();
        LoadGraph op = new LoadGraph();
        expected.addChild((IGroupMemberNode)op);
        RDFParserOptions options = new RDFParserOptions();
        options.setPreserveBNodeIDs(true);
        op.setSourceGraph(new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://www.bigdata.com/data"))));
        UpdateRoot actual = this.parseUpdate("load preserveBNodeIDs=true <http://www.bigdata.com/data>", this.baseURI);
        TestUpdateExprBuilder.assertSameAST((String)"load preserveBNodeIDs=true <http://www.bigdata.com/data>", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_load_nonStandard_preserveBNodeIDs_false() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "load preserveBNodeIDs=false <http://www.bigdata.com/data>";
        UpdateRoot expected = new UpdateRoot();
        LoadGraph op = new LoadGraph();
        expected.addChild((IGroupMemberNode)op);
        RDFParserOptions options = new RDFParserOptions();
        options.setPreserveBNodeIDs(false);
        op.setSourceGraph(new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://www.bigdata.com/data"))));
        UpdateRoot actual = this.parseUpdate("load preserveBNodeIDs=false <http://www.bigdata.com/data>", this.baseURI);
        TestUpdateExprBuilder.assertSameAST((String)"load preserveBNodeIDs=false <http://www.bigdata.com/data>", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_load_nonStandard_datatypeHandling_ignore() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "load datatypeHandling=ignore <http://www.bigdata.com/data>";
        UpdateRoot expected = new UpdateRoot();
        LoadGraph op = new LoadGraph();
        expected.addChild((IGroupMemberNode)op);
        RDFParserOptions options = new RDFParserOptions();
        options.setDatatypeHandling(RDFParser.DatatypeHandling.IGNORE);
        op.setSourceGraph(new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://www.bigdata.com/data"))));
        UpdateRoot actual = this.parseUpdate("load datatypeHandling=ignore <http://www.bigdata.com/data>", this.baseURI);
        TestUpdateExprBuilder.assertSameAST((String)"load datatypeHandling=ignore <http://www.bigdata.com/data>", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_load_nonStandard_datatypeHandling_verify() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "load datatypeHandling=verify <http://www.bigdata.com/data>";
        UpdateRoot expected = new UpdateRoot();
        LoadGraph op = new LoadGraph();
        expected.addChild((IGroupMemberNode)op);
        RDFParserOptions options = new RDFParserOptions();
        options.setDatatypeHandling(RDFParser.DatatypeHandling.VERIFY);
        op.setSourceGraph(new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://www.bigdata.com/data"))));
        UpdateRoot actual = this.parseUpdate("load datatypeHandling=verify <http://www.bigdata.com/data>", this.baseURI);
        TestUpdateExprBuilder.assertSameAST((String)"load datatypeHandling=verify <http://www.bigdata.com/data>", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_load_nonStandard_datatypeHandling_normalize() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "load datatypeHandling=normalize <http://www.bigdata.com/data>";
        UpdateRoot expected = new UpdateRoot();
        LoadGraph op = new LoadGraph();
        expected.addChild((IGroupMemberNode)op);
        RDFParserOptions options = new RDFParserOptions();
        options.setDatatypeHandling(RDFParser.DatatypeHandling.VERIFY);
        op.setSourceGraph(new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://www.bigdata.com/data"))));
        UpdateRoot actual = this.parseUpdate("load datatypeHandling=normalize <http://www.bigdata.com/data>", this.baseURI);
        TestUpdateExprBuilder.assertSameAST((String)"load datatypeHandling=normalize <http://www.bigdata.com/data>", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_load_nonStandard_multipleOptions() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "load verifyData=true silent datatypeHandling=normalize <http://www.bigdata.com/data>";
        UpdateRoot expected = new UpdateRoot();
        LoadGraph op = new LoadGraph();
        expected.addChild((IGroupMemberNode)op);
        op.setSilent(true);
        RDFParserOptions options = new RDFParserOptions();
        options.setVerifyData(true);
        options.setDatatypeHandling(RDFParser.DatatypeHandling.VERIFY);
        op.setSourceGraph(new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://www.bigdata.com/data"))));
        UpdateRoot actual = this.parseUpdate("load verifyData=true silent datatypeHandling=normalize <http://www.bigdata.com/data>", this.baseURI);
        TestUpdateExprBuilder.assertSameAST((String)"load verifyData=true silent datatypeHandling=normalize <http://www.bigdata.com/data>", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_clear_graph() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "clear graph <http://www.bigdata.com/data>";
        UpdateRoot expected = new UpdateRoot();
        ClearGraph op = new ClearGraph();
        expected.addChild((IGroupMemberNode)op);
        op.setTargetGraph(new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://www.bigdata.com/data"))));
        UpdateRoot actual = this.parseUpdate("clear graph <http://www.bigdata.com/data>", this.baseURI);
        TestUpdateExprBuilder.assertSameAST((String)"clear graph <http://www.bigdata.com/data>", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_clear_default() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "clear default";
        UpdateRoot expected = new UpdateRoot();
        ClearGraph op = new ClearGraph();
        expected.addChild((IGroupMemberNode)op);
        op.setScope(StatementPattern.Scope.DEFAULT_CONTEXTS);
        UpdateRoot actual = this.parseUpdate("clear default", this.baseURI);
        TestUpdateExprBuilder.assertSameAST((String)"clear default", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_clear_named() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "clear named";
        UpdateRoot expected = new UpdateRoot();
        ClearGraph op = new ClearGraph();
        expected.addChild((IGroupMemberNode)op);
        op.setScope(StatementPattern.Scope.NAMED_CONTEXTS);
        UpdateRoot actual = this.parseUpdate("clear named", this.baseURI);
        TestUpdateExprBuilder.assertSameAST((String)"clear named", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_clear_all() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "clear all";
        UpdateRoot expected = new UpdateRoot();
        ClearGraph op = new ClearGraph();
        op.setAllGraphs(true);
        op.setAllSolutionSets(true);
        expected.addChild((IGroupMemberNode)op);
        UpdateRoot actual = this.parseUpdate("clear all", this.baseURI);
        TestUpdateExprBuilder.assertSameAST((String)"clear all", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_clear_silent_all() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "clear silent all";
        UpdateRoot expected = new UpdateRoot();
        ClearGraph op = new ClearGraph();
        expected.addChild((IGroupMemberNode)op);
        op.setAllGraphs(true);
        op.setAllSolutionSets(true);
        op.setSilent(true);
        UpdateRoot actual = this.parseUpdate("clear silent all", this.baseURI);
        TestUpdateExprBuilder.assertSameAST((String)"clear silent all", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_drop_graph() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "drop graph <http://www.bigdata.com/data>";
        UpdateRoot expected = new UpdateRoot();
        DropGraph op = new DropGraph();
        expected.addChild((IGroupMemberNode)op);
        op.setTargetGraph(new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://www.bigdata.com/data"))));
        UpdateRoot actual = this.parseUpdate("drop graph <http://www.bigdata.com/data>", this.baseURI);
        TestUpdateExprBuilder.assertSameAST((String)"drop graph <http://www.bigdata.com/data>", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_drop_default() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "drop default";
        UpdateRoot expected = new UpdateRoot();
        DropGraph op = new DropGraph();
        expected.addChild((IGroupMemberNode)op);
        op.setScope(StatementPattern.Scope.DEFAULT_CONTEXTS);
        UpdateRoot actual = this.parseUpdate("drop default", this.baseURI);
        TestUpdateExprBuilder.assertSameAST((String)"drop default", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_drop_named() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "drop named";
        UpdateRoot expected = new UpdateRoot();
        DropGraph op = new DropGraph();
        expected.addChild((IGroupMemberNode)op);
        op.setScope(StatementPattern.Scope.NAMED_CONTEXTS);
        UpdateRoot actual = this.parseUpdate("drop named", this.baseURI);
        TestUpdateExprBuilder.assertSameAST((String)"drop named", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_drop_all() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "drop all";
        UpdateRoot expected = new UpdateRoot();
        DropGraph op = new DropGraph();
        op.setAllGraphs(true);
        op.setAllSolutionSets(true);
        expected.addChild((IGroupMemberNode)op);
        UpdateRoot actual = this.parseUpdate("drop all", this.baseURI);
        TestUpdateExprBuilder.assertSameAST((String)"drop all", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_drop_silent_all() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "drop silent all";
        UpdateRoot expected = new UpdateRoot();
        DropGraph op = new DropGraph();
        expected.addChild((IGroupMemberNode)op);
        op.setAllGraphs(true);
        op.setAllSolutionSets(true);
        op.setSilent(true);
        UpdateRoot actual = this.parseUpdate("drop silent all", this.baseURI);
        TestUpdateExprBuilder.assertSameAST((String)"drop silent all", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_create() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "create graph <http://www.bigdata.com/graph1>";
        UpdateRoot expected = new UpdateRoot();
        CreateGraph op = new CreateGraph();
        expected.addChild((IGroupMemberNode)op);
        op.setTargetGraph(new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://www.bigdata.com/graph1"))));
        UpdateRoot actual = this.parseUpdate("create graph <http://www.bigdata.com/graph1>", this.baseURI);
        TestUpdateExprBuilder.assertSameAST((String)"create graph <http://www.bigdata.com/graph1>", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_create_silent() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "create silent graph <http://www.bigdata.com/graph1>";
        UpdateRoot expected = new UpdateRoot();
        CreateGraph op = new CreateGraph();
        expected.addChild((IGroupMemberNode)op);
        op.setSilent(true);
        op.setTargetGraph(new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://www.bigdata.com/graph1"))));
        UpdateRoot actual = this.parseUpdate("create silent graph <http://www.bigdata.com/graph1>", this.baseURI);
        TestUpdateExprBuilder.assertSameAST((String)"create silent graph <http://www.bigdata.com/graph1>", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_copy_graph_to_graph() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "copy <http://www.bigdata.com/graph1> to <http://www.bigdata.com/graph2>";
        UpdateRoot expected = new UpdateRoot();
        CopyGraph op = new CopyGraph();
        expected.addChild((IGroupMemberNode)op);
        op.setSourceGraph(new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://www.bigdata.com/graph1"))));
        op.setTargetGraph(new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://www.bigdata.com/graph2"))));
        UpdateRoot actual = this.parseUpdate("copy <http://www.bigdata.com/graph1> to <http://www.bigdata.com/graph2>", this.baseURI);
        TestUpdateExprBuilder.assertSameAST((String)"copy <http://www.bigdata.com/graph1> to <http://www.bigdata.com/graph2>", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_silent_copy_graph_to_graph() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "copy silent <http://www.bigdata.com/graph1> to <http://www.bigdata.com/graph2>";
        UpdateRoot expected = new UpdateRoot();
        CopyGraph op = new CopyGraph();
        expected.addChild((IGroupMemberNode)op);
        op.setSilent(true);
        op.setSourceGraph(new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://www.bigdata.com/graph1"))));
        op.setTargetGraph(new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://www.bigdata.com/graph2"))));
        UpdateRoot actual = this.parseUpdate("copy silent <http://www.bigdata.com/graph1> to <http://www.bigdata.com/graph2>", this.baseURI);
        TestUpdateExprBuilder.assertSameAST((String)"copy silent <http://www.bigdata.com/graph1> to <http://www.bigdata.com/graph2>", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_copy_graph_to_default() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "copy silent <http://www.bigdata.com/graph1> to default";
        UpdateRoot expected = new UpdateRoot();
        CopyGraph op = new CopyGraph();
        expected.addChild((IGroupMemberNode)op);
        op.setSilent(true);
        op.setSourceGraph(new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://www.bigdata.com/graph1"))));
        UpdateRoot actual = this.parseUpdate("copy silent <http://www.bigdata.com/graph1> to default", this.baseURI);
        TestUpdateExprBuilder.assertSameAST((String)"copy silent <http://www.bigdata.com/graph1> to default", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_silent_copy_default_to_graph() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "copy silent default to <http://www.bigdata.com/graph2>";
        UpdateRoot expected = new UpdateRoot();
        CopyGraph op = new CopyGraph();
        expected.addChild((IGroupMemberNode)op);
        op.setSilent(true);
        op.setTargetGraph(new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://www.bigdata.com/graph2"))));
        UpdateRoot actual = this.parseUpdate("copy silent default to <http://www.bigdata.com/graph2>", this.baseURI);
        TestUpdateExprBuilder.assertSameAST((String)"copy silent default to <http://www.bigdata.com/graph2>", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_move_graph_to_graph() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "move <http://www.bigdata.com/graph1> to <http://www.bigdata.com/graph2>";
        UpdateRoot expected = new UpdateRoot();
        MoveGraph op = new MoveGraph();
        expected.addChild((IGroupMemberNode)op);
        op.setSourceGraph(new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://www.bigdata.com/graph1"))));
        op.setTargetGraph(new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://www.bigdata.com/graph2"))));
        UpdateRoot actual = this.parseUpdate("move <http://www.bigdata.com/graph1> to <http://www.bigdata.com/graph2>", this.baseURI);
        TestUpdateExprBuilder.assertSameAST((String)"move <http://www.bigdata.com/graph1> to <http://www.bigdata.com/graph2>", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_silent_move_graph_to_graph() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "move silent <http://www.bigdata.com/graph1> to <http://www.bigdata.com/graph2>";
        UpdateRoot expected = new UpdateRoot();
        MoveGraph op = new MoveGraph();
        expected.addChild((IGroupMemberNode)op);
        op.setSilent(true);
        op.setSourceGraph(new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://www.bigdata.com/graph1"))));
        op.setTargetGraph(new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://www.bigdata.com/graph2"))));
        UpdateRoot actual = this.parseUpdate("move silent <http://www.bigdata.com/graph1> to <http://www.bigdata.com/graph2>", this.baseURI);
        TestUpdateExprBuilder.assertSameAST((String)"move silent <http://www.bigdata.com/graph1> to <http://www.bigdata.com/graph2>", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_move_graph_to_default() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "move silent <http://www.bigdata.com/graph1> to default";
        UpdateRoot expected = new UpdateRoot();
        MoveGraph op = new MoveGraph();
        expected.addChild((IGroupMemberNode)op);
        op.setSilent(true);
        op.setSourceGraph(new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://www.bigdata.com/graph1"))));
        UpdateRoot actual = this.parseUpdate("move silent <http://www.bigdata.com/graph1> to default", this.baseURI);
        TestUpdateExprBuilder.assertSameAST((String)"move silent <http://www.bigdata.com/graph1> to default", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_silent_move_default_to_graph() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "move silent default to <http://www.bigdata.com/graph2>";
        UpdateRoot expected = new UpdateRoot();
        MoveGraph op = new MoveGraph();
        expected.addChild((IGroupMemberNode)op);
        op.setSilent(true);
        op.setTargetGraph(new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://www.bigdata.com/graph2"))));
        UpdateRoot actual = this.parseUpdate("move silent default to <http://www.bigdata.com/graph2>", this.baseURI);
        TestUpdateExprBuilder.assertSameAST((String)"move silent default to <http://www.bigdata.com/graph2>", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_add_graph_to_graph() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "add <http://www.bigdata.com/graph1> to <http://www.bigdata.com/graph2>";
        UpdateRoot expected = new UpdateRoot();
        AddGraph op = new AddGraph();
        expected.addChild((IGroupMemberNode)op);
        op.setSourceGraph(new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://www.bigdata.com/graph1"))));
        op.setTargetGraph(new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://www.bigdata.com/graph2"))));
        UpdateRoot actual = this.parseUpdate("add <http://www.bigdata.com/graph1> to <http://www.bigdata.com/graph2>", this.baseURI);
        TestUpdateExprBuilder.assertSameAST((String)"add <http://www.bigdata.com/graph1> to <http://www.bigdata.com/graph2>", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_silent_add_graph_to_graph() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "add silent <http://www.bigdata.com/graph1> to <http://www.bigdata.com/graph2>";
        UpdateRoot expected = new UpdateRoot();
        AddGraph op = new AddGraph();
        expected.addChild((IGroupMemberNode)op);
        op.setSilent(true);
        op.setSourceGraph(new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://www.bigdata.com/graph1"))));
        op.setTargetGraph(new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://www.bigdata.com/graph2"))));
        UpdateRoot actual = this.parseUpdate("add silent <http://www.bigdata.com/graph1> to <http://www.bigdata.com/graph2>", this.baseURI);
        TestUpdateExprBuilder.assertSameAST((String)"add silent <http://www.bigdata.com/graph1> to <http://www.bigdata.com/graph2>", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_add_graph_to_default() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "add silent <http://www.bigdata.com/graph1> to default";
        UpdateRoot expected = new UpdateRoot();
        AddGraph op = new AddGraph();
        expected.addChild((IGroupMemberNode)op);
        op.setSilent(true);
        op.setSourceGraph(new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://www.bigdata.com/graph1"))));
        UpdateRoot actual = this.parseUpdate("add silent <http://www.bigdata.com/graph1> to default", this.baseURI);
        TestUpdateExprBuilder.assertSameAST((String)"add silent <http://www.bigdata.com/graph1> to default", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_silent_add_default_to_graph() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "add silent default to <http://www.bigdata.com/graph2>";
        UpdateRoot expected = new UpdateRoot();
        AddGraph op = new AddGraph();
        expected.addChild((IGroupMemberNode)op);
        op.setSilent(true);
        op.setTargetGraph(new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://www.bigdata.com/graph2"))));
        UpdateRoot actual = this.parseUpdate("add silent default to <http://www.bigdata.com/graph2>", this.baseURI);
        TestUpdateExprBuilder.assertSameAST((String)"add silent default to <http://www.bigdata.com/graph2>", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_insert_data() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "PREFIX dc: <http://purl.org/dc/elements/1.1/>\nINSERT DATA\n{\n  <http://example/book1> dc:title \"A new book\" ;\n                         dc:creator \"A.N.Other\" .\n}";
        UpdateRoot expected = new UpdateRoot();
        InsertData op = new InsertData();
        expected.addChild((IGroupMemberNode)op);
        BigdataURI book1 = this.valueFactory.createURI("http://example/book1");
        BigdataURI dcCreator = this.valueFactory.createURI("http://purl.org/dc/elements/1.1/creator");
        BigdataURI dcTitle = this.valueFactory.createURI("http://purl.org/dc/elements/1.1/title");
        BigdataLiteral label1 = this.valueFactory.createLiteral("A new book");
        BigdataLiteral label2 = this.valueFactory.createLiteral("A.N.Other");
        BigdataStatement[] data = new BigdataStatement[]{this.valueFactory.createStatement((Resource)book1, (URI)dcTitle, (Value)label1, null, StatementEnum.Explicit), this.valueFactory.createStatement((Resource)book1, (URI)dcCreator, (Value)label2, null, StatementEnum.Explicit)};
        op.setData(data);
        UpdateRoot actual = this.parseUpdate("PREFIX dc: <http://purl.org/dc/elements/1.1/>\nINSERT DATA\n{\n  <http://example/book1> dc:title \"A new book\" ;\n                         dc:creator \"A.N.Other\" .\n}", this.baseURI);
        TestUpdateExprBuilder.assertSameAST((String)"PREFIX dc: <http://purl.org/dc/elements/1.1/>\nINSERT DATA\n{\n  <http://example/book1> dc:title \"A new book\" ;\n                         dc:creator \"A.N.Other\" .\n}", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_insert_data_quads() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "PREFIX dc: <http://purl.org/dc/elements/1.1/>\nPREFIX ns: <http://example.org/ns#>\nINSERT DATA\n{ GRAPH <http://example/bookStore> { <http://example/book1>  ns:price  42 } }";
        UpdateRoot expected = new UpdateRoot();
        InsertData op = new InsertData();
        expected.addChild((IGroupMemberNode)op);
        BigdataURI bookstore = this.valueFactory.createURI("http://example/bookStore");
        BigdataURI book1 = this.valueFactory.createURI("http://example/book1");
        BigdataURI price = this.valueFactory.createURI("http://example.org/ns#price");
        BigdataLiteral i42 = this.valueFactory.createLiteral("42", XSD.INTEGER);
        BigdataStatement[] data = new BigdataStatement[]{this.valueFactory.createStatement((Resource)book1, (URI)price, (Value)i42, (Resource)bookstore, StatementEnum.Explicit)};
        op.setData(data);
        UpdateRoot actual = this.parseUpdate("PREFIX dc: <http://purl.org/dc/elements/1.1/>\nPREFIX ns: <http://example.org/ns#>\nINSERT DATA\n{ GRAPH <http://example/bookStore> { <http://example/book1>  ns:price  42 } }", this.baseURI);
        TestUpdateExprBuilder.assertSameAST((String)"PREFIX dc: <http://purl.org/dc/elements/1.1/>\nPREFIX ns: <http://example.org/ns#>\nINSERT DATA\n{ GRAPH <http://example/bookStore> { <http://example/book1>  ns:price  42 } }", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_insert_data_ticket573() throws MalformedQueryException {
        String sparql = "INSERT DATA { _:bnode a <http://example/Foo> . }";
        UpdateRoot expected = new UpdateRoot();
        InsertData op = new InsertData();
        expected.addChild((IGroupMemberNode)op);
        BigdataBNode bnode = this.valueFactory.createBNode("-anon-1");
        BigdataURI rdfType = this.valueFactory.createURI(RDF.TYPE.toString());
        BigdataURI foo = this.valueFactory.createURI("http://example/Foo");
        BigdataStatement[] data = new BigdataStatement[]{this.valueFactory.createStatement((Resource)bnode, (URI)rdfType, (Value)foo, null, StatementEnum.Explicit)};
        op.setData(data);
        UpdateRoot actual = this.parseUpdate("INSERT DATA { _:bnode a <http://example/Foo> . }", this.baseURI);
    }

    public void test_insert_data_triples_then_quads() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "PREFIX dc: <http://purl.org/dc/elements/1.1/>\nPREFIX ns: <http://example.org/ns#>\nINSERT DATA\n{\n  <http://example/book1> dc:title \"A new book\" .\n  <http://example/book1> dc:creator \"A.N.Other\" .\n  GRAPH <http://example/bookStore> { <http://example/book1>  ns:price  42 }\n}";
        UpdateRoot expected = new UpdateRoot();
        InsertData op = new InsertData();
        expected.addChild((IGroupMemberNode)op);
        BigdataURI book1 = this.valueFactory.createURI("http://example/book1");
        BigdataURI dcCreator = this.valueFactory.createURI("http://purl.org/dc/elements/1.1/creator");
        BigdataURI dcTitle = this.valueFactory.createURI("http://purl.org/dc/elements/1.1/title");
        BigdataLiteral label1 = this.valueFactory.createLiteral("A new book");
        BigdataLiteral label2 = this.valueFactory.createLiteral("A.N.Other");
        BigdataURI bookstore = this.valueFactory.createURI("http://example/bookStore");
        BigdataURI price = this.valueFactory.createURI("http://example.org/ns#price");
        BigdataLiteral i42 = this.valueFactory.createLiteral("42", XSD.INTEGER);
        BigdataStatement[] data = new BigdataStatement[]{this.valueFactory.createStatement((Resource)book1, (URI)dcTitle, (Value)label1, null, StatementEnum.Explicit), this.valueFactory.createStatement((Resource)book1, (URI)dcCreator, (Value)label2, null, StatementEnum.Explicit), this.valueFactory.createStatement((Resource)book1, (URI)price, (Value)i42, (Resource)bookstore, StatementEnum.Explicit)};
        op.setData(data);
        UpdateRoot actual = this.parseUpdate("PREFIX dc: <http://purl.org/dc/elements/1.1/>\nPREFIX ns: <http://example.org/ns#>\nINSERT DATA\n{\n  <http://example/book1> dc:title \"A new book\" .\n  <http://example/book1> dc:creator \"A.N.Other\" .\n  GRAPH <http://example/bookStore> { <http://example/book1>  ns:price  42 }\n}", this.baseURI);
        TestUpdateExprBuilder.assertSameAST((String)"PREFIX dc: <http://purl.org/dc/elements/1.1/>\nPREFIX ns: <http://example.org/ns#>\nINSERT DATA\n{\n  <http://example/book1> dc:title \"A new book\" .\n  <http://example/book1> dc:creator \"A.N.Other\" .\n  GRAPH <http://example/bookStore> { <http://example/book1>  ns:price  42 }\n}", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_insert_data_triples_then_quads2() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "PREFIX dc: <http://purl.org/dc/elements/1.1/>\nPREFIX ns: <http://example.org/ns#>\nINSERT DATA\n{\n    { <a:s1> <a:p1> <a:o1>\n }    GRAPH <a:G> { <a:s> <a:p1> 'o1'; <a:p2> <a:o2> }\n    GRAPH <a:G1> { <a:s> <a:p1> 'o1'; <a:p2> <a:o2> } \n    <a:s1> <a:p1> <a:o1>\n}";
        this.parseUpdate("PREFIX dc: <http://purl.org/dc/elements/1.1/>\nPREFIX ns: <http://example.org/ns#>\nINSERT DATA\n{\n    { <a:s1> <a:p1> <a:o1>\n }    GRAPH <a:G> { <a:s> <a:p1> 'o1'; <a:p2> <a:o2> }\n    GRAPH <a:G1> { <a:s> <a:p1> 'o1'; <a:p2> <a:o2> } \n    <a:s1> <a:p1> <a:o1>\n}", this.baseURI);
    }

    public void test_insert_data_quads_then_triples() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "PREFIX dc: <http://purl.org/dc/elements/1.1/>\nPREFIX ns: <http://example.org/ns#>\nINSERT DATA\n{\n  GRAPH <http://example/bookStore> { <http://example/book1>  ns:price  42 }\n  <http://example/book1> dc:title \"A new book\" .\n  <http://example/book1> dc:creator \"A.N.Other\" .\n}";
        UpdateRoot expected = new UpdateRoot();
        InsertData op = new InsertData();
        expected.addChild((IGroupMemberNode)op);
        BigdataURI book1 = this.valueFactory.createURI("http://example/book1");
        BigdataURI dcCreator = this.valueFactory.createURI("http://purl.org/dc/elements/1.1/creator");
        BigdataURI dcTitle = this.valueFactory.createURI("http://purl.org/dc/elements/1.1/title");
        BigdataLiteral label1 = this.valueFactory.createLiteral("A new book");
        BigdataLiteral label2 = this.valueFactory.createLiteral("A.N.Other");
        BigdataURI bookstore = this.valueFactory.createURI("http://example/bookStore");
        BigdataURI price = this.valueFactory.createURI("http://example.org/ns#price");
        BigdataLiteral i42 = this.valueFactory.createLiteral("42", XSD.INTEGER);
        BigdataStatement[] data = new BigdataStatement[]{this.valueFactory.createStatement((Resource)book1, (URI)price, (Value)i42, (Resource)bookstore, StatementEnum.Explicit), this.valueFactory.createStatement((Resource)book1, (URI)dcTitle, (Value)label1, null, StatementEnum.Explicit), this.valueFactory.createStatement((Resource)book1, (URI)dcCreator, (Value)label2, null, StatementEnum.Explicit)};
        op.setData(data);
        UpdateRoot actual = this.parseUpdate("PREFIX dc: <http://purl.org/dc/elements/1.1/>\nPREFIX ns: <http://example.org/ns#>\nINSERT DATA\n{\n  GRAPH <http://example/bookStore> { <http://example/book1>  ns:price  42 }\n  <http://example/book1> dc:title \"A new book\" .\n  <http://example/book1> dc:creator \"A.N.Other\" .\n}", this.baseURI);
        TestUpdateExprBuilder.assertSameAST((String)"PREFIX dc: <http://purl.org/dc/elements/1.1/>\nPREFIX ns: <http://example.org/ns#>\nINSERT DATA\n{\n  GRAPH <http://example/bookStore> { <http://example/book1>  ns:price  42 }\n  <http://example/book1> dc:title \"A new book\" .\n  <http://example/book1> dc:creator \"A.N.Other\" .\n}", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_insert_data_triples_quads_triples() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "PREFIX dc: <http://purl.org/dc/elements/1.1/>\nPREFIX ns: <http://example.org/ns#>\nINSERT DATA\n{\n  <http://example/book1> dc:title \"A new book\" .   GRAPH <http://example/bookStore> { <http://example/book1>  ns:price  42 }\n  <http://example/book1> dc:creator \"A.N.Other\" .\n}";
        UpdateRoot expected = new UpdateRoot();
        InsertData op = new InsertData();
        expected.addChild((IGroupMemberNode)op);
        BigdataURI book1 = this.valueFactory.createURI("http://example/book1");
        BigdataURI dcCreator = this.valueFactory.createURI("http://purl.org/dc/elements/1.1/creator");
        BigdataURI dcTitle = this.valueFactory.createURI("http://purl.org/dc/elements/1.1/title");
        BigdataLiteral label1 = this.valueFactory.createLiteral("A new book");
        BigdataLiteral label2 = this.valueFactory.createLiteral("A.N.Other");
        BigdataURI bookstore = this.valueFactory.createURI("http://example/bookStore");
        BigdataURI price = this.valueFactory.createURI("http://example.org/ns#price");
        BigdataLiteral i42 = this.valueFactory.createLiteral("42", XSD.INTEGER);
        BigdataStatement[] data = new BigdataStatement[]{this.valueFactory.createStatement((Resource)book1, (URI)dcTitle, (Value)label1, null, StatementEnum.Explicit), this.valueFactory.createStatement((Resource)book1, (URI)price, (Value)i42, (Resource)bookstore, StatementEnum.Explicit), this.valueFactory.createStatement((Resource)book1, (URI)dcCreator, (Value)label2, null, StatementEnum.Explicit)};
        op.setData(data);
        UpdateRoot actual = this.parseUpdate("PREFIX dc: <http://purl.org/dc/elements/1.1/>\nPREFIX ns: <http://example.org/ns#>\nINSERT DATA\n{\n  <http://example/book1> dc:title \"A new book\" .   GRAPH <http://example/bookStore> { <http://example/book1>  ns:price  42 }\n  <http://example/book1> dc:creator \"A.N.Other\" .\n}", this.baseURI);
        TestUpdateExprBuilder.assertSameAST((String)"PREFIX dc: <http://purl.org/dc/elements/1.1/>\nPREFIX ns: <http://example.org/ns#>\nINSERT DATA\n{\n  <http://example/book1> dc:title \"A new book\" .   GRAPH <http://example/bookStore> { <http://example/book1>  ns:price  42 }\n  <http://example/book1> dc:creator \"A.N.Other\" .\n}", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_delete_data_quads_insert_data_quads() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "PREFIX dc: <http://purl.org/dc/elements/1.1/>\nDELETE DATA\n{ GRAPH <http://example/bookStore> { <http://example/book1>  dc:title  \"Fundamentals of Compiler Desing\" } } ;\n\nPREFIX dc: <http://purl.org/dc/elements/1.1/>\nINSERT DATA\n{ GRAPH <http://example/bookStore> { <http://example/book1>  dc:title  \"Fundamentals of Compiler Design\" } }";
        IV book1 = this.makeIV((BigdataValue)this.valueFactory.createURI("http://example/book1"));
        IV dcTitle = this.makeIV((BigdataValue)this.valueFactory.createURI("http://purl.org/dc/elements/1.1/title"));
        IV label1 = this.makeIV((BigdataValue)this.valueFactory.createLiteral("Fundamentals of Compiler Desing"));
        IV label2 = this.makeIV((BigdataValue)this.valueFactory.createLiteral("Fundamentals of Compiler Design"));
        IV bookstore = this.makeIV((BigdataValue)this.valueFactory.createURI("http://example/bookStore"));
        UpdateRoot expected = new UpdateRoot();
        DeleteData op = new DeleteData();
        expected.addChild((IGroupMemberNode)op);
        BigdataStatement[] data = new BigdataStatement[]{this.valueFactory.createStatement((Resource)((BigdataResource)book1.getValue()), (URI)((BigdataURI)dcTitle.getValue()), (Value)label1.getValue(), (Resource)((BigdataResource)bookstore.getValue()), StatementEnum.Explicit)};
        op.setData(data);
        op = new InsertData();
        expected.addChild((IGroupMemberNode)op);
        data = new BigdataStatement[]{this.valueFactory.createStatement((Resource)((BigdataResource)book1.getValue()), (URI)((BigdataURI)dcTitle.getValue()), (Value)label2.getValue(), (Resource)((BigdataResource)bookstore.getValue()), StatementEnum.Explicit)};
        op.setData(data);
        UpdateRoot actual = this.parseUpdate("PREFIX dc: <http://purl.org/dc/elements/1.1/>\nDELETE DATA\n{ GRAPH <http://example/bookStore> { <http://example/book1>  dc:title  \"Fundamentals of Compiler Desing\" } } ;\n\nPREFIX dc: <http://purl.org/dc/elements/1.1/>\nINSERT DATA\n{ GRAPH <http://example/bookStore> { <http://example/book1>  dc:title  \"Fundamentals of Compiler Design\" } }", this.baseURI);
        TestUpdateExprBuilder.assertSameAST((String)"PREFIX dc: <http://purl.org/dc/elements/1.1/>\nDELETE DATA\n{ GRAPH <http://example/bookStore> { <http://example/book1>  dc:title  \"Fundamentals of Compiler Desing\" } } ;\n\nPREFIX dc: <http://purl.org/dc/elements/1.1/>\nINSERT DATA\n{ GRAPH <http://example/bookStore> { <http://example/book1>  dc:title  \"Fundamentals of Compiler Design\" } }", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_delete_insert_00() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "PREFIX foaf:  <http://xmlns.com/foaf/0.1/>\nDELETE { ?person foaf:givenName 'Bill' }\nINSERT { ?person foaf:givenName 'William' }\nWHERE {\n  ?person foaf:givenName 'Bill'. \n  GRAPH <http://example/addresses> {\n    ?person foaf:givenName 'Bill'\n    }\n}";
        IV addresses = this.makeIV((BigdataValue)this.valueFactory.createURI("http://example/addresses"));
        IV givenName = this.makeIV((BigdataValue)this.valueFactory.createURI("http://xmlns.com/foaf/0.1/givenName"));
        IV label1 = this.makeIV((BigdataValue)this.valueFactory.createLiteral("Bill"));
        IV label2 = this.makeIV((BigdataValue)this.valueFactory.createLiteral("William"));
        UpdateRoot expected = new UpdateRoot();
        DeleteInsertGraph op = new DeleteInsertGraph();
        expected.addChild((IGroupMemberNode)op);
        QuadData deleteClause = new QuadData();
        deleteClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("person"), (TermNode)new ConstantNode(givenName), (TermNode)new ConstantNode(label1), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        op.setDeleteClause(new QuadsDataOrNamedSolutionSet(deleteClause));
        QuadData insertClause = new QuadData();
        insertClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("person"), (TermNode)new ConstantNode(givenName), (TermNode)new ConstantNode(label2), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        op.setInsertClause(new QuadsDataOrNamedSolutionSet(insertClause));
        JoinGroupNode whereClause = new JoinGroupNode();
        op.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("person"), (TermNode)new ConstantNode(givenName), (TermNode)new ConstantNode(label1), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new JoinGroupNode((TermNode)new ConstantNode(addresses), (IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("person"), (TermNode)new ConstantNode(givenName), (TermNode)new ConstantNode(label1), (TermNode)new ConstantNode(addresses), StatementPattern.Scope.NAMED_CONTEXTS)));
        UpdateRoot actual = this.parseUpdate("PREFIX foaf:  <http://xmlns.com/foaf/0.1/>\nDELETE { ?person foaf:givenName 'Bill' }\nINSERT { ?person foaf:givenName 'William' }\nWHERE {\n  ?person foaf:givenName 'Bill'. \n  GRAPH <http://example/addresses> {\n    ?person foaf:givenName 'Bill'\n    }\n}", this.baseURI);
        TestUpdateExprBuilder.assertSameAST((String)"PREFIX foaf:  <http://xmlns.com/foaf/0.1/>\nDELETE { ?person foaf:givenName 'Bill' }\nINSERT { ?person foaf:givenName 'William' }\nWHERE {\n  ?person foaf:givenName 'Bill'. \n  GRAPH <http://example/addresses> {\n    ?person foaf:givenName 'Bill'\n    }\n}", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_delete_insert_01() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "PREFIX foaf:  <http://xmlns.com/foaf/0.1/>\nWITH <http://example/addresses>\nDELETE { ?person foaf:givenName 'Bill' }\nINSERT { ?person foaf:givenName 'William' }\nWHERE {\n  ?person foaf:givenName 'Bill'. \n  GRAPH <http://example/addresses> {\n    ?person foaf:givenName 'Bill'\n    }\n}";
        IV addresses = this.makeIV((BigdataValue)this.valueFactory.createURI("http://example/addresses"));
        IV givenName = this.makeIV((BigdataValue)this.valueFactory.createURI("http://xmlns.com/foaf/0.1/givenName"));
        IV label1 = this.makeIV((BigdataValue)this.valueFactory.createLiteral("Bill"));
        IV label2 = this.makeIV((BigdataValue)this.valueFactory.createLiteral("William"));
        UpdateRoot expected = new UpdateRoot();
        DeleteInsertGraph op = new DeleteInsertGraph();
        expected.addChild((IGroupMemberNode)op);
        QuadData deleteClause = new QuadData();
        deleteClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("person"), (TermNode)new ConstantNode(givenName), (TermNode)new ConstantNode(label1), (TermNode)new ConstantNode(addresses), StatementPattern.Scope.NAMED_CONTEXTS));
        op.setDeleteClause(new QuadsDataOrNamedSolutionSet(deleteClause));
        QuadData insertClause = new QuadData();
        insertClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("person"), (TermNode)new ConstantNode(givenName), (TermNode)new ConstantNode(label2), (TermNode)new ConstantNode(addresses), StatementPattern.Scope.NAMED_CONTEXTS));
        op.setInsertClause(new QuadsDataOrNamedSolutionSet(insertClause));
        JoinGroupNode whereClause = new JoinGroupNode();
        op.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("person"), (TermNode)new ConstantNode(givenName), (TermNode)new ConstantNode(label1), (TermNode)new ConstantNode(addresses), StatementPattern.Scope.NAMED_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new JoinGroupNode((TermNode)new ConstantNode(addresses), (IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("person"), (TermNode)new ConstantNode(givenName), (TermNode)new ConstantNode(label1), (TermNode)new ConstantNode(addresses), StatementPattern.Scope.NAMED_CONTEXTS)));
        UpdateRoot actual = this.parseUpdate("PREFIX foaf:  <http://xmlns.com/foaf/0.1/>\nWITH <http://example/addresses>\nDELETE { ?person foaf:givenName 'Bill' }\nINSERT { ?person foaf:givenName 'William' }\nWHERE {\n  ?person foaf:givenName 'Bill'. \n  GRAPH <http://example/addresses> {\n    ?person foaf:givenName 'Bill'\n    }\n}", this.baseURI);
        TestUpdateExprBuilder.assertSameAST((String)"PREFIX foaf:  <http://xmlns.com/foaf/0.1/>\nWITH <http://example/addresses>\nDELETE { ?person foaf:givenName 'Bill' }\nINSERT { ?person foaf:givenName 'William' }\nWHERE {\n  ?person foaf:givenName 'Bill'. \n  GRAPH <http://example/addresses> {\n    ?person foaf:givenName 'Bill'\n    }\n}", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_delete_insert_02() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "PREFIX foaf:  <http://xmlns.com/foaf/0.1/>\nDELETE { ?person foaf:givenName 'Bill' }\nINSERT { ?person foaf:givenName 'William' }\nUSING <http://example/addresses2>\nWHERE {\n  ?person foaf:givenName 'Bill'. \n  GRAPH <http://example/addresses> {\n    ?person foaf:givenName 'Bill'\n    }\n}";
        IV addresses = this.makeIV((BigdataValue)this.valueFactory.createURI("http://example/addresses"));
        IV addresses2 = this.makeIV((BigdataValue)this.valueFactory.createURI("http://example/addresses2"));
        IV givenName = this.makeIV((BigdataValue)this.valueFactory.createURI("http://xmlns.com/foaf/0.1/givenName"));
        IV label1 = this.makeIV((BigdataValue)this.valueFactory.createLiteral("Bill"));
        IV label2 = this.makeIV((BigdataValue)this.valueFactory.createLiteral("William"));
        UpdateRoot expected = new UpdateRoot();
        DeleteInsertGraph op = new DeleteInsertGraph();
        expected.addChild((IGroupMemberNode)op);
        QuadData deleteClause = new QuadData();
        deleteClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("person"), (TermNode)new ConstantNode(givenName), (TermNode)new ConstantNode(label1), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        op.setDeleteClause(new QuadsDataOrNamedSolutionSet(deleteClause));
        QuadData insertClause = new QuadData();
        insertClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("person"), (TermNode)new ConstantNode(givenName), (TermNode)new ConstantNode(label2), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        op.setInsertClause(new QuadsDataOrNamedSolutionSet(insertClause));
        JoinGroupNode whereClause = new JoinGroupNode();
        op.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("person"), (TermNode)new ConstantNode(givenName), (TermNode)new ConstantNode(label1), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new JoinGroupNode((TermNode)new ConstantNode(addresses), (IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("person"), (TermNode)new ConstantNode(givenName), (TermNode)new ConstantNode(label1), (TermNode)new ConstantNode(addresses), StatementPattern.Scope.NAMED_CONTEXTS)));
        DatasetNode dataset = new DatasetNode(Collections.singleton(addresses2), Collections.emptySet(), true);
        op.setDataset(dataset);
        UpdateRoot actual = this.parseUpdate("PREFIX foaf:  <http://xmlns.com/foaf/0.1/>\nDELETE { ?person foaf:givenName 'Bill' }\nINSERT { ?person foaf:givenName 'William' }\nUSING <http://example/addresses2>\nWHERE {\n  ?person foaf:givenName 'Bill'. \n  GRAPH <http://example/addresses> {\n    ?person foaf:givenName 'Bill'\n    }\n}", this.baseURI);
        TestUpdateExprBuilder.assertSameAST((String)"PREFIX foaf:  <http://xmlns.com/foaf/0.1/>\nDELETE { ?person foaf:givenName 'Bill' }\nINSERT { ?person foaf:givenName 'William' }\nUSING <http://example/addresses2>\nWHERE {\n  ?person foaf:givenName 'Bill'. \n  GRAPH <http://example/addresses> {\n    ?person foaf:givenName 'Bill'\n    }\n}", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_delete_insert_03() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "PREFIX foaf:  <http://xmlns.com/foaf/0.1/>\nDELETE { ?person foaf:givenName 'Bill' }\nINSERT { ?person foaf:givenName 'William' }\nUSING NAMED <http://example/addresses>\nWHERE {\n  ?person foaf:givenName 'Bill'. \n  GRAPH ?graph {\n    ?person foaf:givenName 'Bill'\n    }\n}";
        IV addresses = this.makeIV((BigdataValue)this.valueFactory.createURI("http://example/addresses"));
        IV givenName = this.makeIV((BigdataValue)this.valueFactory.createURI("http://xmlns.com/foaf/0.1/givenName"));
        IV label1 = this.makeIV((BigdataValue)this.valueFactory.createLiteral("Bill"));
        IV label2 = this.makeIV((BigdataValue)this.valueFactory.createLiteral("William"));
        UpdateRoot expected = new UpdateRoot();
        DeleteInsertGraph op = new DeleteInsertGraph();
        expected.addChild((IGroupMemberNode)op);
        QuadData deleteClause = new QuadData();
        deleteClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("person"), (TermNode)new ConstantNode(givenName), (TermNode)new ConstantNode(label1), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        op.setDeleteClause(new QuadsDataOrNamedSolutionSet(deleteClause));
        QuadData insertClause = new QuadData();
        insertClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("person"), (TermNode)new ConstantNode(givenName), (TermNode)new ConstantNode(label2), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        op.setInsertClause(new QuadsDataOrNamedSolutionSet(insertClause));
        JoinGroupNode whereClause = new JoinGroupNode();
        op.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("person"), (TermNode)new ConstantNode(givenName), (TermNode)new ConstantNode(label1), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new JoinGroupNode((TermNode)new VarNode("graph"), (IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("person"), (TermNode)new ConstantNode(givenName), (TermNode)new ConstantNode(label1), (TermNode)new VarNode("graph"), StatementPattern.Scope.NAMED_CONTEXTS)));
        DatasetNode dataset = new DatasetNode(Collections.emptySet(), Collections.singleton(addresses), true);
        op.setDataset(dataset);
        UpdateRoot actual = this.parseUpdate("PREFIX foaf:  <http://xmlns.com/foaf/0.1/>\nDELETE { ?person foaf:givenName 'Bill' }\nINSERT { ?person foaf:givenName 'William' }\nUSING NAMED <http://example/addresses>\nWHERE {\n  ?person foaf:givenName 'Bill'. \n  GRAPH ?graph {\n    ?person foaf:givenName 'Bill'\n    }\n}", this.baseURI);
        TestUpdateExprBuilder.assertSameAST((String)"PREFIX foaf:  <http://xmlns.com/foaf/0.1/>\nDELETE { ?person foaf:givenName 'Bill' }\nINSERT { ?person foaf:givenName 'William' }\nUSING NAMED <http://example/addresses>\nWHERE {\n  ?person foaf:givenName 'Bill'. \n  GRAPH ?graph {\n    ?person foaf:givenName 'Bill'\n    }\n}", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_delete_insert_04() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "PREFIX foaf:  <http://xmlns.com/foaf/0.1/>\nWITH <http://example/addresses>\nDELETE { ?person foaf:givenName 'Bill' }\nINSERT { ?person foaf:givenName 'William' }\nUSING NAMED <http://example/addresses>\nUSING NAMED <http://example/addresses2>\nWHERE {\n  ?person foaf:givenName 'Bill'. \n  GRAPH ?graph {\n    ?person foaf:givenName 'Bill'\n    }\n}";
        IV addresses = this.makeIV((BigdataValue)this.valueFactory.createURI("http://example/addresses"));
        IV addresses2 = this.makeIV((BigdataValue)this.valueFactory.createURI("http://example/addresses2"));
        IV givenName = this.makeIV((BigdataValue)this.valueFactory.createURI("http://xmlns.com/foaf/0.1/givenName"));
        IV label1 = this.makeIV((BigdataValue)this.valueFactory.createLiteral("Bill"));
        IV label2 = this.makeIV((BigdataValue)this.valueFactory.createLiteral("William"));
        UpdateRoot expected = new UpdateRoot();
        DeleteInsertGraph op = new DeleteInsertGraph();
        expected.addChild((IGroupMemberNode)op);
        QuadData deleteClause = new QuadData();
        deleteClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("person"), (TermNode)new ConstantNode(givenName), (TermNode)new ConstantNode(label1), (TermNode)new ConstantNode(addresses), StatementPattern.Scope.NAMED_CONTEXTS));
        op.setDeleteClause(new QuadsDataOrNamedSolutionSet(deleteClause));
        QuadData insertClause = new QuadData();
        insertClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("person"), (TermNode)new ConstantNode(givenName), (TermNode)new ConstantNode(label2), (TermNode)new ConstantNode(addresses), StatementPattern.Scope.NAMED_CONTEXTS));
        op.setInsertClause(new QuadsDataOrNamedSolutionSet(insertClause));
        JoinGroupNode whereClause = new JoinGroupNode();
        op.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("person"), (TermNode)new ConstantNode(givenName), (TermNode)new ConstantNode(label1), (TermNode)new ConstantNode(addresses), StatementPattern.Scope.NAMED_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new JoinGroupNode((TermNode)new VarNode("graph"), (IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("person"), (TermNode)new ConstantNode(givenName), (TermNode)new ConstantNode(label1), (TermNode)new VarNode("graph"), StatementPattern.Scope.NAMED_CONTEXTS)));
        LinkedHashSet<IV> namedGraphs = new LinkedHashSet<IV>();
        namedGraphs.add(addresses);
        namedGraphs.add(addresses2);
        DatasetNode dataset = new DatasetNode(Collections.emptySet(), namedGraphs, true);
        op.setDataset(dataset);
        UpdateRoot actual = this.parseUpdate("PREFIX foaf:  <http://xmlns.com/foaf/0.1/>\nWITH <http://example/addresses>\nDELETE { ?person foaf:givenName 'Bill' }\nINSERT { ?person foaf:givenName 'William' }\nUSING NAMED <http://example/addresses>\nUSING NAMED <http://example/addresses2>\nWHERE {\n  ?person foaf:givenName 'Bill'. \n  GRAPH ?graph {\n    ?person foaf:givenName 'Bill'\n    }\n}", this.baseURI);
        TestUpdateExprBuilder.assertSameAST((String)"PREFIX foaf:  <http://xmlns.com/foaf/0.1/>\nWITH <http://example/addresses>\nDELETE { ?person foaf:givenName 'Bill' }\nINSERT { ?person foaf:givenName 'William' }\nUSING NAMED <http://example/addresses>\nUSING NAMED <http://example/addresses2>\nWHERE {\n  ?person foaf:givenName 'Bill'. \n  GRAPH ?graph {\n    ?person foaf:givenName 'Bill'\n    }\n}", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_delete_insert_10() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "PREFIX foaf:  <http://xmlns.com/foaf/0.1/>\nDELETE {\n  GRAPH <http://example/addresses> { ?person foaf:givenName 'Bill' } .\n  ?person foaf:givenName 'Bill'\n}\nINSERT {\n  ?person foaf:givenName 'William'\n  GRAPH <http://example/addresses> { ?person foaf:givenName 'William' } .\n}\nWHERE {\n  ?person foaf:givenName 'Bill'. \n  GRAPH <http://example/addresses> {\n    ?person foaf:givenName 'Bill'\n    }\n}";
        IV addresses = this.makeIV((BigdataValue)this.valueFactory.createURI("http://example/addresses"));
        IV givenName = this.makeIV((BigdataValue)this.valueFactory.createURI("http://xmlns.com/foaf/0.1/givenName"));
        IV label1 = this.makeIV((BigdataValue)this.valueFactory.createLiteral("Bill"));
        IV label2 = this.makeIV((BigdataValue)this.valueFactory.createLiteral("William"));
        UpdateRoot expected = new UpdateRoot();
        DeleteInsertGraph op = new DeleteInsertGraph();
        expected.addChild((IGroupMemberNode)op);
        QuadData deleteClause = new QuadData();
        deleteClause.addChild((IGroupMemberNode)new QuadData((IStatementContainer)new StatementPatternNode((TermNode)new VarNode("person"), (TermNode)new ConstantNode(givenName), (TermNode)new ConstantNode(label1), (TermNode)new ConstantNode(addresses), StatementPattern.Scope.NAMED_CONTEXTS)));
        deleteClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("person"), (TermNode)new ConstantNode(givenName), (TermNode)new ConstantNode(label1), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        op.setDeleteClause(new QuadsDataOrNamedSolutionSet(deleteClause));
        QuadData insertClause = new QuadData();
        insertClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("person"), (TermNode)new ConstantNode(givenName), (TermNode)new ConstantNode(label2), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        insertClause.addChild((IGroupMemberNode)new QuadData((IStatementContainer)new StatementPatternNode((TermNode)new VarNode("person"), (TermNode)new ConstantNode(givenName), (TermNode)new ConstantNode(label2), (TermNode)new ConstantNode(addresses), StatementPattern.Scope.NAMED_CONTEXTS)));
        op.setInsertClause(new QuadsDataOrNamedSolutionSet(insertClause));
        JoinGroupNode whereClause = new JoinGroupNode();
        op.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("person"), (TermNode)new ConstantNode(givenName), (TermNode)new ConstantNode(label1), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new JoinGroupNode((TermNode)new ConstantNode(addresses), (IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("person"), (TermNode)new ConstantNode(givenName), (TermNode)new ConstantNode(label1), (TermNode)new ConstantNode(addresses), StatementPattern.Scope.NAMED_CONTEXTS)));
        UpdateRoot actual = this.parseUpdate("PREFIX foaf:  <http://xmlns.com/foaf/0.1/>\nDELETE {\n  GRAPH <http://example/addresses> { ?person foaf:givenName 'Bill' } .\n  ?person foaf:givenName 'Bill'\n}\nINSERT {\n  ?person foaf:givenName 'William'\n  GRAPH <http://example/addresses> { ?person foaf:givenName 'William' } .\n}\nWHERE {\n  ?person foaf:givenName 'Bill'. \n  GRAPH <http://example/addresses> {\n    ?person foaf:givenName 'Bill'\n    }\n}", this.baseURI);
        TestUpdateExprBuilder.assertSameAST((String)"PREFIX foaf:  <http://xmlns.com/foaf/0.1/>\nDELETE {\n  GRAPH <http://example/addresses> { ?person foaf:givenName 'Bill' } .\n  ?person foaf:givenName 'Bill'\n}\nINSERT {\n  ?person foaf:givenName 'William'\n  GRAPH <http://example/addresses> { ?person foaf:givenName 'William' } .\n}\nWHERE {\n  ?person foaf:givenName 'Bill'. \n  GRAPH <http://example/addresses> {\n    ?person foaf:givenName 'Bill'\n    }\n}", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_delete_insert_11() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "PREFIX foaf:  <http://xmlns.com/foaf/0.1/>\nWITH <http://example/addresses>\nDELETE {\n  GRAPH ?graph { ?person foaf:givenName 'Bill' } .\n  ?person foaf:givenName 'Bill'\n}\nINSERT {\n  ?person foaf:givenName 'William'\n  GRAPH ?graph { ?person foaf:givenName 'William' } .\n}\nWHERE {\n  ?person foaf:givenName 'Bill'. \n  GRAPH ?group {\n    ?person foaf:givenName 'Bill'\n    }\n}";
        IV addresses = this.makeIV((BigdataValue)this.valueFactory.createURI("http://example/addresses"));
        IV givenName = this.makeIV((BigdataValue)this.valueFactory.createURI("http://xmlns.com/foaf/0.1/givenName"));
        IV label1 = this.makeIV((BigdataValue)this.valueFactory.createLiteral("Bill"));
        IV label2 = this.makeIV((BigdataValue)this.valueFactory.createLiteral("William"));
        UpdateRoot expected = new UpdateRoot();
        DeleteInsertGraph op = new DeleteInsertGraph();
        expected.addChild((IGroupMemberNode)op);
        QuadData deleteClause = new QuadData();
        deleteClause.addChild((IGroupMemberNode)new QuadData((IStatementContainer)new StatementPatternNode((TermNode)new VarNode("person"), (TermNode)new ConstantNode(givenName), (TermNode)new ConstantNode(label1), (TermNode)new VarNode("graph"), StatementPattern.Scope.NAMED_CONTEXTS)));
        deleteClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("person"), (TermNode)new ConstantNode(givenName), (TermNode)new ConstantNode(label1), (TermNode)new ConstantNode(addresses), StatementPattern.Scope.NAMED_CONTEXTS));
        op.setDeleteClause(new QuadsDataOrNamedSolutionSet(deleteClause));
        QuadData insertClause = new QuadData();
        insertClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("person"), (TermNode)new ConstantNode(givenName), (TermNode)new ConstantNode(label2), (TermNode)new ConstantNode(addresses), StatementPattern.Scope.NAMED_CONTEXTS));
        insertClause.addChild((IGroupMemberNode)new QuadData((IStatementContainer)new StatementPatternNode((TermNode)new VarNode("person"), (TermNode)new ConstantNode(givenName), (TermNode)new ConstantNode(label2), (TermNode)new VarNode("graph"), StatementPattern.Scope.NAMED_CONTEXTS)));
        op.setInsertClause(new QuadsDataOrNamedSolutionSet(insertClause));
        JoinGroupNode whereClause = new JoinGroupNode();
        op.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("person"), (TermNode)new ConstantNode(givenName), (TermNode)new ConstantNode(label1), (TermNode)new ConstantNode(addresses), StatementPattern.Scope.NAMED_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new JoinGroupNode((TermNode)new VarNode("group"), (IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("person"), (TermNode)new ConstantNode(givenName), (TermNode)new ConstantNode(label1), (TermNode)new VarNode("group"), StatementPattern.Scope.NAMED_CONTEXTS)));
        UpdateRoot actual = this.parseUpdate("PREFIX foaf:  <http://xmlns.com/foaf/0.1/>\nWITH <http://example/addresses>\nDELETE {\n  GRAPH ?graph { ?person foaf:givenName 'Bill' } .\n  ?person foaf:givenName 'Bill'\n}\nINSERT {\n  ?person foaf:givenName 'William'\n  GRAPH ?graph { ?person foaf:givenName 'William' } .\n}\nWHERE {\n  ?person foaf:givenName 'Bill'. \n  GRAPH ?group {\n    ?person foaf:givenName 'Bill'\n    }\n}", this.baseURI);
        TestUpdateExprBuilder.assertSameAST((String)"PREFIX foaf:  <http://xmlns.com/foaf/0.1/>\nWITH <http://example/addresses>\nDELETE {\n  GRAPH ?graph { ?person foaf:givenName 'Bill' } .\n  ?person foaf:givenName 'Bill'\n}\nINSERT {\n  ?person foaf:givenName 'William'\n  GRAPH ?graph { ?person foaf:givenName 'William' } .\n}\nWHERE {\n  ?person foaf:givenName 'Bill'. \n  GRAPH ?group {\n    ?person foaf:givenName 'Bill'\n    }\n}", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_delete_insert_20() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "PREFIX dc:  <http://purl.org/dc/elements/1.1/>\nPREFIX xsd: <http://www.w3.org/2001/XMLSchema#>\nDELETE\n { ?book ?p ?v }\nWHERE\n { ?book dc:date ?date .\n  FILTER ( ?date > \"1970-01-01T00:00:00-02:00\"^^xsd:dateTime )\n   ?book ?p ?v\n}";
        IV dcDate = this.makeIV((BigdataValue)this.valueFactory.createURI("http://purl.org/dc/elements/1.1/date"));
        IV dateTime = this.makeIV((BigdataValue)this.valueFactory.createLiteral("1970-01-01T00:00:00-02:00", XSD.DATETIME));
        UpdateRoot expected = new UpdateRoot();
        DeleteInsertGraph op = new DeleteInsertGraph();
        expected.addChild((IGroupMemberNode)op);
        QuadData deleteClause = new QuadData();
        deleteClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("book"), (TermNode)new VarNode("p"), (TermNode)new VarNode("v")));
        op.setDeleteClause(new QuadsDataOrNamedSolutionSet(deleteClause));
        JoinGroupNode whereClause = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("book"), (TermNode)new ConstantNode(dcDate), (TermNode)new VarNode("date")));
        whereClause.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)FunctionNode.GT((ValueExpressionNode)new VarNode("date"), (ValueExpressionNode)new ConstantNode(dateTime))));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("book"), (TermNode)new VarNode("p"), (TermNode)new VarNode("v")));
        op.setWhereClause((GraphPatternGroup)whereClause);
        UpdateRoot actual = this.parseUpdate("PREFIX dc:  <http://purl.org/dc/elements/1.1/>\nPREFIX xsd: <http://www.w3.org/2001/XMLSchema#>\nDELETE\n { ?book ?p ?v }\nWHERE\n { ?book dc:date ?date .\n  FILTER ( ?date > \"1970-01-01T00:00:00-02:00\"^^xsd:dateTime )\n   ?book ?p ?v\n}", this.baseURI);
        TestUpdateExprBuilder.assertSameAST((String)"PREFIX dc:  <http://purl.org/dc/elements/1.1/>\nPREFIX xsd: <http://www.w3.org/2001/XMLSchema#>\nDELETE\n { ?book ?p ?v }\nWHERE\n { ?book dc:date ?date .\n  FILTER ( ?date > \"1970-01-01T00:00:00-02:00\"^^xsd:dateTime )\n   ?book ?p ?v\n}", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_delete_insert_21() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "PREFIX dc:  <http://purl.org/dc/elements/1.1/>\nPREFIX xsd: <http://www.w3.org/2001/XMLSchema#>\nINSERT \n   { GRAPH <http://example/bookStore2> { ?book ?p ?v } }\nWHERE\n   { GRAPH  <http://example/bookStore>\n        { ?book dc:date ?date .\n          FILTER ( ?date > \"1970-01-01T00:00:00-02:00\"^^xsd:dateTime )\n          ?book ?p ?v\n} }";
        IV dcDate = this.makeIV((BigdataValue)this.valueFactory.createURI("http://purl.org/dc/elements/1.1/date"));
        IV dateTime = this.makeIV((BigdataValue)this.valueFactory.createLiteral("1970-01-01T00:00:00-02:00", XSD.DATETIME));
        IV bookstore = this.makeIV((BigdataValue)this.valueFactory.createURI("http://example/bookStore"));
        IV bookstore2 = this.makeIV((BigdataValue)this.valueFactory.createURI("http://example/bookStore2"));
        UpdateRoot expected = new UpdateRoot();
        DeleteInsertGraph op = new DeleteInsertGraph();
        expected.addChild((IGroupMemberNode)op);
        QuadData insertClause = new QuadData();
        QuadData innerGraph = new QuadData();
        insertClause.addChild((IGroupMemberNode)innerGraph);
        innerGraph.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("book"), (TermNode)new VarNode("p"), (TermNode)new VarNode("v"), (TermNode)new ConstantNode(bookstore2), StatementPattern.Scope.NAMED_CONTEXTS));
        op.setInsertClause(new QuadsDataOrNamedSolutionSet(insertClause));
        JoinGroupNode whereClause = new JoinGroupNode();
        JoinGroupNode graphGroup = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)graphGroup);
        graphGroup.setContext((TermNode)new ConstantNode(bookstore));
        graphGroup.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("book"), (TermNode)new ConstantNode(dcDate), (TermNode)new VarNode("date"), (TermNode)new ConstantNode(bookstore), StatementPattern.Scope.NAMED_CONTEXTS));
        graphGroup.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)FunctionNode.GT((ValueExpressionNode)new VarNode("date"), (ValueExpressionNode)new ConstantNode(dateTime))));
        graphGroup.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("book"), (TermNode)new VarNode("p"), (TermNode)new VarNode("v"), (TermNode)new ConstantNode(bookstore), StatementPattern.Scope.NAMED_CONTEXTS));
        op.setWhereClause((GraphPatternGroup)whereClause);
        UpdateRoot actual = this.parseUpdate("PREFIX dc:  <http://purl.org/dc/elements/1.1/>\nPREFIX xsd: <http://www.w3.org/2001/XMLSchema#>\nINSERT \n   { GRAPH <http://example/bookStore2> { ?book ?p ?v } }\nWHERE\n   { GRAPH  <http://example/bookStore>\n        { ?book dc:date ?date .\n          FILTER ( ?date > \"1970-01-01T00:00:00-02:00\"^^xsd:dateTime )\n          ?book ?p ?v\n} }", this.baseURI);
        TestUpdateExprBuilder.assertSameAST((String)"PREFIX dc:  <http://purl.org/dc/elements/1.1/>\nPREFIX xsd: <http://www.w3.org/2001/XMLSchema#>\nINSERT \n   { GRAPH <http://example/bookStore2> { ?book ?p ?v } }\nWHERE\n   { GRAPH  <http://example/bookStore>\n        { ?book dc:date ?date .\n          FILTER ( ?date > \"1970-01-01T00:00:00-02:00\"^^xsd:dateTime )\n          ?book ?p ?v\n} }", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_delete_where_01() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "DELETE WHERE {?x <http://xmlns.com/foaf/0.1/name> ?y }";
        IV foafName = this.makeIV((BigdataValue)this.valueFactory.createURI("http://xmlns.com/foaf/0.1/name"));
        UpdateRoot expected = new UpdateRoot();
        DeleteInsertGraph op = new DeleteInsertGraph();
        expected.addChild((IGroupMemberNode)op);
        JoinGroupNode whereClause = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(foafName), (TermNode)new VarNode("y")));
        op.setWhereClause((GraphPatternGroup)whereClause);
        UpdateRoot actual = this.parseUpdate("DELETE WHERE {?x <http://xmlns.com/foaf/0.1/name> ?y }", this.baseURI);
        TestUpdateExprBuilder.assertSameAST((String)"DELETE WHERE {?x <http://xmlns.com/foaf/0.1/name> ?y }", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_delete_where_02() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "DELETE WHERE { GRAPH ?g { ?x <http://xmlns.com/foaf/0.1/name> ?y } }";
        IV foafName = this.makeIV((BigdataValue)this.valueFactory.createURI("http://xmlns.com/foaf/0.1/name"));
        UpdateRoot expected = new UpdateRoot();
        DeleteInsertGraph op = new DeleteInsertGraph();
        expected.addChild((IGroupMemberNode)op);
        JoinGroupNode whereClause = new JoinGroupNode();
        JoinGroupNode graphClause = new JoinGroupNode();
        graphClause.setContext((TermNode)new VarNode("g"));
        whereClause.addChild((IGroupMemberNode)graphClause);
        graphClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(foafName), (TermNode)new VarNode("y"), (TermNode)new VarNode("g"), StatementPattern.Scope.NAMED_CONTEXTS));
        op.setWhereClause((GraphPatternGroup)whereClause);
        UpdateRoot actual = this.parseUpdate("DELETE WHERE { GRAPH ?g { ?x <http://xmlns.com/foaf/0.1/name> ?y } }", this.baseURI);
        TestUpdateExprBuilder.assertSameAST((String)"DELETE WHERE { GRAPH ?g { ?x <http://xmlns.com/foaf/0.1/name> ?y } }", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_delete_insert_blankNodes01() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "PREFIX foaf:  <http://xmlns.com/foaf/0.1/>\nDELETE { [] foaf:givenName 'Bill' }\nINSERT { ?person foaf:givenName 'William' }\nWHERE {\n  ?person foaf:givenName 'Bill'. \n  GRAPH <http://example/addresses> {\n    ?person foaf:givenName 'Bill'\n    }\n}";
        try {
            this.parseUpdate("PREFIX foaf:  <http://xmlns.com/foaf/0.1/>\nDELETE { [] foaf:givenName 'Bill' }\nINSERT { ?person foaf:givenName 'William' }\nWHERE {\n  ?person foaf:givenName 'Bill'. \n  GRAPH <http://example/addresses> {\n    ?person foaf:givenName 'Bill'\n    }\n}", this.baseURI);
            TestUpdateExprBuilder.fail((String)"Expecting exception: blank nodes not allowed in DELETE template");
        }
        catch (MalformedQueryException malformedQueryException) {
            // empty catch block
        }
    }

    public void test_delete_insert_blankNodes02() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "PREFIX foaf:  <http://xmlns.com/foaf/0.1/>\nDELETE { ?person foaf:givenName [] }\nINSERT { ?person foaf:givenName 'William' }\nWHERE {\n  ?person foaf:givenName 'Bill'. \n  GRAPH <http://example/addresses> {\n    ?person foaf:givenName 'Bill'\n    }\n}";
        try {
            this.parseUpdate("PREFIX foaf:  <http://xmlns.com/foaf/0.1/>\nDELETE { ?person foaf:givenName [] }\nINSERT { ?person foaf:givenName 'William' }\nWHERE {\n  ?person foaf:givenName 'Bill'. \n  GRAPH <http://example/addresses> {\n    ?person foaf:givenName 'Bill'\n    }\n}", this.baseURI);
            TestUpdateExprBuilder.fail((String)"Expecting exception: blank nodes not allowed in DELETE template");
        }
        catch (MalformedQueryException malformedQueryException) {
            // empty catch block
        }
    }

    public void test_delete_where_without_shortcut_02() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "DELETE {?x <http://xmlns.com/foaf/0.1/name> ?y}\n WHERE {?x <http://xmlns.com/foaf/0.1/name> ?y }";
        IV foafName = this.makeIV((BigdataValue)this.valueFactory.createURI("http://xmlns.com/foaf/0.1/name"));
        UpdateRoot expected = new UpdateRoot();
        DeleteInsertGraph op = new DeleteInsertGraph();
        expected.addChild((IGroupMemberNode)op);
        QuadData deleteClause = new QuadData();
        deleteClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(foafName), (TermNode)new VarNode("y")));
        op.setDeleteClause(new QuadsDataOrNamedSolutionSet(deleteClause));
        JoinGroupNode whereClause = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(foafName), (TermNode)new VarNode("y")));
        op.setWhereClause((GraphPatternGroup)whereClause);
        UpdateRoot actual = this.parseUpdate("DELETE {?x <http://xmlns.com/foaf/0.1/name> ?y}\n WHERE {?x <http://xmlns.com/foaf/0.1/name> ?y }", this.baseURI);
        TestUpdateExprBuilder.assertSameAST((String)"DELETE {?x <http://xmlns.com/foaf/0.1/name> ?y}\n WHERE {?x <http://xmlns.com/foaf/0.1/name> ?y }", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_delete_insert_30() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "PREFIX foaf:  <http://xmlns.com/foaf/0.1/>\nDELETE { ?person foaf:givenName 'Bill' }\nWHERE {\n  ?person foaf:givenName 'Bill'. \n  GRAPH ?graph {\n    ?person foaf:givenName 'Bill'\n    }\n};INSERT { ?person foaf:givenName 'William' }\nUSING NAMED <http://example/addresses>\nWHERE {\n  ?person foaf:givenName 'Bill'. \n  GRAPH ?graph {\n    ?person foaf:givenName 'Bill'\n    }\n}";
        IV addresses = this.makeIV((BigdataValue)this.valueFactory.createURI("http://example/addresses"));
        IV givenName = this.makeIV((BigdataValue)this.valueFactory.createURI("http://xmlns.com/foaf/0.1/givenName"));
        IV label1 = this.makeIV((BigdataValue)this.valueFactory.createLiteral("Bill"));
        IV label2 = this.makeIV((BigdataValue)this.valueFactory.createLiteral("William"));
        UpdateRoot expected = new UpdateRoot();
        DeleteInsertGraph op = new DeleteInsertGraph();
        expected.addChild((IGroupMemberNode)op);
        QuadData deleteClause = new QuadData();
        deleteClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("person"), (TermNode)new ConstantNode(givenName), (TermNode)new ConstantNode(label1), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        op.setDeleteClause(new QuadsDataOrNamedSolutionSet(deleteClause));
        JoinGroupNode whereClause = new JoinGroupNode();
        op.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("person"), (TermNode)new ConstantNode(givenName), (TermNode)new ConstantNode(label1), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new JoinGroupNode((TermNode)new VarNode("graph"), (IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("person"), (TermNode)new ConstantNode(givenName), (TermNode)new ConstantNode(label1), (TermNode)new VarNode("graph"), StatementPattern.Scope.NAMED_CONTEXTS)));
        op = new DeleteInsertGraph();
        expected.addChild((IGroupMemberNode)op);
        QuadData insertClause = new QuadData();
        insertClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("person"), (TermNode)new ConstantNode(givenName), (TermNode)new ConstantNode(label2), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        op.setInsertClause(new QuadsDataOrNamedSolutionSet(insertClause));
        whereClause = new JoinGroupNode();
        op.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("person"), (TermNode)new ConstantNode(givenName), (TermNode)new ConstantNode(label1), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new JoinGroupNode((TermNode)new VarNode("graph"), (IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("person"), (TermNode)new ConstantNode(givenName), (TermNode)new ConstantNode(label1), (TermNode)new VarNode("graph"), StatementPattern.Scope.NAMED_CONTEXTS)));
        LinkedHashSet<IV> namedGraphs = new LinkedHashSet<IV>();
        namedGraphs.add(addresses);
        DatasetNode dataset = new DatasetNode(Collections.emptySet(), namedGraphs, true);
        op.setDataset(dataset);
        UpdateRoot actual = this.parseUpdate("PREFIX foaf:  <http://xmlns.com/foaf/0.1/>\nDELETE { ?person foaf:givenName 'Bill' }\nWHERE {\n  ?person foaf:givenName 'Bill'. \n  GRAPH ?graph {\n    ?person foaf:givenName 'Bill'\n    }\n};INSERT { ?person foaf:givenName 'William' }\nUSING NAMED <http://example/addresses>\nWHERE {\n  ?person foaf:givenName 'Bill'. \n  GRAPH ?graph {\n    ?person foaf:givenName 'Bill'\n    }\n}", this.baseURI);
        TestUpdateExprBuilder.assertSameAST((String)"PREFIX foaf:  <http://xmlns.com/foaf/0.1/>\nDELETE { ?person foaf:givenName 'Bill' }\nWHERE {\n  ?person foaf:givenName 'Bill'. \n  GRAPH ?graph {\n    ?person foaf:givenName 'Bill'\n    }\n};INSERT { ?person foaf:givenName 'William' }\nUSING NAMED <http://example/addresses>\nWHERE {\n  ?person foaf:givenName 'Bill'. \n  GRAPH ?graph {\n    ?person foaf:givenName 'Bill'\n    }\n}", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_delete_insert_31() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "PREFIX foaf:  <http://xmlns.com/foaf/0.1/>\nDELETE { ?person foaf:givenName 'Bill' }\nUSING NAMED <http://example/addresses>\nWHERE {\n  ?person foaf:givenName 'Bill'. \n  GRAPH ?graph {\n    ?person foaf:givenName 'Bill'\n    }\n};INSERT { ?person foaf:givenName 'William' }\nWHERE {\n  ?person foaf:givenName 'Bill'. \n  GRAPH ?graph {\n    ?person foaf:givenName 'Bill'\n    }\n}";
        IV addresses = this.makeIV((BigdataValue)this.valueFactory.createURI("http://example/addresses"));
        IV givenName = this.makeIV((BigdataValue)this.valueFactory.createURI("http://xmlns.com/foaf/0.1/givenName"));
        IV label1 = this.makeIV((BigdataValue)this.valueFactory.createLiteral("Bill"));
        IV label2 = this.makeIV((BigdataValue)this.valueFactory.createLiteral("William"));
        UpdateRoot expected = new UpdateRoot();
        DeleteInsertGraph op = new DeleteInsertGraph();
        expected.addChild((IGroupMemberNode)op);
        QuadData deleteClause = new QuadData();
        deleteClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("person"), (TermNode)new ConstantNode(givenName), (TermNode)new ConstantNode(label1), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        op.setDeleteClause(new QuadsDataOrNamedSolutionSet(deleteClause));
        JoinGroupNode whereClause = new JoinGroupNode();
        op.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("person"), (TermNode)new ConstantNode(givenName), (TermNode)new ConstantNode(label1), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new JoinGroupNode((TermNode)new VarNode("graph"), (IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("person"), (TermNode)new ConstantNode(givenName), (TermNode)new ConstantNode(label1), (TermNode)new VarNode("graph"), StatementPattern.Scope.NAMED_CONTEXTS)));
        LinkedHashSet<IV> namedGraphs = new LinkedHashSet<IV>();
        namedGraphs.add(addresses);
        DatasetNode dataset = new DatasetNode(Collections.emptySet(), namedGraphs, true);
        op.setDataset(dataset);
        op = new DeleteInsertGraph();
        expected.addChild((IGroupMemberNode)op);
        QuadData insertClause = new QuadData();
        insertClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("person"), (TermNode)new ConstantNode(givenName), (TermNode)new ConstantNode(label2), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        op.setInsertClause(new QuadsDataOrNamedSolutionSet(insertClause));
        whereClause = new JoinGroupNode();
        op.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("person"), (TermNode)new ConstantNode(givenName), (TermNode)new ConstantNode(label1), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new JoinGroupNode((TermNode)new VarNode("graph"), (IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("person"), (TermNode)new ConstantNode(givenName), (TermNode)new ConstantNode(label1), (TermNode)new VarNode("graph"), StatementPattern.Scope.NAMED_CONTEXTS)));
        UpdateRoot actual = this.parseUpdate("PREFIX foaf:  <http://xmlns.com/foaf/0.1/>\nDELETE { ?person foaf:givenName 'Bill' }\nUSING NAMED <http://example/addresses>\nWHERE {\n  ?person foaf:givenName 'Bill'. \n  GRAPH ?graph {\n    ?person foaf:givenName 'Bill'\n    }\n};INSERT { ?person foaf:givenName 'William' }\nWHERE {\n  ?person foaf:givenName 'Bill'. \n  GRAPH ?graph {\n    ?person foaf:givenName 'Bill'\n    }\n}", this.baseURI);
        TestUpdateExprBuilder.assertSameAST((String)"PREFIX foaf:  <http://xmlns.com/foaf/0.1/>\nDELETE { ?person foaf:givenName 'Bill' }\nUSING NAMED <http://example/addresses>\nWHERE {\n  ?person foaf:givenName 'Bill'. \n  GRAPH ?graph {\n    ?person foaf:givenName 'Bill'\n    }\n};INSERT { ?person foaf:givenName 'William' }\nWHERE {\n  ?person foaf:givenName 'Bill'. \n  GRAPH ?graph {\n    ?person foaf:givenName 'Bill'\n    }\n}", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_datasets_isolation() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "PREFIX foaf:  <http://xmlns.com/foaf/0.1/>\nDELETE { ?person foaf:givenName 'Bill' }\nUSING NAMED <http://example/addresses>\nWHERE {\n  ?person foaf:givenName 'Bill'. \n  GRAPH ?graph {\n    ?person foaf:givenName 'Bill'\n    }\n};INSERT { ?person foaf:givenName 'William' }\nUSING NAMED <http://example/addresses2>\nWHERE {\n  ?person foaf:givenName 'Bill'. \n  GRAPH ?graph {\n    ?person foaf:givenName 'Bill'\n    }\n}";
        IV addresses = this.makeIV((BigdataValue)this.valueFactory.createURI("http://example/addresses"));
        IV addresses2 = this.makeIV((BigdataValue)this.valueFactory.createURI("http://example/addresses2"));
        IV givenName = this.makeIV((BigdataValue)this.valueFactory.createURI("http://xmlns.com/foaf/0.1/givenName"));
        IV label1 = this.makeIV((BigdataValue)this.valueFactory.createLiteral("Bill"));
        IV label2 = this.makeIV((BigdataValue)this.valueFactory.createLiteral("William"));
        UpdateRoot expected = new UpdateRoot();
        DeleteInsertGraph op = new DeleteInsertGraph();
        expected.addChild((IGroupMemberNode)op);
        QuadData deleteClause = new QuadData();
        deleteClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("person"), (TermNode)new ConstantNode(givenName), (TermNode)new ConstantNode(label1), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        op.setDeleteClause(new QuadsDataOrNamedSolutionSet(deleteClause));
        JoinGroupNode whereClause = new JoinGroupNode();
        op.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("person"), (TermNode)new ConstantNode(givenName), (TermNode)new ConstantNode(label1), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new JoinGroupNode((TermNode)new VarNode("graph"), (IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("person"), (TermNode)new ConstantNode(givenName), (TermNode)new ConstantNode(label1), (TermNode)new VarNode("graph"), StatementPattern.Scope.NAMED_CONTEXTS)));
        LinkedHashSet<IV> namedGraphs = new LinkedHashSet<IV>();
        namedGraphs.add(addresses);
        DatasetNode dataset = new DatasetNode(Collections.emptySet(), namedGraphs, true);
        op.setDataset(dataset);
        op = new DeleteInsertGraph();
        expected.addChild((IGroupMemberNode)op);
        QuadData insertClause = new QuadData();
        insertClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("person"), (TermNode)new ConstantNode(givenName), (TermNode)new ConstantNode(label2), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        op.setInsertClause(new QuadsDataOrNamedSolutionSet(insertClause));
        whereClause = new JoinGroupNode();
        op.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("person"), (TermNode)new ConstantNode(givenName), (TermNode)new ConstantNode(label1), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new JoinGroupNode((TermNode)new VarNode("graph"), (IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("person"), (TermNode)new ConstantNode(givenName), (TermNode)new ConstantNode(label1), (TermNode)new VarNode("graph"), StatementPattern.Scope.NAMED_CONTEXTS)));
        namedGraphs = new LinkedHashSet();
        namedGraphs.add(addresses2);
        dataset = new DatasetNode(Collections.emptySet(), namedGraphs, true);
        op.setDataset(dataset);
        UpdateRoot actual = this.parseUpdate("PREFIX foaf:  <http://xmlns.com/foaf/0.1/>\nDELETE { ?person foaf:givenName 'Bill' }\nUSING NAMED <http://example/addresses>\nWHERE {\n  ?person foaf:givenName 'Bill'. \n  GRAPH ?graph {\n    ?person foaf:givenName 'Bill'\n    }\n};INSERT { ?person foaf:givenName 'William' }\nUSING NAMED <http://example/addresses2>\nWHERE {\n  ?person foaf:givenName 'Bill'. \n  GRAPH ?graph {\n    ?person foaf:givenName 'Bill'\n    }\n}", this.baseURI);
        TestUpdateExprBuilder.assertSameAST((String)"PREFIX foaf:  <http://xmlns.com/foaf/0.1/>\nDELETE { ?person foaf:givenName 'Bill' }\nUSING NAMED <http://example/addresses>\nWHERE {\n  ?person foaf:givenName 'Bill'. \n  GRAPH ?graph {\n    ?person foaf:givenName 'Bill'\n    }\n};INSERT { ?person foaf:givenName 'William' }\nUSING NAMED <http://example/addresses2>\nWHERE {\n  ?person foaf:givenName 'Bill'. \n  GRAPH ?graph {\n    ?person foaf:givenName 'Bill'\n    }\n}", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_ticket_562() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "INSERT {\n  GRAPH <http://example/out> { ?s ?p ?v . }\n}\nWHERE {\n  SELECT ?s ?p ?v\n  WHERE {\n    GRAPH <http://example/in> { ?s ?p ?v . }\n    }\n}";
        IV out = this.makeIV((BigdataValue)this.valueFactory.createURI("http://example/out"));
        IV in = this.makeIV((BigdataValue)this.valueFactory.createURI("http://example/in"));
        UpdateRoot expected = new UpdateRoot();
        DeleteInsertGraph op = new DeleteInsertGraph();
        expected.addChild((IGroupMemberNode)op);
        QuadData insertClause = new QuadData();
        op.setInsertClause(new QuadsDataOrNamedSolutionSet(insertClause));
        QuadData innerGroup = new QuadData();
        insertClause.addChild((IGroupMemberNode)innerGroup);
        innerGroup.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("v"), (TermNode)new ConstantNode(out), StatementPattern.Scope.NAMED_CONTEXTS));
        JoinGroupNode whereClause = new JoinGroupNode();
        op.setWhereClause((GraphPatternGroup)whereClause);
        SubqueryRoot subquery = new SubqueryRoot(QueryType.SELECT);
        whereClause.addChild((IGroupMemberNode)subquery);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("s"));
        projection.addProjectionVar(new VarNode("p"));
        projection.addProjectionVar(new VarNode("v"));
        subquery.setProjection(projection);
        JoinGroupNode whereClause2 = new JoinGroupNode();
        subquery.setWhereClause((GraphPatternGroup)whereClause2);
        JoinGroupNode graphClause = new JoinGroupNode();
        graphClause.setContext((TermNode)new ConstantNode(in));
        whereClause2.addChild((IGroupMemberNode)graphClause);
        graphClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("v"), (TermNode)new ConstantNode(in), StatementPattern.Scope.NAMED_CONTEXTS));
        UpdateRoot actual = this.parseUpdate("INSERT {\n  GRAPH <http://example/out> { ?s ?p ?v . }\n}\nWHERE {\n  SELECT ?s ?p ?v\n  WHERE {\n    GRAPH <http://example/in> { ?s ?p ?v . }\n    }\n}", this.baseURI);
        TestUpdateExprBuilder.assertSameAST((String)"INSERT {\n  GRAPH <http://example/out> { ?s ?p ?v . }\n}\nWHERE {\n  SELECT ?s ?p ?v\n  WHERE {\n    GRAPH <http://example/in> { ?s ?p ?v . }\n    }\n}", (IQueryNode)expected, (IQueryNode)actual);
    }
}

