/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.sparql;

import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.XSD;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataStatement;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.StatementEnum;
import com.bigdata.rdf.sail.sparql.ast.ParseException;
import com.bigdata.rdf.sail.sparql.ast.TokenMgrError;
import com.bigdata.rdf.sparql.AbstractBigdataExprBuilderTestCase;
import com.bigdata.rdf.sparql.ast.ClearGraph;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.CreateGraph;
import com.bigdata.rdf.sparql.ast.DeleteInsertGraph;
import com.bigdata.rdf.sparql.ast.DropGraph;
import com.bigdata.rdf.sparql.ast.FilterNode;
import com.bigdata.rdf.sparql.ast.FunctionNode;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.IValueExpressionNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.ProjectionNode;
import com.bigdata.rdf.sparql.ast.QuadsDataOrNamedSolutionSet;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.UpdateRoot;
import com.bigdata.rdf.sparql.ast.ValueExpressionNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.hints.QueryHintScope;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.algebra.StatementPattern;

public class TestUpdateExprBuilder2
extends AbstractBigdataExprBuilderTestCase {
    public TestUpdateExprBuilder2() {
    }

    public TestUpdateExprBuilder2(String name) {
        super(name);
    }

    public void test_delete_insert__insertInto_01() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "PREFIX dc:  <http://purl.org/dc/elements/1.1/>\nPREFIX xsd: <http://www.w3.org/2001/XMLSchema#>\nINSERT INTO %cached_solution_set\nSELECT ?book ?date\nWHERE\n   { GRAPH  <http://example/bookStore>\n        { ?book dc:date ?date .\n          FILTER ( ?date > \"1970-01-01T00:00:00-02:00\"^^xsd:dateTime )\n          ?book ?p ?v\n} }";
        IV dcDate = this.makeIV((BigdataValue)this.valueFactory.createURI("http://purl.org/dc/elements/1.1/date"));
        IV dateTime = this.makeIV((BigdataValue)this.valueFactory.createLiteral("1970-01-01T00:00:00-02:00", XSD.DATETIME));
        IV bookstore = this.makeIV((BigdataValue)this.valueFactory.createURI("http://example/bookStore"));
        UpdateRoot expected = new UpdateRoot();
        DeleteInsertGraph op = new DeleteInsertGraph();
        expected.addChild((IGroupMemberNode)op);
        QuadsDataOrNamedSolutionSet insertClause = new QuadsDataOrNamedSolutionSet("%cached_solution_set");
        TestUpdateExprBuilder2.assertTrue((boolean)insertClause.isSolutions());
        TestUpdateExprBuilder2.assertFalse((boolean)insertClause.isQuads());
        ProjectionNode projection = new ProjectionNode();
        insertClause.setProjection(projection);
        projection.addProjectionVar(new VarNode("book"));
        projection.addProjectionVar(new VarNode("date"));
        op.setInsertClause(insertClause);
        JoinGroupNode whereClause = new JoinGroupNode();
        JoinGroupNode graphGroup = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)graphGroup);
        graphGroup.setContext((TermNode)new ConstantNode(bookstore));
        graphGroup.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("book"), (TermNode)new ConstantNode(dcDate), (TermNode)new VarNode("date"), (TermNode)new ConstantNode(bookstore), StatementPattern.Scope.NAMED_CONTEXTS));
        graphGroup.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)FunctionNode.GT((ValueExpressionNode)new VarNode("date"), (ValueExpressionNode)new ConstantNode(dateTime))));
        graphGroup.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("book"), (TermNode)new VarNode("p"), (TermNode)new VarNode("v"), (TermNode)new ConstantNode(bookstore), StatementPattern.Scope.NAMED_CONTEXTS));
        op.setWhereClause((GraphPatternGroup)whereClause);
        UpdateRoot actual = this.parseUpdate("PREFIX dc:  <http://purl.org/dc/elements/1.1/>\nPREFIX xsd: <http://www.w3.org/2001/XMLSchema#>\nINSERT INTO %cached_solution_set\nSELECT ?book ?date\nWHERE\n   { GRAPH  <http://example/bookStore>\n        { ?book dc:date ?date .\n          FILTER ( ?date > \"1970-01-01T00:00:00-02:00\"^^xsd:dateTime )\n          ?book ?p ?v\n} }", this.baseURI);
        TestUpdateExprBuilder2.assertSameAST((String)"PREFIX dc:  <http://purl.org/dc/elements/1.1/>\nPREFIX xsd: <http://www.w3.org/2001/XMLSchema#>\nINSERT INTO %cached_solution_set\nSELECT ?book ?date\nWHERE\n   { GRAPH  <http://example/bookStore>\n        { ?book dc:date ?date .\n          FILTER ( ?date > \"1970-01-01T00:00:00-02:00\"^^xsd:dateTime )\n          ?book ?p ?v\n} }", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_delete_insert__deleteFrom_01() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "PREFIX dc:  <http://purl.org/dc/elements/1.1/>\nPREFIX xsd: <http://www.w3.org/2001/XMLSchema#>\nDELETE FROM %cached_solution_set\nSELECT ?book ?date\nWHERE\n   { GRAPH  <http://example/bookStore>\n        { ?book dc:date ?date .\n          FILTER ( ?date > \"1970-01-01T00:00:00-02:00\"^^xsd:dateTime )\n          ?book ?p ?v\n} }";
        IV dcDate = this.makeIV((BigdataValue)this.valueFactory.createURI("http://purl.org/dc/elements/1.1/date"));
        IV dateTime = this.makeIV((BigdataValue)this.valueFactory.createLiteral("1970-01-01T00:00:00-02:00", XSD.DATETIME));
        IV bookstore = this.makeIV((BigdataValue)this.valueFactory.createURI("http://example/bookStore"));
        UpdateRoot expected = new UpdateRoot();
        DeleteInsertGraph op = new DeleteInsertGraph();
        expected.addChild((IGroupMemberNode)op);
        QuadsDataOrNamedSolutionSet deleteClause = new QuadsDataOrNamedSolutionSet("%cached_solution_set");
        ProjectionNode projection = new ProjectionNode();
        deleteClause.setProjection(projection);
        projection.addProjectionVar(new VarNode("book"));
        projection.addProjectionVar(new VarNode("date"));
        op.setDeleteClause(deleteClause);
        JoinGroupNode whereClause = new JoinGroupNode();
        JoinGroupNode graphGroup = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)graphGroup);
        graphGroup.setContext((TermNode)new ConstantNode(bookstore));
        graphGroup.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("book"), (TermNode)new ConstantNode(dcDate), (TermNode)new VarNode("date"), (TermNode)new ConstantNode(bookstore), StatementPattern.Scope.NAMED_CONTEXTS));
        graphGroup.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)FunctionNode.GT((ValueExpressionNode)new VarNode("date"), (ValueExpressionNode)new ConstantNode(dateTime))));
        graphGroup.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("book"), (TermNode)new VarNode("p"), (TermNode)new VarNode("v"), (TermNode)new ConstantNode(bookstore), StatementPattern.Scope.NAMED_CONTEXTS));
        op.setWhereClause((GraphPatternGroup)whereClause);
        UpdateRoot actual = this.parseUpdate("PREFIX dc:  <http://purl.org/dc/elements/1.1/>\nPREFIX xsd: <http://www.w3.org/2001/XMLSchema#>\nDELETE FROM %cached_solution_set\nSELECT ?book ?date\nWHERE\n   { GRAPH  <http://example/bookStore>\n        { ?book dc:date ?date .\n          FILTER ( ?date > \"1970-01-01T00:00:00-02:00\"^^xsd:dateTime )\n          ?book ?p ?v\n} }", this.baseURI);
        TestUpdateExprBuilder2.assertSameAST((String)"PREFIX dc:  <http://purl.org/dc/elements/1.1/>\nPREFIX xsd: <http://www.w3.org/2001/XMLSchema#>\nDELETE FROM %cached_solution_set\nSELECT ?book ?date\nWHERE\n   { GRAPH  <http://example/bookStore>\n        { ?book dc:date ?date .\n          FILTER ( ?date > \"1970-01-01T00:00:00-02:00\"^^xsd:dateTime )\n          ?book ?p ?v\n} }", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_create_solutions() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "create solutions %solutionSet";
        UpdateRoot expected = new UpdateRoot();
        CreateGraph op = new CreateGraph();
        expected.addChild((IGroupMemberNode)op);
        op.setTargetSolutionSet("%solutionSet");
        TestUpdateExprBuilder2.assertTrue((boolean)op.isTargetSolutionSet());
        UpdateRoot actual = this.parseUpdate("create solutions %solutionSet", this.baseURI);
        TestUpdateExprBuilder2.assertSameAST((String)"create solutions %solutionSet", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_create_solutions_silent() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "create silent solutions %solutionSet";
        UpdateRoot expected = new UpdateRoot();
        CreateGraph op = new CreateGraph();
        expected.addChild((IGroupMemberNode)op);
        op.setTargetSolutionSet("%solutionSet");
        op.setSilent(true);
        UpdateRoot actual = this.parseUpdate("create silent solutions %solutionSet", this.baseURI);
        TestUpdateExprBuilder2.assertSameAST((String)"create silent solutions %solutionSet", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_create_solutions_silent_params() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "create silent solutions %solutionSet {\n  hint:Query hint:engine \"cache\" .\n  hint:Query hint:expireAge \"100000\"^^<http://www.w3.org/2001/XMLSchema#long> .\n}";
        UpdateRoot expected = new UpdateRoot();
        CreateGraph op = new CreateGraph();
        expected.addChild((IGroupMemberNode)op);
        op.setTargetSolutionSet("%solutionSet");
        op.setSilent(true);
        BigdataURI hintQuery = this.valueFactory.createURI("http://www.bigdata.com/queryHints#" + QueryHintScope.Query);
        BigdataURI hintEngine = this.valueFactory.createURI("http://www.bigdata.com/queryHints#engine");
        BigdataURI hintExpireAge = this.valueFactory.createURI("http://www.bigdata.com/queryHints#expireAge");
        BigdataLiteral cache = this.valueFactory.createLiteral("cache");
        BigdataLiteral millis = this.valueFactory.createLiteral("100000", XSD.LONG);
        BigdataStatement[] params = new BigdataStatement[]{this.valueFactory.createStatement((Resource)hintQuery, (URI)hintEngine, (Value)cache, null, StatementEnum.Explicit), this.valueFactory.createStatement((Resource)hintQuery, (URI)hintExpireAge, (Value)millis, null, StatementEnum.Explicit)};
        op.setParams(params);
        UpdateRoot actual = this.parseUpdate("create silent solutions %solutionSet {\n  hint:Query hint:engine \"cache\" .\n  hint:Query hint:expireAge \"100000\"^^<http://www.w3.org/2001/XMLSchema#long> .\n}", this.baseURI);
        TestUpdateExprBuilder2.assertSameAST((String)"create silent solutions %solutionSet {\n  hint:Query hint:engine \"cache\" .\n  hint:Query hint:expireAge \"100000\"^^<http://www.w3.org/2001/XMLSchema#long> .\n}", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_drop_solutions_namedSet() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "drop solutions %solutionSet";
        UpdateRoot expected = new UpdateRoot();
        DropGraph op = new DropGraph();
        expected.addChild((IGroupMemberNode)op);
        op.setTargetSolutionSet("%solutionSet");
        UpdateRoot actual = this.parseUpdate("drop solutions %solutionSet", this.baseURI);
        TestUpdateExprBuilder2.assertSameAST((String)"drop solutions %solutionSet", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_drop_solutions_namedSet_silent() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "drop silent solutions %solutionSet";
        UpdateRoot expected = new UpdateRoot();
        DropGraph op = new DropGraph();
        expected.addChild((IGroupMemberNode)op);
        op.setTargetSolutionSet("%solutionSet");
        op.setSilent(true);
        UpdateRoot actual = this.parseUpdate("drop silent solutions %solutionSet", this.baseURI);
        TestUpdateExprBuilder2.assertSameAST((String)"drop silent solutions %solutionSet", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_drop_solutions() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "drop solutions";
        UpdateRoot expected = new UpdateRoot();
        DropGraph op = new DropGraph();
        op.setAllSolutionSets(true);
        expected.addChild((IGroupMemberNode)op);
        UpdateRoot actual = this.parseUpdate("drop solutions", this.baseURI);
        TestUpdateExprBuilder2.assertSameAST((String)"drop solutions", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_drop_graphs() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "drop graphs";
        UpdateRoot expected = new UpdateRoot();
        DropGraph op = new DropGraph();
        op.setAllGraphs(true);
        expected.addChild((IGroupMemberNode)op);
        UpdateRoot actual = this.parseUpdate("drop graphs", this.baseURI);
        TestUpdateExprBuilder2.assertSameAST((String)"drop graphs", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_clear_solutions_namedSet() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "clear solutions %solutionSet";
        UpdateRoot expected = new UpdateRoot();
        ClearGraph op = new ClearGraph();
        expected.addChild((IGroupMemberNode)op);
        op.setTargetSolutionSet("%solutionSet");
        UpdateRoot actual = this.parseUpdate("clear solutions %solutionSet", this.baseURI);
        TestUpdateExprBuilder2.assertSameAST((String)"clear solutions %solutionSet", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_clear_solutions_namedSet_silent() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "clear silent solutions %solutionSet";
        UpdateRoot expected = new UpdateRoot();
        ClearGraph op = new ClearGraph();
        expected.addChild((IGroupMemberNode)op);
        op.setTargetSolutionSet("%solutionSet");
        op.setSilent(true);
        UpdateRoot actual = this.parseUpdate("clear silent solutions %solutionSet", this.baseURI);
        TestUpdateExprBuilder2.assertSameAST((String)"clear silent solutions %solutionSet", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_clear_solutions() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "clear solutions";
        UpdateRoot expected = new UpdateRoot();
        ClearGraph op = new ClearGraph();
        op.setAllSolutionSets(true);
        expected.addChild((IGroupMemberNode)op);
        UpdateRoot actual = this.parseUpdate("clear solutions", this.baseURI);
        TestUpdateExprBuilder2.assertSameAST((String)"clear solutions", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_clear_graphs() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "clear graphs";
        UpdateRoot expected = new UpdateRoot();
        ClearGraph op = new ClearGraph();
        op.setAllGraphs(true);
        expected.addChild((IGroupMemberNode)op);
        UpdateRoot actual = this.parseUpdate("clear graphs", this.baseURI);
        TestUpdateExprBuilder2.assertSameAST((String)"clear graphs", (IQueryNode)expected, (IQueryNode)actual);
    }
}

