/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.sparql;

import com.bigdata.bop.aggregate.AggregateBase;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.sail.sparql.PrefixDeclProcessor;
import com.bigdata.rdf.sail.sparql.ast.ParseException;
import com.bigdata.rdf.sail.sparql.ast.TokenMgrError;
import com.bigdata.rdf.sparql.AbstractBigdataExprBuilderTestCase;
import com.bigdata.rdf.sparql.ast.AssignmentNode;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.FunctionNode;
import com.bigdata.rdf.sparql.ast.FunctionRegistry;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.IValueExpressionNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.ProjectionNode;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.ValueExpressionNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import java.util.Collections;
import java.util.LinkedHashMap;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.algebra.StatementPattern;

public class TestValueExprBuilder
extends AbstractBigdataExprBuilderTestCase {
    public TestValueExprBuilder() {
    }

    public TestValueExprBuilder(String name) {
        super(name);
    }

    public void test_select_bind() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "select (?s as ?x) where {?s ?p ?o}";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionExpression(new AssignmentNode(new VarNode("x"), (IValueExpressionNode)new VarNode("s")));
        expected.setProjection(projection);
        QueryRoot actual = this.parse("select (?s as ?x) where {?s ?p ?o}", this.baseURI);
        TestValueExprBuilder.assertSameAST((String)"select (?s as ?x) where {?s ?p ?o}", (IQueryNode)expected.getProjection(), (IQueryNode)actual.getProjection());
    }

    public void test_select_math_expr() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "select (?s + ?o as ?x) where {?s ?p ?o}";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionExpression(new AssignmentNode(new VarNode("x"), (IValueExpressionNode)new FunctionNode(FunctionRegistry.ADD, null, new ValueExpressionNode[]{new VarNode("s"), new VarNode("o")})));
        expected.setProjection(projection);
        QueryRoot actual = this.parse("select (?s + ?o as ?x) where {?s ?p ?o}", this.baseURI);
        TestValueExprBuilder.assertSameAST((String)"select (?s + ?o as ?x) where {?s ?p ?o}", (IQueryNode)expected.getProjection(), (IQueryNode)actual.getProjection());
    }

    public void test_select_compare_expr() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "select (?s < ?o as ?x) where {?s ?p ?o}";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionExpression(new AssignmentNode(new VarNode("x"), (IValueExpressionNode)new FunctionNode(FunctionRegistry.LT, null, new ValueExpressionNode[]{new VarNode("s"), new VarNode("o")})));
        expected.setProjection(projection);
        QueryRoot actual = this.parse("select (?s < ?o as ?x) where {?s ?p ?o}", this.baseURI);
        TestValueExprBuilder.assertSameAST((String)"select (?s < ?o as ?x) where {?s ?p ?o}", (IQueryNode)expected.getProjection(), (IQueryNode)actual.getProjection());
    }

    public void test_select_uri() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "select ( <http://xmlns.com/foaf/0.1/> as ?x) where {?s ?p ?o}";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionExpression(new AssignmentNode(new VarNode("x"), (IValueExpressionNode)new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI("http://xmlns.com/foaf/0.1/")))));
        expected.setProjection(projection);
        QueryRoot actual = this.parse("select ( <http://xmlns.com/foaf/0.1/> as ?x) where {?s ?p ?o}", this.baseURI);
        TestValueExprBuilder.assertSameAST((String)"select ( <http://xmlns.com/foaf/0.1/> as ?x) where {?s ?p ?o}", (IQueryNode)expected.getProjection(), (IQueryNode)actual.getProjection());
    }

    public void test_select_bnode() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "select ?s where {?s ?p _:a1}";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        LinkedHashMap prefixDecls = new LinkedHashMap(PrefixDeclProcessor.defaultDecls);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("s"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        VarNode blankNodeVar = new VarNode("-anon-1");
        blankNodeVar.setAnonymous(true);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)blankNodeVar, null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        QueryRoot actual = this.parse("select ?s where {?s ?p _:a1}", this.baseURI);
        TestValueExprBuilder.assertSameAST((String)"select ?s where {?s ?p _:a1}", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_select_literal() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "select (\"abc\" as ?x) where {?s ?p ?o}";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionExpression(new AssignmentNode(new VarNode("x"), (IValueExpressionNode)new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createLiteral("abc")))));
        expected.setProjection(projection);
        QueryRoot actual = this.parse("select (\"abc\" as ?x) where {?s ?p ?o}", this.baseURI);
        TestValueExprBuilder.assertSameAST((String)"select (\"abc\" as ?x) where {?s ?p ?o}", (IQueryNode)expected.getProjection(), (IQueryNode)actual.getProjection());
    }

    public void test_select_xsd_int() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "select (\"12\"^^<http://www.w3.org/2001/XMLSchema#int> as ?x) where {?s ?p ?o}";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionExpression(new AssignmentNode(new VarNode("x"), (IValueExpressionNode)new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createLiteral(12)))));
        expected.setProjection(projection);
        QueryRoot actual = this.parse("select (\"12\"^^<http://www.w3.org/2001/XMLSchema#int> as ?x) where {?s ?p ?o}", this.baseURI);
        TestValueExprBuilder.assertSameAST((String)"select (\"12\"^^<http://www.w3.org/2001/XMLSchema#int> as ?x) where {?s ?p ?o}", (IQueryNode)expected.getProjection(), (IQueryNode)actual.getProjection());
    }

    public void test_select_count_foo() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "select (count(?s) as ?x) where {?s ?p ?o}";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionExpression(new AssignmentNode(new VarNode("x"), (IValueExpressionNode)new FunctionNode(FunctionRegistry.COUNT, null, new ValueExpressionNode[]{new VarNode("s")})));
        expected.setProjection(projection);
        QueryRoot actual = this.parse("select (count(?s) as ?x) where {?s ?p ?o}", this.baseURI);
        TestValueExprBuilder.assertSameAST((String)"select (count(?s) as ?x) where {?s ?p ?o}", (IQueryNode)expected.getProjection(), (IQueryNode)actual.getProjection());
    }

    public void test_select_count_distinct_foo() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "select (count(distinct ?s) as ?x) where {?s ?p ?o}";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionExpression(new AssignmentNode(new VarNode("x"), (IValueExpressionNode)new FunctionNode(FunctionRegistry.COUNT, Collections.singletonMap(AggregateBase.Annotations.DISTINCT, Boolean.TRUE), new ValueExpressionNode[]{new VarNode("s")})));
        expected.setProjection(projection);
        QueryRoot actual = this.parse("select (count(distinct ?s) as ?x) where {?s ?p ?o}", this.baseURI);
        TestValueExprBuilder.assertSameAST((String)"select (count(distinct ?s) as ?x) where {?s ?p ?o}", (IQueryNode)expected.getProjection(), (IQueryNode)actual.getProjection());
    }

    public void test_select_count_star() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "select (count(*) as ?x) where {?s ?p ?o}";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionExpression(new AssignmentNode(new VarNode("x"), (IValueExpressionNode)new FunctionNode(FunctionRegistry.COUNT, null, new ValueExpressionNode[]{new VarNode("*")})));
        expected.setProjection(projection);
        QueryRoot actual = this.parse("select (count(*) as ?x) where {?s ?p ?o}", this.baseURI);
        TestValueExprBuilder.assertSameAST((String)"select (count(*) as ?x) where {?s ?p ?o}", (IQueryNode)expected.getProjection(), (IQueryNode)actual.getProjection());
    }

    public void test_select_count_distinct_star() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "select (count(distinct *) as ?x) where {?s ?p ?o}";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionExpression(new AssignmentNode(new VarNode("x"), (IValueExpressionNode)new FunctionNode(FunctionRegistry.COUNT, Collections.singletonMap(AggregateBase.Annotations.DISTINCT, Boolean.TRUE), new ValueExpressionNode[]{new VarNode("*")})));
        expected.setProjection(projection);
        QueryRoot actual = this.parse("select (count(distinct *) as ?x) where {?s ?p ?o}", this.baseURI);
        TestValueExprBuilder.assertSameAST((String)"select (count(distinct *) as ?x) where {?s ?p ?o}", (IQueryNode)expected.getProjection(), (IQueryNode)actual.getProjection());
    }

    public void test_select_function_call() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "select (<" + FunctionRegistry.ADD + ">(?s,?o) as ?x) where {?s ?p ?o}";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionExpression(new AssignmentNode(new VarNode("x"), (IValueExpressionNode)new FunctionNode(FunctionRegistry.ADD, null, new ValueExpressionNode[]{new VarNode("s"), new VarNode("o")})));
        expected.setProjection(projection);
        QueryRoot actual = this.parse(sparql, this.baseURI);
        TestValueExprBuilder.assertSameAST((String)sparql, (IQueryNode)expected.getProjection(), (IQueryNode)actual.getProjection());
    }

    public void test_select_coalesce() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "select (coalesce(?s,?p,?o) as ?x) where {?s ?p ?o}";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionExpression(new AssignmentNode(new VarNode("x"), (IValueExpressionNode)new FunctionNode(FunctionRegistry.COALESCE, null, new ValueExpressionNode[]{new VarNode("s"), new VarNode("p"), new VarNode("o")})));
        expected.setProjection(projection);
        QueryRoot actual = this.parse("select (coalesce(?s,?p,?o) as ?x) where {?s ?p ?o}", this.baseURI);
        TestValueExprBuilder.assertSameAST((String)"select (coalesce(?s,?p,?o) as ?x) where {?s ?p ?o}", (IQueryNode)expected.getProjection(), (IQueryNode)actual.getProjection());
    }

    public void test_select_if_then_else() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "select (if(?s,?p,?o) as ?x) where {?s ?p ?o}";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionExpression(new AssignmentNode(new VarNode("x"), (IValueExpressionNode)new FunctionNode(FunctionRegistry.IF, null, new ValueExpressionNode[]{new VarNode("s"), new VarNode("p"), new VarNode("o")})));
        expected.setProjection(projection);
        QueryRoot actual = this.parse("select (if(?s,?p,?o) as ?x) where {?s ?p ?o}", this.baseURI);
        TestValueExprBuilder.assertSameAST((String)"select (if(?s,?p,?o) as ?x) where {?s ?p ?o}", (IQueryNode)expected.getProjection(), (IQueryNode)actual.getProjection());
    }

    public void test_select_regex() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "select ( regex(?o,\"^ali\") as ?x) where {?s ?p ?o}";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionExpression(new AssignmentNode(new VarNode("x"), (IValueExpressionNode)new FunctionNode(FunctionRegistry.REGEX, null, new ValueExpressionNode[]{new VarNode("o"), new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createLiteral("^ali")))})));
        expected.setProjection(projection);
        QueryRoot actual = this.parse("select ( regex(?o,\"^ali\") as ?x) where {?s ?p ?o}", this.baseURI);
        TestValueExprBuilder.assertSameAST((String)"select ( regex(?o,\"^ali\") as ?x) where {?s ?p ?o}", (IQueryNode)expected.getProjection(), (IQueryNode)actual.getProjection());
    }

    public void test_select_regex_flags() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "select ( regex(?o,\"^ali\", \"i\") as ?x) where {?s ?p ?o}";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionExpression(new AssignmentNode(new VarNode("x"), (IValueExpressionNode)new FunctionNode(FunctionRegistry.REGEX, null, new ValueExpressionNode[]{new VarNode("o"), new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createLiteral("^ali"))), new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createLiteral("i")))})));
        expected.setProjection(projection);
        QueryRoot actual = this.parse("select ( regex(?o,\"^ali\", \"i\") as ?x) where {?s ?p ?o}", this.baseURI);
        TestValueExprBuilder.assertSameAST((String)"select ( regex(?o,\"^ali\", \"i\") as ?x) where {?s ?p ?o}", (IQueryNode)expected.getProjection(), (IQueryNode)actual.getProjection());
    }

    public void test_select_foo_IN_none() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "select (?s IN() as ?x) where {?s ?p ?o}";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionExpression(new AssignmentNode(new VarNode("x"), (IValueExpressionNode)new FunctionNode(FunctionRegistry.IN, null, new ValueExpressionNode[]{new VarNode("s")})));
        expected.setProjection(projection);
        QueryRoot actual = this.parse("select (?s IN() as ?x) where {?s ?p ?o}", this.baseURI);
        TestValueExprBuilder.assertSameAST((String)"select (?s IN() as ?x) where {?s ?p ?o}", (IQueryNode)expected.getProjection(), (IQueryNode)actual.getProjection());
    }

    public void test_select_foo_IN_bar() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "select (?s IN(?p,?o) as ?x) where {?s ?p ?o}";
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionExpression(new AssignmentNode(new VarNode("x"), (IValueExpressionNode)new FunctionNode(FunctionRegistry.IN, null, new ValueExpressionNode[]{new VarNode("s"), new VarNode("p"), new VarNode("o")})));
        expected.setProjection(projection);
        QueryRoot actual = this.parse("select (?s IN(?p,?o) as ?x) where {?s ?p ?o}", this.baseURI);
        TestValueExprBuilder.assertSameAST((String)"select (?s IN(?p,?o) as ?x) where {?s ?p ?o}", (IQueryNode)expected.getProjection(), (IQueryNode)actual.getProjection());
    }
}

