/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.sparql;

import com.bigdata.bop.aggregate.AggregateBase;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.impl.literal.XSDNumericIV;
import com.bigdata.rdf.sail.sparql.VerifyAggregates;
import com.bigdata.rdf.sparql.ast.AssignmentNode;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.FunctionNode;
import com.bigdata.rdf.sparql.ast.FunctionRegistry;
import com.bigdata.rdf.sparql.ast.GlobalAnnotations;
import com.bigdata.rdf.sparql.ast.GroupByNode;
import com.bigdata.rdf.sparql.ast.HavingNode;
import com.bigdata.rdf.sparql.ast.IValueExpressionNode;
import com.bigdata.rdf.sparql.ast.ProjectionNode;
import com.bigdata.rdf.sparql.ast.ValueExpressionNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import java.util.HashMap;
import junit.framework.TestCase2;

public class TestVerifyAggregates
extends TestCase2 {
    private GlobalAnnotations globals;

    public TestVerifyAggregates() {
    }

    public TestVerifyAggregates(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.globals = new GlobalAnnotations(this.getName(), -1L);
    }

    protected void tearDown() throws Exception {
        this.globals = null;
        super.tearDown();
    }

    public void test_aggregateExpr_01() {
        VarNode org = new VarNode("org");
        ProjectionNode select = new ProjectionNode();
        select.addProjectionVar(org);
        GroupByNode groupBy = new GroupByNode();
        groupBy.addGroupByVar(org);
        HavingNode having = null;
        new VerifyAggregates(select, groupBy, having);
    }

    public void test_aggregateExpr_02() {
        VarNode org = new VarNode("org");
        VarNode newVar = new VarNode("newVar");
        ProjectionNode select = new ProjectionNode();
        select.addProjectionExpression(new AssignmentNode(newVar, (IValueExpressionNode)org));
        GroupByNode groupBy = new GroupByNode();
        groupBy.addGroupByVar(org);
        HavingNode having = null;
        new VerifyAggregates(select, groupBy, having);
    }

    public void test_simpleAggregate() {
        VarNode org = new VarNode("org");
        VarNode lprice = new VarNode("lprice");
        VarNode totalPrice = new VarNode("totalPrice");
        FunctionNode totalPriceExprNode = new FunctionNode(FunctionRegistry.SUM, null, new ValueExpressionNode[]{lprice});
        ProjectionNode select = new ProjectionNode();
        select.addProjectionVar(org);
        select.addProjectionExpression(new AssignmentNode(totalPrice, (IValueExpressionNode)totalPriceExprNode));
        GroupByNode groupBy = new GroupByNode();
        groupBy.addGroupByVar(org);
        HavingNode having = null;
        new VerifyAggregates(select, groupBy, having);
    }

    public void test_simpleAggregate_noGroupBy() {
        VarNode lprice = new VarNode("lprice");
        VarNode totalPrice = new VarNode("totalPrice");
        FunctionNode totalPriceExprNode = new FunctionNode(FunctionRegistry.SUM, null, new ValueExpressionNode[]{lprice});
        ProjectionNode select = new ProjectionNode();
        select.addProjectionExpression(new AssignmentNode(totalPrice, (IValueExpressionNode)totalPriceExprNode));
        GroupByNode groupBy = null;
        HavingNode having = null;
        new VerifyAggregates(select, groupBy, having);
    }

    public void test_aggregateExpr_03() {
        VarNode org = new VarNode("org");
        VarNode org2 = new VarNode("org2");
        FunctionNode ucaseExpr = new FunctionNode(FunctionRegistry.UCASE, null, new ValueExpressionNode[]{org});
        ProjectionNode select = new ProjectionNode();
        select.addProjectionVar(org2);
        GroupByNode groupBy = new GroupByNode();
        groupBy.addExpr((IValueExpressionNode)new AssignmentNode(org2, (IValueExpressionNode)ucaseExpr));
        HavingNode having = null;
        new VerifyAggregates(select, groupBy, having);
    }

    public void test_aggregateExpr_04() {
        VarNode index = new VarNode("index");
        VarNode o = new VarNode("o");
        FunctionNode mathExpr = FunctionNode.add((ValueExpressionNode)o, (ValueExpressionNode)new ConstantNode((IV)new XSDNumericIV(1)));
        ProjectionNode select = new ProjectionNode();
        select.addProjectionVar(index);
        GroupByNode groupBy = new GroupByNode();
        groupBy.addExpr((IValueExpressionNode)new AssignmentNode(index, (IValueExpressionNode)mathExpr));
        HavingNode having = null;
        new VerifyAggregates(select, groupBy, having);
    }

    public void test_simpleHavingClause() {
        VarNode y = new VarNode("y");
        VarNode x = new VarNode("x");
        VarNode z = new VarNode("z");
        FunctionNode xExpr = new FunctionNode(FunctionRegistry.SUM, null, new ValueExpressionNode[]{y});
        ProjectionNode select = new ProjectionNode();
        select.addExpr((IValueExpressionNode)new AssignmentNode(x, (IValueExpressionNode)xExpr));
        GroupByNode groupBy = new GroupByNode();
        groupBy.addGroupByVar(z);
        HavingNode having = new HavingNode();
        having.addExpr((IValueExpressionNode)FunctionNode.GT((ValueExpressionNode)x, (ValueExpressionNode)new ConstantNode((IV)new XSDNumericIV(10))));
        new VerifyAggregates(select, groupBy, having);
    }

    public void test_complexHavingClause() {
        VarNode y = new VarNode("y");
        VarNode x = new VarNode("x");
        VarNode z = new VarNode("z");
        FunctionNode xExpr = new FunctionNode(FunctionRegistry.SUM, null, new ValueExpressionNode[]{y});
        ProjectionNode select = new ProjectionNode();
        select.addExpr((IValueExpressionNode)new AssignmentNode(x, (IValueExpressionNode)xExpr));
        GroupByNode groupBy = new GroupByNode();
        groupBy.addGroupByVar(new VarNode(z));
        HavingNode having = new HavingNode();
        having.addExpr((IValueExpressionNode)FunctionNode.GT((ValueExpressionNode)xExpr, (ValueExpressionNode)new ConstantNode((IV)new XSDNumericIV(10))));
        new VerifyAggregates(select, groupBy, having);
    }

    public void test_nestedAggregates() {
        VarNode a = new VarNode("a");
        VarNode x = new VarNode("x");
        VarNode y = new VarNode("y");
        VarNode z = new VarNode("z");
        FunctionNode zExpr = new FunctionNode(FunctionRegistry.SUM, null, new ValueExpressionNode[]{FunctionNode.add((ValueExpressionNode)x, (ValueExpressionNode)new FunctionNode(FunctionRegistry.MIN, null, new ValueExpressionNode[]{y}))});
        ProjectionNode select = new ProjectionNode();
        select.addExpr((IValueExpressionNode)new AssignmentNode(z, (IValueExpressionNode)zExpr));
        GroupByNode groupBy = new GroupByNode();
        groupBy.addGroupByVar(a);
        HavingNode having = null;
        new VerifyAggregates(select, groupBy, having);
    }

    public void test_reverseReference_allowed_aka_select_dependency() {
        VarNode a = new VarNode("a");
        VarNode b = new VarNode("b");
        VarNode x = new VarNode("x");
        VarNode y = new VarNode("y");
        VarNode z = new VarNode("z");
        FunctionNode zExpr = new FunctionNode(FunctionRegistry.SUM, null, new ValueExpressionNode[]{y});
        FunctionNode aExpr = FunctionNode.add((ValueExpressionNode)new FunctionNode(FunctionRegistry.SUM, null, new ValueExpressionNode[]{x}), (ValueExpressionNode)z);
        ProjectionNode select = new ProjectionNode();
        select.addExpr((IValueExpressionNode)new AssignmentNode(z, (IValueExpressionNode)zExpr));
        select.addExpr((IValueExpressionNode)new AssignmentNode(a, (IValueExpressionNode)aExpr));
        GroupByNode groupBy = new GroupByNode();
        groupBy.addGroupByVar(b);
        HavingNode having = null;
        new VerifyAggregates(select, groupBy, having);
    }

    public void test_forwardReference_not_allowed() {
        block2: {
            VarNode a = new VarNode("a");
            VarNode b = new VarNode("b");
            VarNode x = new VarNode("x");
            VarNode y = new VarNode("y");
            VarNode z = new VarNode("z");
            FunctionNode zExpr = new FunctionNode(FunctionRegistry.SUM, null, new ValueExpressionNode[]{y});
            FunctionNode aExpr = FunctionNode.add((ValueExpressionNode)new FunctionNode(FunctionRegistry.SUM, null, new ValueExpressionNode[]{x}), (ValueExpressionNode)z);
            ProjectionNode select = new ProjectionNode();
            select.addExpr((IValueExpressionNode)new AssignmentNode(a, (IValueExpressionNode)aExpr));
            select.addExpr((IValueExpressionNode)new AssignmentNode(z, (IValueExpressionNode)zExpr));
            GroupByNode groupBy = new GroupByNode();
            groupBy.addGroupByVar(b);
            HavingNode having = null;
            try {
                new VerifyAggregates(select, groupBy, having);
                TestVerifyAggregates.fail((String)("Expecting: " + IllegalArgumentException.class));
            }
            catch (IllegalArgumentException ex) {
                if (!log.isInfoEnabled()) break block2;
                log.info((Object)("Ignoring expected exception: " + ex), (Throwable)ex);
            }
        }
    }

    public void test_isAnyDistinct_select() {
        VarNode y = new VarNode("y");
        VarNode x = new VarNode("x");
        VarNode z = new VarNode("z");
        HashMap<String, Boolean> scalarValues = new HashMap<String, Boolean>();
        scalarValues.put(AggregateBase.Annotations.DISTINCT, Boolean.TRUE);
        FunctionNode xExpr = new FunctionNode(FunctionRegistry.SUM, scalarValues, new ValueExpressionNode[]{y});
        ProjectionNode select = new ProjectionNode();
        select.addExpr((IValueExpressionNode)new AssignmentNode(x, (IValueExpressionNode)xExpr));
        GroupByNode groupBy = new GroupByNode();
        groupBy.addGroupByVar(z);
        HavingNode having = new HavingNode();
        having.addExpr((IValueExpressionNode)FunctionNode.GT((ValueExpressionNode)x, (ValueExpressionNode)new ConstantNode((IV)new XSDNumericIV(10))));
        new VerifyAggregates(select, groupBy, having);
    }

    public void test_isAnyDistinct_having() {
        VarNode y = new VarNode("y");
        VarNode x = new VarNode("x");
        VarNode z = new VarNode("z");
        FunctionNode xExpr = new FunctionNode(FunctionRegistry.SUM, null, new ValueExpressionNode[]{y});
        ProjectionNode select = new ProjectionNode();
        select.addExpr((IValueExpressionNode)new AssignmentNode(x, (IValueExpressionNode)xExpr));
        GroupByNode groupBy = new GroupByNode();
        groupBy.addGroupByVar(z);
        HavingNode having = new HavingNode();
        HashMap<String, Boolean> scalarValues = new HashMap<String, Boolean>();
        scalarValues.put(AggregateBase.Annotations.DISTINCT, Boolean.TRUE);
        having.addExpr((IValueExpressionNode)FunctionNode.GT((ValueExpressionNode)new FunctionNode(FunctionRegistry.SUM, scalarValues, new ValueExpressionNode[]{y}), (ValueExpressionNode)new ConstantNode((IV)new XSDNumericIV(10))));
        new VerifyAggregates(select, groupBy, having);
    }

    public void test_with_constant() {
        VarNode x = new VarNode("x");
        ConstantNode xExpr = new ConstantNode((IV)new XSDNumericIV(12));
        ProjectionNode select = new ProjectionNode();
        select.addExpr((IValueExpressionNode)new AssignmentNode(x, (IValueExpressionNode)xExpr));
        GroupByNode groupBy = null;
        HavingNode having = null;
        new VerifyAggregates(select, groupBy, having);
    }

    public void test_correctRejection() {
        block5: {
            HavingNode having;
            GroupByNode groupBy;
            block4: {
                VarNode y = new VarNode("y");
                VarNode x = new VarNode("x");
                VarNode z = new VarNode("z");
                groupBy = new GroupByNode();
                groupBy.addGroupByVar(z);
                having = new HavingNode();
                having.addExpr((IValueExpressionNode)FunctionNode.LT((ValueExpressionNode)new FunctionNode(FunctionRegistry.SUM, null, new ValueExpressionNode[]{y}), (ValueExpressionNode)new ConstantNode((IV)new XSDNumericIV(10))));
                try {
                    new VerifyAggregates(null, groupBy, having);
                    TestVerifyAggregates.fail((String)("Expecting: " + IllegalArgumentException.class));
                }
                catch (IllegalArgumentException ex) {
                    if (!log.isInfoEnabled()) break block4;
                    log.info((Object)("Ignoring expected exception: " + ex), (Throwable)ex);
                }
            }
            try {
                new VerifyAggregates(new ProjectionNode(), groupBy, having);
                TestVerifyAggregates.fail((String)("Expecting: " + IllegalArgumentException.class));
            }
            catch (IllegalArgumentException ex) {
                if (!log.isInfoEnabled()) break block5;
                log.info((Object)("Ignoring expected exception: " + ex), (Throwable)ex);
            }
        }
    }
}

