/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.sparql;

import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.StatementEnum;
import com.bigdata.rdf.rio.StatementBuffer;
import com.bigdata.rdf.sail.sparql.PrefixDeclProcessor;
import com.bigdata.rdf.sail.sparql.ast.ParseException;
import com.bigdata.rdf.sail.sparql.ast.TokenMgrError;
import com.bigdata.rdf.sparql.AbstractBigdataExprBuilderTestCase;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.DatasetNode;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.ProjectionNode;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.BD;
import com.bigdata.rdf.vocab.decls.FOAFVocabularyDecl;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Properties;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.DC;
import org.openrdf.query.Dataset;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.algebra.StatementPattern;
import org.openrdf.query.impl.DatasetImpl;

public class TestVirtualGraphs
extends AbstractBigdataExprBuilderTestCase {
    public TestVirtualGraphs() {
    }

    public TestVirtualGraphs(String name) {
        super(name);
    }

    protected Properties getProperties() {
        Properties properties = new Properties(super.getProperties());
        properties.setProperty(AbstractTripleStore.Options.QUADS_MODE, "true");
        return properties;
    }

    public void test_virtualGraphs_01() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "PREFIX foaf: <http://xmlns.com/foaf/0.1/>\nPREFIX dc: <http://purl.org/dc/elements/1.1/>\nSELECT ?who ?g ?mbox\nFROM <http://example.org/dft.ttl>\nFROM NAMED VIRTUAL GRAPH <http://example.org/vg>\nWHERE {\n    ?g dc:publisher ?who .\n    GRAPH ?g { ?x foaf:mbox ?mbox } \n}";
        BigdataURI virtualGraph = this.valueFactory.asValue(BD.VIRTUAL_GRAPH);
        BigdataURI vg = this.valueFactory.createURI("http://example.org/vg");
        BigdataURI context = this.valueFactory.createURI("http://www.bigdata.com/context");
        BigdataURI uri1 = this.valueFactory.createURI("http://example.org/dft.ttl");
        BigdataURI alice = this.valueFactory.createURI("http://example.org/alice");
        BigdataURI bob = this.valueFactory.createURI("http://example.org/bob");
        BigdataValue[] values = new BigdataValue[]{virtualGraph, vg, context, uri1, alice, bob};
        this.tripleStore.getLexiconRelation().addTerms(values, values.length, false);
        StatementBuffer sb = new StatementBuffer(this.tripleStore, 10);
        sb.add((Statement)this.valueFactory.createStatement((Resource)vg, (URI)virtualGraph, (Value)alice, (Resource)context, StatementEnum.Explicit));
        sb.add((Statement)this.valueFactory.createStatement((Resource)vg, (URI)virtualGraph, (Value)bob, (Resource)context, StatementEnum.Explicit));
        sb.flush();
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        LinkedHashMap<String, String> prefixDecls = new LinkedHashMap<String, String>(PrefixDeclProcessor.defaultDecls);
        prefixDecls.put("foaf", "http://xmlns.com/foaf/0.1/");
        prefixDecls.put("dc", "http://purl.org/dc/elements/1.1/");
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        expected.setProjection(projection);
        projection.addProjectionVar(new VarNode("who"));
        projection.addProjectionVar(new VarNode("g"));
        projection.addProjectionVar(new VarNode("mbox"));
        DatasetImpl dataset = new DatasetImpl();
        dataset.addDefaultGraph((URI)uri1);
        dataset.addNamedGraph((URI)alice);
        dataset.addNamedGraph((URI)bob);
        DatasetNode datasetNode = new DatasetNode((Dataset)dataset, false);
        expected.setDataset(datasetNode);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("g"), (TermNode)new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI(DC.PUBLISHER.toString()))), (TermNode)new VarNode("who"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        JoinGroupNode group = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)group);
        group.setContext((TermNode)new VarNode("g"));
        group.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI(FOAFVocabularyDecl.mbox.toString()))), (TermNode)new VarNode("mbox"), (TermNode)new VarNode("g"), StatementPattern.Scope.NAMED_CONTEXTS));
        QueryRoot actual = this.parse("PREFIX foaf: <http://xmlns.com/foaf/0.1/>\nPREFIX dc: <http://purl.org/dc/elements/1.1/>\nSELECT ?who ?g ?mbox\nFROM <http://example.org/dft.ttl>\nFROM NAMED VIRTUAL GRAPH <http://example.org/vg>\nWHERE {\n    ?g dc:publisher ?who .\n    GRAPH ?g { ?x foaf:mbox ?mbox } \n}", this.baseURI);
        TestVirtualGraphs.assertSameAST((String)"PREFIX foaf: <http://xmlns.com/foaf/0.1/>\nPREFIX dc: <http://purl.org/dc/elements/1.1/>\nSELECT ?who ?g ?mbox\nFROM <http://example.org/dft.ttl>\nFROM NAMED VIRTUAL GRAPH <http://example.org/vg>\nWHERE {\n    ?g dc:publisher ?who .\n    GRAPH ?g { ?x foaf:mbox ?mbox } \n}", (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_virtualGraphs_02() throws MalformedQueryException, TokenMgrError, ParseException {
        String sparql = "PREFIX foaf: <http://xmlns.com/foaf/0.1/>\nPREFIX dc: <http://purl.org/dc/elements/1.1/>\nSELECT ?who ?g ?mbox\nFROM <http://example.org/dft.ttl>\nFROM VIRTUAL GRAPH <http://example.org/vg>\nWHERE {\n    ?g dc:publisher ?who .\n    GRAPH ?g { ?x foaf:mbox ?mbox } \n}";
        BigdataURI virtualGraph = this.valueFactory.asValue(BD.VIRTUAL_GRAPH);
        BigdataURI vg = this.valueFactory.createURI("http://example.org/vg");
        BigdataURI context = this.valueFactory.createURI("http://www.bigdata.com/context");
        BigdataURI uri1 = this.valueFactory.createURI("http://example.org/dft.ttl");
        BigdataURI alice = this.valueFactory.createURI("http://example.org/alice");
        BigdataURI bob = this.valueFactory.createURI("http://example.org/bob");
        BigdataValue[] values = new BigdataValue[]{virtualGraph, vg, context, uri1, alice, bob};
        this.tripleStore.getLexiconRelation().addTerms(values, values.length, false);
        StatementBuffer sb = new StatementBuffer(this.tripleStore, 10);
        sb.add((Statement)this.valueFactory.createStatement((Resource)vg, (URI)virtualGraph, (Value)alice, (Resource)context, StatementEnum.Explicit));
        sb.add((Statement)this.valueFactory.createStatement((Resource)vg, (URI)virtualGraph, (Value)bob, (Resource)context, StatementEnum.Explicit));
        sb.flush();
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        LinkedHashMap<String, String> prefixDecls = new LinkedHashMap<String, String>(PrefixDeclProcessor.defaultDecls);
        prefixDecls.put("foaf", "http://xmlns.com/foaf/0.1/");
        prefixDecls.put("dc", "http://purl.org/dc/elements/1.1/");
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        expected.setProjection(projection);
        projection.addProjectionVar(new VarNode("who"));
        projection.addProjectionVar(new VarNode("g"));
        projection.addProjectionVar(new VarNode("mbox"));
        LinkedHashSet<IV> defaultGraphs = new LinkedHashSet<IV>();
        defaultGraphs.add(uri1.getIV());
        defaultGraphs.add(alice.getIV().clone(true));
        defaultGraphs.add(bob.getIV().clone(true));
        DatasetNode datasetNode = new DatasetNode(defaultGraphs, null, false);
        expected.setDataset(datasetNode);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("g"), (TermNode)new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI(DC.PUBLISHER.toString()))), (TermNode)new VarNode("who"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        JoinGroupNode group = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)group);
        group.setContext((TermNode)new VarNode("g"));
        group.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(this.makeIV((BigdataValue)this.valueFactory.createURI(FOAFVocabularyDecl.mbox.toString()))), (TermNode)new VarNode("mbox"), (TermNode)new VarNode("g"), StatementPattern.Scope.NAMED_CONTEXTS));
        QueryRoot actual = this.parse("PREFIX foaf: <http://xmlns.com/foaf/0.1/>\nPREFIX dc: <http://purl.org/dc/elements/1.1/>\nSELECT ?who ?g ?mbox\nFROM <http://example.org/dft.ttl>\nFROM VIRTUAL GRAPH <http://example.org/vg>\nWHERE {\n    ?g dc:publisher ?who .\n    GRAPH ?g { ?x foaf:mbox ?mbox } \n}", this.baseURI);
        TestVirtualGraphs.assertSameAST((String)"PREFIX foaf: <http://xmlns.com/foaf/0.1/>\nPREFIX dc: <http://purl.org/dc/elements/1.1/>\nSELECT ?who ?g ?mbox\nFROM <http://example.org/dft.ttl>\nFROM VIRTUAL GRAPH <http://example.org/vg>\nWHERE {\n    ?g dc:publisher ?who .\n    GRAPH ?g { ?x foaf:mbox ?mbox } \n}", (IQueryNode)expected, (IQueryNode)actual);
    }
}

