/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.tck;

import com.bigdata.journal.BufferMode;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepository;
import java.util.Properties;
import junit.framework.TestCase;
import org.openrdf.model.Resource;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.QueryLanguage;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.sail.SailRepository;

public class BigdataArbitraryLengthPathTest
extends TestCase {
    private Repository repo;
    private RepositoryConnection con;

    protected Properties getProperties() {
        Properties props = new Properties();
        props.setProperty(BigdataSail.Options.BUFFER_MODE, BufferMode.Transient.toString());
        props.setProperty(BigdataSail.Options.QUADS_MODE, "true");
        props.setProperty(BigdataSail.Options.JUSTIFY, "false");
        props.setProperty(BigdataSail.Options.QUERY_TIME_EXPANDER, "false");
        props.setProperty(BigdataSail.Options.ALLOW_AUTO_COMMIT, "true");
        props.setProperty(BigdataSail.Options.EXACT_SIZE, "true");
        props.setProperty(BigdataSail.Options.ISOLATABLE_INDICES, "false");
        props.setProperty(BigdataSail.Options.TRUTH_MAINTENANCE, "false");
        return props;
    }

    protected SailRepository newRepository() throws RepositoryException {
        Properties props = this.getProperties();
        BigdataSail sail = new BigdataSail(props);
        return new BigdataSailRepository(sail);
    }

    public void setUp() throws Exception {
        this.repo = this.newRepository();
        this.repo.initialize();
        this.con = this.repo.getConnection();
    }

    public void tearDown() throws Exception {
        this.con.close();
        this.repo.shutDown();
        this.con = null;
        this.repo = null;
    }

    public void test10() throws Exception {
        this.populate(10);
        String sparql = "ASK { <urn:test:root> <urn:test:hasChild>* <urn:test:node-end> }";
        BigdataArbitraryLengthPathTest.assertTrue((boolean)this.con.prepareBooleanQuery(QueryLanguage.SPARQL, sparql).evaluate());
    }

    public void test100() throws Exception {
        this.populate(100);
        String sparql = "ASK { <urn:test:root> <urn:test:hasChild>* <urn:test:node-end> }";
        BigdataArbitraryLengthPathTest.assertTrue((boolean)this.con.prepareBooleanQuery(QueryLanguage.SPARQL, sparql).evaluate());
    }

    public void test1000() throws Exception {
        this.populate(1000);
        String sparql = "ASK { <urn:test:root> <urn:test:hasChild>* <urn:test:node-end> }";
        BigdataArbitraryLengthPathTest.assertTrue((boolean)this.con.prepareBooleanQuery(QueryLanguage.SPARQL, sparql).evaluate());
    }

    public void test10000() throws Exception {
        this.populate(10000);
        String sparql = "ASK { <urn:test:root> <urn:test:hasChild>* <urn:test:node-end> }";
        BigdataArbitraryLengthPathTest.assertTrue((boolean)this.con.prepareBooleanQuery(QueryLanguage.SPARQL, sparql).evaluate());
    }

    public void test100000() throws Exception {
        this.populate(100000);
        String sparql = "ASK { <urn:test:root> <urn:test:hasChild>* <urn:test:node-end> }";
        BigdataArbitraryLengthPathTest.assertTrue((boolean)this.con.prepareBooleanQuery(QueryLanguage.SPARQL, sparql).evaluate());
    }

    private void populate(int n) throws RepositoryException {
        ValueFactory vf = this.con.getValueFactory();
        for (int i = 0; i < n; ++i) {
            this.con.add((Resource)vf.createURI("urn:test:root"), vf.createURI("urn:test:hasChild"), (Value)vf.createURI("urn:test:node" + i), new Resource[0]);
        }
        this.con.add((Resource)vf.createURI("urn:test:root"), vf.createURI("urn:test:hasChild"), (Value)vf.createURI("urn:test:node-end"), new Resource[0]);
    }
}

