/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.tck;

import com.bigdata.BigdataStatics;
import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpUtility;
import com.bigdata.journal.BufferMode;
import com.bigdata.journal.IIndexManager;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepository;
import com.bigdata.rdf.sail.BigdataSailTupleQuery;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.junit.Test;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.parser.sparql.ComplexSPARQLQueryTest;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryException;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFParseException;

public class BigdataComplexSparqlQueryTest
extends ComplexSPARQLQueryTest {
    private static final Logger logger = Logger.getLogger(BigdataComplexSparqlQueryTest.class);
    private IIndexManager backend = null;
    private static boolean runKnownBadTests = BigdataStatics.runKnownBadTests;

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        if (this.backend != null) {
            this.tearDownBackend(this.backend);
        }
        this.backend = null;
        this.f = null;
    }

    protected void tearDownBackend(IIndexManager backend) {
        backend.destroy();
    }

    protected Properties getProperties() {
        Properties props = new Properties();
        props.setProperty(BigdataSail.Options.BUFFER_MODE, BufferMode.Transient.toString());
        props.setProperty(BigdataSail.Options.QUADS_MODE, "true");
        props.setProperty(BigdataSail.Options.JUSTIFY, "false");
        props.setProperty(BigdataSail.Options.QUERY_TIME_EXPANDER, "false");
        props.setProperty(BigdataSail.Options.EXACT_SIZE, "true");
        props.setProperty(BigdataSail.Options.ISOLATABLE_INDICES, "false");
        props.setProperty(BigdataSail.Options.TRUTH_MAINTENANCE, "false");
        return props;
    }

    @Override
    protected Repository newRepository() throws RepositoryException {
        Properties props = this.getProperties();
        BigdataSail sail = new BigdataSail(props);
        this.backend = sail.getIndexManager();
        return new BigdataSailRepository(sail);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void loadTestData(String dataFile, Resource ... contexts) throws RDFParseException, RepositoryException, IOException {
        logger.debug((Object)("loading dataset " + dataFile));
        try (InputStream dataset = ComplexSPARQLQueryTest.class.getResourceAsStream(dataFile);){
            this.conn.setAutoCommit(false);
            this.conn.add(dataset, "", RDFFormat.forFileName((String)dataFile), contexts);
            this.conn.commit();
        }
        logger.debug((Object)"dataset loaded.");
    }

    @Override
    @Test
    public void testNullContext1() throws Exception {
        if (runKnownBadTests) {
            super.testNullContext1();
        }
    }

    @Override
    @Test
    public void testDescribeA() throws Exception {
        if (runKnownBadTests) {
            super.testDescribeA();
        }
    }

    @Override
    @Test
    public void testDescribeAWhere() throws Exception {
        if (runKnownBadTests) {
            super.testDescribeAWhere();
        }
    }

    @Override
    @Test
    public void testDescribeB() throws Exception {
        if (runKnownBadTests) {
            super.testDescribeB();
        }
    }

    @Override
    @Test
    public void testDescribeD() throws Exception {
        if (runKnownBadTests) {
            super.testDescribeD();
        }
    }

    @Override
    @Test
    public void testDescribeF() throws Exception {
        if (runKnownBadTests) {
            super.testDescribeF();
        }
    }

    @Override
    @Test
    public void testSameTermRepeatInOptional() throws Exception {
        if (runKnownBadTests) {
            super.testSameTermRepeatInOptional();
        }
    }

    @Override
    @Test
    public void testSES1898LeftJoinSemantics1() throws Exception {
        if (runKnownBadTests) {
            super.testSES1898LeftJoinSemantics1();
        }
    }

    @Override
    @Test
    public void testInComparison1() throws Exception {
        if (runKnownBadTests) {
            super.testInComparison1();
        }
    }

    @Override
    @Test
    public void testInComparison2() throws Exception {
        if (runKnownBadTests) {
            super.testInComparison2();
        }
    }

    @Override
    @Test
    public void testInComparison3() throws Exception {
        if (runKnownBadTests) {
            super.testInComparison3();
        }
    }

    @Override
    @Test
    public void testSameTermRepeatInUnionAndOptional() throws Exception {
        if (runKnownBadTests) {
            super.testSameTermRepeatInUnionAndOptional();
        }
    }

    @Override
    @Test
    public void testSES1991RANDEvaluation() throws Exception {
        if (runKnownBadTests) {
            super.testSES1991RANDEvaluation();
        }
    }

    @Override
    @Test
    public void testValuesInOptional() throws Exception {
        super.testValuesInOptional();
    }

    public void testRequiredValues() throws Exception {
        this.loadTestData("/testdata-query/dataset-ses1692.trig", new Resource[0]);
        StringBuilder query = new StringBuilder();
        query.append(" PREFIX : <http://example.org/>\n");
        query.append(" SELECT DISTINCT ?a ?name ?isX WHERE { ?b :p1 ?a . ?a :name ?name. ?a a :X . VALUES(?isX) { (:X) } } ");
        BigdataSailTupleQuery tq = (BigdataSailTupleQuery)this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query.toString());
        if (logger.isInfoEnabled()) {
            logger.info((Object)("optimized ast:\n" + tq.optimize()));
            logger.info((Object)("query plan:\n" + BOpUtility.toString((BOp)tq.getASTContainer().getQueryPlan())));
        }
        TupleQueryResult result = tq.evaluate();
        BigdataComplexSparqlQueryTest.assertNotNull((Object)result);
        BigdataComplexSparqlQueryTest.assertTrue((boolean)result.hasNext());
        int count = 0;
        while (result.hasNext()) {
            ++count;
            BindingSet bs = (BindingSet)result.next();
            System.out.println(bs);
            URI a = (URI)bs.getValue("a");
            BigdataComplexSparqlQueryTest.assertNotNull((Object)a);
            Value isX = bs.getValue("isX");
            Literal name = (Literal)bs.getValue("name");
            BigdataComplexSparqlQueryTest.assertNotNull((Object)name);
            if (a.stringValue().endsWith("a1")) {
                BigdataComplexSparqlQueryTest.assertNotNull((Object)isX);
                continue;
            }
            if (!a.stringValue().endsWith("a2")) continue;
            BigdataComplexSparqlQueryTest.assertNull((Object)isX);
        }
        BigdataComplexSparqlQueryTest.assertEquals((int)1, (int)count);
    }
}

