/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.tck;

import com.bigdata.bop.fed.QueryEngineFactory;
import com.bigdata.btree.keys.CollatorEnum;
import com.bigdata.btree.keys.StrengthEnum;
import com.bigdata.journal.BufferMode;
import com.bigdata.journal.IBTreeManager;
import com.bigdata.journal.IIndexManager;
import com.bigdata.journal.Journal;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepository;
import com.bigdata.rdf.sail.tck.BigdataStoreTest;
import java.io.File;
import java.io.IOException;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.openrdf.model.Resource;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.query.QueryInterruptedException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnectionTest;

public class BigdataConnectionTest
extends RepositoryConnectionTest {
    private static final Logger log = Logger.getLogger(BigdataConnectionTest.class);

    public BigdataConnectionTest(String name) {
        super(name);
    }

    protected Properties getProperties() {
        Properties props = new Properties();
        File journal = BigdataStoreTest.createTempFile();
        props.setProperty(BigdataSail.Options.FILE, journal.getAbsolutePath());
        props.setProperty(BigdataSail.Options.BUFFER_MODE, BufferMode.DiskWORM.toString());
        props.setProperty(BigdataSail.Options.STORE_BLANK_NODES, "true");
        props.setProperty(BigdataSail.Options.QUADS_MODE, "true");
        props.setProperty(BigdataSail.Options.JUSTIFY, "false");
        props.setProperty(BigdataSail.Options.QUERY_TIME_EXPANDER, "false");
        props.setProperty(BigdataSail.Options.ALLOW_AUTO_COMMIT, "true");
        props.setProperty(BigdataSail.Options.EXACT_SIZE, "true");
        props.setProperty(BigdataSail.Options.COLLATOR, CollatorEnum.ASCII.toString());
        props.setProperty(BigdataSail.Options.STRENGTH, StrengthEnum.Identical.toString());
        props.setProperty(BigdataSail.Options.ISOLATABLE_INDICES, "true");
        props.setProperty(BigdataSail.Options.TRUTH_MAINTENANCE, "false");
        return props;
    }

    @Override
    protected Repository createRepository() throws IOException {
        BigdataSail sail = new BigdataSail(this.getProperties());
        return new BigdataSailRepository(sail);
    }

    @Override
    public void tearDown() throws Exception {
        IIndexManager backend = this.testRepository == null ? null : ((BigdataSailRepository)this.testRepository).getSail().getIndexManager();
        super.tearDown();
        if (backend != null) {
            if (log.isInfoEnabled() && backend instanceof Journal) {
                log.info((Object)QueryEngineFactory.getInstance().getExistingQueryController((IBTreeManager)((Journal)backend)).getCounters());
            }
            backend.destroy();
        }
    }

    @Override
    public void testOrderByQueriesAreInterruptable() throws Exception {
        Class<?> cls1 = Class.forName("com.sun.management.GarbageCollectorMXBean");
        Class<?> cls2 = Class.forName("com.sun.management.GcInfo");
        Method method1 = cls1.getMethod("getLastGcInfo", new Class[0]);
        Method method2 = cls2.getMethod("getDuration", new Class[0]);
        this.testCon.setAutoCommit(false);
        for (int index = 0; index < 512; ++index) {
            this.testCon.add((Resource)RDFS.CLASS, RDFS.COMMENT, (Value)this.testCon.getValueFactory().createBNode(), new Resource[0]);
        }
        this.testCon.setAutoCommit(true);
        this.testCon.commit();
        long MAX_QUERY_TIME = 2000L;
        long MAX_TIME_MILLIS = 5000L;
        int NTRIALS = 20;
        int nok = 0;
        int ngcfail = 0;
        for (int i = 0; i < 20; ++i) {
            if (log.isInfoEnabled()) {
                log.info((Object)("RUN-TEST-PASS #" + i));
            }
            TupleQuery query = this.testCon.prepareTupleQuery(QueryLanguage.SPARQL, "SELECT * WHERE { ?s ?p ?o . ?s1 ?p1 ?o1 . ?s2 ?p2 ?o2 . ?s3 ?p3 ?o3 . } ORDER BY ?s1 ?p1 ?o1 LIMIT 1000");
            query.setMaxQueryTime(2);
            long startTime = System.currentTimeMillis();
            TupleQueryResult result = query.evaluate();
            if (log.isInfoEnabled()) {
                log.info((Object)"Query evaluation has begin");
            }
            try {
                result.hasNext();
                BigdataConnectionTest.fail((String)("Query should have been interrupted on pass# " + i));
                continue;
            }
            catch (QueryInterruptedException e) {
                boolean ok;
                long duration = System.currentTimeMillis() - startTime;
                if (log.isInfoEnabled()) {
                    log.info((Object)("Actual query duration: " + duration + "ms on pass#" + i));
                }
                boolean bl = ok = duration < 5000L;
                if (ok) {
                    ++nok;
                    continue;
                }
                boolean failedByGCPause = false;
                List<GarbageCollectorMXBean> mbeans = ManagementFactory.getGarbageCollectorMXBeans();
                for (GarbageCollectorMXBean m : mbeans) {
                    Object lastGcInfo;
                    long lastDuration;
                    if (!cls1.isAssignableFrom(m.getClass()) || (lastDuration = ((Long)method2.invoke(lastGcInfo = method1.invoke((Object)m, new Object[0]), new Object[0])).longValue()) < 2000L) continue;
                    log.warn((Object)("Large GC pause caused artifical liveness problem: duration=" + duration + "ms"));
                    failedByGCPause = true;
                    break;
                }
                if (!failedByGCPause) {
                    BigdataConnectionTest.fail((String)("Query not interrupted quickly enough, should have been ~2s, but was " + duration / 1000L + "s on pass#" + i));
                }
                ++ngcfail;
            }
        }
        String msg = "NTRIALS=20, nok=" + nok + ", ngcfail=" + ngcfail;
        log.warn((Object)msg);
        if (nok < 5) {
            BigdataConnectionTest.fail((String)msg);
        }
    }
}

