/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.tck;

import com.bigdata.btree.keys.CollatorEnum;
import com.bigdata.btree.keys.StrengthEnum;
import com.bigdata.journal.IIndexManager;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepository;
import com.bigdata.rdf.sail.tck.BigdataSparqlTest;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.ScaleOutTripleStore;
import com.bigdata.resources.ResourceManager;
import com.bigdata.service.DistributedTransactionService;
import com.bigdata.service.EmbeddedClient;
import com.bigdata.service.IBigdataClient;
import com.bigdata.service.IBigdataFederation;
import java.io.File;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.log4j.Logger;
import org.openrdf.query.Dataset;
import org.openrdf.query.parser.sparql.manifest.ManifestTest;
import org.openrdf.query.parser.sparql.manifest.SPARQL11ManifestTest;
import org.openrdf.query.parser.sparql.manifest.SPARQLQueryTest;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryException;

public class BigdataEmbeddedFederationSparqlTest
extends BigdataSparqlTest {
    private static final Logger log = Logger.getLogger(BigdataEmbeddedFederationSparqlTest.class);
    private final String NAMESPACE = this.getName();
    private IBigdataClient<?> client;
    private IBigdataFederation<?> fed;

    public BigdataEmbeddedFederationSparqlTest(String testURI, String name, String queryFileURL, String resultFileURL, Dataset dataSet, boolean laxCardinality, boolean checkOrder) {
        super(testURI, name, queryFileURL, resultFileURL, dataSet, laxCardinality, checkOrder);
    }

    public static Test suite() throws Exception {
        return BigdataEmbeddedFederationSparqlTest.suite(true);
    }

    public static Test suite(boolean hideDatasetTests) throws Exception {
        TestSuite suite1 = BigdataEmbeddedFederationSparqlTest.suiteEmbeddedFederation();
        if (!testURIs.isEmpty()) {
            TestSuite suite = new TestSuite();
            for (String s : testURIs) {
                suite.addTest((Test)BigdataEmbeddedFederationSparqlTest.getSingleTest(suite1, s));
            }
            return suite;
        }
        if (hideDatasetTests) {
            suite1 = BigdataEmbeddedFederationSparqlTest.filterOutTests(suite1, "dataset");
        }
        suite1 = BigdataSparqlTest.filterOutTests(suite1, "bsbm");
        return suite1;
    }

    public static TestSuite suiteEmbeddedFederation() throws Exception {
        SPARQLQueryTest.Factory factory = new SPARQLQueryTest.Factory(){

            @Override
            public SPARQLQueryTest createSPARQLQueryTest(String testURI, String name, String queryFileURL, String resultFileURL, Dataset dataSet, boolean laxCardinality) {
                return this.createSPARQLQueryTest(testURI, name, queryFileURL, resultFileURL, dataSet, laxCardinality, true);
            }

            @Override
            public SPARQLQueryTest createSPARQLQueryTest(String testURI, String name, String queryFileURL, String resultFileURL, Dataset dataSet, boolean laxCardinality, boolean checkOrder) {
                return new BigdataEmbeddedFederationSparqlTest(testURI, name, queryFileURL, resultFileURL, dataSet, laxCardinality, checkOrder){

                    @Override
                    protected Properties getProperties() {
                        Properties p = new Properties(super.getProperties());
                        return p;
                    }
                };
            }
        };
        TestSuite suite = new TestSuite();
        suite.addTest((Test)ManifestTest.suite((SPARQLQueryTest.Factory)factory));
        suite.addTest((Test)SPARQL11ManifestTest.suite(factory, true, true, false, new String[0]));
        return suite;
    }

    @Override
    protected Properties getProperties() {
        Properties properties = super.getProperties();
        properties.setProperty(EmbeddedClient.Options.NDATA_SERVICES, "1");
        properties.setProperty(EmbeddedClient.Options.DATA_DIR, this.NAMESPACE);
        properties.setProperty(DistributedTransactionService.Options.DATA_DIR, new File(this.NAMESPACE, "txService").toString());
        properties.setProperty(IBigdataClient.Options.COLLECT_PLATFORM_STATISTICS, "false");
        properties.setProperty(ResourceManager.Options.MAXIMUM_MOVES_PER_TARGET, "0");
        properties.setProperty(BigdataSail.Options.ISOLATABLE_INDICES, "false");
        return properties;
    }

    @Override
    protected Repository newRepository() throws RepositoryException {
        File dataDir = new File(this.NAMESPACE);
        if (dataDir.exists() && dataDir.isDirectory()) {
            this.recursiveDelete(dataDir);
        }
        Properties properties = this.getProperties();
        if (cannotInlineTests.contains(this.testURI)) {
            properties.setProperty(BigdataSail.Options.INLINE_XSD_DATATYPE_LITERALS, "false");
            properties.setProperty(BigdataSail.Options.INLINE_DATE_TIMES, "false");
        }
        if (unicodeStrengthIdentical.contains(this.testURI)) {
            properties.setProperty(BigdataSail.Options.COLLATOR, CollatorEnum.JDK.toString());
            properties.setProperty(BigdataSail.Options.STRENGTH, StrengthEnum.Identical.toString());
        }
        this.client = new EmbeddedClient(properties);
        this.fed = this.client.connect();
        BigdataSail sail = new BigdataSail(this.openTripleStore(this.NAMESPACE, properties));
        return new BigdataSailRepository(sail);
    }

    @Override
    protected void tearDownBackend(IIndexManager backend) {
        backend.destroy();
        if (this.client != null) {
            this.client.disconnect(true);
            this.client = null;
        }
        this.fed = null;
    }

    private void recursiveDelete(File f) {
        if (f.isDirectory()) {
            File[] children = f.listFiles();
            for (int i = 0; i < children.length; ++i) {
                this.recursiveDelete(children[i]);
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Removing: " + f));
        }
        if (!f.delete()) {
            throw new RuntimeException("Could not remove: " + f);
        }
    }

    private AbstractTripleStore openTripleStore(String namespace, Properties properties) {
        AbstractTripleStore tripleStore = (AbstractTripleStore)this.fed.getResourceLocator().locate(namespace, 0L);
        if (tripleStore == null) {
            tripleStore = new ScaleOutTripleStore(this.fed, namespace, Long.valueOf(0L), properties);
            tripleStore.create();
        }
        return tripleStore;
    }
}

