/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.tck;

import com.bigdata.BigdataStatics;
import com.bigdata.btree.keys.CollatorEnum;
import com.bigdata.btree.keys.KeyBuilder;
import com.bigdata.btree.keys.StrengthEnum;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepository;
import com.bigdata.rdf.sail.BigdataSailRepositoryConnection;
import com.bigdata.rdf.sail.tck.BigdataSparqlTest;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.ScaleOutTripleStore;
import com.bigdata.service.AbstractDistributedFederation;
import com.bigdata.service.AbstractScaleOutClient;
import com.bigdata.service.ScaleOutClientFactory;
import java.util.Properties;
import java.util.UUID;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.log4j.Logger;
import org.openrdf.query.Dataset;
import org.openrdf.query.parser.sparql.manifest.ManifestTest;
import org.openrdf.query.parser.sparql.manifest.SPARQL11ManifestTest;
import org.openrdf.query.parser.sparql.manifest.SPARQLQueryTest;
import org.openrdf.repository.Repository;
import org.openrdf.repository.dataset.DatasetRepository;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.sail.SailConnection;

public class BigdataFederationSparqlTest
extends SPARQLQueryTest {
    public static final String CONFIG_PROPERTY = "bigdata.configuration";
    private static final Logger _logger = Logger.getLogger(BigdataFederationSparqlTest.class);
    private AbstractDistributedFederation<Object> _fed = null;
    private ScaleOutTripleStore _ts = null;
    private BigdataSail _sail = null;

    public static Test suite() throws Exception {
        return BigdataFederationSparqlTest.suite(true);
    }

    public static Test suite(boolean hideDatasetTests) throws Exception {
        TestSuite suite1 = BigdataFederationSparqlTest.fullSuite();
        if (!BigdataSparqlTest.testURIs.isEmpty()) {
            TestSuite suite = new TestSuite();
            for (String s : BigdataSparqlTest.testURIs) {
                suite.addTest((Test)BigdataSparqlTest.getSingleTest(suite1, s));
            }
            return suite;
        }
        if (hideDatasetTests) {
            suite1 = BigdataSparqlTest.filterOutTests(suite1, "dataset");
        }
        suite1 = BigdataSparqlTest.filterOutTests(suite1, BigdataSparqlTest.badTests);
        if (!BigdataStatics.runKnownBadTests) {
            suite1 = BigdataSparqlTest.filterOutTests(suite1, BigdataSparqlTest.knownBadTests);
        }
        suite1 = BigdataSparqlTest.filterOutTests(suite1, "bsbm");
        return suite1;
    }

    public static TestSuite fullSuite() throws Exception {
        SPARQLQueryTest.Factory factory = new SPARQLQueryTest.Factory(){

            @Override
            public SPARQLQueryTest createSPARQLQueryTest(String URI2, String name, String query, String results, Dataset dataSet, boolean laxCardinality) {
                return this.createSPARQLQueryTest(URI2, name, query, results, dataSet, laxCardinality, true);
            }

            @Override
            public SPARQLQueryTest createSPARQLQueryTest(String URI2, String name, String query, String results, Dataset dataSet, boolean laxCardinality, boolean checkOrder) {
                return new BigdataFederationSparqlTest(URI2, name, query, results, dataSet, laxCardinality, checkOrder);
            }
        };
        TestSuite suite = new TestSuite();
        suite.addTest((Test)ManifestTest.suite((SPARQLQueryTest.Factory)factory));
        suite.addTest((Test)SPARQL11ManifestTest.suite(factory, true, true, false, new String[0]));
        return suite;
    }

    public BigdataFederationSparqlTest(String URI2, String name, String query, String results, Dataset dataSet, boolean laxCardinality, boolean checkOrder) {
        super(URI2, name, query, results, dataSet, laxCardinality, checkOrder);
    }

    @Override
    public void runTest() throws Exception {
        _logger.info((Object)String.format(">>>>> Running test: %s", this.testURI));
        super.runTest();
        _logger.info((Object)String.format(">>>>> Completed test: %s", this.testURI));
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        if (this._ts != null) {
            this._ts.destroy();
            this._ts = null;
        }
        if (this._fed != null) {
            this._fed.shutdownNow();
            this._fed = null;
        }
    }

    @Override
    protected Repository newRepository() throws Exception {
        this._sail = new BigdataSail((AbstractTripleStore)this.newTripleStore());
        return new DatasetRepository((SailRepository)new BigdataSailRepository(this._sail));
    }

    protected BigdataSailRepositoryConnection getQueryConnection(Repository dataRep) throws Exception {
        BigdataSailRepositoryConnection con = new BigdataSailRepositoryConnection(new BigdataSailRepository(this._sail), (SailConnection)this._sail.getReadOnlyConnection());
        return con;
    }

    private ScaleOutTripleStore newTripleStore() throws Exception {
        this._ts = new ScaleOutTripleStore(this.getFederation(), this.newNamespace(), Long.valueOf(0L), this.getProperties());
        this._ts.create();
        return this._ts;
    }

    private AbstractDistributedFederation<Object> getFederation() throws Exception {
        if (null == this._fed) {
            AbstractScaleOutClient jc = ScaleOutClientFactory.getJiniClient((String[])new String[]{BigdataFederationSparqlTest.getConfiguration()});
            this._fed = (AbstractDistributedFederation)jc.connect();
        }
        return this._fed;
    }

    private static String getConfiguration() throws Exception {
        String c = System.getProperty(CONFIG_PROPERTY);
        if (null == c) {
            throw new Exception(String.format("Configuration property not set. Specify as: -D%s=<filename or URL>", CONFIG_PROPERTY));
        }
        return c;
    }

    private String newNamespace() {
        return "SPARQLTest_" + UUID.randomUUID().toString();
    }

    private Properties getProperties() throws Exception {
        Properties _properties = new Properties();
        _properties.put(BigdataSail.Options.QUADS_MODE, "true");
        _properties.put(BigdataSail.Options.TRUTH_MAINTENANCE, "false");
        _properties.put(BigdataSail.Options.QUERY_TIME_EXPANDER, "false");
        _properties.put(KeyBuilder.Options.COLLATOR, "ICU");
        _properties.put("user.language", "en");
        _properties.put("user.country", "US");
        _properties.put("user.variant", "");
        _properties.put(BigdataSail.Options.TEXT_INDEX, "false");
        _properties.put(BigdataSail.Options.BLOOM_FILTER, "true");
        if (BigdataSparqlTest.cannotInlineTests.contains(this.testURI)) {
            _properties.setProperty(BigdataSail.Options.INLINE_XSD_DATATYPE_LITERALS, "false");
            _properties.setProperty(BigdataSail.Options.INLINE_DATE_TIMES, "false");
        } else {
            _properties.setProperty(BigdataSail.Options.INLINE_XSD_DATATYPE_LITERALS, "true");
            _properties.setProperty(BigdataSail.Options.INLINE_DATE_TIMES, "true");
        }
        if (BigdataSparqlTest.unicodeStrengthIdentical.contains(this.testURI)) {
            _properties.setProperty(BigdataSail.Options.COLLATOR, CollatorEnum.JDK.toString());
            _properties.setProperty(BigdataSail.Options.STRENGTH, StrengthEnum.Identical.toString());
        }
        return _properties;
    }
}

