/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.tck;

import com.bigdata.BigdataStatics;
import com.bigdata.journal.BufferMode;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepository;
import com.bigdata.rdf.sail.BigdataSailRepositoryConnection;
import com.bigdata.rdf.sail.BigdataSailUpdate;
import com.bigdata.rdf.sparql.ast.UpdateRoot;
import info.aduna.iteration.Iteration;
import info.aduna.iteration.Iterations;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.util.ModelUtil;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.Update;
import org.openrdf.query.parser.sparql.manifest.SPARQL11ManifestTest;
import org.openrdf.query.parser.sparql.manifest.SPARQLUpdateConformanceTest;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.rio.RDFFormat;

public class BigdataSPARQLUpdateConformanceTest
extends SPARQLUpdateConformanceTest {
    static final Collection<String> testURIs = Arrays.asList(new String[0]);
    static final Collection<String> knownBadTests = Arrays.asList("http://www.w3.org/2009/sparql/docs/tests/data-sparql11/delete-data/manifest#dawg-delete-data-05", "http://www.w3.org/2009/sparql/docs/tests/data-sparql11/delete-where/manifest#dawg-delete-where-05", "http://www.w3.org/2009/sparql/docs/tests/data-sparql11/delete/manifest#dawg-delete-05", "http://www.w3.org/2009/sparql/docs/tests/data-sparql11/delete/manifest#dawg-delete-using-01", "http://www.w3.org/2009/sparql/docs/tests/data-sparql11/delete/manifest#dawg-delete-using-02a", "http://www.w3.org/2009/sparql/docs/tests/data-sparql11/delete/manifest#dawg-delete-using-06a");

    static BigdataSPARQLUpdateConformanceTest getSingleTest(TestSuite suite, String testURI) throws RuntimeException {
        Enumeration e1 = suite.tests();
        while (e1.hasMoreElements()) {
            BigdataSPARQLUpdateConformanceTest test;
            Test aTest = (Test)e1.nextElement();
            if (aTest instanceof TestSuite && (test = BigdataSPARQLUpdateConformanceTest.getSingleTest((TestSuite)aTest, testURI)) != null) {
                return test;
            }
            if (!(aTest instanceof BigdataSPARQLUpdateConformanceTest)) continue;
            test = (BigdataSPARQLUpdateConformanceTest)aTest;
            if (!testURI.equals(test.testURI)) continue;
            return test;
        }
        return null;
    }

    static TestSuite filterOutTests(TestSuite suite1, Collection<String> testURIs) {
        TestSuite suite2 = new TestSuite(suite1.getName());
        Enumeration e = suite1.tests();
        while (e.hasMoreElements()) {
            Test aTest = (Test)e.nextElement();
            if (aTest instanceof TestSuite) {
                TestSuite aTestSuite = (TestSuite)aTest;
                suite2.addTest((Test)BigdataSPARQLUpdateConformanceTest.filterOutTests(aTestSuite, testURIs));
                continue;
            }
            if (!(aTest instanceof BigdataSPARQLUpdateConformanceTest)) continue;
            BigdataSPARQLUpdateConformanceTest test = (BigdataSPARQLUpdateConformanceTest)aTest;
            if (testURIs.contains(test.testURI)) continue;
            suite2.addTest((Test)test);
        }
        return suite2;
    }

    public BigdataSPARQLUpdateConformanceTest(String testURI, String name, String requestFile, URI defaultGraphURI, Map<String, URI> inputNamedGraphs, URI resultDefaultGraphURI, Map<String, URI> resultNamedGraphs) {
        super(testURI, name, requestFile, defaultGraphURI, inputNamedGraphs, resultDefaultGraphURI, resultNamedGraphs);
    }

    public static Test suite() throws Exception {
        TestSuite suite1 = SPARQL11ManifestTest.suite(new SPARQLUpdateConformanceTest.Factory(){

            @Override
            public BigdataSPARQLUpdateConformanceTest createSPARQLUpdateConformanceTest(String testURI, String name, String requestFile, URI defaultGraphURI, Map<String, URI> inputNamedGraphs, URI resultDefaultGraphURI, Map<String, URI> resultNamedGraphs) {
                return new BigdataSPARQLUpdateConformanceTest(testURI, name, requestFile, defaultGraphURI, inputNamedGraphs, resultDefaultGraphURI, resultNamedGraphs);
            }
        }, true, false, false, new String[0]);
        if (!testURIs.isEmpty()) {
            TestSuite suite2 = new TestSuite();
            for (String s : testURIs) {
                BigdataSPARQLUpdateConformanceTest test = BigdataSPARQLUpdateConformanceTest.getSingleTest(suite1, s);
                if (test == null) {
                    throw new RuntimeException("Could not find test: uri=" + s);
                }
                suite2.addTest((Test)test);
            }
            return suite2;
        }
        if (!BigdataStatics.runKnownBadTests) {
            suite1 = BigdataSPARQLUpdateConformanceTest.filterOutTests(suite1, knownBadTests);
        }
        return suite1;
    }

    protected Properties getProperties() {
        Properties props = new Properties();
        props.setProperty(BigdataSail.Options.BUFFER_MODE, BufferMode.Transient.toString());
        props.setProperty(BigdataSail.Options.QUADS_MODE, "true");
        props.setProperty(BigdataSail.Options.JUSTIFY, "false");
        props.setProperty(BigdataSail.Options.QUERY_TIME_EXPANDER, "false");
        props.setProperty(BigdataSail.Options.EXACT_SIZE, "true");
        props.setProperty(BigdataSail.Options.ISOLATABLE_INDICES, "false");
        props.setProperty(BigdataSail.Options.TRUTH_MAINTENANCE, "false");
        props.setProperty(BigdataSail.Options.NAMESPACE, "kb-" + UUID.randomUUID().toString());
        return props;
    }

    protected BigdataSailRepository newRepository() throws RepositoryException {
        Properties props = this.getProperties();
        BigdataSail sail = new BigdataSail(props);
        return new BigdataSailRepository(sail);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setUp() throws Exception {
        this.dataRep = this.createRepository();
        URL graphURL = null;
        try (RepositoryConnection conn = this.dataRep.getConnection();){
            conn.clear(new Resource[0]);
            if (this.inputDefaultGraph != null) {
                graphURL = new URL(this.inputDefaultGraph.stringValue());
                conn.add(graphURL, null, RDFFormat.forFileName((String)graphURL.toString()), new Resource[0]);
            }
            for (String ng : this.inputNamedGraphs.keySet()) {
                graphURL = new URL(((URI)this.inputNamedGraphs.get(ng)).stringValue());
                conn.add(graphURL, null, RDFFormat.forFileName((String)graphURL.toString()), new Resource[]{this.dataRep.getValueFactory().createURI(ng)});
            }
            conn.commit();
        }
        this.expectedResultRepo = this.createRepository();
        conn = this.expectedResultRepo.getConnection();
        try {
            conn.clear(new Resource[0]);
            if (this.resultDefaultGraph != null) {
                graphURL = new URL(this.resultDefaultGraph.stringValue());
                conn.add(graphURL, null, RDFFormat.forFileName((String)graphURL.toString()), new Resource[0]);
            }
            for (String ng : this.resultNamedGraphs.keySet()) {
                graphURL = new URL(((URI)this.resultNamedGraphs.get(ng)).stringValue());
                conn.add(graphURL, null, RDFFormat.forFileName((String)graphURL.toString()), new Resource[]{this.dataRep.getValueFactory().createURI(ng)});
            }
            conn.commit();
        }
        finally {
            conn.close();
        }
    }

    @Override
    protected void runTest() throws Exception {
        BigdataSailRepositoryConnection con = (BigdataSailRepositoryConnection)this.dataRep.getConnection();
        BigdataSailRepositoryConnection erCon = (BigdataSailRepositoryConnection)this.expectedResultRepo.getConnection();
        try {
            String updateString = this.readUpdateString();
            con.begin();
            Update update = con.prepareUpdate(QueryLanguage.SPARQL, updateString, this.requestFileURL);
            update.execute();
            con.commit();
            this.compareGraphs(Iterations.asList((Iteration)con.getStatements(null, null, null, true, new Resource[]{null})), Iterations.asList((Iteration)erCon.getStatements(null, null, null, true, new Resource[]{null})), con);
            for (String namedGraph : this.inputNamedGraphs.keySet()) {
                BigdataURI contextURI = con.getValueFactory().createURI(namedGraph.replaceAll("\"", ""));
                this.compareGraphs(Iterations.asList((Iteration)con.getStatements(null, null, null, true, new Resource[]{contextURI})), Iterations.asList((Iteration)erCon.getStatements(null, null, null, true, new Resource[]{contextURI})), con);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            if (con.isActive()) {
                con.rollback();
            }
            throw e;
        }
        finally {
            con.close();
            erCon.close();
        }
    }

    protected void compareGraphs(Iterable<? extends Statement> actual, Iterable<? extends Statement> expected, BigdataSailRepositoryConnection cxn) throws Exception {
        if (!ModelUtil.equals(expected, actual)) {
            StringBuilder message = new StringBuilder(128);
            message.append("\n=========================================\n");
            message.append(this.getName());
            message.append("\n");
            message.append(this.testURI);
            message.append("\n=========================================\n");
            message.append("Expected results: \n");
            for (Statement statement : expected) {
                message.append(statement);
                message.append("\n");
            }
            message.append("=========================================\n");
            message.append("Bigdata results: \n");
            for (Statement statement : actual) {
                message.append(statement);
                message.append("\n");
            }
            message.append("=========================================\n");
            String queryStr = this.readUpdateString();
            message.append("Query:\n" + queryStr);
            message.append("\n=========================================\n");
            BigdataSailUpdate bigdataSailUpdate = (BigdataSailUpdate)cxn.prepareUpdate(QueryLanguage.SPARQL, queryStr);
            UpdateRoot original = bigdataSailUpdate.getASTContainer().getOriginalUpdateAST();
            message.append("Original AST:\n" + original);
            message.append("\n=========================================\n");
            logger.error(message.toString());
            BigdataSPARQLUpdateConformanceTest.fail((String)message.toString());
        }
    }
}

