/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.tck;

import com.bigdata.journal.BufferMode;
import com.bigdata.journal.IIndexManager;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepository;
import com.bigdata.rdf.sail.BigdataSailUpdate;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.query.BindingSet;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.Update;
import org.openrdf.query.UpdateExecutionException;
import org.openrdf.query.parser.sparql.SPARQLUpdateTest;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryException;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFParseException;

public class BigdataSPARQLUpdateTest
extends SPARQLUpdateTest {
    private static final Logger logger = Logger.getLogger(BigdataSPARQLUpdateTest.class);
    private IIndexManager backend = null;

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        if (this.backend != null) {
            this.tearDownBackend(this.backend);
        }
        this.backend = null;
    }

    protected void tearDownBackend(IIndexManager backend) {
        backend.destroy();
    }

    protected Properties getProperties() {
        Properties props = new Properties();
        props.setProperty(BigdataSail.Options.BUFFER_MODE, BufferMode.Transient.toString());
        props.setProperty(BigdataSail.Options.QUADS_MODE, "true");
        props.setProperty(BigdataSail.Options.JUSTIFY, "false");
        props.setProperty(BigdataSail.Options.QUERY_TIME_EXPANDER, "false");
        props.setProperty(BigdataSail.Options.EXACT_SIZE, "true");
        props.setProperty(BigdataSail.Options.ISOLATABLE_INDICES, "false");
        props.setProperty(BigdataSail.Options.TRUTH_MAINTENANCE, "false");
        props.setProperty(BigdataSail.Options.TEXT_INDEX, "true");
        props.setProperty(BigdataSail.Options.NAMESPACE, "BigdataSPARQLUpdate-" + UUID.randomUUID());
        return props;
    }

    @Override
    protected Repository createRepository() throws Exception {
        Repository repo = this.newRepository();
        repo.initialize();
        return repo;
    }

    @Override
    protected Repository newRepository() throws RepositoryException {
        Properties props = this.getProperties();
        BigdataSail sail = new BigdataSail(props);
        this.backend = sail.getIndexManager();
        return new BigdataSailRepository(sail);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void loadDataset(String datasetFile) throws RDFParseException, RepositoryException, IOException {
        logger.debug((Object)"loading dataset...");
        try (InputStream dataset = SPARQLUpdateTest.class.getResourceAsStream(datasetFile);){
            this.con.add(dataset, "", RDFFormat.forFileName((String)datasetFile), new Resource[0]);
            this.con.commit();
        }
        logger.debug((Object)"dataset loaded.");
    }

    public void test_ticket538() throws UpdateExecutionException, RepositoryException, MalformedQueryException, QueryEvaluationException {
        URI gin = this.f.createURI("http://example/in");
        URI gout = this.f.createURI("http://example/out");
        this.con.prepareUpdate(QueryLanguage.SPARQL, "DROP SILENT ALL").execute();
        BigdataSPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement(null, null, null, true, new Resource[]{gin}));
        BigdataSPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement(null, null, null, true, new Resource[]{gout}));
        String s = "# Update 2\nPREFIX foaf: <http://xmlns.com/foaf/0.1/>\nINSERT DATA {\n  GRAPH <http://example/in> {\n        <http://example/president25> foaf:givenName \"William\" .\n  }\n};\nINSERT {\n   GRAPH <http://example/out> {\n       ?s ?p ?v .\n        }\n    }\nWHERE {\n   GRAPH <http://example/in> {\n       ?s ?p ?v .\n        }\n  }\n;";
        BigdataSailUpdate update = (BigdataSailUpdate)this.con.prepareUpdate(QueryLanguage.SPARQL, "# Update 2\nPREFIX foaf: <http://xmlns.com/foaf/0.1/>\nINSERT DATA {\n  GRAPH <http://example/in> {\n        <http://example/president25> foaf:givenName \"William\" .\n  }\n};\nINSERT {\n   GRAPH <http://example/out> {\n       ?s ?p ?v .\n        }\n    }\nWHERE {\n   GRAPH <http://example/in> {\n       ?s ?p ?v .\n        }\n  }\n;");
        update.execute();
        BigdataSPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement(null, null, null, true, new Resource[]{gin}));
        BigdataSPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement(null, null, null, true, new Resource[]{gout}));
    }

    public void testTicket567() throws RepositoryException, MalformedQueryException, UpdateExecutionException {
        this.con.clear(new Resource[0]);
        this.con.commit();
        StringBuilder update = new StringBuilder();
        update.append("DROP ALL;\n");
        update.append("INSERT DATA {\n");
        update.append(" GRAPH <http://example.org/one> {\n");
        update.append("   <http://example.org/a> <http://example.org/b> <http://example.org/c> .\n");
        update.append("   <http://example.org/d> <http://example.org/e> <http://example.org/f> .\n");
        update.append("}};\n");
        update.append("ADD SILENT GRAPH <http://example.org/one> TO GRAPH <http://example.org/two> ;\n");
        update.append("DROP SILENT GRAPH <http://example.org/one>  ;\n");
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update.toString());
        operation.execute();
        URI one = this.f.createURI("http://example.org/one");
        URI two = this.f.createURI("http://example.org/two");
        String msg = "Nothing in graph <one>";
        BigdataSPARQLUpdateTest.assertFalse((String)msg, (boolean)this.con.hasStatement(null, null, null, true, new Resource[]{one}));
        msg = "statements are in graph <two>";
        BigdataSPARQLUpdateTest.assertTrue((String)msg, (boolean)this.con.hasStatement(null, null, null, true, new Resource[]{two}));
    }

    public void testTicket571() throws RepositoryException, MalformedQueryException, UpdateExecutionException, QueryEvaluationException {
        this.con.prepareUpdate(QueryLanguage.SPARQL, "DROP ALL").execute();
        this.con.prepareUpdate(QueryLanguage.SPARQL, "PREFIX graphA:  <http://example/graphA> \nINSERT DATA { \n GRAPH graphA: { \n   _:bnode <http://example/p> 2 . \n   _:bnode a <http://example/Foo> . \n   <http://example/s> <http://example/p> 2 . \n}}\n").execute();
        String query = "SELECT * WHERE { GRAPH <http://example/graphA> { ?s ?p ?v . } }";
        BigdataSPARQLUpdateTest.assertEquals((String)"graphA", (long)3L, (long)this.countSolutions("SELECT * WHERE { GRAPH <http://example/graphA> { ?s ?p ?v . } }"));
        this.con.prepareUpdate(QueryLanguage.SPARQL, "PREFIX graphA:  <http://example/graphA> \nPREFIX tempGraph:  <http://example/temp> \nDELETE { GRAPH graphA:    { ?s ?p ?v . } } \nINSERT { GRAPH tempGraph: { ?s ?p ?v . } } \nWHERE { GRAPH graphA: { \n    ?s a <http://example/Foo> . \n    ?s ?p ?v . } }\n").execute();
        query = "SELECT * WHERE { GRAPH <http://example/graphA> { ?s ?p ?v . } }";
        BigdataSPARQLUpdateTest.assertEquals((String)"graphA", (long)1L, (long)this.countSolutions("SELECT * WHERE { GRAPH <http://example/graphA> { ?s ?p ?v . } }"));
        query = "SELECT * WHERE { GRAPH <http://example/temp> { ?s ?p ?v . } }";
        BigdataSPARQLUpdateTest.assertEquals((String)"tempGraph", (long)2L, (long)this.countSolutions("SELECT * WHERE { GRAPH <http://example/temp> { ?s ?p ?v . } }"));
    }

    public void testTicket571b() throws RepositoryException, MalformedQueryException, UpdateExecutionException, QueryEvaluationException {
        this.con.prepareUpdate(QueryLanguage.SPARQL, "DROP ALL").execute();
        this.con.prepareUpdate(QueryLanguage.SPARQL, "PREFIX graphA:  <http://example/graphA> \nINSERT DATA { \n GRAPH graphA: { \n   <http://nobnode> <http://example/p> 2 . \n   <http://nobnode> a <http://example/Foo> . \n   <http://example/s> <http://example/p> 2 . \n}}\n").execute();
        String query = "SELECT * WHERE { GRAPH <http://example/graphA> { ?s ?p ?v . } }";
        BigdataSPARQLUpdateTest.assertEquals((String)"graphA", (long)3L, (long)this.countSolutions("SELECT * WHERE { GRAPH <http://example/graphA> { ?s ?p ?v . } }"));
        this.con.prepareUpdate(QueryLanguage.SPARQL, "PREFIX graphA:  <http://example/graphA> \nPREFIX tempGraph:  <http://example/temp> \nDELETE { GRAPH graphA:    { ?s ?p ?v . } } \nINSERT { GRAPH tempGraph: { ?s ?p ?v . } } \nWHERE { GRAPH graphA: { \n    ?s a <http://example/Foo> . \n    ?s ?p ?v . } }\n").execute();
        query = "SELECT * WHERE { GRAPH <http://example/graphA> { ?s ?p ?v . } }";
        BigdataSPARQLUpdateTest.assertEquals((String)"graphA", (long)1L, (long)this.countSolutions("SELECT * WHERE { GRAPH <http://example/graphA> { ?s ?p ?v . } }"));
        query = "SELECT * WHERE { GRAPH <http://example/temp> { ?s ?p ?v . } }";
        BigdataSPARQLUpdateTest.assertEquals((String)"tempGraph", (long)2L, (long)this.countSolutions("SELECT * WHERE { GRAPH <http://example/temp> { ?s ?p ?v . } }"));
    }

    public void testUnicodeCleanAndRegex() throws Exception {
        String updateStr = "PREFIX ns: <http://example.org/ns#>\nINSERT DATA { GRAPH ns:graph { ns:auml ns:label \"\u00c4\", \"\u00e4\" } }\n";
        BigdataSailUpdate update = (BigdataSailUpdate)this.con.prepareUpdate(QueryLanguage.SPARQL, "PREFIX ns: <http://example.org/ns#>\nINSERT DATA { GRAPH ns:graph { ns:auml ns:label \"\u00c4\", \"\u00e4\" } }\n");
        update.execute();
        String queryStr = "PREFIX ns: <http://example.org/ns#>\nSELECT * { GRAPH ns:graph { ?s ?p ?o FILTER(regex(?o, \"\u00e4\", \"i\")) } }";
        BigdataSPARQLUpdateTest.assertEquals((long)2L, (long)this.countSolutions("PREFIX ns: <http://example.org/ns#>\nSELECT * { GRAPH ns:graph { ?s ?p ?o FILTER(regex(?o, \"\u00e4\", \"i\")) } }"));
    }

    public void testLoadGZip() throws Exception {
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource("com/bigdata/rdf/rio/small.rdf.gz");
        String update = "LOAD <" + url.toExternalForm() + ">";
        String ns = "http://bigdata.com/test/data#";
        this.con.prepareUpdate(QueryLanguage.SPARQL, update).execute();
        BigdataSPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.f.createURI("http://bigdata.com/test/data#", "mike"), RDFS.LABEL, (Value)this.f.createLiteral("Michael Personick"), true, new Resource[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long countSolutions(String query) throws QueryEvaluationException, RepositoryException, MalformedQueryException {
        try (TupleQueryResult result = this.con.prepareTupleQuery(QueryLanguage.SPARQL, query).evaluate();){
            long n = 0L;
            while (result.hasNext()) {
                BindingSet bset = (BindingSet)result.next();
                ++n;
                if (!logger.isInfoEnabled()) continue;
                logger.info((Object)bset.toString());
            }
            long l = n;
            return l;
        }
    }

    public void testUpdateLiteralsWithLanguageTags() throws Exception {
        String queryStr = "SELECT * WHERE { ?s ?p ?o }";
        long nrTriplesBeforeUpdate = this.countSolutions("SELECT * WHERE { ?s ?p ?o }");
        StringBuilder updateStrBuf = new StringBuilder();
        updateStrBuf.append("INSERT DATA { ");
        updateStrBuf.append("<http://rm-lod.org/object/2176/production/date> ");
        updateStrBuf.append("<http://www.w3.org/2000/01/rdf-schema#label> ");
        updateStrBuf.append("\"1906\"@ru . }");
        String updateStr = updateStrBuf.toString();
        BigdataSailUpdate update = (BigdataSailUpdate)this.con.prepareUpdate(QueryLanguage.SPARQL, updateStr);
        update.execute();
        long nrTriplesAfterUpdate = this.countSolutions("SELECT * WHERE { ?s ?p ?o }");
        BigdataSPARQLUpdateTest.assertEquals((long)(nrTriplesBeforeUpdate + 1L), (long)nrTriplesAfterUpdate);
    }
}

