/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.tck;

import com.bigdata.bop.engine.AbstractQueryEngineTestCase;
import com.bigdata.journal.BufferMode;
import com.bigdata.journal.IIndexManager;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepository;
import com.bigdata.rdf.sail.BigdataSailRepositoryConnection;
import com.bigdata.rdf.store.AbstractTripleStore;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import junit.framework.TestCase2;
import org.apache.log4j.Logger;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.UpdateExecutionException;
import org.openrdf.query.impl.TupleQueryResultBuilder;
import org.openrdf.query.resultio.QueryResultIO;
import org.openrdf.query.resultio.TupleQueryResultFormat;
import org.openrdf.query.resultio.TupleQueryResultParser;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;

public class BigdataSPARQLUpdateTest2
extends TestCase2 {
    private static final Logger log = Logger.getLogger(BigdataSPARQLUpdateTest2.class);
    protected final String packagePath = "file:src/test/java/com/bigdata/rdf/sail/tck/data/";
    private IIndexManager backend = null;
    private Repository rep;
    protected RepositoryConnection con;

    public BigdataSPARQLUpdateTest2() {
    }

    public BigdataSPARQLUpdateTest2(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        this.rep = this.createRepository();
        this.con = this.rep.getConnection();
        this.con.setAutoCommit(false);
    }

    public void tearDown() throws Exception {
        this.con.close();
        this.con = null;
        this.rep.shutDown();
        this.rep = null;
        if (this.backend != null) {
            this.backend.destroy();
            this.backend = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TupleQueryResult readExpectedTupleQueryResult(String resultFileURL) throws Exception {
        TupleQueryResultFormat tqrFormat = QueryResultIO.getParserFormatForFileName((String)resultFileURL);
        if (tqrFormat == null) {
            throw new RuntimeException("Format not found: resource=" + resultFileURL);
        }
        try (InputStream in = this.getResourceAsStream(resultFileURL);){
            TupleQueryResultParser parser = QueryResultIO.createParser((TupleQueryResultFormat)tqrFormat);
            TupleQueryResultBuilder qrBuilder = new TupleQueryResultBuilder();
            parser.setTupleQueryResultHandler((TupleQueryResultHandler)qrBuilder);
            parser.parse(in);
            TupleQueryResult tupleQueryResult = qrBuilder.getQueryResult();
            return tupleQueryResult;
        }
    }

    protected InputStream getResourceAsStream(String resource) {
        File file;
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(resource);
        if (is == null) {
            is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(resource);
        }
        if (is == null && (file = new File(resource)).exists()) {
            try {
                is = new FileInputStream(resource);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        if (is == null) {
            try {
                is = new URL(resource).openStream();
            }
            catch (MalformedURLException e) {
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (is == null) {
            throw new RuntimeException("Not found: " + resource);
        }
        return is;
    }

    protected String getResourceAsString(String resource) {
        StringBuilder sb = new StringBuilder();
        InputStream is = this.getResourceAsStream(resource);
        if (is == null) {
            throw new RuntimeException("Not found: " + resource);
        }
        try {
            String s;
            LineNumberReader r = new LineNumberReader(new InputStreamReader(is));
            while ((s = r.readLine()) != null) {
                sb.append(s);
                sb.append("\n");
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected void compareTupleQueryResults(TupleQueryResult queryResult, TupleQueryResult expectedResult) throws QueryEvaluationException {
        AbstractQueryEngineTestCase.compareTupleQueryResults((String)this.getName(), (String)this.getName(), null, null, (TupleQueryResult)queryResult, (TupleQueryResult)expectedResult, (boolean)false, (boolean)false);
    }

    public Properties getProperties() {
        Properties props = new Properties(super.getProperties());
        props.setProperty(BigdataSail.Options.BUFFER_MODE, BufferMode.MemStore.toString());
        props.setProperty(BigdataSail.Options.QUADS_MODE, "true");
        props.setProperty(BigdataSail.Options.JUSTIFY, "false");
        props.setProperty(BigdataSail.Options.QUERY_TIME_EXPANDER, "false");
        props.setProperty(BigdataSail.Options.EXACT_SIZE, "true");
        props.setProperty(BigdataSail.Options.ISOLATABLE_INDICES, "false");
        props.setProperty(BigdataSail.Options.TRUTH_MAINTENANCE, "false");
        props.setProperty(BigdataSail.Options.TEXT_INDEX, "true");
        return props;
    }

    protected Repository createRepository() throws Exception {
        Repository repo = this.newRepository();
        repo.initialize();
        return repo;
    }

    protected Repository newRepository() throws RepositoryException {
        Properties props = this.getProperties();
        BigdataSail sail = new BigdataSail(props);
        this.backend = sail.getIndexManager();
        return new BigdataSailRepository(sail);
    }

    protected void loadDataset(String datasetFile) throws UpdateExecutionException, MalformedQueryException, RepositoryException {
        String updateStr = "LOAD <" + datasetFile + ">";
        this.con.prepareUpdate(QueryLanguage.SPARQL, updateStr).execute();
    }

    protected boolean isSolutionSetUpdateEnabled() {
        AbstractTripleStore tripleStore = ((BigdataSailRepositoryConnection)this.con).getTripleStore();
        boolean isolatable = Boolean.parseBoolean(tripleStore.getProperty(BigdataSail.Options.ISOLATABLE_INDICES, "false"));
        return !isolatable;
    }

    public void test_insertIntoSolutions_01() throws Exception {
        if (!this.isSolutionSetUpdateEnabled()) {
            return;
        }
        this.loadDataset("file:src/test/java/com/bigdata/rdf/sail/tck/data/dataset-01.trig");
        StringBuilder sb = new StringBuilder();
        sb.append("PREFIX rdf:  <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n");
        sb.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n");
        sb.append("PREFIX foaf: <http://xmlns.com/foaf/0.1/>\n");
        sb.append("INSERT INTO %namedSet1\n");
        sb.append("SELECT ?x ?name\n");
        sb.append("WHERE { SELECT ?x ?name\n");
        sb.append("WHERE {\n");
        sb.append("  ?x rdf:type foaf:Person .\n");
        sb.append("  ?x rdfs:label ?name .\n");
        sb.append("}\n");
        sb.append("ORDER BY ?name\n");
        sb.append("}");
        this.con.prepareUpdate(QueryLanguage.SPARQL, sb.toString()).execute();
        sb = new StringBuilder();
        sb.append("PREFIX rdf:  <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n");
        sb.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n");
        sb.append("PREFIX foaf: <http://xmlns.com/foaf/0.1/>\n");
        sb.append("SELECT ?x ?name\n");
        sb.append("WHERE {\n");
        sb.append("  INCLUDE %namedSet1 .\n");
        sb.append("  ?x rdfs:label \"Mike\" .\n");
        sb.append("}\n");
        TupleQueryResult ret = this.con.prepareTupleQuery(QueryLanguage.SPARQL, sb.toString()).evaluate();
        TupleQueryResult expected = this.readExpectedTupleQueryResult("file:src/test/java/com/bigdata/rdf/sail/tck/data/test_insertIntoSolutions_01.srx");
        this.compareTupleQueryResults(ret, expected);
    }

    public void test_deleteFromSolutions_01() throws Exception {
        if (!this.isSolutionSetUpdateEnabled()) {
            return;
        }
        this.loadDataset("file:src/test/java/com/bigdata/rdf/sail/tck/data/dataset-01.trig");
        StringBuilder sb = new StringBuilder();
        sb.append("PREFIX rdf:  <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n");
        sb.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n");
        sb.append("PREFIX foaf: <http://xmlns.com/foaf/0.1/>\n");
        sb.append("INSERT INTO %namedSet1\n");
        sb.append("SELECT ?x ?name\n");
        sb.append("WHERE {\n");
        sb.append("  ?x rdf:type foaf:Person .\n");
        sb.append("  ?x rdfs:label ?name .\n");
        sb.append("}\n");
        this.con.prepareUpdate(QueryLanguage.SPARQL, sb.toString()).execute();
        sb = new StringBuilder();
        sb.append("PREFIX rdf:  <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n");
        sb.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n");
        sb.append("PREFIX foaf: <http://xmlns.com/foaf/0.1/>\n");
        sb.append("DELETE FROM %namedSet1\n");
        sb.append("SELECT * \n");
        sb.append("WHERE { \n");
        sb.append("   BIND(<http://www.bigdata.com/Mike> as ?x)\n");
        sb.append("   BIND(\"Mike\" as ?name)\n");
        sb.append("}\n");
        this.con.prepareUpdate(QueryLanguage.SPARQL, sb.toString()).execute();
        sb = new StringBuilder();
        sb.append("PREFIX rdf:  <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n");
        sb.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n");
        sb.append("PREFIX foaf: <http://xmlns.com/foaf/0.1/>\n");
        sb.append("SELECT ?x ?name\n");
        sb.append("WHERE {\n");
        sb.append("  INCLUDE %namedSet1 .\n");
        sb.append("}\n");
        TupleQueryResult ret = this.con.prepareTupleQuery(QueryLanguage.SPARQL, sb.toString()).evaluate();
        TupleQueryResult expected = this.readExpectedTupleQueryResult("file:src/test/java/com/bigdata/rdf/sail/tck/data/test_deleteFromSolutions_01.srx");
        this.compareTupleQueryResults(ret, expected);
    }

    public void test_deleteFromSolutions_02() throws Exception {
        if (!this.isSolutionSetUpdateEnabled()) {
            return;
        }
        this.loadDataset("file:src/test/java/com/bigdata/rdf/sail/tck/data/dataset-01.trig");
        StringBuilder sb = new StringBuilder();
        sb.append("PREFIX rdf:  <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n");
        sb.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n");
        sb.append("PREFIX foaf: <http://xmlns.com/foaf/0.1/>\n");
        sb.append("INSERT INTO %namedSet1\n");
        sb.append("SELECT ?x ?name\n");
        sb.append("WHERE {\n");
        sb.append("  ?x rdf:type foaf:Person .\n");
        sb.append("  ?x rdfs:label ?name .\n");
        sb.append("}\n");
        this.con.prepareUpdate(QueryLanguage.SPARQL, sb.toString()).execute();
        sb = new StringBuilder();
        sb.append("PREFIX rdf:  <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n");
        sb.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n");
        sb.append("PREFIX foaf: <http://xmlns.com/foaf/0.1/>\n");
        sb.append("DELETE FROM %namedSet1\n");
        sb.append("SELECT ?x ?name\n");
        sb.append("WHERE { \n");
        sb.append("  ?x rdfs:label ?name .\n");
        sb.append("  FILTER (?x = <http://www.bigdata.com/Mike> ) .\n");
        sb.append("}\n");
        this.con.prepareUpdate(QueryLanguage.SPARQL, sb.toString()).execute();
        sb = new StringBuilder();
        sb.append("PREFIX rdf:  <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n");
        sb.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n");
        sb.append("PREFIX foaf: <http://xmlns.com/foaf/0.1/>\n");
        sb.append("SELECT ?x ?name\n");
        sb.append("WHERE {\n");
        sb.append("  INCLUDE %namedSet1 .\n");
        sb.append("}\n");
        TupleQueryResult ret = this.con.prepareTupleQuery(QueryLanguage.SPARQL, sb.toString()).evaluate();
        TupleQueryResult expected = this.readExpectedTupleQueryResult("file:src/test/java/com/bigdata/rdf/sail/tck/data/test_deleteFromSolutions_02.srx");
        this.compareTupleQueryResults(ret, expected);
    }

    public void test_deleteFromSolutions_03() throws Exception {
        if (!this.isSolutionSetUpdateEnabled()) {
            return;
        }
        this.loadDataset("file:src/test/java/com/bigdata/rdf/sail/tck/data/dataset-01.trig");
        StringBuilder sb = new StringBuilder();
        sb.append("PREFIX rdf:  <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n");
        sb.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n");
        sb.append("PREFIX foaf: <http://xmlns.com/foaf/0.1/>\n");
        sb.append("INSERT INTO %namedSet1\n");
        sb.append("SELECT ?x ?name\n");
        sb.append("WHERE {\n");
        sb.append("  ?x rdf:type foaf:Person .\n");
        sb.append("  ?x rdfs:label ?name .\n");
        sb.append("}\n");
        this.con.prepareUpdate(QueryLanguage.SPARQL, sb.toString()).execute();
        sb = new StringBuilder();
        sb.append("PREFIX rdf:  <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n");
        sb.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n");
        sb.append("PREFIX foaf: <http://xmlns.com/foaf/0.1/>\n");
        sb.append("DELETE FROM %namedSet1\n");
        sb.append("SELECT ?x ?name\n");
        sb.append("WHERE { \n");
        sb.append("  ?x rdfs:label ?name .\n");
        sb.append("  FILTER (?x = <http://www.bigdata.com/Bryan> ) .\n");
        sb.append("}\n");
        this.con.prepareUpdate(QueryLanguage.SPARQL, sb.toString()).execute();
        sb = new StringBuilder();
        sb.append("PREFIX rdf:  <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n");
        sb.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n");
        sb.append("PREFIX foaf: <http://xmlns.com/foaf/0.1/>\n");
        sb.append("SELECT ?x ?name\n");
        sb.append("WHERE {\n");
        sb.append("  INCLUDE %namedSet1 .\n");
        sb.append("}\n");
        TupleQueryResult ret = this.con.prepareTupleQuery(QueryLanguage.SPARQL, sb.toString()).evaluate();
        TupleQueryResult expected = this.readExpectedTupleQueryResult("file:src/test/java/com/bigdata/rdf/sail/tck/data/test_deleteFromSolutions_03.srx");
        this.compareTupleQueryResults(ret, expected);
    }

    public void test_deleteInsertSolutions_01() throws Exception {
        if (!this.isSolutionSetUpdateEnabled()) {
            return;
        }
        this.loadDataset("file:src/test/java/com/bigdata/rdf/sail/tck/data/dataset-01.trig");
        StringBuilder sb = new StringBuilder();
        sb.append("PREFIX rdf:  <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n");
        sb.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n");
        sb.append("PREFIX foaf: <http://xmlns.com/foaf/0.1/>\n");
        sb.append("INSERT INTO %namedSet1\n");
        sb.append("SELECT ?x ?name\n");
        sb.append("WHERE {\n");
        sb.append("  ?x rdf:type foaf:Person .\n");
        sb.append("  ?x rdfs:label ?name .\n");
        sb.append("}\n");
        this.con.prepareUpdate(QueryLanguage.SPARQL, sb.toString()).execute();
        sb = new StringBuilder();
        sb.append("PREFIX rdf:  <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n");
        sb.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n");
        sb.append("PREFIX foaf: <http://xmlns.com/foaf/0.1/>\n");
        sb.append("DELETE FROM %namedSet1\n");
        sb.append("  SELECT ?x ?name\n");
        sb.append("INSERT INTO %namedSet2\n");
        sb.append("  SELECT ?x ?name\n");
        sb.append("WHERE { \n");
        sb.append("  ?x rdfs:label ?name .\n");
        sb.append("  FILTER (?x = <http://www.bigdata.com/Bryan> ) .\n");
        sb.append("}\n");
        this.con.prepareUpdate(QueryLanguage.SPARQL, sb.toString()).execute();
        sb = new StringBuilder();
        sb.append("PREFIX rdf:  <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n");
        sb.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n");
        sb.append("PREFIX foaf: <http://xmlns.com/foaf/0.1/>\n");
        sb.append("SELECT ?x ?name\n");
        sb.append("WHERE {\n");
        sb.append("  INCLUDE %namedSet1 .\n");
        sb.append("}\n");
        TupleQueryResult ret = this.con.prepareTupleQuery(QueryLanguage.SPARQL, sb.toString()).evaluate();
        TupleQueryResult expected = this.readExpectedTupleQueryResult("file:src/test/java/com/bigdata/rdf/sail/tck/data/test_deleteInsertSolutions_01a.srx");
        this.compareTupleQueryResults(ret, expected);
        sb = new StringBuilder();
        sb.append("PREFIX rdf:  <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n");
        sb.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n");
        sb.append("PREFIX foaf: <http://xmlns.com/foaf/0.1/>\n");
        sb.append("SELECT ?x ?name\n");
        sb.append("WHERE {\n");
        sb.append("  INCLUDE %namedSet2 .\n");
        sb.append("}\n");
        ret = this.con.prepareTupleQuery(QueryLanguage.SPARQL, sb.toString()).evaluate();
        expected = this.readExpectedTupleQueryResult("file:src/test/java/com/bigdata/rdf/sail/tck/data/test_deleteInsertSolutions_01b.srx");
        this.compareTupleQueryResults(ret, expected);
    }

    public void test_createSolutionSet_01() throws UpdateExecutionException, RepositoryException, MalformedQueryException {
        block3: {
            if (!this.isSolutionSetUpdateEnabled()) {
                return;
            }
            try {
                this.con.prepareUpdate(QueryLanguage.SPARQL, "drop solutions %namedSet1").execute();
                BigdataSPARQLUpdateTest2.fail((String)("Excepting: " + UpdateExecutionException.class));
            }
            catch (UpdateExecutionException ex) {
                if (!log.isInfoEnabled()) break block3;
                log.info((Object)("Ignoring expected exception: " + (Object)((Object)ex)));
            }
        }
        this.con.prepareUpdate(QueryLanguage.SPARQL, "create solutions %namedSet1").execute();
        this.con.prepareUpdate(QueryLanguage.SPARQL, "drop solutions %namedSet1").execute();
    }

    public void test_createSolutionSet_02() throws UpdateExecutionException, RepositoryException, MalformedQueryException {
        block3: {
            if (!this.isSolutionSetUpdateEnabled()) {
                return;
            }
            this.con.prepareUpdate(QueryLanguage.SPARQL, "create solutions %namedSet1").execute();
            try {
                this.con.prepareUpdate(QueryLanguage.SPARQL, "create solutions %namedSet1").execute();
                BigdataSPARQLUpdateTest2.fail((String)("Excepting: " + UpdateExecutionException.class));
            }
            catch (UpdateExecutionException ex) {
                if (!log.isInfoEnabled()) break block3;
                log.info((Object)("Ignoring expected exception: " + (Object)((Object)ex)));
            }
        }
        this.con.prepareUpdate(QueryLanguage.SPARQL, "create silent solutions %namedSet1").execute();
    }

    public void test_dropSolutionSet_01() throws UpdateExecutionException, RepositoryException, MalformedQueryException {
        block3: {
            if (!this.isSolutionSetUpdateEnabled()) {
                return;
            }
            try {
                this.con.prepareUpdate(QueryLanguage.SPARQL, "drop solutions %namedSet1").execute();
                BigdataSPARQLUpdateTest2.fail((String)("Excepting: " + UpdateExecutionException.class));
            }
            catch (UpdateExecutionException ex) {
                if (!log.isInfoEnabled()) break block3;
                log.info((Object)("Ignoring expected exception: " + (Object)((Object)ex)));
            }
        }
    }

    public void test_dropSolutionSet_02() throws UpdateExecutionException, RepositoryException, MalformedQueryException {
        if (!this.isSolutionSetUpdateEnabled()) {
            return;
        }
        this.con.prepareUpdate(QueryLanguage.SPARQL, "drop silent solutions %namedSet1").execute();
    }

    public void test_clearSolutionSet_01() throws UpdateExecutionException, RepositoryException, MalformedQueryException {
        block3: {
            if (!this.isSolutionSetUpdateEnabled()) {
                return;
            }
            try {
                this.con.prepareUpdate(QueryLanguage.SPARQL, "clear solutions %namedSet1").execute();
                BigdataSPARQLUpdateTest2.fail((String)("Excepting: " + UpdateExecutionException.class));
            }
            catch (UpdateExecutionException ex) {
                if (!log.isInfoEnabled()) break block3;
                log.info((Object)("Ignoring expected exception: " + (Object)((Object)ex)));
            }
        }
    }

    public void test_clearSolutionSet_02() throws UpdateExecutionException, RepositoryException, MalformedQueryException {
        if (!this.isSolutionSetUpdateEnabled()) {
            return;
        }
        this.con.prepareUpdate(QueryLanguage.SPARQL, "clear silent solutions %namedSet1").execute();
    }
}

