/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.tck;

import com.bigdata.BigdataStatics;
import com.bigdata.btree.keys.CollatorEnum;
import com.bigdata.btree.keys.StrengthEnum;
import com.bigdata.journal.BufferMode;
import com.bigdata.journal.IIndexManager;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepository;
import com.bigdata.rdf.sail.BigdataSailRepositoryConnection;
import com.bigdata.rdf.sail.BigdataSailTupleQuery;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import info.aduna.io.IOUtil;
import info.aduna.iteration.Iteration;
import info.aduna.iteration.Iterations;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.util.ModelUtil;
import org.openrdf.query.BindingSet;
import org.openrdf.query.BooleanQuery;
import org.openrdf.query.Dataset;
import org.openrdf.query.GraphQuery;
import org.openrdf.query.GraphQueryResult;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.QueryResults;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.impl.MutableTupleQueryResult;
import org.openrdf.query.parser.sparql.manifest.ManifestTest;
import org.openrdf.query.parser.sparql.manifest.SPARQL11ManifestTest;
import org.openrdf.query.parser.sparql.manifest.SPARQLQueryTest;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.sail.SailQuery;
import org.openrdf.rio.helpers.BasicParserSettings;

public class BigdataSparqlTest
extends SPARQLQueryTest {
    protected static final Collection<String> cannotInlineTests = Arrays.asList("http://www.w3.org/2001/sw/DataAccess/tests/data-r2/open-world/manifest#open-eq-01", "http://www.w3.org/2001/sw/DataAccess/tests/data-r2/open-world/manifest#open-eq-03", "http://www.w3.org/2001/sw/DataAccess/tests/data-r2/open-world/manifest#open-eq-04", "http://www.w3.org/2001/sw/DataAccess/tests/data-r2/expr-builtin/manifest#dawg-str-1", "http://www.w3.org/2001/sw/DataAccess/tests/data-r2/expr-builtin/manifest#dawg-str-2", "http://www.w3.org/2001/sw/DataAccess/tests/data-r2/expr-builtin/manifest#dawg-datatype-1", "http://www.w3.org/2001/sw/DataAccess/tests/data-r2/expr-builtin/manifest#sameTerm-simple", "http://www.w3.org/2001/sw/DataAccess/tests/data-r2/expr-builtin/manifest#sameTerm-eq", "http://www.w3.org/2001/sw/DataAccess/tests/data-r2/expr-builtin/manifest#sameTerm-not-eq", "http://www.w3.org/2001/sw/DataAccess/tests/data-r2/expr-equals/manifest#eq-graph-1", "http://www.w3.org/2001/sw/DataAccess/tests/data-r2/expr-equals/manifest#eq-graph-2", "http://www.w3.org/2001/sw/DataAccess/tests/data-r2/distinct/manifest#no-distinct-1", "http://www.w3.org/2001/sw/DataAccess/tests/data-r2/distinct/manifest#distinct-1", "http://www.w3.org/2001/sw/DataAccess/tests/data-r2/distinct/manifest#no-distinct-9", "http://www.w3.org/2001/sw/DataAccess/tests/data-r2/distinct/manifest#distinct-9", "http://www.w3.org/2001/sw/DataAccess/tests/data-r2/open-world/manifest#date-2", "http://www.w3.org/2001/sw/DataAccess/tests/data-r2/open-world/manifest#date-3", "http://www.w3.org/2001/sw/DataAccess/tests/data-r2/open-world/manifest#date-4", "http://www.w3.org/2001/sw/DataAccess/tests/data-r2/syntax-sparql1/manifest#sparql11-exists-05", "http://www.w3.org/2001/sw/DataAccess/tests/data-r2/syntax-sparql1/manifest#sparql11-exists-06", "http://www.w3.org/2009/sparql/docs/tests/data-sparql11/functions/manifest#hours", "http://www.w3.org/2009/sparql/docs/tests/data-sparql11/functions/manifest#timezone", "http://www.w3.org/2009/sparql/docs/tests/data-sparql11/functions/manifest#tz");
    public static final Collection<String> badTests = Arrays.asList("http://www.w3.org/2001/sw/DataAccess/tests/data-r2/syntax-sparql1/manifest#sparql11-sequence-04", "http://www.w3.org/2001/sw/DataAccess/tests/data-r2/syntax-sparql1/manifest#sparql11-sequence-05", "http://www.w3.org/2001/sw/DataAccess/tests/data-r2/syntax-sparql1/manifest#sparql11-sequence-06", "http://www.w3.org/2009/sparql/docs/tests/data-sparql11/property-path/manifest#pp35", "http://www.w3.org/2009/sparql/docs/tests/data-sparql11/exists/manifest#exists03", "http://www.w3.org/2009/sparql/docs/tests/data-sparql11/functions/manifest#bnode01");
    public static final Collection<String> knownBadTests = Arrays.asList("http://www.w3.org/2001/sw/DataAccess/tests/data-r2/syntax-sparql1/manifest#sparql11-wildcard-cycles-04", "http://www.w3.org/2001/sw/DataAccess/tests/data-r2/syntax-sparql1/manifest#sparql11-sum-02", "http://www.w3.org/2009/sparql/docs/tests/data-sparql11/aggregates/manifest#agg-empty-group2", "http://www.w3.org/2009/sparql/docs/tests/data-sparql11/bindings/manifest#values7", "http://www.w3.org/2009/sparql/docs/tests/data-sparql11/construct/manifest#constructwhere04", "http://www.w3.org/2009/sparql/docs/tests/data-sparql11/grouping/manifest#group03", "http://www.w3.org/2009/sparql/docs/tests/data-sparql11/grouping/manifest#group05", "http://www.w3.org/2009/sparql/docs/tests/data-sparql11/negation/manifest#partial-minuend", "http://www.w3.org/2009/sparql/docs/tests/data-sparql11/negation/manifest#full-minuend", "http://www.w3.org/2009/sparql/docs/tests/data-sparql11/property-path/manifest#pp16", "http://www.w3.org/2009/sparql/docs/tests/data-sparql11/subquery/manifest#subquery03");
    protected static final Collection<String> unicodeStrengthIdentical = Arrays.asList("http://www.w3.org/2001/sw/DataAccess/tests/data-r2/i18n/manifest#normalization-1");
    protected static final Collection<String> testURIs = Arrays.asList(new String[0]);
    private String queryString = null;

    public static Test suite() throws Exception {
        return BigdataSparqlTest.suite(true);
    }

    public static Test suite(boolean hideDatasetTests) throws Exception {
        TestSuite suite1 = BigdataSparqlTest.suiteLTSWithPipelineJoins();
        if (!testURIs.isEmpty()) {
            TestSuite suite = new TestSuite();
            for (String s : testURIs) {
                SPARQLQueryTest test = BigdataSparqlTest.getSingleTest(suite1, s);
                if (test == null) {
                    throw new RuntimeException("Could not find test: uri=" + s);
                }
                suite.addTest((Test)test);
            }
            return suite;
        }
        if (hideDatasetTests) {
            suite1 = BigdataSparqlTest.filterOutTests(suite1, "dataset");
        }
        suite1 = BigdataSparqlTest.filterOutTests(suite1, badTests);
        if (!BigdataStatics.runKnownBadTests) {
            suite1 = BigdataSparqlTest.filterOutTests(suite1, knownBadTests);
        }
        suite1 = BigdataSparqlTest.filterOutTests(suite1, "bsbm");
        return suite1;
    }

    protected static TestSuite filterOutTests(TestSuite suite1, String name) {
        TestSuite suite2 = new TestSuite(suite1.getName());
        Enumeration e = suite1.tests();
        while (e.hasMoreElements()) {
            Test aTest = (Test)e.nextElement();
            if (aTest instanceof TestSuite) {
                TestSuite aTestSuite = (TestSuite)aTest;
                if (aTestSuite.getName().equals(name)) continue;
                suite2.addTest((Test)BigdataSparqlTest.filterOutTests(aTestSuite, name));
                continue;
            }
            suite2.addTest(aTest);
        }
        return suite2;
    }

    protected static TestSuite filterOutTests(TestSuite suite1, Collection<String> testURIs) {
        TestSuite suite2 = new TestSuite(suite1.getName());
        Enumeration e = suite1.tests();
        while (e.hasMoreElements()) {
            Test aTest = (Test)e.nextElement();
            if (aTest instanceof TestSuite) {
                TestSuite aTestSuite = (TestSuite)aTest;
                suite2.addTest((Test)BigdataSparqlTest.filterOutTests(aTestSuite, testURIs));
                continue;
            }
            if (!(aTest instanceof BigdataSparqlTest)) continue;
            BigdataSparqlTest test = (BigdataSparqlTest)aTest;
            if (testURIs.contains(test.testURI)) continue;
            suite2.addTest((Test)test);
        }
        return suite2;
    }

    protected static SPARQLQueryTest getSingleTest(TestSuite suite, String testURI) throws RuntimeException {
        Enumeration e1 = suite.tests();
        while (e1.hasMoreElements()) {
            SPARQLQueryTest test;
            Test aTest = (Test)e1.nextElement();
            if (aTest instanceof TestSuite && (test = BigdataSparqlTest.getSingleTest((TestSuite)aTest, testURI)) != null) {
                return test;
            }
            if (!(aTest instanceof BigdataSparqlTest)) continue;
            test = (BigdataSparqlTest)aTest;
            if (!testURI.equals(((BigdataSparqlTest)test).testURI)) continue;
            return test;
        }
        return null;
    }

    public static TestSuite suiteLTSWithPipelineJoins() throws Exception {
        SPARQLQueryTest.Factory factory = new SPARQLQueryTest.Factory(){

            @Override
            public SPARQLQueryTest createSPARQLQueryTest(String testURI, String name, String queryFileURL, String resultFileURL, Dataset dataSet, boolean laxCardinality) {
                return this.createSPARQLQueryTest(testURI, name, queryFileURL, resultFileURL, dataSet, laxCardinality, true);
            }

            @Override
            public SPARQLQueryTest createSPARQLQueryTest(String testURI, String name, String queryFileURL, String resultFileURL, Dataset dataSet, boolean laxCardinality, boolean checkOrder) {
                return new BigdataSparqlTest(testURI, name, queryFileURL, resultFileURL, dataSet, laxCardinality, checkOrder){

                    @Override
                    protected Properties getProperties() {
                        Properties p = new Properties(super.getProperties());
                        return p;
                    }
                };
            }
        };
        TestSuite suite = new TestSuite();
        suite.addTest((Test)ManifestTest.suite((SPARQLQueryTest.Factory)factory));
        suite.addTest((Test)SPARQL11ManifestTest.suite(factory, false, false, false, new String[0]));
        suite.addTest((Test)SPARQL11ManifestTest.suite(factory, true, false, false, "service"));
        return suite;
    }

    public BigdataSparqlTest(String testURI, String name, String queryFileURL, String resultFileURL, Dataset dataSet, boolean laxCardinality, boolean checkOrder) {
        super(testURI, name, queryFileURL, resultFileURL, dataSet, laxCardinality, checkOrder);
    }

    @Override
    public void tearDown() throws Exception {
        Repository delegate;
        IIndexManager backend = null;
        Repository repository = delegate = this.dataRep == null ? null : this.dataRep;
        if (delegate != null && delegate instanceof BigdataSailRepository) {
            backend = ((BigdataSailRepository)delegate).getSail().getIndexManager();
        }
        super.tearDown();
        if (backend != null) {
            this.tearDownBackend(backend);
        }
        this.dataRep = null;
        this.queryString = null;
    }

    protected Properties getProperties() {
        Properties props = new Properties();
        props.setProperty(BigdataSail.Options.BUFFER_MODE, BufferMode.Transient.toString());
        props.setProperty(BigdataSail.Options.QUADS_MODE, "true");
        props.setProperty(BigdataSail.Options.JUSTIFY, "false");
        props.setProperty(BigdataSail.Options.QUERY_TIME_EXPANDER, "false");
        props.setProperty(BigdataSail.Options.EXACT_SIZE, "true");
        props.setProperty(BigdataSail.Options.ISOLATABLE_INDICES, "false");
        props.setProperty(BigdataSail.Options.TRUTH_MAINTENANCE, "false");
        return props;
    }

    @Override
    protected Repository newRepository() throws RepositoryException {
        Properties props = this.getProperties();
        if (cannotInlineTests.contains(this.testURI)) {
            props.setProperty(BigdataSail.Options.INLINE_XSD_DATATYPE_LITERALS, "false");
            props.setProperty(BigdataSail.Options.INLINE_DATE_TIMES, "false");
        }
        if (unicodeStrengthIdentical.contains(this.testURI)) {
            props.setProperty(BigdataSail.Options.COLLATOR, CollatorEnum.JDK.toString());
            props.setProperty(BigdataSail.Options.STRENGTH, StrengthEnum.Identical.toString());
        }
        BigdataSail sail = new BigdataSail(props);
        return new BigdataSailRepository(sail);
    }

    protected void tearDownBackend(IIndexManager backend) {
        backend.destroy();
    }

    @Override
    protected Repository createRepository() throws Exception {
        Repository repo = this.newRepository();
        repo.initialize();
        return repo;
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    public Repository getRepository() {
        return this.dataRep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getQueryString() throws Exception {
        if (this.queryString == null) {
            try (InputStream stream = new URL(this.queryFileURL).openStream();){
                String string = IOUtil.readString((Reader)new InputStreamReader(stream, "UTF-8"));
                return string;
            }
        }
        return this.queryString;
    }

    protected String readInputData(Dataset dataset) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (dataset != null) {
            HashSet graphURIs = new HashSet();
            graphURIs.addAll(dataset.getDefaultGraphs());
            graphURIs.addAll(dataset.getNamedGraphs());
            for (Resource graphURI : graphURIs) {
                URL graphURL = new URL(graphURI.toString());
                InputStream in = graphURL.openStream();
                sb.append(IOUtil.readString((InputStream)in));
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runTest() throws Exception {
        block8: {
            BigdataSailRepositoryConnection con = this.getQueryConnection(this.dataRep);
            con.getParserConfig().set(BasicParserSettings.VERIFY_DATATYPE_VALUES, (Object)Boolean.FALSE);
            con.getParserConfig().set(BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES, (Object)Boolean.FALSE);
            try {
                String name;
                String queryString = this.readQueryString();
                SailQuery query = con.prepareQuery(QueryLanguage.SPARQL, queryString, this.queryFileURL);
                if (this.dataset != null) {
                    query.setDataset(this.dataset);
                }
                if ((name = this.getName()).contains("pp34")) {
                    System.out.println(name);
                }
                if (query instanceof TupleQuery) {
                    TupleQueryResult queryResult = ((TupleQuery)query).evaluate();
                    TupleQueryResult expectedResult = this.readExpectedTupleQueryResult();
                    this.compareTupleQueryResults(queryResult, expectedResult, con);
                    break block8;
                }
                if (query instanceof GraphQuery) {
                    GraphQueryResult gqr = ((GraphQuery)query).evaluate();
                    Set queryResult = Iterations.asSet((Iteration)gqr);
                    Set<Statement> expectedResult = this.readExpectedGraphQueryResult();
                    this.compareGraphs(queryResult, expectedResult);
                    break block8;
                }
                if (query instanceof BooleanQuery) {
                    boolean queryResult = ((BooleanQuery)query).evaluate();
                    boolean expectedResult = this.readExpectedBooleanQueryResult();
                    BigdataSparqlTest.assertEquals((boolean)expectedResult, (boolean)queryResult);
                    break block8;
                }
                throw new RuntimeException("Unexpected query type: " + query.getClass());
            }
            finally {
                con.close();
            }
        }
    }

    protected BigdataSailRepositoryConnection getQueryConnection(Repository dataRep) throws Exception {
        return ((BigdataSailRepository)dataRep).getReadOnlyConnection();
    }

    @Override
    protected void uploadDataset(Dataset dataset) throws Exception {
        HashSet graphURIs = new HashSet();
        graphURIs.addAll(dataset.getDefaultGraphs());
        graphURIs.addAll(dataset.getNamedGraphs());
        for (Resource graphURI : graphURIs) {
            this.upload((URI)graphURI, graphURI);
        }
    }

    protected final void compareTupleQueryResults(TupleQueryResult queryResult, TupleQueryResult expectedResult, BigdataSailRepositoryConnection cxn) throws Exception {
        boolean resultsEqual;
        MutableTupleQueryResult queryResultTable = new MutableTupleQueryResult(queryResult);
        MutableTupleQueryResult expectedResultTable = new MutableTupleQueryResult(expectedResult);
        if (this.laxCardinality) {
            resultsEqual = QueryResults.isSubset((TupleQueryResult)queryResultTable, (TupleQueryResult)expectedResultTable);
        } else {
            resultsEqual = QueryResults.equals((TupleQueryResult)queryResultTable, (TupleQueryResult)expectedResultTable);
            if (this.checkOrder) {
                queryResultTable.beforeFirst();
                expectedResultTable.beforeFirst();
                while (queryResultTable.hasNext()) {
                    BindingSet expectedBs;
                    BindingSet bs = queryResultTable.next();
                    if (bs.equals((Object)(expectedBs = expectedResultTable.next()))) continue;
                    resultsEqual = false;
                    break;
                }
            }
        }
        if (!resultsEqual) {
            queryResultTable.beforeFirst();
            expectedResultTable.beforeFirst();
            List queryBindings = Iterations.asList((Iteration)queryResultTable);
            List expectedBindings = Iterations.asList((Iteration)expectedResultTable);
            ArrayList missingBindings = new ArrayList(expectedBindings);
            missingBindings.removeAll(queryBindings);
            ArrayList unexpectedBindings = new ArrayList(queryBindings);
            unexpectedBindings.removeAll(expectedBindings);
            StringBuilder message = new StringBuilder(128);
            message.append("\n=========================================\n");
            message.append(this.getName());
            message.append("\n");
            message.append(this.testURI);
            message.append("\n=========================================\n");
            message.append("Expected results: \n");
            for (BindingSet bs : expectedBindings) {
                this.printBindingSet(message, bs);
                message.append("\n");
            }
            message.append("=========================================\n");
            message.append("Bigdata results: \n");
            for (BindingSet bs : queryBindings) {
                this.printBindingSet(message, bs);
                message.append("\n");
            }
            message.append("=========================================\n");
            if (!missingBindings.isEmpty()) {
                message.append("Missing results: \n");
                for (BindingSet bs : missingBindings) {
                    this.printBindingSet(message, bs);
                    message.append("\n");
                }
                message.append("=========================================\n");
            }
            if (!unexpectedBindings.isEmpty()) {
                message.append("Extra results: \n");
                for (BindingSet bs : unexpectedBindings) {
                    this.printBindingSet(message, bs);
                    message.append("\n");
                }
                message.append("=========================================\n");
            }
            if (this.checkOrder && missingBindings.isEmpty() && unexpectedBindings.isEmpty()) {
                message.append("Results are not in expected order.\n");
                message.append(" =======================\n");
                message.append("query result: \n");
                for (BindingSet bs : queryBindings) {
                    this.printBindingSet(message, bs);
                    message.append("\n");
                }
                message.append(" =======================\n");
                message.append("expected result: \n");
                for (BindingSet bs : expectedBindings) {
                    this.printBindingSet(message, bs);
                    message.append("\n");
                }
                message.append(" =======================\n");
                System.out.print(message.toString());
            } else if (missingBindings.isEmpty() && unexpectedBindings.isEmpty()) {
                message.append("unexpected duplicate in result.\n");
                message.append(" =======================\n");
                message.append("query result: \n");
                for (BindingSet bs : queryBindings) {
                    this.printBindingSet(message, bs);
                    message.append("\n");
                }
                message.append(" =======================\n");
                message.append("expected result: \n");
                for (BindingSet bs : expectedBindings) {
                    this.printBindingSet(message, bs);
                    message.append("\n");
                }
                message.append(" =======================\n");
                System.out.print(message.toString());
            }
            String queryStr = this.readQueryString();
            message.append("Query:\n" + queryStr);
            message.append("\n=========================================\n");
            message.append("Data:\n" + this.readInputData(this.dataset));
            message.append("\n=========================================\n");
            BigdataSailTupleQuery query = (BigdataSailTupleQuery)cxn.prepareTupleQuery(QueryLanguage.SPARQL, queryStr);
            QueryRoot original = query.getASTContainer().getOriginalAST();
            message.append("Original AST:\n" + original);
            message.append("\n=========================================\n");
            QueryRoot optimized = query.optimize();
            message.append("Optimized AST:\n" + optimized);
            message.append("\n=========================================\n");
            this.logger.error(message.toString());
            BigdataSparqlTest.fail((String)message.toString());
        }
    }

    private void printBindingSet(StringBuilder message, BindingSet bs) {
        for (String bn : bs.getBindingNames()) {
            Value v = bs.getBinding(bn).getValue();
            message.append(bn).append('=').append(v);
            if (!(v instanceof BigdataValue)) continue;
            message.append(' ').append(((BigdataValue)v).getIV()).append(' ');
        }
    }

    @Override
    protected final void compareGraphs(Set<Statement> queryResult, Set<Statement> expectedResult) throws Exception {
        if (!ModelUtil.equals(expectedResult, queryResult)) {
            StringBuilder message = new StringBuilder(128);
            message.append("\n=========================================\n");
            message.append(this.getName());
            message.append("\n");
            message.append(this.testURI);
            message.append("\n=========================================\n");
            message.append("Expected results: \n");
            for (Statement bs : expectedResult) {
                message.append(bs);
                message.append("\n");
            }
            message.append("=========================================\n");
            message.append("Bigdata results: \n");
            for (Statement bs : queryResult) {
                message.append(bs);
                message.append("\n");
            }
            message.append("=========================================\n");
            String queryStr = this.readQueryString();
            message.append("Query:\n" + queryStr);
            message.append("\n=========================================\n");
            message.append("Data:\n" + this.readInputData(this.dataset));
            message.append("\n=========================================\n");
            this.logger.error(message.toString());
            BigdataSparqlTest.fail((String)message.toString());
        }
    }
}

