/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.tck;

import com.bigdata.btree.keys.CollatorEnum;
import com.bigdata.btree.keys.StrengthEnum;
import com.bigdata.journal.BufferMode;
import com.bigdata.journal.IIndexManager;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.sparql.Bigdata2ASTSPARQLParser;
import com.bigdata.rdf.sparql.ast.ASTContainer;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.eval.ASTEvalHelper;
import com.bigdata.rdf.store.AbstractTripleStore;
import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.Iteration;
import info.aduna.iteration.Iterations;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.algebra.evaluation.QueryBindingSet;
import org.openrdf.query.impl.EmptyBindingSet;
import org.openrdf.query.impl.MapBindingSet;
import org.openrdf.sail.RDFStoreTest;
import org.openrdf.sail.Sail;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;

public class BigdataStoreTest
extends RDFStoreTest {
    private static final Logger log = Logger.getLogger(BigdataStoreTest.class);

    static File createTempFile() {
        try {
            return File.createTempFile("bigdata-tck", ".jnl");
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void tearDown() throws Exception {
        IIndexManager backend = this.sail == null ? null : ((BigdataSail)this.sail).getIndexManager();
        super.tearDown();
        if (backend != null) {
            backend.destroy();
        }
    }

    protected Properties getProperties() {
        Properties props = new Properties();
        File journal = BigdataStoreTest.createTempFile();
        props.setProperty(BigdataSail.Options.FILE, journal.getAbsolutePath());
        props.setProperty(BigdataSail.Options.BUFFER_MODE, BufferMode.DiskWORM.toString());
        props.setProperty(BigdataSail.Options.STORE_BLANK_NODES, "true");
        props.setProperty(BigdataSail.Options.QUADS_MODE, "true");
        props.setProperty(BigdataSail.Options.JUSTIFY, "false");
        props.setProperty(BigdataSail.Options.QUERY_TIME_EXPANDER, "false");
        props.setProperty(BigdataSail.Options.ALLOW_AUTO_COMMIT, "true");
        props.setProperty(BigdataSail.Options.EXACT_SIZE, "true");
        props.setProperty(BigdataSail.Options.COLLATOR, CollatorEnum.ASCII.toString());
        props.setProperty(BigdataSail.Options.STRENGTH, StrengthEnum.Identical.toString());
        props.setProperty(BigdataSail.Options.ISOLATABLE_INDICES, "true");
        props.setProperty(BigdataSail.Options.TRUTH_MAINTENANCE, "false");
        props.setProperty(BigdataSail.Options.INLINE_DATE_TIMES, "false");
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Sail createSail() throws SailException {
        BigdataSail sail = new BigdataSail(this.getProperties());
        sail.initialize();
        try (SailConnection conn = sail.getConnection();){
            conn.clear(new Resource[0]);
            conn.clearNamespaces();
            conn.commit();
        }
        return sail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testDualConnections() throws Exception {
        log.warn((Object)"Test overridden since bigdata uses full snapshot tx isolation.");
        try (SailConnection con2 = this.sail.getConnection();){
            BigdataStoreTest.assertEquals((int)0, (int)this.countAllElements());
            this.con.addStatement((Resource)this.painter, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
            this.con.addStatement((Resource)this.painting, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
            this.con.addStatement((Resource)this.picasso, RDF.TYPE, (Value)this.painter, new Resource[]{this.context1});
            this.con.addStatement((Resource)this.guernica, RDF.TYPE, (Value)this.painting, new Resource[]{this.context1});
            this.con.commit();
            BigdataStoreTest.assertEquals((int)4, (int)this.countAllElements());
            con2.addStatement((Resource)RDF.NIL, RDF.TYPE, (Value)RDF.LIST, new Resource[0]);
            String query = "SELECT ?S ?P ?O WHERE { ?S ?P ?O }";
            CloseableIteration<? extends BindingSet, QueryEvaluationException> queryResult = this.evaluate(query, con2);
            boolean nexpected = true;
            BigdataStoreTest.assertEquals((int)1, (int)this.countElements((Iteration<?, ?>)queryResult));
            Runnable clearer = new Runnable(){

                @Override
                public void run() {
                    try {
                        BigdataStoreTest.this.con.clear(new Resource[0]);
                        BigdataStoreTest.this.con.commit();
                    }
                    catch (SailException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
            Thread thread = new Thread(clearer);
            thread.start();
            Thread.yield();
            Thread.yield();
            con2.commit();
            thread.join();
        }
    }

    private CloseableIteration<? extends BindingSet, QueryEvaluationException> evaluate(String query, SailConnection con) throws Exception {
        return this.evaluate(query, con, EmptyBindingSet.getInstance());
    }

    private CloseableIteration<? extends BindingSet, QueryEvaluationException> evaluate(String query, SailConnection con, BindingSet bs) throws Exception {
        ((BigdataSail.BigdataSailConnection)con).flush();
        AbstractTripleStore db = ((BigdataSail.BigdataSailConnection)con).getTripleStore();
        ASTContainer astContainer = new Bigdata2ASTSPARQLParser().parseQuery2(query, null);
        QueryRoot originalQuery = astContainer.getOriginalAST();
        originalQuery.setIncludeInferred(false);
        TupleQueryResult queryResult = ASTEvalHelper.evaluateTupleQuery((AbstractTripleStore)db, (ASTContainer)astContainer, (QueryBindingSet)new QueryBindingSet(bs), null);
        return queryResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int countElements(Iteration<?, ?> iter) throws Exception {
        int count = 0;
        try {
            while (iter.hasNext()) {
                iter.next();
                ++count;
            }
        }
        finally {
            Iterations.closeCloseable(iter);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void testValueRoundTrip(Resource subj, URI pred, Value obj) throws Exception {
        this.con.begin();
        this.con.addStatement(subj, pred, obj, new Resource[0]);
        this.con.commit();
        try (CloseableIteration stIter = this.con.getStatements(null, null, null, false, new Resource[0]);){
            BigdataStoreTest.assertTrue((boolean)stIter.hasNext());
            Statement st = (Statement)stIter.next();
            BigdataStoreTest.assertEquals((Object)subj, (Object)st.getSubject());
            BigdataStoreTest.assertEquals((Object)pred, (Object)st.getPredicate());
            BigdataStoreTest.assertEquals((Object)obj, (Object)st.getObject());
            BigdataStoreTest.assertTrue((!stIter.hasNext() ? 1 : 0) != 0);
        }
        String query = "SELECT ?S ?P ?O WHERE { ?S ?P ?O filter(?P = <" + pred.stringValue() + ">) }";
        try (CloseableIteration<? extends BindingSet, QueryEvaluationException> iter = this.evaluate(query, this.con);){
            BigdataStoreTest.assertTrue((boolean)iter.hasNext());
            BindingSet bindings = (BindingSet)iter.next();
            BigdataStoreTest.assertEquals((Object)subj, (Object)bindings.getValue("S"));
            BigdataStoreTest.assertEquals((Object)pred, (Object)bindings.getValue("P"));
            BigdataStoreTest.assertEquals((Object)obj, (Object)bindings.getValue("O"));
            BigdataStoreTest.assertTrue((!iter.hasNext() ? 1 : 0) != 0);
        }
    }

    @Override
    public void testEmptyRepository() throws Exception {
        BigdataStoreTest.assertEquals((String)"Empty repository should not return any statements", (int)0, (int)this.countAllElements());
        BigdataStoreTest.assertEquals((String)"Named context should be empty", (int)0, (int)this.countContext1Elements());
        BigdataStoreTest.assertEquals((String)"Empty repository should not return any context identifiers", (int)0, (int)this.countElements((Iteration<?, ?>)this.con.getContextIDs()));
        BigdataStoreTest.assertEquals((String)"Empty repository should not return any query results", (int)0, (int)this.countQueryResults("select * where { ?S ?P ?O }"));
    }

    @Override
    public void testAddData() throws Exception {
        this.con.addStatement((Resource)this.painter, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        this.con.addStatement((Resource)this.painting, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        this.con.addStatement((Resource)this.picasso, RDF.TYPE, (Value)this.painter, new Resource[]{this.context1});
        this.con.addStatement((Resource)this.guernica, RDF.TYPE, (Value)this.painting, new Resource[]{this.context1});
        this.con.addStatement((Resource)this.picasso, this.paints, (Value)this.guernica, new Resource[]{this.context1});
        this.con.commit();
        BigdataStoreTest.assertEquals((String)"Repository should contain 5 statements in total", (int)5, (int)this.countAllElements());
        BigdataStoreTest.assertEquals((String)"Named context should contain 3 statements", (int)3, (int)this.countContext1Elements());
        BigdataStoreTest.assertEquals((String)"Repository should have 1 context identifier", (int)1, (int)this.countElements((Iteration<?, ?>)this.con.getContextIDs()));
        BigdataStoreTest.assertEquals((String)"Repository should contain 5 statements in total", (int)5, (int)this.countQueryResults("select * where { ?S ?P ?O }"));
        BigdataStoreTest.assertEquals((String)"Statement (Painter, type, Class) should be in the repository", (int)1, (int)this.countQueryResults("select * where { ex:Painter rdf:type rdfs:Class }"));
        BigdataStoreTest.assertEquals((String)"Statement (picasso, type, Painter) should be in the repository", (int)1, (int)this.countQueryResults("select * where { ex:picasso rdf:type ex:Painter}"));
        BigdataStoreTest.assertEquals((String)"Statement (Painter, paints, Painting) should not be in the repository", (int)0, (int)this.countQueryResults("select * where {ex:Painter ex:paints ex:Painting}"));
        BigdataStoreTest.assertEquals((String)"Statement (picasso, creates, guernica) should not be in the repository", (int)0, (int)this.countQueryResults("select * where {ex:picasso ex:creates ex:guernica}"));
        BigdataStoreTest.assertEquals((String)"Repository should contain 2 statements matching (picasso, _, _)", (int)2, (int)this.countQueryResults("select * where {ex:picasso ?P ?O}"));
        BigdataStoreTest.assertEquals((String)"Repository should contain 1 statement matching (picasso, paints, _)", (int)1, (int)this.countQueryResults("select * where {ex:picasso ex:paints ?O}"));
        BigdataStoreTest.assertEquals((String)"Repository should contain 4 statements matching (_, type, _)", (int)4, (int)this.countQueryResults("select * where {?S rdf:type ?O}"));
        BigdataStoreTest.assertEquals((String)"Repository should contain 2 statements matching (_, _, Class)", (int)2, (int)this.countQueryResults("select * where {?S ?P rdfs:Class}"));
        BigdataStoreTest.assertEquals((String)"Repository should contain 0 statements matching (_, _, type)", (int)0, (int)this.countQueryResults("select * where {?S ?P rdf:type}"));
    }

    @Override
    public void testAddWhileQuerying() throws Exception {
        BindingSet bindings;
        this.con.addStatement((Resource)this.painter, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        this.con.addStatement((Resource)this.painting, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        this.con.addStatement((Resource)this.picasso, RDF.TYPE, (Value)this.painter, new Resource[0]);
        this.con.addStatement((Resource)this.guernica, RDF.TYPE, (Value)this.painting, new Resource[0]);
        this.con.addStatement((Resource)this.picasso, this.paints, (Value)this.guernica, new Resource[0]);
        this.con.commit();
        CloseableIteration<? extends BindingSet, QueryEvaluationException> iter = this.evaluate("SELECT ?C where { ?s <" + RDF.TYPE + ">  ?C}", this.con);
        while (iter.hasNext()) {
            bindings = (BindingSet)iter.next();
            Value c = bindings.getValue("C");
            if (!(c instanceof Resource)) continue;
            this.con.addStatement((Resource)c, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        }
        this.con.commit();
        BigdataStoreTest.assertEquals((int)3, (int)this.countElements((Iteration<?, ?>)this.con.getStatements(null, RDF.TYPE, (Value)RDFS.CLASS, false, new Resource[0])));
        iter = this.evaluate("SELECT ?P where {?s ?P ?o}", this.con);
        while (iter.hasNext()) {
            bindings = (BindingSet)iter.next();
            Value p = bindings.getValue("P");
            if (!(p instanceof URI)) continue;
            this.con.addStatement((Resource)((URI)p), RDF.TYPE, (Value)RDF.PROPERTY, new Resource[0]);
            this.con.commit();
        }
        BigdataStoreTest.assertEquals((int)2, (int)this.countElements((Iteration<?, ?>)this.con.getStatements(null, RDF.TYPE, (Value)RDF.PROPERTY, false, new Resource[0])));
    }

    @Override
    public void testRemoveAndClear() throws Exception {
        this.con.addStatement((Resource)this.painter, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        this.con.addStatement((Resource)this.painting, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        this.con.addStatement((Resource)this.picasso, RDF.TYPE, (Value)this.painter, new Resource[]{this.context1});
        this.con.addStatement((Resource)this.guernica, RDF.TYPE, (Value)this.painting, new Resource[]{this.context1});
        this.con.addStatement((Resource)this.picasso, this.paints, (Value)this.guernica, new Resource[]{this.context1});
        this.con.commit();
        this.con.removeStatements((Resource)this.painting, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        this.con.commit();
        BigdataStoreTest.assertEquals((String)"Repository should contain 4 statements in total", (int)4, (int)this.countAllElements());
        BigdataStoreTest.assertEquals((String)"Named context should contain 3 statements", (int)3, (int)this.countContext1Elements());
        BigdataStoreTest.assertEquals((String)"Statement (Painting, type, Class) should no longer be in the repository", (int)0, (int)this.countQueryResults("select * where {ex:Painting rdf:type rdfs:Class}"));
        this.con.removeStatements(null, null, null, new Resource[]{this.context1});
        this.con.commit();
        BigdataStoreTest.assertEquals((String)"Repository should contain 1 statement in total", (int)1, (int)this.countAllElements());
        BigdataStoreTest.assertEquals((String)"Named context should be empty", (int)0, (int)this.countContext1Elements());
        this.con.clear(new Resource[0]);
        this.con.commit();
        BigdataStoreTest.assertEquals((String)"Repository should no longer contain any statements", (int)0, (int)this.countAllElements());
    }

    @Override
    public void testQueryBindings() throws Exception {
        this.con.addStatement((Resource)this.painter, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        this.con.addStatement((Resource)this.painting, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        this.con.addStatement((Resource)this.picasso, RDF.TYPE, (Value)this.painter, new Resource[]{this.context1});
        this.con.addStatement((Resource)this.guernica, RDF.TYPE, (Value)this.painting, new Resource[]{this.context1});
        this.con.addStatement((Resource)this.picasso, this.paints, (Value)this.guernica, new Resource[]{this.context1});
        this.con.commit();
        MapBindingSet bindings = new MapBindingSet(2);
        CloseableIteration<? extends BindingSet, QueryEvaluationException> iter = this.evaluate("select ?X where { ?X <" + RDF.TYPE + "> ?Y . ?Y <" + RDF.TYPE + "> <" + RDFS.CLASS + ">}", this.con, (BindingSet)bindings);
        int resultCount = this.verifyQueryResult(iter, 1);
        BigdataStoreTest.assertEquals((String)"Wrong number of query results", (int)2, (int)resultCount);
        bindings.addBinding("Y", (Value)this.painter);
        iter = this.evaluate("select ?X where { ?X <" + RDF.TYPE + "> ?Y . ?Y <" + RDF.TYPE + "> <" + RDFS.CLASS + ">}", this.con, (BindingSet)bindings);
        resultCount = this.verifyQueryResult(iter, 1);
        BigdataStoreTest.assertEquals((String)"Wrong number of query results", (int)1, (int)resultCount);
        bindings.addBinding("Z", (Value)this.painting);
        iter = this.evaluate("select ?X where { ?X <" + RDF.TYPE + "> ?Y . ?Y <" + RDF.TYPE + "> <" + RDFS.CLASS + ">}", this.con, (BindingSet)bindings);
        resultCount = this.verifyQueryResult(iter, 1);
        BigdataStoreTest.assertEquals((String)"Wrong number of query results", (int)1, (int)resultCount);
        bindings.removeBinding("Y");
        iter = this.evaluate("select ?X where { ?X <" + RDF.TYPE + "> ?Y . ?Y <" + RDF.TYPE + "> <" + RDFS.CLASS + ">}", this.con, (BindingSet)bindings);
        resultCount = this.verifyQueryResult(iter, 1);
        BigdataStoreTest.assertEquals((String)"Wrong number of query results", (int)2, (int)resultCount);
        bindings.clear();
        iter = this.evaluate("select ?X where { ?X <" + RDF.TYPE + "> ?Y . ?Y <" + RDF.TYPE + "> <" + RDFS.CLASS + "> . filter( ?Y = ?Z) }", this.con, (BindingSet)bindings);
        resultCount = this.verifyQueryResult(iter, 1);
        BigdataStoreTest.assertEquals((String)"Wrong number of query results", (int)0, (int)resultCount);
        bindings.addBinding("Z", (Value)this.painter);
        iter = this.evaluate("select ?X where { ?X <" + RDF.TYPE + "> ?Y . ?Y <" + RDF.TYPE + "> <" + RDFS.CLASS + "> . filter( ?Y = ?Z) }", this.con, (BindingSet)bindings);
        resultCount = this.verifyQueryResult(iter, 1);
        BigdataStoreTest.assertEquals((String)"Wrong number of query results", (int)1, (int)resultCount);
    }

    @Override
    protected int countQueryResults(String query) throws Exception {
        query = "PREFIX ex: <http://example.org/> PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> " + query;
        return this.countElements((Iteration<?, ?>)this.evaluate(query, this.con));
    }
}

