/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp;

import com.bigdata.rdf.sail.webapp.AbstractProtocolTest;
import com.bigdata.rdf.sparql.ast.eval.ASTConstructIterator;
import java.io.IOException;

public class AbstractNamedGraphUpdateTest
extends AbstractProtocolTest {
    private static final String distinctHintFalse = "    hint:Query hint:nativeDistinctSPO false . \n";
    private static final String distinctHintTrue = "    hint:Query hint:nativeDistinctSPO true . \n";
    private final boolean nativeDistinct;
    private String insertData = "prefix rdf:  <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nINSERT DATA\n{ \n GRAPH <eg:a> {\n   [ a \"Blank\" ] .\n   <eg:b> rdf:type <eg:c> ; rdf:value [] .\n   [ rdf:value [] ] .\n }\n GRAPH <eg:tmp> {\n   [ a \"Blankx\" ] .\n   <eg:B> rdf:type <eg:C> ; rdf:value [] .\n   [ rdf:value [] ] .\n }\n}\n";

    public AbstractNamedGraphUpdateTest(boolean nativeDistinct, String name) {
        super(name);
        this.nativeDistinct = nativeDistinct;
    }

    private String atomicMoveNamedGraph() {
        return "DELETE {\n  GRAPH <eg:a> {\n    ?olds ?oldp ?oldo\n  }\n  GRAPH <eg:tmp> {\n    ?news ?newp ?newo\n  }\n}\nINSERT {\n  GRAPH <eg:a> {\n    ?news ?newp ?newo\n  }\n}\nWHERE {\n    hint:Query hint:nativeDistinctSPO false . \n  {\n    GRAPH <eg:a> {\n      ?olds ?oldp ?oldo\n    }\n  } UNION {\n    GRAPH <eg:tmp> {\n      ?news ?newp ?newo\n    }\n  }\n}";
    }

    private void makeUpdate(String update) throws IOException {
        boolean hasHint = update.contains(distinctHintFalse);
        if (hasHint) {
            ASTConstructIterator.flagToCheckNativeDistinctQuadsInvocationForJUnitTesting = false;
            if (this.nativeDistinct) {
                update = update.replace(distinctHintFalse, distinctHintTrue);
            }
        }
        this.setMethodisPostUrlEncodedData();
        this.serviceRequest("update", update);
        if (hasHint) {
            AbstractNamedGraphUpdateTest.assertEquals((boolean)this.nativeDistinct, (boolean)ASTConstructIterator.flagToCheckNativeDistinctQuadsInvocationForJUnitTesting);
        }
    }

    private void assertQuad(String graph, String triple) throws IOException {
        this.assertQuad("true", graph, triple);
    }

    private void assertNotQuad(String graph, String triple) throws IOException {
        this.assertQuad("false", graph, triple);
    }

    void assertQuad(String expected, String graph, String triple) throws IOException {
        String result = this.serviceRequest("query", "ASK { GRAPH " + graph + " { " + triple + "} }");
        AbstractNamedGraphUpdateTest.assertTrue((boolean)result.contains(expected));
    }

    private void updateAFewTimes(int numberOfUpdatesPerTime) throws IOException {
        int numberOfTimes = 5;
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < numberOfUpdatesPerTime; ++j) {
                this.makeUpdate(this.insertData);
            }
            this.makeUpdate(this.atomicMoveNamedGraph());
            this.assertNotQuad("<eg:tmp>", " ?s ?p ?o ");
        }
    }

    public void test_t_1() throws IOException {
        this.updateAFewTimes(1);
    }

    public void test_t_2() throws IOException {
        this.updateAFewTimes(2);
    }

    public void test_t_3() throws IOException {
        this.updateAFewTimes(3);
    }

    public void test_t_5() throws IOException {
        this.updateAFewTimes(5);
    }

    public void test_double_triple_delete() throws IOException {
        this.setMethodisPostUrlEncodedData();
        this.makeUpdate("prefix rdf:  <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nINSERT DATA\n{ \n GRAPH <eg:a> {\n   <eg:b> rdf:type <eg:c> \n }\n GRAPH <eg:tmp> {\n   <eg:b> rdf:type <eg:c> \n }\n}\n");
        this.makeUpdate("DELETE {\n  GRAPH <eg:a> {\n    ?olds ?oldp ?oldo\n  }\n  GRAPH <eg:tmp> {\n    ?olds ?oldp ?oldo\n  }\n}\nWHERE {\n    hint:Query hint:nativeDistinctSPO false . \n    GRAPH <eg:a> {\n      ?olds ?oldp ?oldo\n    }\n}");
        this.assertNotQuad("?g", "?s ?p ?o");
    }

    public void test_double_triple_insert() throws IOException {
        this.makeUpdate("prefix rdf:  <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nINSERT DATA\n{ \n GRAPH <eg:tmp> {\n   <eg:b> rdf:type <eg:c> .\n   <eg:x> rdf:type _:foo \n }\n}\n");
        this.makeUpdate("INSERT {\n  GRAPH <eg:A> {\n    ?olds ?oldp ?oldo\n  }\n  GRAPH <eg:B> {\n    ?olds ?oldp ?oldo\n  }\n}\nWHERE {\n    hint:Query hint:nativeDistinctSPO false . \n    GRAPH <eg:tmp> {\n      ?olds ?oldp ?oldo\n    }\n}");
        this.assertQuad("<eg:A>", "<eg:b> rdf:type <eg:c> ");
        this.assertQuad("<eg:B>", "<eg:b> rdf:type <eg:c> ");
        this.assertQuad("<eg:A>", "<eg:x> rdf:type ?x");
        this.assertQuad("<eg:B>", "<eg:x> rdf:type ?x ");
    }

    public void test_double_triple_delete_insert() throws IOException {
        this.makeUpdate("prefix rdf:  <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nINSERT DATA\n{ \n GRAPH <eg:tmp> {\n   <eg:A> <eg:moveTo> <eg:AA> .\n   <eg:B> <eg:moveTo> <eg:BB> \n }\n}\n");
        this.makeUpdate("INSERT {\n  GRAPH <eg:A> {\n    ?olds ?oldp ?oldo\n  }\n}\nWHERE {\n    GRAPH <eg:tmp> {\n      ?olds ?oldp ?oldo\n    }\n}");
        this.makeUpdate("INSERT {\n  GRAPH <eg:B> {\n    ?olds ?oldp ?oldo\n  }\n}\nWHERE {\n    GRAPH <eg:tmp> {\n      ?olds ?oldp ?oldo\n    }\n}");
        this.assertQuad("<eg:A>", "<eg:A> <eg:moveTo> <eg:AA> ");
        this.assertQuad("<eg:B>", "<eg:A> <eg:moveTo> <eg:AA> ");
        this.assertQuad("<eg:A>", "<eg:B> <eg:moveTo> <eg:BB>");
        this.assertQuad("<eg:B>", "<eg:B> <eg:moveTo> <eg:BB> ");
        this.makeUpdate("DELETE {\n    GRAPH ?oldg {\n    ?olds ?oldp ?oldo\n  }\n}\nINSERT {\n  GRAPH ?newg {\n    ?olds ?oldp ?oldo\n  }\n}\nWHERE {\n    hint:Query hint:nativeDistinctSPO false . \n    GRAPH <eg:tmp> {\n      ?oldg <eg:moveTo> ?newg\n    }\n    GRAPH ?oldg {\n       ?olds ?oldp ?oldo\n    }\n}");
        this.assertNotQuad("<eg:A>", "<eg:A> <eg:moveTo> <eg:AA> ");
        this.assertNotQuad("<eg:B>", "<eg:A> <eg:moveTo> <eg:AA> ");
        this.assertNotQuad("<eg:A>", "<eg:B> <eg:moveTo> <eg:BB>");
        this.assertNotQuad("<eg:B>", "<eg:B> <eg:moveTo> <eg:BB> ");
        this.assertQuad("<eg:AA>", "<eg:A> <eg:moveTo> <eg:AA> ");
        this.assertQuad("<eg:BB>", "<eg:A> <eg:moveTo> <eg:AA> ");
        this.assertQuad("<eg:AA>", "<eg:B> <eg:moveTo> <eg:BB>");
        this.assertQuad("<eg:BB>", "<eg:B> <eg:moveTo> <eg:BB> ");
    }
}

