/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp;

import com.bigdata.journal.IIndexManager;
import com.bigdata.rdf.sail.webapp.AbstractTestNanoSparqlClient;
import com.bigdata.rdf.sail.webapp.QueryServlet;
import com.bigdata.rdf.sail.webapp.client.ConnectOptions;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServlet;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;

public abstract class AbstractProtocolTest
extends AbstractTestNanoSparqlClient<IIndexManager> {
    protected static final String SELECT = "SELECT (1 as ?one){}";
    protected static final String ASK = "ASK WHERE {}";
    protected static final String CONSTRUCT = "CONSTRUCT { <a:b> <c:d> <e:f> } WHERE {}";
    protected static final long PAUSE_BEFORE_CLOSE_TIME = 100L;
    private static int updateCounter = 0;
    private final String askIfUpdated = AbstractProtocolTest.askIfUpdated();
    final String update = AbstractProtocolTest.update();
    HttpServlet servlet;
    HttpClient client;
    private String responseContentType = null;
    private String accept = null;
    private boolean permit400s = false;
    private Header[] headers = null;
    private final RequestFactory GET;
    private volatile RequestFactory requestFactory = this.GET = new RequestFactory(){

        @Override
        public HttpUriRequest createRequest(String ... params) {
            StringBuffer url = new StringBuffer();
            url.append(AbstractProtocolTest.this.getSparqlURL(AbstractProtocolTest.this.m_serviceURL));
            int sep = 63;
            for (int i = 0; i < params.length; i += 2) {
                url.append((char)sep);
                url.append(params[i]);
                url.append('=');
                try {
                    url.append(URLEncoder.encode(params[i + 1], "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new Error(e);
                }
                sep = 38;
            }
            return new HttpGet(url.toString());
        }
    };
    private static Pattern charset = Pattern.compile("[; ]charset *= *\"?([^ ;\"]*)([ \";]|$)");

    private static String update() {
        return "INSERT { <http://example.org/a> <http://example.org/a> <http://example.org/" + updateCounter++ + "> } WHERE {}";
    }

    private static String askIfUpdated() {
        return "ASK { <http://example.org/a> <http://example.org/a> <http://example.org/" + updateCounter + "> }";
    }

    private final String getSparqlURL(String serviceURL) {
        return serviceURL + "/sparql";
    }

    protected RequestFactory getRequestFactory() {
        return this.requestFactory;
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.client = new DefaultHttpClient(this.newInstance());
        this.resetDefaultOptions();
    }

    @Override
    public void tearDown() throws Exception {
        this.client.getConnectionManager().shutdown();
        this.client = null;
        this.servlet = null;
        super.tearDown();
    }

    protected void resetDefaultOptions() {
        this.accept = null;
        this.requestFactory = this.GET;
        this.accept = null;
        this.permit400s = false;
        this.headers = null;
    }

    protected String getResponseContentType() {
        return this.responseContentType;
    }

    protected void setAccept(String mimetype) {
        this.accept = mimetype;
    }

    protected void setHeaders(Header[] headers) {
        this.headers = headers;
    }

    public static void main(String[] argv) {
        for (String t : new String[]{"text/html ; charset=iso-8856-1", "text/html ; charset=iso-8856-1; foo = bar", "text/html ;charset=iso-8856-1; foo = bar", "text/html ; charset= \"iso-8856-1\"", "text/html ; charset=iso-8856-1; foo = bar", "text/html ; charset = iso-8856-1; foo = bar", "text/html ; foo = bar", "text/html"}) {
            Matcher m = charset.matcher(t);
            System.err.println(t + " ====> " + (m.find() ? m.group(1) : ""));
        }
    }

    protected ClientConnectionManager newInstance() {
        ThreadSafeClientConnManager cm = new ThreadSafeClientConnManager(this.newSchemeRegistry());
        cm.setMaxTotal(200);
        cm.setDefaultMaxPerRoute(20);
        HttpHost localhost = new HttpHost("locahost");
        cm.setMaxForRoute(new HttpRoute(localhost), 50);
        return cm;
    }

    protected SchemeRegistry newSchemeRegistry() {
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        schemeRegistry.register(new Scheme("https", 443, (SchemeSocketFactory)SSLSocketFactory.getSocketFactory()));
        return schemeRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String serviceRequest(String ... paramValues) throws IOException {
        this.responseContentType = null;
        try {
            HttpUriRequest req;
            try {
                req = this.requestFactory.createRequest(paramValues);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            req.setHeader("Accept", this.accept == null ? "*" : this.accept);
            if (this.headers != null) {
                req.setHeaders(this.headers);
            }
            HttpResponse resp = this.client.execute(req);
            String page = "";
            HttpEntity entity = resp.getEntity();
            if (entity != null) {
                String encoding = "utf-8";
                AbstractProtocolTest.assertNotNull((String)("Entity in " + resp.getStatusLine().getStatusCode() + " response must specify content type"), (Object)entity.getContentType());
                Matcher m = charset.matcher(entity.getContentType().getValue());
                if (m.find()) {
                    encoding = m.group(1);
                }
                page = QueryServlet.readFully((Reader)new InputStreamReader(entity.getContent(), encoding));
                this.responseContentType = entity.getContentType().getValue();
            }
            if (resp.getStatusLine().getStatusCode() >= (this.permit400s ? 500 : 400)) {
                AbstractProtocolTest.fail((String)(resp.getStatusLine().toString() + "\n" + page));
            }
            String string = page;
            return string;
        }
        finally {
            this.resetDefaultOptions();
        }
    }

    private Map<String, String[]> pairs2map(String ... paramValues) {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        for (int i = 0; i < paramValues.length; i += 2) {
            String key = paramValues[i];
            String value = paramValues[i + 1];
            String[] val = (String[])params.get(key);
            if (val == null) {
                params.put(key, new String[]{value});
                continue;
            }
            String[] nval = new String[val.length + 1];
            System.arraycopy(val, 0, nval, 0, val.length);
            nval[val.length] = value;
            params.put(key, nval);
        }
        return params;
    }

    protected void setMethodisPostUrlEncodedData() {
        this.requestFactory = new RequestFactory(){

            @Override
            public HttpUriRequest createRequest(String ... params) {
                HttpPost rslt = new HttpPost(AbstractProtocolTest.this.getSparqlURL(AbstractProtocolTest.this.m_serviceURL));
                try {
                    rslt.setEntity(ConnectOptions.getFormEntity((Map)AbstractProtocolTest.this.pairs2map(params)));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return rslt;
            }
        };
    }

    protected void setMethodisPost(String mimeType, String body) {
        StringEntity toPostx = null;
        try {
            toPostx = new StringEntity(body, mimeType, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
        StringEntity toPost = toPostx;
        this.requestFactory = new RequestFactory((HttpEntity)toPost){
            final /* synthetic */ HttpEntity val$toPost;
            {
                this.val$toPost = httpEntity;
            }

            @Override
            public HttpUriRequest createRequest(String ... params) {
                StringBuffer url = new StringBuffer();
                url.append(AbstractProtocolTest.this.getSparqlURL(AbstractProtocolTest.this.m_serviceURL));
                int sep = 63;
                for (int i = 0; i < params.length; i += 2) {
                    url.append((char)sep);
                    url.append(params[i]);
                    url.append('=');
                    try {
                        url.append(URLEncoder.encode(params[i + 1], "UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new Error(e);
                    }
                    sep = 38;
                }
                HttpPost rslt = new HttpPost(url.toString());
                rslt.setEntity(this.val$toPost);
                return rslt;
            }
        };
    }

    protected void setAllow400s() {
        this.permit400s = true;
    }

    protected void checkUpdate(boolean expected) throws IOException {
        this.resetDefaultOptions();
        AbstractProtocolTest.assertTrue((boolean)this.serviceRequest("query", this.askIfUpdated).contains(Boolean.toString(expected)));
    }

    protected void setMethodAsGet() {
        this.requestFactory = this.GET;
    }

    public AbstractProtocolTest(HttpServlet servlet, String name) {
        super(name);
        this.servlet = servlet;
    }

    public AbstractProtocolTest(String name) {
        this((HttpServlet)new QueryServlet(), name);
    }

    protected static interface RequestFactory {
        public HttpUriRequest createRequest(String ... var1);
    }
}

