/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp;

import com.bigdata.journal.IIndexManager;
import com.bigdata.rdf.sail.webapp.AbstractTestNanoSparqlClient;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.repository.RepositoryException;

public class AbstractSimpleInsertTest<S extends IIndexManager>
extends AbstractTestNanoSparqlClient<S> {
    private static final String EX_NS = "http://example.org/";
    private ValueFactory f = new ValueFactoryImpl();
    private URI bob;

    public AbstractSimpleInsertTest() {
    }

    public AbstractSimpleInsertTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.bob = this.f.createURI(EX_NS, "bob");
    }

    @Override
    public void tearDown() throws Exception {
        this.bob = null;
        this.f = null;
        super.tearDown();
    }

    protected String getNamespaceDeclarations() {
        StringBuilder declarations = new StringBuilder();
        declarations.append("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \n");
        declarations.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> \n");
        declarations.append("PREFIX dc: <http://purl.org/dc/elements/1.1/> \n");
        declarations.append("PREFIX foaf: <http://xmlns.com/foaf/0.1/> \n");
        declarations.append("PREFIX ex: <http://example.org/> \n");
        declarations.append("PREFIX xsd: <http://www.w3.org/2001/XMLSchema#> \n");
        declarations.append("\n");
        return declarations.toString();
    }

    protected boolean hasStatement(Resource subj, URI pred, Value obj, boolean includeInferred, Resource ... contexts) throws RepositoryException {
        try {
            return this.m_repo.getStatements(subj, pred, obj, includeInferred, contexts).hasNext();
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    protected void executeInsert(String where, boolean expected) throws RepositoryException, Exception {
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("INSERT { ex:bob rdfs:label \"Bob\" . } WHERE { " + where + " }");
        AbstractSimpleInsertTest.assertFalse((boolean)this.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
        this.m_repo.prepareUpdate(update.toString()).evaluate();
        AbstractSimpleInsertTest.assertEquals((boolean)expected, (boolean)this.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
    }
}

