/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp;

import com.bigdata.BigdataStatics;
import com.bigdata.journal.IIndexManager;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.DestroyKBTask;
import com.bigdata.rdf.sail.webapp.DatasetNotFoundException;
import com.bigdata.rdf.sail.webapp.NanoSparqlServer;
import com.bigdata.rdf.sail.webapp.ProxyTestCase;
import com.bigdata.rdf.sail.webapp.TestMode;
import com.bigdata.rdf.sail.webapp.client.HttpClientConfigurator;
import com.bigdata.rdf.sail.webapp.client.IPreparedGraphQuery;
import com.bigdata.rdf.sail.webapp.client.IPreparedTupleQuery;
import com.bigdata.rdf.sail.webapp.client.RemoteRepository;
import com.bigdata.rdf.sail.webapp.client.RemoteRepositoryManager;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.task.AbstractApiTask;
import com.bigdata.rdf.task.IApiTask;
import com.bigdata.util.InnerCause;
import com.bigdata.util.config.NicUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.server.Server;
import org.openrdf.model.Graph;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.LinkedHashModel;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.StatementImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.query.GraphQueryResult;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.RDFParserFactory;
import org.openrdf.rio.RDFParserRegistry;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.RDFWriterFactory;
import org.openrdf.rio.RDFWriterRegistry;
import org.openrdf.rio.helpers.StatementCollector;
import org.openrdf.sail.SailException;

public abstract class AbstractTestNanoSparqlClient<S extends IIndexManager>
extends ProxyTestCase<S> {
    protected static final String packagePath = "src/test/java/com/bigdata/rdf/sail/webapp/";
    protected Server m_fixture;
    protected String namespace;
    protected HttpClient m_client;
    protected RemoteRepositoryManager m_mgr;
    protected RemoteRepository m_repo;
    protected String m_serviceURL;
    protected String m_rootURL;
    private TestMode testMode = null;

    public AbstractTestNanoSparqlClient() {
    }

    public AbstractTestNanoSparqlClient(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTripleStore(IIndexManager indexManager, String namespace, Properties properties) throws InterruptedException, ExecutionException, SailException {
        if (log.isInfoEnabled()) {
            log.info((Object)("KB namespace=" + namespace));
        }
        boolean ok = false;
        BigdataSail sail = new BigdataSail(namespace, indexManager);
        try {
            sail.initialize();
            sail.create(properties);
            if (log.isInfoEnabled()) {
                log.info((Object)("Created tripleStore: " + namespace));
            }
            ok = true;
            return;
        }
        finally {
            if (!ok) {
                sail.shutDown();
            }
        }
    }

    private void dropTripleStore(IIndexManager indexManager, String namespace) throws InterruptedException, ExecutionException {
        block3: {
            if (log.isInfoEnabled()) {
                log.info((Object)("KB namespace=" + namespace));
            }
            try {
                AbstractApiTask.submitApiTask((IIndexManager)indexManager, (IApiTask)new DestroyKBTask(namespace)).get();
            }
            catch (Exception ex) {
                if (!InnerCause.isInnerCause((Throwable)ex, DatasetNotFoundException.class) || !log.isInfoEnabled()) break block3;
                log.info((Object)("namespace does not exist: " + namespace));
            }
        }
    }

    protected TestMode getTestMode() {
        return this.testMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Server newFixture(String lnamespace) throws Exception {
        Object indexManager = this.getIndexManager();
        Properties properties = this.getProperties();
        this.createTripleStore((IIndexManager)indexManager, lnamespace, properties);
        BigdataSail sail = new BigdataSail(lnamespace, indexManager);
        try {
            sail.initialize();
            try (BigdataSail.BigdataSailConnection con = sail.getUnisolatedConnection();){
                AbstractTripleStore tripleStore = con.getTripleStore();
                this.testMode = tripleStore.isStatementIdentifiers() ? TestMode.sids : (tripleStore.isQuads() ? TestMode.quads : TestMode.triples);
            }
        }
        finally {
            sail.shutDown();
        }
        LinkedHashMap<String, String> initParams = new LinkedHashMap<String, String>();
        initParams.put("namespace", lnamespace);
        initParams.put("create", "false");
        Server fixture = NanoSparqlServer.newInstance((int)0, indexManager, initParams);
        fixture.start();
        return fixture;
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        if (log.isTraceEnabled()) {
            log.trace((Object)("Setting up test:" + this.getName()));
        }
        this.namespace = this.getName() + UUID.randomUUID();
        this.m_fixture = this.newFixture(this.namespace);
        int port = NanoSparqlServer.getLocalPort((Server)this.m_fixture);
        String hostAddr = NicUtil.getIpAddress((String)"default.nic", (String)"default", (boolean)true);
        if (hostAddr == null) {
            AbstractTestNanoSparqlClient.fail((String)"Could not identify network address for this host.");
        }
        this.m_rootURL = new URL("http", hostAddr, port, "").toExternalForm();
        this.m_serviceURL = new URL("http", hostAddr, port, BigdataStatics.getContextPath()).toExternalForm();
        if (log.isInfoEnabled()) {
            log.info((Object)("Setup done: \nname=" + this.getName() + "\nnamespace=" + this.namespace + "\nrootURL=" + this.m_rootURL + "\nserviceURL=" + this.m_serviceURL));
        }
        this.m_client = HttpClientConfigurator.getInstance().newInstance();
        this.m_mgr = new RemoteRepositoryManager(this.m_serviceURL, this.m_client, (Executor)this.getIndexManager().getExecutorService());
        this.m_repo = this.m_mgr.getRepositoryForNamespace(this.namespace);
        if (log.isInfoEnabled()) {
            log.info((Object)("Setup Active Threads: " + Thread.activeCount()));
        }
    }

    @Override
    public void tearDown() throws Exception {
        Object m_indexManager;
        if (log.isTraceEnabled()) {
            log.trace((Object)("tearing down test: " + this.getName()));
        }
        if (this.m_fixture != null) {
            this.m_fixture.stop();
            this.m_fixture = null;
        }
        if ((m_indexManager = this.getIndexManager()) != null && this.namespace != null) {
            this.dropTripleStore((IIndexManager)m_indexManager, this.namespace);
        }
        this.namespace = null;
        this.m_rootURL = null;
        this.m_serviceURL = null;
        log.info((Object)"Connection Shutdown Check");
        this.m_mgr.close();
        this.m_client.stop();
        this.m_mgr = null;
        this.m_repo = null;
        this.m_client = null;
        log.info((Object)"tear down done");
        super.tearDown();
        int nthreads = Thread.activeCount();
        if (log.isInfoEnabled()) {
            log.info((Object)("Teardown Active Threads: " + nthreads));
        }
        if (nthreads > 300) {
            log.error((Object)("High residual thread count: " + nthreads));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static long countResults(TupleQueryResult result) throws Exception {
        try {
            long count = 0L;
            while (result.hasNext()) {
                result.next();
                ++count;
            }
            long l = count;
            return l;
        }
        finally {
            result.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static long countResults(GraphQueryResult result) throws Exception {
        try {
            long count = 0L;
            while (result.hasNext()) {
                result.next();
                ++count;
            }
            long l = count;
            return l;
        }
        finally {
            result.close();
        }
    }

    protected static int countMatches(Graph g, Resource s, URI p, Value o) {
        int n = 0;
        Iterator itr = g.match(s, p, o, new Resource[0]);
        while (itr.hasNext()) {
            itr.next();
            ++n;
        }
        return n;
    }

    protected static Statement[] getMatches(Graph g, Resource s, URI p, Value o) {
        LinkedList out = new LinkedList();
        Iterator itr = g.match(s, p, o, new Resource[0]);
        while (itr.hasNext()) {
            out.add(itr.next());
        }
        return out.toArray(new Statement[out.size()]);
    }

    protected static void assertSameGraph(Graph expected, IPreparedGraphQuery actual) throws Exception {
        AbstractTestNanoSparqlClient.assertSameGraph(expected, AbstractTestNanoSparqlClient.asGraph(actual));
    }

    protected static void assertSameGraph(Graph expected, Graph actual) {
        for (Statement s : expected) {
            if (actual.contains((Object)s)) continue;
            AbstractTestNanoSparqlClient.fail((String)("Expecting: " + s));
        }
        AbstractTestNanoSparqlClient.assertEquals((String)"size", (int)expected.size(), (int)actual.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Graph asGraph(IPreparedGraphQuery preparedQuery) throws Exception {
        try (GraphQueryResult result = preparedQuery.evaluate();){
            LinkedHashModel g = new LinkedHashModel();
            while (result.hasNext()) {
                g.add(result.next());
            }
            LinkedHashModel linkedHashModel = g;
            return linkedHashModel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Graph asGraph(GraphQueryResult result) throws Exception {
        try {
            LinkedHashModel g = new LinkedHashModel();
            while (result.hasNext()) {
                g.add(result.next());
            }
            LinkedHashModel linkedHashModel = g;
            return linkedHashModel;
        }
        finally {
            result.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static long countResults(RepositoryResult<Statement> result) throws Exception {
        try {
            long i = 0L;
            while (result.hasNext()) {
                result.next();
                ++i;
            }
            long l = i;
            return l;
        }
        finally {
            result.close();
        }
    }

    protected byte[] genNTRIPLES(int ntriples, RDFFormat format) throws RDFHandlerException {
        Graph g = this.genNTRIPLES2(ntriples);
        RDFWriterFactory writerFactory = (RDFWriterFactory)RDFWriterRegistry.getInstance().get((Object)format);
        if (writerFactory == null) {
            AbstractTestNanoSparqlClient.fail((String)("RDFWriterFactory not found: format=" + format));
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        RDFWriter writer = writerFactory.getWriter((OutputStream)baos);
        writer.startRDF();
        for (Statement stmt : g) {
            writer.handleStatement(stmt);
        }
        writer.endRDF();
        return baos.toByteArray();
    }

    protected Graph genNTRIPLES2(int ntriples) throws RDFHandlerException {
        LinkedHashModel g = new LinkedHashModel();
        ValueFactoryImpl f = new ValueFactoryImpl();
        URI s = f.createURI("http://www.bigdata.org/b");
        URI rdfType = f.createURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
        for (int i = 0; i < ntriples; ++i) {
            URI o = f.createURI("http://www.bigdata.org/c#" + i);
            g.add((Resource)s, rdfType, (Value)o, new Resource[0]);
        }
        return g;
    }

    protected Literal getVeryLargeLiteral() {
        int len = 1024000;
        StringBuilder sb = new StringBuilder(1024000);
        for (int i = 0; i < 1024000; ++i) {
            sb.append(Character.toChars(65 + i % 26));
        }
        return new LiteralImpl(sb.toString());
    }

    protected long countAll() throws Exception {
        return this.m_repo.rangeCount(true, null, null, null, new Resource[0]);
    }

    @Deprecated
    protected long getExactSize() {
        try {
            return this.countAll();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void doDeleteWithPostTest(RDFFormat format) throws Exception {
        this.doInsertWithBodyTest("POST", 23, format);
        AbstractTestNanoSparqlClient.assertEquals((long)23L, (long)this.countAll());
        this.doDeleteWithBody(23, format);
        AbstractTestNanoSparqlClient.assertEquals((long)0L, (long)this.countAll());
    }

    protected long doDeleteWithQuery(String query) throws Exception {
        RemoteRepository.RemoveOp remove = new RemoteRepository.RemoveOp(query);
        return this.m_repo.remove(remove);
    }

    protected long doDeleteWithAccessPath(URI s, URI p, Value o, URI ... c) throws Exception {
        RemoteRepository.RemoveOp remove = new RemoteRepository.RemoveOp((Resource)s, p, o, (Resource[])c);
        return this.m_repo.remove(remove);
    }

    protected void doDeleteWithBody(int ntriples, RDFFormat format) throws Exception {
        byte[] data = this.genNTRIPLES(ntriples, format);
        RemoteRepository.RemoveOp remove = new RemoteRepository.RemoveOp(data, format);
        AbstractTestNanoSparqlClient.assertEquals((long)ntriples, (long)this.m_repo.remove(remove));
    }

    protected void doInsertWithBodyTest(String method, int ntriples, RDFFormat format) throws Exception {
        byte[] data = this.genNTRIPLES(ntriples, format);
        RemoteRepository.AddOp add = new RemoteRepository.AddOp(data, format);
        AbstractTestNanoSparqlClient.assertEquals((long)ntriples, (long)this.m_repo.add(add));
        String queryStr = "select * where {?s ?p ?o}";
        IPreparedTupleQuery query = this.m_repo.prepareTupleQuery("select * where {?s ?p ?o}");
        AbstractTestNanoSparqlClient.assertEquals((long)ntriples, (long)AbstractTestNanoSparqlClient.countResults(query.evaluate()));
    }

    protected long doInsertbyURL(String method, String resource) throws Exception {
        String uri = new File(resource).toURI().toString();
        RemoteRepository.AddOp add = new RemoteRepository.AddOp(uri);
        return this.m_repo.add(add);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String readFromFile(File file) throws IOException {
        try (LineNumberReader r = new LineNumberReader(new FileReader(file));){
            String s;
            StringBuilder sb = new StringBuilder();
            while ((s = r.readLine()) != null) {
                if (r.getLineNumber() > 1) {
                    sb.append("\n");
                }
                sb.append(s);
            }
            String string = sb.toString();
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Graph readGraphFromFile(File file) throws RDFParseException, RDFHandlerException, IOException {
        RDFFormat format = RDFFormat.forFileName((String)file.getName());
        RDFParserFactory rdfParserFactory = (RDFParserFactory)RDFParserRegistry.getInstance().get((Object)format);
        if (rdfParserFactory == null) {
            throw new RuntimeException("Parser not found: file=" + file + ", format=" + format);
        }
        RDFParser rdfParser = rdfParserFactory.getParser();
        rdfParser.setValueFactory((ValueFactory)new ValueFactoryImpl());
        rdfParser.setVerifyData(true);
        rdfParser.setStopAtFirstError(true);
        rdfParser.setDatatypeHandling(RDFParser.DatatypeHandling.IGNORE);
        StatementCollector rdfHandler = new StatementCollector();
        rdfParser.setRDFHandler((RDFHandler)rdfHandler);
        try (FileReader r = new FileReader(file);){
            rdfParser.parse((Reader)r, file.toURI().toString());
        }
        LinkedHashModel g = new LinkedHashModel();
        g.addAll(rdfHandler.getStatements());
        return g;
    }

    protected static byte[] writeOnBuffer(RDFFormat format, Graph g) throws RDFHandlerException {
        RDFWriterFactory writerFactory = (RDFWriterFactory)RDFWriterRegistry.getInstance().get((Object)format);
        if (writerFactory == null) {
            AbstractTestNanoSparqlClient.fail((String)("RDFWriterFactory not found: format=" + format));
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        RDFWriter writer = writerFactory.getWriter((OutputStream)baos);
        writer.startRDF();
        for (Statement stmt : g) {
            writer.handleStatement(stmt);
        }
        writer.endRDF();
        return baos.toByteArray();
    }

    protected Graph loadGraphFromResource(String resource) throws RDFParseException, RDFHandlerException, IOException {
        Graph g = AbstractTestNanoSparqlClient.readGraphFromFile(new File(resource));
        return g;
    }

    protected long doInsertByBody(String method, RDFFormat rdfFormat, Graph g, URI defaultContext) throws Exception {
        byte[] wireData = AbstractTestNanoSparqlClient.writeOnBuffer(rdfFormat, g);
        RemoteRepository.AddOp add = new RemoteRepository.AddOp(wireData, rdfFormat);
        if (defaultContext != null) {
            add.setContext(new Resource[]{defaultContext});
        }
        return this.m_repo.add(add);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getResponseBody(HttpURLConnection conn) throws IOException {
        try (InputStreamReader r = new InputStreamReader(conn.getInputStream());){
            int ch;
            StringWriter w = new StringWriter();
            while ((ch = ((Reader)r).read()) != -1) {
                w.append((char)ch);
            }
            String string = w.toString();
            return string;
        }
    }

    protected void doDescribeTest(String method, RDFFormat format) throws Exception {
        URIImpl mike = new URIImpl("http://www.bigdata.com/rdf#Mike");
        URIImpl bryan = new URIImpl("http://www.bigdata.com/rdf#Bryan");
        URIImpl person = new URIImpl("http://www.bigdata.com/rdf#Person");
        URIImpl likes = new URIImpl("http://www.bigdata.com/rdf#likes");
        URIImpl rdf = new URIImpl("http://www.bigdata.com/rdf#RDF");
        URIImpl rdfs = new URIImpl("http://www.bigdata.com/rdf#RDFS");
        LiteralImpl label1 = new LiteralImpl("Mike");
        LiteralImpl label2 = new LiteralImpl("Bryan");
        LinkedHashModel g = new LinkedHashModel();
        g.add((Resource)mike, RDF.TYPE, (Value)person, new Resource[0]);
        g.add((Resource)mike, (URI)likes, (Value)rdf, new Resource[0]);
        g.add((Resource)mike, RDFS.LABEL, (Value)label1, new Resource[0]);
        g.add((Resource)bryan, RDF.TYPE, (Value)person, new Resource[0]);
        g.add((Resource)bryan, (URI)likes, (Value)rdfs, new Resource[0]);
        g.add((Resource)bryan, RDFS.LABEL, (Value)label2, new Resource[0]);
        this.m_repo.add(new RemoteRepository.AddOp((Iterable)g));
        LinkedHashModel expected = new LinkedHashModel();
        expected.add((Object)new StatementImpl((Resource)mike, (URI)likes, (Value)rdf));
        expected.add((Object)new StatementImpl((Resource)mike, RDF.TYPE, (Value)person));
        expected.add((Object)new StatementImpl((Resource)mike, RDFS.LABEL, (Value)label1));
        String queryStr = "prefix bd: <http://www.bigdata.com/rdf#> prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> DESCRIBE ?x WHERE {   ?x rdf:type bd:Person .   ?x bd:likes bd:RDF }";
        AbstractTestNanoSparqlClient.assertSameGraph((Graph)expected, this.m_repo.prepareGraphQuery("prefix bd: <http://www.bigdata.com/rdf#> prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> DESCRIBE ?x WHERE {   ?x rdf:type bd:Person .   ?x bd:likes bd:RDF }"));
    }

    protected void setupDataOnServer() throws Exception {
        URIImpl mike = new URIImpl("http://www.bigdata.com/rdf#Mike");
        URIImpl bryan = new URIImpl("http://www.bigdata.com/rdf#Bryan");
        URIImpl person = new URIImpl("http://www.bigdata.com/rdf#Person");
        URIImpl likes = new URIImpl("http://www.bigdata.com/rdf#likes");
        URIImpl rdf = new URIImpl("http://www.bigdata.com/rdf#RDF");
        URIImpl rdfs = new URIImpl("http://www.bigdata.com/rdf#RDFS");
        LiteralImpl label1 = new LiteralImpl("Mike");
        LiteralImpl label2 = new LiteralImpl("Bryan");
        LinkedHashModel g = new LinkedHashModel();
        g.add((Resource)mike, RDF.TYPE, (Value)person, new Resource[0]);
        g.add((Resource)mike, (URI)likes, (Value)rdf, new Resource[0]);
        g.add((Resource)mike, RDFS.LABEL, (Value)label1, new Resource[0]);
        g.add((Resource)bryan, RDF.TYPE, (Value)person, new Resource[0]);
        g.add((Resource)bryan, (URI)likes, (Value)rdfs, new Resource[0]);
        g.add((Resource)bryan, RDFS.LABEL, (Value)label2, new Resource[0]);
        this.m_repo.add(new RemoteRepository.AddOp((Iterable)g));
    }

    protected void setupQuadsDataOnServer() throws Exception {
        URIImpl mike = new URIImpl("http://www.bigdata.com/rdf#Mike");
        URIImpl bryan = new URIImpl("http://www.bigdata.com/rdf#Bryan");
        URIImpl person = new URIImpl("http://www.bigdata.com/rdf#Person");
        URIImpl likes = new URIImpl("http://www.bigdata.com/rdf#likes");
        URIImpl rdf = new URIImpl("http://www.bigdata.com/rdf#RDF");
        URIImpl rdfs = new URIImpl("http://www.bigdata.com/rdf#RDFS");
        URIImpl c1 = new URIImpl("http://www.bigdata.com/rdf#c1");
        URIImpl c2 = new URIImpl("http://www.bigdata.com/rdf#c2");
        URIImpl c3 = new URIImpl("http://www.bigdata.com/rdf#c3");
        LiteralImpl label1 = new LiteralImpl("Mike");
        LiteralImpl label2 = new LiteralImpl("Bryan");
        LinkedHashModel g = new LinkedHashModel();
        g.add((Resource)mike, RDF.TYPE, (Value)person, new Resource[]{c1, c2, c3});
        g.add((Resource)mike, (URI)likes, (Value)rdf, new Resource[]{c1, c2, c3});
        g.add((Resource)mike, RDFS.LABEL, (Value)label1, new Resource[]{c1, c2, c3});
        g.add((Resource)bryan, RDF.TYPE, (Value)person, new Resource[]{c1, c2, c3});
        g.add((Resource)bryan, (URI)likes, (Value)rdfs, new Resource[]{c1, c2, c3});
        g.add((Resource)bryan, RDFS.LABEL, (Value)label2, new Resource[]{c1, c2, c3});
        this.m_repo.add(new RemoteRepository.AddOp((Iterable)g));
    }

    protected void doConstructTest(String method, RDFFormat format) throws Exception {
        this.setupDataOnServer();
        URIImpl mike = new URIImpl("http://www.bigdata.com/rdf#Mike");
        URIImpl bryan = new URIImpl("http://www.bigdata.com/rdf#Bryan");
        URIImpl person = new URIImpl("http://www.bigdata.com/rdf#Person");
        LinkedHashModel expected = new LinkedHashModel();
        expected.add((Object)new StatementImpl((Resource)mike, RDF.TYPE, (Value)person));
        expected.add((Object)new StatementImpl((Resource)bryan, RDF.TYPE, (Value)person));
        String queryStr = "prefix bd: <http://www.bigdata.com/rdf#> prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> CONSTRUCT { ?x rdf:type bd:Person }WHERE {   ?x rdf:type bd:Person . }";
        IPreparedGraphQuery query = this.m_repo.prepareGraphQuery("prefix bd: <http://www.bigdata.com/rdf#> prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> CONSTRUCT { ?x rdf:type bd:Person }WHERE {   ?x rdf:type bd:Person . }");
        AbstractTestNanoSparqlClient.assertSameGraph((Graph)expected, query);
    }
}

