/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp;

import com.bigdata.journal.BufferMode;
import com.bigdata.journal.IIndexManager;
import com.bigdata.rdf.sail.webapp.TestMode;
import com.bigdata.rdf.sail.webapp.TestNanoSparqlServerWithProxyIndexManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Set;
import java.util.regex.Pattern;
import junit.extensions.TestSetup;
import junit.extensions.proxy.ProxyTestSuite;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class ProxySuiteHelper {
    static boolean proxyIndexManagerTestingHasStarted = false;

    private static Test cloneTest(Test delegate, Test test) {
        if (test instanceof TestSuite) {
            return ProxySuiteHelper.cloneSuite(delegate, (TestSuite)test);
        }
        if (test instanceof TestCase) {
            return ProxySuiteHelper.cloneTestCase((TestCase)test);
        }
        throw new IllegalArgumentException("Cannot handle test of type: " + test.getClass().getName());
    }

    private static Test cloneTestCase(TestCase test) {
        return ProxySuiteHelper.createTest(test.getClass(), test.getName());
    }

    private static Test cloneSuite(Test delegate, TestSuite suite) {
        CloningTestSuite rslt = new CloningTestSuite(delegate, suite.getName());
        Enumeration enumerate = suite.tests();
        while (enumerate.hasMoreElements()) {
            rslt.addTest((Test)enumerate.nextElement());
        }
        return rslt;
    }

    public static TestSuite suiteWhenStandalone(Class<? extends TestCase> clazz, String regex, Set<BufferMode> bufferModes, TestMode ... testModes) {
        if (!proxyIndexManagerTestingHasStarted) {
            Pattern pat = Pattern.compile(regex);
            proxyIndexManagerTestingHasStarted = true;
            MultiModeTestSuite suite = new MultiModeTestSuite(clazz.getName(), bufferModes, testModes);
            ProxySuiteHelper.addMatchingTestsFromClass(suite, clazz, pat);
            return suite;
        }
        return new TestSuite(clazz);
    }

    public static Test suiteWhenStandalone(Class<? extends TestCase> clazz, String regex, TestMode ... testModes) {
        return ProxySuiteHelper.suiteWhenStandalone(clazz, regex, Collections.singleton(BufferMode.Transient), testModes);
    }

    public static TestSuite suiteWithOptionalProxy(String name, Set<BufferMode> bufferModes, TestMode ... testMode) {
        if (!proxyIndexManagerTestingHasStarted) {
            proxyIndexManagerTestingHasStarted = true;
            return new MultiModeTestSuite(name, bufferModes, testMode);
        }
        return new TestSuite(name);
    }

    public static TestSuite suiteWithOptionalProxy(String name, TestMode ... testMode) {
        return ProxySuiteHelper.suiteWithOptionalProxy(name, Collections.singleton(BufferMode.Transient), testMode);
    }

    private static void addMatchingTestsFromClass(TestSuite suite3, Class<? extends TestCase> clazz, Pattern pat) {
        for (Method m : clazz.getMethods()) {
            if (m.getParameterTypes().length != 0 || !pat.matcher(m.getName()).matches()) continue;
            suite3.addTest(ProxySuiteHelper.createTest(clazz, m.getName()));
        }
    }

    private static Test createTest(Class<? extends TestCase> clazz, String name) {
        try {
            Constructor cons = TestSuite.getTestConstructor(clazz);
            if (cons.getParameterTypes().length == 1) {
                return (Test)cons.newInstance(name);
            }
            TestCase test = (TestCase)cons.newInstance(new Object[0]);
            test.setName(name);
            return test;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Failed to find constructor");
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static class MultiModeTestSuite
    extends TestSuite {
        private final ProxyTestSuite[] subs;

        public MultiModeTestSuite(String name, Set<BufferMode> bufferModes, TestMode ... testModes) {
            super(name);
            if (bufferModes.isEmpty()) {
                throw new IllegalArgumentException();
            }
            int ntests = testModes.length * bufferModes.size();
            this.subs = new ProxyTestSuite[ntests];
            int i = 0;
            for (BufferMode bufferMode : bufferModes) {
                for (TestMode testMode : testModes) {
                    final ProxyTestSuite suite2 = TestNanoSparqlServerWithProxyIndexManager.createProxyTestSuite((IIndexManager)TestNanoSparqlServerWithProxyIndexManager.getTemporaryJournal(bufferMode), testMode);
                    super.addTest((Test)new TestSetup((Test)suite2){

                        protected void setUp() throws Exception {
                        }

                        protected void tearDown() throws Exception {
                            ((TestNanoSparqlServerWithProxyIndexManager)suite2.getDelegate()).tearDownAfterSuite();
                        }
                    });
                    this.subs[i++] = suite2;
                }
            }
        }

        public void addTestSuite(Class clazz) {
            for (ProxyTestSuite s : this.subs) {
                s.addTestSuite(clazz);
            }
        }

        public void addTest(Test test) {
            for (ProxyTestSuite s : this.subs) {
                s.addTest(ProxySuiteHelper.cloneTest(s.getDelegate(), test));
            }
        }
    }

    private static class CloningTestSuite
    extends ProxyTestSuite {
        public CloningTestSuite(Test delegate, String name) {
            super(delegate, name);
        }

        public void addTest(Test test) {
            super.addTest(ProxySuiteHelper.cloneTest(this.getDelegate(), test));
        }
    }
}

