/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp;

import com.bigdata.journal.IIndexManager;
import com.bigdata.rdf.sail.webapp.AbstractIndexManagerTestCase;
import java.util.Properties;
import junit.extensions.proxy.IProxyTest;
import junit.framework.Test;

public abstract class ProxyTestCase<S extends IIndexManager>
extends AbstractIndexManagerTestCase<S>
implements IProxyTest {
    private AbstractIndexManagerTestCase<S> m_delegate = null;
    private int startupActiveThreads = 0;
    private static boolean s_checkThreads = true;

    public ProxyTestCase() {
    }

    public ProxyTestCase(String name) {
        super(name);
    }

    public void setDelegate(Test delegate) {
        this.m_delegate = (AbstractIndexManagerTestCase)delegate;
    }

    public Test getDelegate() throws IllegalStateException {
        return this.m_delegate;
    }

    public AbstractIndexManagerTestCase<S> getOurDelegate() {
        if (this.m_delegate == null) {
            String testClass = System.getProperty("testClass");
            if (testClass == null) {
                throw new IllegalStateException("testClass: property not defined, could not configure delegate.");
            }
            try {
                Class<?> cl = Class.forName(testClass);
                this.m_delegate = (AbstractIndexManagerTestCase)((Object)cl.newInstance());
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        if (this.m_delegate instanceof AbstractIndexManagerTestCase) {
            return this.m_delegate;
        }
        throw new IllegalStateException("The delegate MUST extend " + AbstractIndexManagerTestCase.class.getName() + ", not " + ((Object)this.m_delegate).getClass().getName());
    }

    public void setUp() throws Exception {
        this.startupActiveThreads = Thread.currentThread().getThreadGroup().activeCount();
        this.getOurDelegate().setUp(this);
    }

    @Override
    public void tearDown() throws Exception {
        ThreadGroup grp;
        int tearDownActiveThreads;
        this.getOurDelegate().tearDown(this);
        if (s_checkThreads && this.startupActiveThreads != (tearDownActiveThreads = (grp = Thread.currentThread().getThreadGroup()).activeCount())) {
            Thread[] threads = new Thread[tearDownActiveThreads];
            grp.enumerate(threads);
            StringBuilder info = new StringBuilder();
            boolean first = true;
            for (Thread t : threads) {
                if (t == null) continue;
                if (!first) {
                    info.append(',');
                }
                info.append("[" + t.getName() + "]");
                first = false;
            }
            String failMessage = "Threads left active after task: test=" + this.getName() + ", delegate=" + ((Object)this.getOurDelegate()).getClass().getName() + ", startupCount=" + this.startupActiveThreads + ", teardownCount=" + tearDownActiveThreads + ", thisThread=" + Thread.currentThread().getName() + ", threads: " + info;
            if (grp.activeCount() != this.startupActiveThreads) {
                log.error((Object)failMessage);
            }
            for (int i = 0; i < 20; ++i) {
                Thread.sleep(100L);
                if (grp.activeCount() != this.startupActiveThreads) break;
            }
        }
        super.tearDown();
    }

    @Override
    public Properties getProperties() {
        return this.getOurDelegate().getProperties();
    }

    @Override
    public S getIndexManager() {
        return this.getOurDelegate().getIndexManager();
    }
}

