/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp;

import com.bigdata.BigdataStatics;
import com.bigdata.bop.engine.QueryTimeoutException;
import com.bigdata.journal.BufferMode;
import com.bigdata.journal.IIndexManager;
import com.bigdata.rdf.sail.webapp.AbstractTestNanoSparqlClient;
import com.bigdata.rdf.sail.webapp.ProxySuiteHelper;
import com.bigdata.rdf.sail.webapp.TestMode;
import com.bigdata.rdf.sail.webapp.client.RemoteRepository;
import com.bigdata.rdf.sail.webapp.client.RemoteRepositoryManager;
import com.bigdata.relation.accesspath.BufferClosedException;
import com.bigdata.testutil.ExperimentDriver;
import com.bigdata.util.DaemonThreadFactory;
import com.bigdata.util.InnerCause;
import java.nio.channels.ClosedByInterruptException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import junit.framework.Test;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.StatementImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.query.BindingSet;
import org.openrdf.query.TupleQueryResult;

public class StressTestConcurrentRestApiRequests<S extends IIndexManager>
extends AbstractTestNanoSparqlClient<S> {
    private static final String EX_NS = "http://example.org/";
    private Collection<RestApiOp> restApiOps;
    private SharedTestState sharedTestState;

    public StressTestConcurrentRestApiRequests() {
    }

    public StressTestConcurrentRestApiRequests(String name) {
        super(name);
    }

    public static Test suite() {
        return ProxySuiteHelper.suiteWhenStandalone(StressTestConcurrentRestApiRequests.class, "test.*", new LinkedHashSet<BufferMode>(Arrays.asList(BufferMode.MemStore)), TestMode.quads);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.restApiOps = new LinkedList<RestApiOp>();
        this.sharedTestState = new SharedTestState(this.getTestMode());
        this.setupOperationMixture(this.getTestMode());
    }

    @Override
    public void tearDown() throws Exception {
        this.restApiOps = null;
        this.sharedTestState = null;
        super.tearDown();
    }

    private void setupOperationMixture(TestMode testMode) {
        this.restApiOps.add(new SparqlTupleQueryOp(this.sharedTestState, "SELECT (COUNT(*) as ?count) WHERE {?x foaf:name ?y }"));
        this.restApiOps.add(new SparqlGraphQueryOp(this.sharedTestState, "CONSTRUCT WHERE {?x foaf:name ?y }"));
        this.restApiOps.add(new SparqlBooleanQueryOp(this.sharedTestState, "ASK WHERE {?x foaf:name ?y }"));
        this.restApiOps.add(new DropAll(this.sharedTestState).setOperationFrequency(0.01));
        this.restApiOps.add(new SparqlUpdate(this.sharedTestState, "LOAD <file:src/test/java/com/bigdata/rdf/sail/webapp/dataset-update.trig>"));
        this.restApiOps.add(new SparqlUpdate(this.sharedTestState, "INSERT {?x rdfs:label ?y . } WHERE {?x foaf:name ?y }"));
        if (testMode == TestMode.quads) {
            this.restApiOps.add(new SparqlUpdate(this.sharedTestState, "INSERT {GRAPH ?g {?x rdfs:label ?y . }} WHERE {GRAPH ?g {?x foaf:name ?y }}"));
        }
        this.restApiOps.add(new InsertWithBody(this.sharedTestState, 1000).setOperationFrequency(0.2));
        this.restApiOps.add(new InsertWithBody(this.sharedTestState, 10000).setOperationFrequency(0.01));
        this.restApiOps.add(new DeleteWithBody(this.sharedTestState, 1000).setOperationFrequency(0.2));
        this.restApiOps.add(new DeleteWithBody(this.sharedTestState, 10000).setOperationFrequency(0.01));
        this.restApiOps.add(new DESCRIBE_DATA_SETS(this.sharedTestState).setOperationFrequency(0.05));
        this.restApiOps.add(new CREATE_DATA_SET(this.sharedTestState).setOperationFrequency(0.03));
        this.restApiOps.add(new LIST_PROPERTIES(this.sharedTestState).setOperationFrequency(0.2));
        this.restApiOps.add(new DESTROY_DATA_SET(this.sharedTestState).setOperationFrequency(0.01));
    }

    private static String getNamespaceDeclarations() {
        StringBuilder declarations = new StringBuilder();
        declarations.append("PREFIX ex: <http://example.org/> \n");
        declarations.append("\n");
        return declarations.toString();
    }

    public void test_concurrentClients() throws Exception {
        if (!BigdataStatics.runKnownBadTests) {
            return;
        }
        this.doConcurrentClientTest(this.m_mgr, 10L, TimeUnit.SECONDS, 16, 20, 4000, 1000L, 1000L, TimeUnit.MILLISECONDS);
    }

    public void stressTest_concurrentClients_10Minutes() throws Exception {
        this.doConcurrentClientTest(this.m_mgr, 10L, TimeUnit.MINUTES, 16, 20, 0x100000, 5000L, 5000L, TimeUnit.MILLISECONDS);
    }

    public void stressTest_concurrentClients_2Hours() throws Exception {
        this.doConcurrentClientTest(this.m_mgr, 2L, TimeUnit.HOURS, 16, 20, 0x100000, 5000L, 5000L, TimeUnit.MILLISECONDS);
    }

    public void stressTest_concurrentClients_24Hours() throws Exception {
        this.doConcurrentClientTest(this.m_mgr, 24L, TimeUnit.HOURS, 16, 20, 0x100000, 5000L, 5000L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExperimentDriver.Result doConcurrentClientTest(RemoteRepositoryManager rmgr, long timeout, TimeUnit unit, int nthreads, int initialNamespacesCount, int ntrials, long initialDelayInterrupts, long periodInterrupts, TimeUnit unitInterrupts) throws Exception {
        long elapsedNanos;
        int i;
        if (rmgr == null) {
            throw new IllegalArgumentException();
        }
        if (timeout <= 0L) {
            throw new IllegalArgumentException();
        }
        if (unit == null) {
            throw new IllegalArgumentException();
        }
        if (nthreads <= 0) {
            throw new IllegalArgumentException();
        }
        if (initialNamespacesCount <= 0) {
            throw new IllegalArgumentException();
        }
        if (ntrials <= 0) {
            throw new IllegalArgumentException();
        }
        Random r = new Random();
        this.sharedTestState.minimumNamespaceCount.set(initialNamespacesCount);
        for (int i2 = 0; i2 < initialNamespacesCount; ++i2) {
            CREATE_DATA_SET op = new CREATE_DATA_SET(this.sharedTestState);
            op.newInstance(rmgr).call();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Created " + initialNamespacesCount + " initial nammespaces"));
        }
        LinkedHashSet<Callable<Void>> tasks = new LinkedHashSet<Callable<Void>>();
        RestApiOp[] ops = this.restApiOps.toArray(new RestApiOp[0]);
        double[] p = new double[ops.length];
        double sum = 0.0;
        for (i = 0; i < ops.length; ++i) {
            p[i] = ops[i].operationProbability;
            sum += p[i];
        }
        if (sum == 0.0) {
            throw new AssertionError((Object)"No assigned probabilities");
        }
        i = 0;
        while (i < ops.length) {
            int n = i++;
            p[n] = p[n] / sum;
        }
        sum = 0.0;
        for (i = 0; i < ops.length; ++i) {
            sum += p[i];
        }
        assert (sum <= 1.01) : "sum=" + sum + "::" + Arrays.toString(p);
        assert (sum >= 0.99) : "sum=" + sum + "::" + Arrays.toString(p);
        for (int trial = 0; trial < ntrials; ++trial) {
            double d = r.nextDouble();
            double sum2 = 0.0;
            int indexOf = -1;
            for (int i3 = 0; i3 < ops.length; ++i3) {
                if (!((sum2 += p[i3]) >= d)) continue;
                indexOf = i3;
                break;
            }
            if (indexOf == -1) {
                indexOf = ops.length - 1;
            }
            RestApiOp op = ops[indexOf];
            tasks.add(op.newInstance(rmgr));
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Submitting " + tasks.size() + " tasks"));
        }
        long beginNanos = System.nanoTime();
        ExecutorService executorService = Executors.newFixedThreadPool(nthreads, DaemonThreadFactory.defaultThreadFactory());
        ScheduledExecutorService scheduledExecutor = Executors.newSingleThreadScheduledExecutor(DaemonThreadFactory.defaultThreadFactory());
        int nfailed = 0;
        int ninterrupt = 0;
        int ncommitted = 0;
        int nuncommitted = 0;
        if (periodInterrupts > 0L) {
            scheduledExecutor.scheduleWithFixedDelay(new InterruptTask(rmgr, r), initialDelayInterrupts, periodInterrupts, unitInterrupts);
        }
        try {
            List results = executorService.invokeAll(tasks, timeout, unit);
            elapsedNanos = System.nanoTime() - beginNanos;
            for (Future future : results) {
                if (future.isCancelled()) {
                    ++nuncommitted;
                    continue;
                }
                try {
                    future.get();
                    ++ncommitted;
                }
                catch (ExecutionException ex) {
                    if (StressTestConcurrentRestApiRequests.isInnerCause((Throwable)ex, InterruptedException.class) || StressTestConcurrentRestApiRequests.isInnerCause((Throwable)ex, ClosedByInterruptException.class)) {
                        log.warn((Object)("Interrupted: " + ex));
                        ++ninterrupt;
                        continue;
                    }
                    StressTestConcurrentRestApiRequests.fail((String)("Not expecting: " + ex), (Throwable)ex);
                }
            }
        }
        finally {
            executorService.shutdownNow();
            scheduledExecutor.shutdownNow();
        }
        ExperimentDriver.Result ret = new ExperimentDriver.Result();
        ret.put((Object)"nfailed", (Object)("" + nfailed));
        ret.put((Object)"ncommitted", (Object)("" + ncommitted));
        ret.put((Object)"ninterrupt", (Object)("" + ninterrupt));
        ret.put((Object)"nuncommitted", (Object)("" + nuncommitted));
        ret.put((Object)"elapsed(ms)", (Object)("" + TimeUnit.NANOSECONDS.toMillis(elapsedNanos)));
        ret.put((Object)"tasks/sec", (Object)("" + (long)(ncommitted * 1000) / TimeUnit.NANOSECONDS.toMillis(elapsedNanos)));
        log.warn((Object)ret.toString(true));
        if (nfailed > 0) {
            StressTestConcurrentRestApiRequests.fail((String)("Test failed: " + ret.toString()));
        }
        return ret;
    }

    private static class LIST_PROPERTIES
    extends RestApiOp {
        LIST_PROPERTIES(SharedTestState sharedTestState) {
            super(sharedTestState, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doApply(RemoteRepositoryManager rmgr, UUID uuid) throws Exception {
            String namespace = this.lockRandomNamespace();
            try {
                rmgr.getRepositoryProperties(namespace, uuid);
            }
            finally {
                this.unlockNamespace(namespace);
            }
        }
    }

    private static class DESCRIBE_DATA_SETS
    extends RepositoryManagerOp {
        DESCRIBE_DATA_SETS(SharedTestState sharedTestState) {
            super(sharedTestState, true, "mock-namespace-" + UUID.randomUUID());
        }

        @Override
        protected Callable<Void> getTask(final RemoteRepositoryManager rmgr, final UUID uuid) {
            return new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    rmgr.getRepositoryDescriptions(uuid);
                    return null;
                }
            };
        }
    }

    private static class DESTROY_DATA_SET
    extends RestApiOp {
        DESTROY_DATA_SET(SharedTestState sharedTestState) {
            super(sharedTestState, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doApply(final RemoteRepositoryManager rmgr, final UUID uuid) throws Exception {
            final AtomicBoolean success = new AtomicBoolean(false);
            final String namespace = this.lockRandomNamespaceExclusive();
            try {
                FutureTask<Void> ft = new FutureTask<Void>(new Callable<Void>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Void call() throws Exception {
                        DESTROY_DATA_SET.this.sharedTestState.destroyNamespaceLock.lock();
                        try {
                            if (DESTROY_DATA_SET.this.sharedTestState.namespaceExistCounter.get() <= DESTROY_DATA_SET.this.sharedTestState.minimumNamespaceCount.get()) {
                                log.warn((Object)("AT NAMESPACE MINIMUM: min=" + DESTROY_DATA_SET.this.sharedTestState.minimumNamespaceCount + ", cur=" + DESTROY_DATA_SET.this.sharedTestState.namespaceExistCounter));
                                Void void_ = null;
                                return void_;
                            }
                            rmgr.deleteRepository(namespace, uuid);
                            success.set(true);
                        }
                        finally {
                            DESTROY_DATA_SET.this.sharedTestState.destroyNamespaceLock.unlock();
                        }
                        return null;
                    }
                });
                this.begin(namespace, uuid, ft);
                ft.run();
                try {
                    ft.get();
                }
                finally {
                    this.done(namespace, uuid);
                }
            }
            finally {
                this.unlockNamespaceExclusive(namespace, success.get());
            }
        }
    }

    private static class CREATE_DATA_SET
    extends RestApiOp {
        CREATE_DATA_SET(SharedTestState sharedTestState) {
            super(sharedTestState, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doApply(final RemoteRepositoryManager rmgr, UUID uuid) throws Exception {
            final String namespace = "n" + this.sharedTestState.namespaceCreateCounter.incrementAndGet();
            FutureTask<Void> ft = new FutureTask<Void>(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    Properties properties = new Properties(CREATE_DATA_SET.this.sharedTestState.testMode.getProperties());
                    rmgr.createRepository(namespace, properties);
                    if (CREATE_DATA_SET.this.sharedTestState.namespaces.putIfAbsent(namespace, new ReentrantReadWriteLock()) != null) {
                        throw new AssertionError((Object)("namespace=" + namespace));
                    }
                    CREATE_DATA_SET.this.sharedTestState.namespaceExistCounter.incrementAndGet();
                    return null;
                }
            });
            this.begin(namespace, uuid, ft);
            ft.run();
            try {
                ft.get();
            }
            finally {
                this.done(namespace, uuid);
            }
        }
    }

    private static abstract class RepositoryManagerOp
    extends RestApiOp {
        protected final String namespace;

        RepositoryManagerOp(SharedTestState sharedTestState, boolean readOnly, String namespace) {
            super(sharedTestState, readOnly);
            if (namespace == null) {
                throw new IllegalArgumentException();
            }
            this.namespace = namespace;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected final void doApply(RemoteRepositoryManager rmgr, UUID uuid) throws Exception {
            FutureTask<Void> ft = new FutureTask<Void>(this.getTask(rmgr, uuid));
            this.begin(this.namespace, uuid, ft);
            ft.run();
            try {
                ft.get();
            }
            finally {
                this.done(this.namespace, uuid);
            }
        }

        protected abstract Callable<Void> getTask(RemoteRepositoryManager var1, UUID var2);
    }

    private static class DeleteWithBody
    extends RandomNamespaceOp {
        private final boolean quads;
        private final int batchSize;

        DeleteWithBody(SharedTestState sharedTestState, int batchSize) {
            super(sharedTestState, false);
            if (batchSize <= 0) {
                throw new IllegalArgumentException();
            }
            this.batchSize = batchSize;
            this.quads = sharedTestState.testMode == TestMode.quads;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doApplyToNamespace(RemoteRepository repo, UUID uuid) throws Exception {
            ValueFactoryImpl vf = ValueFactoryImpl.getInstance();
            ArrayList<Statement> stmts = new ArrayList<Statement>(this.batchSize);
            try (TupleQueryResult result = null;){
                result = this.quads ? repo.prepareTupleQuery("SELECT * WHERE {GRAPH ?g {?s ?p ?o} }").evaluate() : repo.prepareTupleQuery("SELECT * WHERE {?s ?p ?o}").evaluate();
                while (result.hasNext() && stmts.size() < this.batchSize) {
                    BindingSet bset = (BindingSet)result.next();
                    Resource s = (Resource)bset.getBinding("s").getValue();
                    URI p = (URI)bset.getBinding("p").getValue();
                    Value o = bset.getBinding("o").getValue();
                    Resource g = (Resource)(this.quads ? bset.getBinding("g").getValue() : null);
                    Statement stmt = this.quads ? vf.createStatement(s, p, o, g) : vf.createStatement(s, p, o);
                    stmts.add(stmt);
                }
            }
            repo.remove(new RemoteRepository.RemoveOp(stmts), uuid);
        }
    }

    private static class InsertWithBody
    extends RandomNamespaceOp {
        private final int batchSize;

        InsertWithBody(SharedTestState sharedTestState, int batchSize) {
            super(sharedTestState, false);
            if (batchSize <= 0) {
                throw new IllegalArgumentException();
            }
            this.batchSize = batchSize;
        }

        @Override
        protected void doApplyToNamespace(RemoteRepository repo, UUID uuid) throws Exception {
            ArrayList<Statement> stmts = new ArrayList<Statement>(this.batchSize);
            for (int i = 0; i < this.batchSize; ++i) {
                stmts.add(InsertWithBody.generateTriple());
            }
            RemoteRepository.AddOp op = new RemoteRepository.AddOp(stmts);
            repo.add(op, uuid);
        }

        private static Statement generateTriple() {
            return new StatementImpl((Resource)new URIImpl(StressTestConcurrentRestApiRequests.EX_NS + UUID.randomUUID()), (URI)new URIImpl(StressTestConcurrentRestApiRequests.EX_NS + UUID.randomUUID()), (Value)new URIImpl(StressTestConcurrentRestApiRequests.EX_NS + UUID.randomUUID()));
        }
    }

    private static class DropAll
    extends SparqlUpdate {
        DropAll(SharedTestState sharedTestState) {
            super(sharedTestState, "DROP ALL");
        }
    }

    private static class SparqlUpdate
    extends RandomNamespaceOp {
        private final String updateStr;

        SparqlUpdate(SharedTestState sharedTestState, String updateStr) {
            super(sharedTestState, false);
            this.updateStr = StressTestConcurrentRestApiRequests.getNamespaceDeclarations() + updateStr;
        }

        @Override
        protected void doApplyToNamespace(RemoteRepository repo, UUID uuid) throws Exception {
            repo.prepareUpdate(this.updateStr, uuid).evaluate();
        }
    }

    private static class SparqlBooleanQueryOp
    extends RandomNamespaceOp {
        private final String queryStr;

        SparqlBooleanQueryOp(SharedTestState sharedTestState, String queryStr) {
            super(sharedTestState, true);
            this.queryStr = StressTestConcurrentRestApiRequests.getNamespaceDeclarations() + queryStr;
        }

        @Override
        protected void doApplyToNamespace(RemoteRepository repo, UUID uuid) throws Exception {
            repo.prepareBooleanQuery(this.queryStr, uuid).evaluate();
        }
    }

    private static class SparqlGraphQueryOp
    extends RandomNamespaceOp {
        private final String queryStr;

        SparqlGraphQueryOp(SharedTestState sharedTestState, String queryStr) {
            super(sharedTestState, true);
            this.queryStr = StressTestConcurrentRestApiRequests.getNamespaceDeclarations() + queryStr;
        }

        @Override
        protected void doApplyToNamespace(RemoteRepository repo, UUID uuid) throws Exception {
            repo.prepareGraphQuery(this.queryStr, uuid).evaluate();
        }
    }

    private static class SparqlTupleQueryOp
    extends RandomNamespaceOp {
        private final String queryStr;

        SparqlTupleQueryOp(SharedTestState sharedTestState, String queryStr) {
            super(sharedTestState, true);
            this.queryStr = StressTestConcurrentRestApiRequests.getNamespaceDeclarations() + queryStr;
        }

        @Override
        protected void doApplyToNamespace(RemoteRepository repo, UUID uuid) throws Exception {
            repo.prepareTupleQuery(this.queryStr, uuid).evaluate();
        }
    }

    private static abstract class RandomNamespaceOp
    extends RestApiOp {
        RandomNamespaceOp(SharedTestState sharedTestState, boolean readOnly) {
            super(sharedTestState, readOnly);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected final void doApply(RemoteRepositoryManager rmgr, final UUID uuid) throws Exception {
            String namespace = this.lockRandomNamespace();
            try {
                final RemoteRepository repo = rmgr.getRepositoryForNamespace(namespace);
                FutureTask<Void> ft = new FutureTask<Void>(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        RandomNamespaceOp.this.doApplyToNamespace(repo, uuid);
                        return null;
                    }
                });
                this.begin(namespace, uuid, ft);
                ft.run();
                try {
                    ft.get();
                }
                finally {
                    this.done(namespace, uuid);
                }
            }
            finally {
                this.unlockNamespace(namespace);
            }
        }

        protected abstract void doApplyToNamespace(RemoteRepository var1, UUID var2) throws Exception;
    }

    private static abstract class RestApiOp {
        protected final SharedTestState sharedTestState;
        private final boolean readOnly;
        private double operationProbability = 1.0;
        private long beginNanos = -1L;

        public String toString() {
            return this.getClass().getSimpleName();
        }

        RestApiOp(SharedTestState sharedTestState, boolean readOnly) {
            if (sharedTestState == null) {
                throw new IllegalArgumentException();
            }
            this.sharedTestState = sharedTestState;
            this.readOnly = readOnly;
        }

        public RestApiOp setOperationFrequency(double newValue) {
            if (newValue < 0.0 || newValue >= 1.0) {
                throw new IllegalArgumentException();
            }
            this.operationProbability = newValue;
            return this;
        }

        public Callable<Void> newInstance(RemoteRepositoryManager rmgr) {
            if (rmgr == null) {
                throw new IllegalArgumentException();
            }
            return new InnerCallable(rmgr);
        }

        protected UUID begin(String namespace, UUID uuid, FutureTask<Void> ft) {
            this.beginNanos = System.nanoTime();
            this.sharedTestState.activeTasks.put(this, namespace);
            this.sharedTestState.futures.put(uuid, new FutureAndTask(ft, this));
            if (log.isInfoEnabled()) {
                log.info((Object)("Call: nactive=" + this.sharedTestState.nacting.incrementAndGet() + ", namespace=" + namespace + ", op=" + this.toString() + ", active=" + this.sharedTestState.activeTasks.entrySet().toString()));
            }
            return uuid;
        }

        protected void done(String namespace, UUID uuid) {
            long elapsedNanos = System.nanoTime() - this.beginNanos;
            this.sharedTestState.activeTasks.remove(this, namespace);
            this.sharedTestState.futures.remove(uuid);
            if (log.isInfoEnabled()) {
                log.info((Object)("Done: nactive=" + this.sharedTestState.nacting.decrementAndGet() + ", namespace=" + namespace + ", op=" + this.toString() + ", elapsed=" + TimeUnit.NANOSECONDS.toMillis(elapsedNanos) + "ms" + ", active=" + this.sharedTestState.activeTasks.entrySet().toString()));
            }
        }

        protected String lockRandomNamespaceExclusive() {
            return this.sharedTestState.lockRandomNamespace(false);
        }

        protected void unlockNamespaceExclusive(String namespace, boolean remove) {
            this.sharedTestState.unlockNamespace(namespace, false, remove);
        }

        protected String lockRandomNamespace() {
            return this.sharedTestState.lockRandomNamespace(true);
        }

        protected void unlockNamespace(String namespace) {
            this.sharedTestState.unlockNamespace(namespace, true, false);
        }

        protected abstract void doApply(RemoteRepositoryManager var1, UUID var2) throws Exception;

        private class InnerCallable
        implements Callable<Void> {
            private final RemoteRepositoryManager rmgr;

            InnerCallable(RemoteRepositoryManager rmgr) {
                if (rmgr == null) {
                    throw new IllegalArgumentException();
                }
                this.rmgr = rmgr;
            }

            @Override
            public final Void call() throws Exception {
                UUID uuid = UUID.randomUUID();
                try {
                    RestApiOp.this.sharedTestState.nrunning.incrementAndGet();
                    RestApiOp.this.doApply(this.rmgr, uuid);
                    Void void_ = null;
                    return void_;
                }
                catch (Throwable t) {
                    if (this.isTerminationByInterrupt(t)) {
                        if (log.isInfoEnabled()) {
                            log.info((Object)t);
                        }
                        InterruptedException ex = new InterruptedException(this.toString());
                        ex.initCause(t);
                        throw ex;
                    }
                    if (t instanceof Exception) {
                        throw (Exception)t;
                    }
                    throw new RuntimeException(this.toString(), t);
                }
                finally {
                    RestApiOp.this.sharedTestState.nrunning.decrementAndGet();
                }
            }

            private boolean isTerminationByInterrupt(Throwable cause) {
                if (InnerCause.isInnerCause((Throwable)cause, InterruptedException.class)) {
                    return true;
                }
                if (InnerCause.isInnerCause((Throwable)cause, CancellationException.class)) {
                    return true;
                }
                if (InnerCause.isInnerCause((Throwable)cause, ClosedByInterruptException.class)) {
                    return true;
                }
                if (InnerCause.isInnerCause((Throwable)cause, BufferClosedException.class)) {
                    return true;
                }
                return InnerCause.isInnerCause((Throwable)cause, QueryTimeoutException.class);
            }
        }
    }

    private class InterruptTask
    implements Runnable {
        private final RemoteRepositoryManager rmgr;
        private final Random r;

        public InterruptTask(RemoteRepositoryManager rmgr, Random r) {
            if (rmgr == null) {
                throw new IllegalArgumentException();
            }
            if (r == null) {
                throw new IllegalArgumentException();
            }
            this.rmgr = rmgr;
            this.r = r;
        }

        @Override
        public void run() {
            UUID[] uuids = StressTestConcurrentRestApiRequests.this.sharedTestState.futures.keySet().toArray(new UUID[0]);
            if (uuids.length == 0) {
                return;
            }
            UUID uuid = uuids[this.r.nextInt(uuids.length)];
            FutureAndTask tmp = (FutureAndTask)StressTestConcurrentRestApiRequests.this.sharedTestState.futures.get(uuid);
            Future<Void> ft = tmp.f;
            ft.cancel(true);
            if (ft.isCancelled()) {
                log.warn((Object)("Cancelled task: op=" + tmp.op + ", uuid=" + uuid));
                try {
                    this.rmgr.cancel(uuid);
                }
                catch (Throwable t) {
                    log.warn((Object)t, t);
                }
            }
        }
    }

    private static class SharedTestState {
        private final TestMode testMode;
        private final AtomicLong nrunning = new AtomicLong();
        private final AtomicLong nacting = new AtomicLong();
        private final ConcurrentHashMap<RestApiOp, String> activeTasks = new ConcurrentHashMap();
        private final ConcurrentHashMap<UUID, FutureAndTask> futures = new ConcurrentHashMap();
        private final AtomicLong namespaceCreateCounter;
        private final AtomicLong namespaceExistCounter;
        private final AtomicLong minimumNamespaceCount;
        private final Lock destroyNamespaceLock;
        private final ConcurrentHashMap<String, ReadWriteLock> namespaces;
        private final Random r;

        public SharedTestState(TestMode testMode) {
            if (testMode == null) {
                throw new IllegalArgumentException();
            }
            this.testMode = testMode;
            this.r = new Random();
            this.namespaces = new ConcurrentHashMap();
            this.namespaceCreateCounter = new AtomicLong();
            this.namespaceExistCounter = new AtomicLong();
            this.minimumNamespaceCount = new AtomicLong();
            this.destroyNamespaceLock = new ReentrantLock();
        }

        private String lockRandomNamespace(boolean readOnly) {
            String namespace;
            int k = this.r.nextInt((int)this.namespaceExistCounter.get());
            int i = -1;
            block0: while (true) {
                Iterator<Map.Entry<String, ReadWriteLock>> i$ = this.namespaces.entrySet().iterator();
                while (true) {
                    if (!i$.hasNext()) continue block0;
                    Map.Entry<String, ReadWriteLock> e = i$.next();
                    if (this.namespaceExistCounter.get() == 0L) {
                        throw new RuntimeException("No namespaces? readOnly=" + readOnly);
                    }
                    if (++i < k) continue;
                    namespace = e.getKey();
                    ReadWriteLock lock = e.getValue();
                    Lock takenLock = readOnly ? lock.readLock() : lock.writeLock();
                    takenLock.lock();
                    if (this.namespaces.get(namespace) == lock) break block0;
                    takenLock.unlock();
                }
                break;
            }
            return namespace;
        }

        private void unlockNamespace(String namespace, boolean readOnly, boolean remove) {
            if (namespace == null) {
                throw new IllegalArgumentException();
            }
            if (remove && readOnly) {
                throw new IllegalStateException("Removal from map requires exclusive lock: namespace=" + namespace);
            }
            ReadWriteLock lock = this.namespaces.get(namespace);
            if (lock == null) {
                throw new IllegalStateException("Not locked: namespace=" + namespace);
            }
            if (remove && !this.namespaces.remove(namespace, lock)) {
                throw new AssertionError((Object)("Entry not found in map: " + namespace));
            }
            if (readOnly) {
                lock.readLock().unlock();
            } else {
                lock.writeLock().unlock();
            }
        }
    }

    private static class FutureAndTask {
        final Future<Void> f;
        final RestApiOp op;

        FutureAndTask(Future<Void> f, RestApiOp op) {
            if (f == null) {
                throw new IllegalArgumentException();
            }
            if (op == null) {
                throw new IllegalArgumentException();
            }
            this.f = f;
            this.op = op;
        }
    }
}

