/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp;

import com.bigdata.journal.BufferMode;
import com.bigdata.journal.IIndexManager;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.webapp.AbstractTestNanoSparqlClient;
import com.bigdata.rdf.sail.webapp.ProxySuiteHelper;
import com.bigdata.rdf.sail.webapp.TestMode;
import com.bigdata.rdf.sail.webapp.client.RemoteRepository;
import com.bigdata.util.DaemonThreadFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.Test;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.StatementImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.query.QueryEvaluationException;

public class StressTest_REST_MultiTenancy<S extends IIndexManager>
extends AbstractTestNanoSparqlClient<S> {
    private static final String URI_PREFIX = "http://bigdata.test/";

    public StressTest_REST_MultiTenancy() {
    }

    public StressTest_REST_MultiTenancy(String name) {
        super(name);
    }

    public static Test suite() {
        return ProxySuiteHelper.suiteWhenStandalone(StressTest_REST_MultiTenancy.class, "test.*", Collections.singleton(BufferMode.DiskRW), TestMode.quads);
    }

    public void test_multiTenancy_967() throws Exception {
    }

    public void test_multiTenancy_2023() throws Exception {
        String ns1 = "namespace1";
        String ns2 = "namespace2";
        String ns3 = "namespace3";
        this.createNamespace("namespace1");
        this.createNamespace("namespace2");
        this.createNamespace("namespace3");
        this.loadStatements("namespace1", 10000);
        this.loadStatements("namespace2", 10000);
        this.loadStatements("namespace3", 10000);
        this.simpleQuery("namespace1");
        this.simpleQuery("namespace2");
        this.simpleQuery("namespace3");
        try {
            this.forceAbort("namespace1");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.loadStatements("namespace2", 1000);
        try {
            this.forceAbort("namespace2");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.dropGraph("namespace2");
        this.dropGraph("namespace1");
        this.simpleQuery("namespace1");
        this.simpleQuery("namespace2");
        this.simpleQuery("namespace3");
        this.loadStatements("namespace2", 1000);
    }

    private void createNamespace(String namespace) throws Exception {
        Properties properties = TestMode.triplesPlusTruthMaintenance.getProperties();
        properties.put(BigdataSail.Options.NAMESPACE, namespace);
        log.warn((Object)String.format("Create namespace %s...", namespace));
        this.m_mgr.createRepository(namespace, properties);
        log.warn((Object)String.format("Create namespace %s done", namespace));
    }

    private void loadStatements(String namespace, int nstatements) throws Exception {
        ArrayList<Statement> stmts = new ArrayList<Statement>(nstatements);
        for (int i = 0; i < nstatements; ++i) {
            stmts.add(StressTest_REST_MultiTenancy.generateTriple());
        }
        log.warn((Object)String.format("Loading package into %s namespace...", namespace));
        this.m_mgr.getRepositoryForNamespace(namespace).add(new RemoteRepository.AddOp(stmts));
        log.warn((Object)String.format("Loading package into %s namespace done", namespace));
    }

    private void forceAbort(String namespace) throws Exception {
        RemoteRepository rr = this.m_mgr.getRepositoryForNamespace(namespace);
        rr.prepareUpdate("FORCE ABORT").evaluate();
    }

    private void dropGraph(String namespace) throws Exception {
        RemoteRepository rr = this.m_mgr.getRepositoryForNamespace(namespace);
        rr.prepareUpdate("DROP GRAPH <" + namespace + ">").evaluate();
    }

    private void simpleQuery(String namespace) throws QueryEvaluationException, Exception {
        log.warn((Object)String.format("Execute SPARQL on %s namespace...", namespace));
        this.m_mgr.getRepositoryForNamespace(namespace).prepareTupleQuery("SELECT * {?s ?p ?o} LIMIT 100").evaluate().close();
        log.warn((Object)String.format("Execute SPARQL on %s namespace done", namespace));
    }

    public void stressTest_multiTenancy_967() throws Exception {
        this.doMultiTenancyStressTest(TimeUnit.HOURS.toMillis(1L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doMultiTenancyStressTest(long timeoutMillis) throws Exception {
        final AtomicInteger namespaceCount = new AtomicInteger(0);
        final CountDownLatch latch = new CountDownLatch(2);
        final AtomicBoolean testSucceeding = new AtomicBoolean(true);
        final ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(20, DaemonThreadFactory.defaultThreadFactory());
        try {
            executor.submit(new Runnable(){

                @Override
                public void run() {
                    String namespace = "n" + namespaceCount.getAndIncrement();
                    Properties properties = new Properties();
                    properties.put("com.bigdata.rdf.sail.namespace", namespace);
                    try {
                        log.warn((Object)String.format("Create namespace %s...", namespace));
                        StressTest_REST_MultiTenancy.this.m_mgr.createRepository(namespace, properties);
                        log.warn((Object)String.format("Create namespace %s done", namespace));
                        latch.countDown();
                    }
                    catch (Exception e) {
                        log.error((Object)String.format("Failed to create namespace %s:", namespace), (Throwable)e);
                        testSucceeding.set(false);
                    }
                    if (testSucceeding.get()) {
                        executor.schedule(this, 5L, TimeUnit.SECONDS);
                    }
                }
            });
            executor.submit(new Runnable(){

                @Override
                public void run() {
                    String namespace = null;
                    try {
                        latch.await();
                        namespace = "n" + ThreadLocalRandom.current().nextInt(namespaceCount.get() - 1);
                        ArrayList<Statement> stmts = new ArrayList<Statement>(100000);
                        for (int i = 0; i < 100000; ++i) {
                            stmts.add(StressTest_REST_MultiTenancy.generateTriple());
                        }
                        log.warn((Object)String.format("Loading package into %s namespace...", namespace));
                        StressTest_REST_MultiTenancy.this.m_mgr.getRepositoryForNamespace(namespace).add(new RemoteRepository.AddOp(stmts));
                        log.warn((Object)String.format("Loading package into %s namespace done", namespace));
                    }
                    catch (Exception e) {
                        log.error((Object)String.format("Failed to load package into namespace %s:", namespace), (Throwable)e);
                        testSucceeding.set(false);
                    }
                    if (testSucceeding.get()) {
                        executor.schedule(this, 5L, TimeUnit.SECONDS);
                    }
                }
            });
            executor.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        log.warn((Object)"Get namespace list...");
                        StressTest_REST_MultiTenancy.this.m_mgr.getRepositoryDescriptions().close();
                        log.warn((Object)"Get namespace list done");
                    }
                    catch (Exception e) {
                        log.error((Object)"Failed to get namespace list:", (Throwable)e);
                        testSucceeding.set(false);
                    }
                    if (testSucceeding.get()) {
                        executor.schedule(this, 1L, TimeUnit.SECONDS);
                    }
                }
            });
            executor.submit(new Runnable(){

                @Override
                public void run() {
                    String namespace = null;
                    try {
                        latch.await();
                        namespace = "n" + ThreadLocalRandom.current().nextInt(namespaceCount.get() - 1);
                        log.warn((Object)String.format("Execute SPARQL on %s namespace...", namespace));
                        StressTest_REST_MultiTenancy.this.m_mgr.getRepositoryForNamespace(namespace).prepareTupleQuery("SELECT * {?s ?p ?o} LIMIT 100").evaluate().close();
                        log.warn((Object)String.format("Execute SPARQL on %s namespace done", namespace));
                    }
                    catch (Exception e) {
                        log.error((Object)String.format("Failed to execute SPARQL on %s namespace:", namespace), (Throwable)e);
                        testSucceeding.set(false);
                    }
                    if (testSucceeding.get()) {
                        executor.schedule(this, 1L, TimeUnit.SECONDS);
                    }
                }
            });
            long beginNanos = System.nanoTime();
            long timeoutNanos = TimeUnit.MILLISECONDS.toNanos(timeoutMillis);
            while (System.nanoTime() - beginNanos < timeoutNanos && testSucceeding.get()) {
                Thread.sleep(1000L);
            }
            log.warn((Object)"Stopping...");
        }
        finally {
            executor.shutdownNow();
            executor.awaitTermination(5L, TimeUnit.MINUTES);
        }
        log.info((Object)"Cleanup namespaces...");
        for (int i = 0; i < namespaceCount.get(); ++i) {
            this.m_mgr.deleteRepository("n" + i);
        }
    }

    private static Statement generateTriple() {
        return new StatementImpl((Resource)new URIImpl(URI_PREFIX + UUID.randomUUID()), (URI)new URIImpl(URI_PREFIX + UUID.randomUUID()), (Value)new URIImpl(URI_PREFIX + UUID.randomUUID()));
    }
}

