/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp;

import com.bigdata.journal.BufferMode;
import com.bigdata.journal.Options;
import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepository;
import com.bigdata.rdf.sail.BigdataSailRepositoryConnection;
import com.bigdata.rdf.sail.ProxyBigdataSailTestCase;
import com.bigdata.rdf.store.AbstractTripleStore;
import java.util.Properties;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.StatementImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.Update;

public class TestBLZG1943
extends ProxyBigdataSailTestCase {
    public TestBLZG1943() {
    }

    public TestBLZG1943(String name) {
        super(name);
    }

    public void testTicketBlzg1943() throws Exception {
        BigdataSail sail = this.getSail();
        BigdataSailRepository repo = new BigdataSailRepository(sail);
        try {
            repo.initialize();
            BigdataSailRepositoryConnection conn = repo.getConnection();
            conn.setAutoCommit(false);
            for (int i = 0; i < 500; ++i) {
                StatementImpl s1 = new StatementImpl((Resource)new URIImpl("http://s" + i), (URI)new URIImpl("http://lat"), (Value)new LiteralImpl("10.24884"));
                StatementImpl s2 = new StatementImpl((Resource)new URIImpl("http://s" + i), (URI)new URIImpl("http://lon"), (Value)new LiteralImpl("73.24884"));
                conn.add((Statement)s1, new Resource[0]);
                conn.add((Statement)s2, new Resource[0]);
            }
            conn.commit();
            TupleQuery validate = conn.prepareTupleQuery(QueryLanguage.SPARQL, "SELECT * WHERE { ?s ?p ?o }");
            TupleQueryResult res = validate.evaluate();
            int numTriples = 0;
            while (res.hasNext()) {
                res.next();
                ++numTriples;
            }
            TestBLZG1943.assertEquals((int)numTriples, (int)1000);
            res.close();
            conn.close();
            conn = repo.getConnection();
            for (int i = 0; i < 100; ++i) {
                StringBuilder sb = new StringBuilder();
                sb.append("PREFIX ogc: <http://www.opengis.net/ont/geosparql#> ");
                sb.append("insert { ?s ogc:asWKT ?wkt } where {     ?s <http://lat> ?lat. ?s <http://lon> ?long.     bind(strdt(concat(\"POINT(\",str(?long),\" \",str(?lat),\")\"),ogc:wktLiteral) as ?wkt) }");
                Update update = conn.prepareUpdate(QueryLanguage.SPARQL, sb.toString());
                update.execute();
            }
            conn.close();
        }
        catch (Exception e) {
            System.err.println("EXCEPTION: " + e.getMessage());
            throw e;
        }
        finally {
            repo.shutDown();
        }
    }

    @Override
    public Properties getProperties() {
        Properties properties = (Properties)super.getProperties().clone();
        properties.setProperty(AbstractTripleStore.Options.QUADS, "false");
        properties.setProperty(BigdataSail.Options.TRUTH_MAINTENANCE, "false");
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        properties.setProperty(Options.BUFFER_MODE, BufferMode.Transient.toString());
        properties.setProperty(AbstractTripleStore.Options.GEO_SPATIAL, "true");
        properties.setProperty(AbstractTripleStore.Options.GEO_SPATIAL_INCLUDE_BUILTIN_DATATYPES, "false");
        properties.setProperty(AbstractTripleStore.Options.GEO_SPATIAL_DATATYPE_CONFIG + ".0", "{\"config\": { \"uri\": \"http://www.opengis.net/ont/geosparql#wktLiteral\", \"literalSerializer\": \"com.bigdata.rdf.sparql.ast.eval.service.BLZG1943LiteralSerializer\",  \"fields\": [ { \"valueType\": \"DOUBLE\", \"multiplier\": \"1000000\", \"serviceMapping\": \"LONGITUDE\" }, { \"valueType\": \"DOUBLE\", \"multiplier\": \"1000000\", \"serviceMapping\": \"LATITUDE\" } ]}}");
        properties.setProperty(AbstractTripleStore.Options.GEO_SPATIAL_DEFAULT_DATATYPE, "http://www.opengis.net/ont/geosparql#wktLiteral");
        properties.setProperty(AbstractTripleStore.Options.VOCABULARY_CLASS, "com.bigdata.rdf.sparql.ast.eval.service.GeoSpatialTestVocabulary");
        return properties;
    }
}

