/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp;

import com.bigdata.journal.BufferMode;
import com.bigdata.journal.IIndexManager;
import com.bigdata.rdf.sail.webapp.AbstractTestNanoSparqlClient;
import com.bigdata.rdf.sail.webapp.ProxySuiteHelper;
import com.bigdata.rdf.sail.webapp.TestMode;
import com.bigdata.rdf.sail.webapp.client.RemoteRepository;
import com.bigdata.rdf.sail.webapp.client.RemoteRepositoryManager;
import java.io.File;
import java.util.Collections;
import java.util.UUID;
import junit.framework.Test;
import org.openrdf.rio.RDFFormat;

public class TestBackupServlet<S extends IIndexManager>
extends AbstractTestNanoSparqlClient<S> {
    static final String BASE = "com/bigdata/rdf/sail/webapp/";

    public TestBackupServlet() {
    }

    public TestBackupServlet(String name) {
        super(name);
    }

    public static Test suite() {
        return ProxySuiteHelper.suiteWhenStandalone(TestBackupServlet.class, "test_backup01", Collections.singleton(BufferMode.DiskRW), new TestMode[0]);
    }

    private void doLoadFile() throws Exception {
        this.loadFile(((Object)((Object)this)).getClass().getResource("sample-data.ttl").getFile(), RDFFormat.TURTLE);
    }

    protected void loadFile(String file, RDFFormat format) throws Exception {
        RemoteRepository.AddOp add = new RemoteRepository.AddOp(new File(file), format);
        this.m_repo.add(add);
    }

    public void test_backup01() throws Exception {
        this.doLoadFile();
        String fileStr = System.getProperty("java.io.tmpdir") + File.separator + UUID.randomUUID() + ".jnl";
        File randomFile = new File(fileStr);
        TestBackupServlet.assertTrue((!randomFile.exists() ? 1 : 0) != 0);
        RemoteRepositoryManager mgr = this.m_repo.getRemoteRepositoryManager();
        mgr.onlineBackup(fileStr, false, true);
        long uncomp_size = randomFile.length();
        TestBackupServlet.assertTrue((boolean)randomFile.exists());
        randomFile.delete();
        TestBackupServlet.assertTrue((!randomFile.exists() ? 1 : 0) != 0);
        mgr.onlineBackup(fileStr, true, true);
        TestBackupServlet.assertTrue((uncomp_size > randomFile.length() ? 1 : 0) != 0);
        TestBackupServlet.assertTrue((boolean)randomFile.exists());
        randomFile.delete();
        TestBackupServlet.assertTrue((!randomFile.exists() ? 1 : 0) != 0);
        mgr.onlineBackup(fileStr, false, false);
        int maxSleep = 100;
        for (int i = 0; !randomFile.exists() && i < 100; ++i) {
            Thread.sleep(2L);
        }
        TestBackupServlet.assertTrue((boolean)randomFile.exists());
        randomFile.delete();
        TestBackupServlet.assertTrue((!randomFile.exists() ? 1 : 0) != 0);
    }
}

