/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp;

import com.bigdata.journal.IIndexManager;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.remote.BigdataSailRemoteRepository;
import com.bigdata.rdf.sail.remote.BigdataSailRemoteRepositoryConnection;
import com.bigdata.rdf.sail.webapp.AbstractTestNanoSparqlClient;
import com.bigdata.rdf.sail.webapp.ProxySuiteHelper;
import com.bigdata.rdf.sail.webapp.TestMode;
import java.io.File;
import java.net.URL;
import java.util.Properties;
import junit.framework.Test;
import org.openrdf.model.Graph;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.LinkedHashModel;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.StatementImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.query.BooleanQuery;
import org.openrdf.query.GraphQuery;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.UpdateExecutionException;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.rio.RDFFormat;

public class TestBigdataSailRemoteRepository<S extends IIndexManager>
extends AbstractTestNanoSparqlClient<S> {
    protected BigdataSailRemoteRepository repo = null;
    protected BigdataSailRemoteRepositoryConnection cxn = null;
    protected static final String DEFAULT_PREFIX = "http://bigdata.com/";

    public TestBigdataSailRemoteRepository() {
    }

    public TestBigdataSailRemoteRepository(String name) {
        super(name);
    }

    public static Test suite() {
        return ProxySuiteHelper.suiteWhenStandalone(ReadWriteTx.class, "test_tx_begin_addStatement_commit.*", TestMode.quads);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.repo = this.m_repo.getBigdataSailRemoteRepository();
        this.cxn = this.repo.getConnection();
    }

    @Override
    public void tearDown() throws Exception {
        if (this.cxn != null) {
            this.cxn.close();
            this.cxn = null;
        }
        this.repo = null;
        super.tearDown();
    }

    protected String getNamespaceDeclarations() {
        StringBuilder declarations = new StringBuilder();
        declarations.append("PREFIX : <http://bigdata.com/> \n");
        declarations.append("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \n");
        declarations.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> \n");
        declarations.append("PREFIX foaf: <http://xmlns.com/foaf/0.1/> \n");
        declarations.append("PREFIX xsd: <http://www.w3.org/2001/XMLSchema#> \n");
        declarations.append("PREFIX dc: <http://purl.org/dc/elements/1.1/> \n");
        declarations.append("PREFIX ex: <http://example.org/> \n");
        declarations.append("\n");
        return declarations.toString();
    }

    @Override
    protected void doInsertWithBodyTest(String method, int ntriples, RDFFormat format) throws Exception {
        Graph g = this.genNTRIPLES2(ntriples);
        this.cxn.add((Iterable)g, new Resource[0]);
        TestBigdataSailRemoteRepository.assertEquals((long)ntriples, (long)this.getExactSize());
        String queryStr = "select * where {?s ?p ?o}";
        TupleQuery query = this.cxn.prepareTupleQuery(QueryLanguage.SPARQL, "select * where {?s ?p ?o}");
        TestBigdataSailRemoteRepository.assertEquals((long)ntriples, (long)TestBigdataSailRemoteRepository.countResults(query.evaluate()));
    }

    @Override
    protected long doInsertByBody(String method, RDFFormat rdfFormat, Graph g, URI defaultContext) throws Exception {
        Resource[] resourceArray;
        long start = this.getExactSize();
        if (defaultContext != null) {
            Resource[] resourceArray2 = new Resource[1];
            resourceArray = resourceArray2;
            resourceArray2[0] = defaultContext;
        } else {
            resourceArray = new Resource[]{};
        }
        this.cxn.add((Iterable)g, resourceArray);
        return this.getExactSize() - start;
    }

    @Override
    protected long doDeleteWithAccessPath(URI s, URI p, Value o, URI ... c) throws Exception {
        long start = this.getExactSize();
        this.cxn.remove((Resource)s, p, o, (Resource[])c);
        return start - this.getExactSize();
    }

    protected RepositoryResult<Statement> doGetWithAccessPath(URI s, URI p, Value o, URI ... c) throws Exception {
        return this.cxn.getStatements((Resource)s, p, o, false, (Resource[])c);
    }

    public void test_ASK() throws Exception {
        String queryStr = "ASK where {?s ?p ?o}";
        BooleanQuery query = this.cxn.prepareBooleanQuery(QueryLanguage.SPARQL, "ASK where {?s ?p ?o}");
        TestBigdataSailRemoteRepository.assertEquals((boolean)false, (boolean)query.evaluate());
    }

    public void test_SELECT_ALL() throws Exception {
        String queryStr = "select * where {?s ?p ?o}";
        TupleQuery query = this.cxn.prepareTupleQuery(QueryLanguage.SPARQL, "select * where {?s ?p ?o}");
        TestBigdataSailRemoteRepository.assertEquals((long)0L, (long)TestBigdataSailRemoteRepository.countResults(query.evaluate()));
    }

    public void test_GET_SELECT_ERROR() throws Exception {
        String queryStr = "select * where {?s ?p ?o} X {}";
        TupleQuery query = this.cxn.prepareTupleQuery(QueryLanguage.SPARQL, "select * where {?s ?p ?o} X {}");
        try {
            TestBigdataSailRemoteRepository.assertEquals((long)0L, (long)TestBigdataSailRemoteRepository.countResults(query.evaluate()));
            TestBigdataSailRemoteRepository.fail((String)"should be an error");
        }
        catch (QueryEvaluationException queryEvaluationException) {
            // empty catch block
        }
    }

    public void test_INSERT_withBody_RDFXML() throws Exception {
        this.doInsertWithBodyTest("POST", 23, RDFFormat.RDFXML);
    }

    public void test_INSERT_withBody_NTRIPLES() throws Exception {
        this.doInsertWithBodyTest("POST", 23, RDFFormat.NTRIPLES);
    }

    public void test_INSERT_withBody_N3() throws Exception {
        this.doInsertWithBodyTest("POST", 23, RDFFormat.N3);
    }

    public void test_INSERT_withBody_TURTLE() throws Exception {
        this.doInsertWithBodyTest("POST", 23, RDFFormat.TURTLE);
    }

    public void test_INSERT_withBody_TRIG() throws Exception {
        this.doInsertWithBodyTest("POST", 23, RDFFormat.TRIG);
    }

    public void test_INSERT_withBody_TRIX() throws Exception {
        this.doInsertWithBodyTest("POST", 23, RDFFormat.TRIX);
    }

    public void test_POST_INSERT_withBody_NQUADS() throws Exception {
        this.doInsertWithBodyTest("POST", 23, RDFFormat.NQUADS);
    }

    public void test_INSERT_triples_with_BODY_and_defaultContext() throws Exception {
        if (TestMode.quads != this.getTestMode()) {
            return;
        }
        String resource = "src/test/java/com/bigdata/rdf/sail/webapp/insert_triples_with_defaultContext.ttl";
        Graph g = this.loadGraphFromResource("src/test/java/com/bigdata/rdf/sail/webapp/insert_triples_with_defaultContext.ttl");
        this.doInsertByBody("POST", RDFFormat.TURTLE, g, (URI)new URIImpl("http://example.org"));
        String queryStr = "select * { GRAPH <http://example.org> {?s ?p ?p} }";
        TupleQuery query = this.cxn.prepareTupleQuery(QueryLanguage.SPARQL, "select * { GRAPH <http://example.org> {?s ?p ?p} }");
        TestBigdataSailRemoteRepository.assertEquals((long)7L, (long)TestBigdataSailRemoteRepository.countResults(query.evaluate()));
    }

    public void test_INSERT_triples_with_URI_and_defaultContext() throws Exception {
        if (TestMode.quads != this.getTestMode()) {
            return;
        }
        File file = new File("src/test/java/com/bigdata/rdf/sail/webapp/insert_triples_with_defaultContext.ttl");
        this.cxn.add(file, "", RDFFormat.TURTLE, new Resource[]{new URIImpl("http://example.org")});
        TestBigdataSailRemoteRepository.assertEquals((long)7L, (long)this.getExactSize());
        String queryStr = "select * { GRAPH <http://example.org> {?s ?p ?p} }";
        TupleQuery query = this.cxn.prepareTupleQuery(QueryLanguage.SPARQL, "select * { GRAPH <http://example.org> {?s ?p ?p} }");
        TestBigdataSailRemoteRepository.assertEquals((long)7L, (long)TestBigdataSailRemoteRepository.countResults(query.evaluate()));
    }

    public void test_INSERT_NQuads_by_URL() throws Exception {
        if (TestMode.quads != this.getTestMode()) {
            return;
        }
        String queryStr = "ASK where {?s ?p ?o}";
        BooleanQuery query = this.cxn.prepareBooleanQuery(QueryLanguage.SPARQL, "ASK where {?s ?p ?o}");
        TestBigdataSailRemoteRepository.assertEquals((boolean)false, (boolean)query.evaluate());
        long expectedStatementCount = 7L;
        URL url = new URL("file:src/test/java/com/bigdata/rdf/sail/webapp/quads.nq");
        this.cxn.add(url, "", RDFFormat.NQUADS, new Resource[0]);
        TestBigdataSailRemoteRepository.assertEquals((long)7L, (long)this.getExactSize());
        String queryStr2 = "SELECT * where {?s ?p ?o}";
        TupleQuery query2 = this.cxn.prepareTupleQuery(QueryLanguage.SPARQL, "SELECT * where {?s ?p ?o}");
        TestBigdataSailRemoteRepository.assertEquals((long)7L, (long)TestBigdataSailRemoteRepository.countResults(query2.evaluate()));
    }

    public void test_INSERT_veryLargeLiteral() throws Exception {
        LinkedHashModel g = new LinkedHashModel();
        URIImpl s = new URIImpl("http://www.bigdata.com/");
        URI p = RDFS.LABEL;
        Literal o = this.getVeryLargeLiteral();
        StatementImpl stmt = new StatementImpl((Resource)s, p, (Value)o);
        g.add((Object)stmt);
        TestBigdataSailRemoteRepository.assertEquals((long)1L, (long)this.doInsertByBody("POST", RDFFormat.RDFXML, (Graph)g, null));
        String queryStr = "DESCRIBE <" + s.stringValue() + ">";
        GraphQuery query = this.cxn.prepareGraphQuery(QueryLanguage.SPARQL, queryStr);
        Graph g2 = TestBigdataSailRemoteRepository.asGraph(query.evaluate());
        TestBigdataSailRemoteRepository.assertEquals((int)1, (int)g2.size());
        TestBigdataSailRemoteRepository.assertTrue((boolean)g2.match((Resource)s, p, (Value)o, new Resource[0]).hasNext());
    }

    public void test_INSERT_LOAD_FROM_URI() throws Exception {
        String queryStr = "ASK where {?s ?p ?o}";
        BooleanQuery query = this.cxn.prepareBooleanQuery(QueryLanguage.SPARQL, "ASK where {?s ?p ?o}");
        TestBigdataSailRemoteRepository.assertEquals((boolean)false, (boolean)query.evaluate());
        long expectedStatementCount = 4L;
        this.cxn.add(((Object)((Object)this)).getClass().getClassLoader().getResource("com/bigdata/rdf/rio/small.rdf"), "", RDFFormat.RDFXML, new Resource[0]);
        TestBigdataSailRemoteRepository.assertEquals((long)4L, (long)this.getExactSize());
        String queryStr2 = "SELECT * where {?s ?p ?o}";
        TupleQuery query2 = this.cxn.prepareTupleQuery(QueryLanguage.SPARQL, "SELECT * where {?s ?p ?o}");
        TestBigdataSailRemoteRepository.assertEquals((long)4L, (long)TestBigdataSailRemoteRepository.countResults(query2.evaluate()));
    }

    public void test_CONTEXTS() throws Exception {
        if (this.getTestMode() != TestMode.quads) {
            return;
        }
        this.doInsertbyURL("POST", "src/test/java/com/bigdata/rdf/sail/webapp/test_estcard.trig");
        RepositoryResult contexts = this.cxn.getContextIDs();
        int size = 0;
        while (contexts.hasNext()) {
            contexts.next();
            ++size;
        }
        TestBigdataSailRemoteRepository.assertEquals((int)3, (int)size);
    }

    public void test_DELETE_accessPath_delete_all() throws Exception {
        this.doInsertbyURL("POST", "src/test/java/com/bigdata/rdf/sail/webapp/test_delete_by_access_path.ttl");
        long mutationResult = this.doDeleteWithAccessPath(null, null, null, new URI[0]);
        TestBigdataSailRemoteRepository.assertEquals((long)7L, (long)mutationResult);
    }

    public void test_DELETE_accessPath_delete_s() throws Exception {
        this.doInsertbyURL("POST", "src/test/java/com/bigdata/rdf/sail/webapp/test_delete_by_access_path.ttl");
        long mutationResult = this.doDeleteWithAccessPath((URI)new URIImpl("http://www.bigdata.com/Mike"), null, null, new URI[0]);
        TestBigdataSailRemoteRepository.assertEquals((long)3L, (long)mutationResult);
    }

    public void test_DELETE_accessPath_delete_p() throws Exception {
        this.doInsertbyURL("POST", "src/test/java/com/bigdata/rdf/sail/webapp/test_delete_by_access_path.ttl");
        long mutationResult = this.doDeleteWithAccessPath(null, (URI)new URIImpl("http://www.w3.org/2000/01/rdf-schema#label"), null, new URI[0]);
        TestBigdataSailRemoteRepository.assertEquals((long)2L, (long)mutationResult);
    }

    public void test_DELETE_accessPath_delete_o_URI() throws Exception {
        this.doInsertbyURL("POST", "src/test/java/com/bigdata/rdf/sail/webapp/test_delete_by_access_path.ttl");
        long mutationResult = this.doDeleteWithAccessPath(null, null, (Value)new URIImpl("http://xmlns.com/foaf/0.1/Person"), new URI[0]);
        TestBigdataSailRemoteRepository.assertEquals((long)3L, (long)mutationResult);
    }

    public void test_DELETE_accessPath_delete_o_Literal() throws Exception {
        this.doInsertbyURL("POST", "src/test/java/com/bigdata/rdf/sail/webapp/test_delete_by_access_path.ttl");
        long mutationResult = this.doDeleteWithAccessPath(null, null, (Value)new URIImpl("http://www.bigdata.com/Bryan"), new URI[0]);
        TestBigdataSailRemoteRepository.assertEquals((long)1L, (long)mutationResult);
    }

    public void test_DELETE_accessPath_delete_p_o_URI() throws Exception {
        this.doInsertbyURL("POST", "src/test/java/com/bigdata/rdf/sail/webapp/test_delete_by_access_path.ttl");
        long mutationResult = this.doDeleteWithAccessPath(null, RDF.TYPE, (Value)new URIImpl("http://xmlns.com/foaf/0.1/Person"), new URI[0]);
        TestBigdataSailRemoteRepository.assertEquals((long)3L, (long)mutationResult);
    }

    public void test_DELETE_accessPath_delete_p_o_Literal() throws Exception {
        this.doInsertbyURL("POST", "src/test/java/com/bigdata/rdf/sail/webapp/test_delete_by_access_path.ttl");
        long mutationResult = this.doDeleteWithAccessPath(null, RDFS.LABEL, (Value)new LiteralImpl("Bryan"), new URI[0]);
        TestBigdataSailRemoteRepository.assertEquals((long)1L, (long)mutationResult);
    }

    public void test_DELETE_accessPath_delete_NothingMatched() throws Exception {
        this.doInsertbyURL("POST", "src/test/java/com/bigdata/rdf/sail/webapp/test_delete_by_access_path.ttl");
        long mutationResult = this.doDeleteWithAccessPath(null, null, (Value)new URIImpl("http://xmlns.com/foaf/0.1/XXX"), new URI[0]);
        TestBigdataSailRemoteRepository.assertEquals((long)0L, (long)mutationResult);
    }

    public void test_DELETE_accessPath_delete_c() throws Exception {
        if (TestMode.quads != this.getTestMode()) {
            return;
        }
        this.doInsertbyURL("POST", "src/test/java/com/bigdata/rdf/sail/webapp/test_delete_by_access_path.trig");
        long mutationResult = this.doDeleteWithAccessPath(null, null, null, new URI[]{new URIImpl("http://www.bigdata.com/")});
        TestBigdataSailRemoteRepository.assertEquals((long)3L, (long)mutationResult);
    }

    public void test_DELETE_accessPath_delete_c1() throws Exception {
        if (TestMode.quads != this.getTestMode()) {
            return;
        }
        this.doInsertbyURL("POST", "src/test/java/com/bigdata/rdf/sail/webapp/test_delete_by_access_path.trig");
        long mutationResult = this.doDeleteWithAccessPath(null, null, null, new URI[]{new URIImpl("http://www.bigdata.com/c1")});
        TestBigdataSailRemoteRepository.assertEquals((long)2L, (long)mutationResult);
    }

    public void test_DELETE_accessPath_delete_c_nothingMatched() throws Exception {
        if (TestMode.quads != this.getTestMode()) {
            return;
        }
        this.doInsertbyURL("POST", "src/test/java/com/bigdata/rdf/sail/webapp/test_delete_by_access_path.trig");
        long mutationResult = this.doDeleteWithAccessPath(null, null, null, new URI[]{new URIImpl("http://xmlns.com/foaf/0.1/XXX")});
        TestBigdataSailRemoteRepository.assertEquals((long)0L, (long)mutationResult);
    }

    public void test_GET_accessPath_delete_all() throws Exception {
        this.doInsertbyURL("POST", "src/test/java/com/bigdata/rdf/sail/webapp/test_delete_by_access_path.ttl");
        long result = TestBigdataSailRemoteRepository.countResults(this.doGetWithAccessPath(null, null, null, new URI[0]));
        TestBigdataSailRemoteRepository.assertEquals((long)7L, (long)result);
    }

    public void test_GET_accessPath_delete_s() throws Exception {
        this.doInsertbyURL("POST", "src/test/java/com/bigdata/rdf/sail/webapp/test_delete_by_access_path.ttl");
        long result = TestBigdataSailRemoteRepository.countResults(this.doGetWithAccessPath((URI)new URIImpl("http://www.bigdata.com/Mike"), null, null, new URI[0]));
        TestBigdataSailRemoteRepository.assertEquals((long)3L, (long)result);
    }

    public void test_GET_accessPath_delete_p() throws Exception {
        this.doInsertbyURL("POST", "src/test/java/com/bigdata/rdf/sail/webapp/test_delete_by_access_path.ttl");
        long result = TestBigdataSailRemoteRepository.countResults(this.doGetWithAccessPath(null, (URI)new URIImpl("http://www.w3.org/2000/01/rdf-schema#label"), null, new URI[0]));
        TestBigdataSailRemoteRepository.assertEquals((long)2L, (long)result);
    }

    public void test_GET_accessPath_delete_o_URI() throws Exception {
        this.doInsertbyURL("POST", "src/test/java/com/bigdata/rdf/sail/webapp/test_delete_by_access_path.ttl");
        long result = TestBigdataSailRemoteRepository.countResults(this.doGetWithAccessPath(null, null, (Value)new URIImpl("http://xmlns.com/foaf/0.1/Person"), new URI[0]));
        TestBigdataSailRemoteRepository.assertEquals((long)3L, (long)result);
    }

    public void test_GET_accessPath_delete_o_Literal() throws Exception {
        this.doInsertbyURL("POST", "src/test/java/com/bigdata/rdf/sail/webapp/test_delete_by_access_path.ttl");
        long result = TestBigdataSailRemoteRepository.countResults(this.doGetWithAccessPath(null, null, (Value)new URIImpl("http://www.bigdata.com/Bryan"), new URI[0]));
        TestBigdataSailRemoteRepository.assertEquals((long)1L, (long)result);
    }

    public void test_GET_accessPath_delete_p_o_URI() throws Exception {
        this.doInsertbyURL("POST", "src/test/java/com/bigdata/rdf/sail/webapp/test_delete_by_access_path.ttl");
        long result = TestBigdataSailRemoteRepository.countResults(this.doGetWithAccessPath(null, RDF.TYPE, (Value)new URIImpl("http://xmlns.com/foaf/0.1/Person"), new URI[0]));
        TestBigdataSailRemoteRepository.assertEquals((long)3L, (long)result);
    }

    public void test_GET_accessPath_delete_p_o_Literal() throws Exception {
        this.doInsertbyURL("POST", "src/test/java/com/bigdata/rdf/sail/webapp/test_delete_by_access_path.ttl");
        long result = TestBigdataSailRemoteRepository.countResults(this.doGetWithAccessPath(null, RDFS.LABEL, (Value)new LiteralImpl("Bryan"), new URI[0]));
        TestBigdataSailRemoteRepository.assertEquals((long)1L, (long)result);
    }

    public void test_GET_accessPath_delete_NothingMatched() throws Exception {
        this.doInsertbyURL("POST", "src/test/java/com/bigdata/rdf/sail/webapp/test_delete_by_access_path.ttl");
        long result = TestBigdataSailRemoteRepository.countResults(this.doGetWithAccessPath(null, null, (Value)new URIImpl("http://xmlns.com/foaf/0.1/XXX"), new URI[0]));
        TestBigdataSailRemoteRepository.assertEquals((long)0L, (long)result);
    }

    public void test_GET_accessPath_delete_c() throws Exception {
        if (TestMode.quads != this.getTestMode()) {
            return;
        }
        this.doInsertbyURL("POST", "src/test/java/com/bigdata/rdf/sail/webapp/test_delete_by_access_path.trig");
        long result = TestBigdataSailRemoteRepository.countResults(this.doGetWithAccessPath(null, null, null, new URI[]{new URIImpl("http://www.bigdata.com/")}));
        TestBigdataSailRemoteRepository.assertEquals((long)3L, (long)result);
    }

    public void test_GET_accessPath_delete_c1() throws Exception {
        if (TestMode.quads != this.getTestMode()) {
            return;
        }
        this.doInsertbyURL("POST", "src/test/java/com/bigdata/rdf/sail/webapp/test_delete_by_access_path.trig");
        long result = TestBigdataSailRemoteRepository.countResults(this.doGetWithAccessPath(null, null, null, new URI[]{new URIImpl("http://www.bigdata.com/c1")}));
        TestBigdataSailRemoteRepository.assertEquals((long)2L, (long)result);
    }

    public void test_GET_accessPath_delete_c_nothingMatched() throws Exception {
        if (TestMode.quads != this.getTestMode()) {
            return;
        }
        this.doInsertbyURL("POST", "src/test/java/com/bigdata/rdf/sail/webapp/test_delete_by_access_path.trig");
        long result = TestBigdataSailRemoteRepository.countResults(this.doGetWithAccessPath(null, null, null, new URI[]{new URIImpl("http://xmlns.com/foaf/0.1/XXX")}));
        TestBigdataSailRemoteRepository.assertEquals((long)0L, (long)result);
    }

    public void test_tx_begin_rollback() throws RepositoryException {
        TestBigdataSailRemoteRepository.assertFalse((boolean)this.cxn.isActive());
        this.cxn.begin();
        TestBigdataSailRemoteRepository.assertTrue((boolean)this.cxn.isActive());
        this.cxn.rollback();
        TestBigdataSailRemoteRepository.assertFalse((boolean)this.cxn.isActive());
    }

    public void test_tx_begin_commit() throws RepositoryException {
        TestBigdataSailRemoteRepository.assertFalse((boolean)this.cxn.isActive());
        this.cxn.begin();
        TestBigdataSailRemoteRepository.assertTrue((boolean)this.cxn.isActive());
        this.cxn.commit();
        TestBigdataSailRemoteRepository.assertFalse((boolean)this.cxn.isActive());
    }

    public static class ReadWriteTx<S extends IIndexManager>
    extends TestBigdataSailRemoteRepository<S> {
        public ReadWriteTx() {
        }

        public ReadWriteTx(String name) {
            super(name);
        }

        @Override
        public Properties getProperties() {
            Properties p = new Properties(super.getProperties());
            p.setProperty(BigdataSail.Options.ISOLATABLE_INDICES, "true");
            return p;
        }

        public void test_tx_begin_addStatement_commit() throws RepositoryException, MalformedQueryException, UpdateExecutionException {
        }

        public void test_tx_begin_UPDATE_commit() throws RepositoryException, MalformedQueryException, UpdateExecutionException {
        }
    }
}

