/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp;

import com.bigdata.counters.format.CounterSetFormat;
import com.bigdata.rdf.sail.webapp.ConnegScore;
import com.bigdata.rdf.sail.webapp.ConnegUtil;
import junit.framework.TestCase2;
import org.openrdf.query.resultio.BooleanQueryResultFormat;
import org.openrdf.query.resultio.TupleQueryResultFormat;
import org.openrdf.rio.RDFFormat;

public class TestConneg
extends TestCase2 {
    public TestConneg() {
    }

    public TestConneg(String name) {
        super(name);
    }

    public void test_conneg_no_Accept_headser() {
        String acceptStr = null;
        ConnegUtil util = new ConnegUtil(acceptStr);
        TestConneg.assertNull((Object)util.getRDFFormat());
        TestConneg.assertEquals((Object)RDFFormat.N3, (Object)util.getRDFFormat(RDFFormat.N3));
    }

    public void test_conneg_empty_Accept_headser() {
        String acceptStr = "";
        ConnegUtil util = new ConnegUtil("");
        TestConneg.assertNull((Object)util.getRDFFormat());
        TestConneg.assertEquals((Object)RDFFormat.N3, (Object)util.getRDFFormat(RDFFormat.N3));
    }

    public void test_conneg_rdf_data_01() {
        for (RDFFormat format : RDFFormat.values()) {
            ConnegUtil util = new ConnegUtil(format.getDefaultMIMEType());
            TestConneg.assertEquals((String)format.getName(), (Object)format, (Object)util.getRDFFormat());
            if (!format.getName().equals("JSON")) {
                TestConneg.assertNull((String)format.getName(), (Object)util.getTupleQueryResultFormat());
            }
            TestConneg.assertSameArray((Object[])new ConnegScore[]{new ConnegScore(1.0f, (Object)format)}, (Object[])util.getScores(RDFFormat.class));
        }
    }

    public void test_conneg_sparql_result_set_01() {
        for (TupleQueryResultFormat format : TupleQueryResultFormat.values()) {
            ConnegUtil util = new ConnegUtil(format.getDefaultMIMEType());
            if (!format.getName().equals("SPARQL/JSON")) {
                TestConneg.assertNull((String)format.getName(), (Object)util.getRDFFormat());
            }
            TestConneg.assertEquals((String)format.getName(), (Object)format, (Object)util.getTupleQueryResultFormat());
            TestConneg.assertSameArray((Object[])new ConnegScore[]{new ConnegScore(1.0f, (Object)format)}, (Object[])util.getScores(TupleQueryResultFormat.class));
        }
    }

    public void test_conneg_sparql_result_set_02() {
        String acceptStr = "application/x-binary-rdf-results-table;q=1,application/sparql-results+xml;q=1";
        ConnegUtil util = new ConnegUtil("application/x-binary-rdf-results-table;q=1,application/sparql-results+xml;q=1");
        TestConneg.assertNull((Object)util.getRDFFormat());
        TestConneg.assertSameArray((Object[])new ConnegScore[]{new ConnegScore(1.0f, (Object)TupleQueryResultFormat.BINARY), new ConnegScore(1.0f, (Object)TupleQueryResultFormat.SPARQL)}, (Object[])util.getScores(TupleQueryResultFormat.class));
        TestConneg.assertEquals((Object)TupleQueryResultFormat.BINARY, (Object)util.getTupleQueryResultFormat());
    }

    public void test_conneg_sparql_result_set_03() {
        String acceptStr = "text/xhtml,application/x-binary-rdf-results-table;q=.3,application/sparql-results+xml;q=.5";
        ConnegUtil util = new ConnegUtil("text/xhtml,application/x-binary-rdf-results-table;q=.3,application/sparql-results+xml;q=.5");
        TestConneg.assertNull((Object)util.getRDFFormat());
        TestConneg.assertSameArray((Object[])new ConnegScore[]{new ConnegScore(0.5f, (Object)TupleQueryResultFormat.SPARQL), new ConnegScore(0.3f, (Object)TupleQueryResultFormat.BINARY)}, (Object[])util.getScores(TupleQueryResultFormat.class));
        TestConneg.assertEquals((Object)TupleQueryResultFormat.SPARQL, (Object)util.getTupleQueryResultFormat());
    }

    public void test_conneg_sparql_result_set_03b() {
        String acceptStr = "text/xhtml,application/x-binary-rdf-results-table;q=.4,application/sparql-results+xml;q=.2";
        ConnegUtil util = new ConnegUtil("text/xhtml,application/x-binary-rdf-results-table;q=.4,application/sparql-results+xml;q=.2");
        TestConneg.assertNull((Object)util.getRDFFormat());
        TestConneg.assertSameArray((Object[])new ConnegScore[]{new ConnegScore(0.4f, (Object)TupleQueryResultFormat.BINARY), new ConnegScore(0.2f, (Object)TupleQueryResultFormat.SPARQL)}, (Object[])util.getScores(TupleQueryResultFormat.class));
        TestConneg.assertEquals((Object)TupleQueryResultFormat.BINARY, (Object)util.getTupleQueryResultFormat());
    }

    public void test_conneg_sparql_boolean_result_set_01() {
        for (BooleanQueryResultFormat format : BooleanQueryResultFormat.values()) {
            ConnegUtil util = new ConnegUtil(format.getDefaultMIMEType());
            if (!format.getName().equals("SPARQL/JSON")) {
                TestConneg.assertNull((String)format.getName(), (Object)util.getRDFFormat());
            }
            TestConneg.assertEquals((String)format.getName(), (Object)format, (Object)util.getBooleanQueryResultFormat());
            TestConneg.assertSameArray((Object[])new ConnegScore[]{new ConnegScore(1.0f, (Object)format)}, (Object[])util.getScores(BooleanQueryResultFormat.class));
        }
    }

    public void test_conneg_ask_json() {
        ConnegUtil util = new ConnegUtil("application/sparql-results+json");
        BooleanQueryResultFormat format = util.getBooleanQueryResultFormat(BooleanQueryResultFormat.SPARQL);
        TestConneg.assertFalse((String)format.toString(), (boolean)format.toString().toLowerCase().contains("xml"));
    }

    public void test_conneg_counterSet_application_xml() {
        String acceptStr = "application/xml";
        ConnegUtil util = new ConnegUtil("application/xml");
        CounterSetFormat format = util.getCounterSetFormat();
        TestConneg.assertEquals((Object)CounterSetFormat.XML, (Object)format);
    }

    public void test_conneg_counterSet_text_plain() {
        String acceptStr = "text/plain";
        ConnegUtil util = new ConnegUtil("text/plain");
        CounterSetFormat format = util.getCounterSetFormat();
        TestConneg.assertEquals((Object)CounterSetFormat.TEXT, (Object)format);
    }

    public void test_conneg_counterSet_text_html() {
        String acceptStr = "text/html";
        ConnegUtil util = new ConnegUtil("text/html");
        CounterSetFormat format = util.getCounterSetFormat();
        TestConneg.assertEquals((Object)CounterSetFormat.HTML, (Object)format);
    }

    public void test_conneg_counterSet_browser1() {
        String acceptStr = "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8,";
        ConnegUtil util = new ConnegUtil("text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8,");
        TestConneg.assertSameArray((Object[])new ConnegScore[]{new ConnegScore(1.0f, (Object)CounterSetFormat.HTML), new ConnegScore(0.9f, (Object)CounterSetFormat.XML)}, (Object[])util.getScores(CounterSetFormat.class));
        CounterSetFormat format = util.getCounterSetFormat();
        TestConneg.assertEquals((Object)CounterSetFormat.HTML, (Object)format);
    }

    public void test_connect_getMimeTypeForQueryParameter2() {
        String outputFormat = "json";
        String correctResult = "application/sparql-results+json";
        Object acceptHeader = null;
        TestConneg.assertEquals((String)ConnegUtil.getMimeTypeForQueryParameterQueryRequest((String)"json", (String[])new String[]{acceptHeader}), (String)"application/sparql-results+json");
    }

    public void test_connect_getMimeTypeForQueryParameter3() {
        String outputFormat = "sparql-results+xml";
        String correctResult = "application/sparql-results+xml";
        Object acceptHeader = null;
        TestConneg.assertEquals((String)ConnegUtil.getMimeTypeForQueryParameterQueryRequest((String)"sparql-results+xml", (String[])new String[]{acceptHeader}), (String)"application/sparql-results+xml");
    }

    public void test_connect_getMimeTypeForQueryParameter4() {
        String outputFormat = "xml";
        String correctResult = "application/sparql-results+xml";
        Object acceptHeader = null;
        TestConneg.assertEquals((String)ConnegUtil.getMimeTypeForQueryParameterQueryRequest((String)"xml", (String[])new String[]{acceptHeader}), (String)"application/sparql-results+xml");
    }

    public void test_connect_getMimeTypeForQueryParameter5() {
        String outputFormat = null;
        String correctResult = "application/sparql-results+xml";
        Object acceptHeader = null;
        TestConneg.assertEquals((String)ConnegUtil.getMimeTypeForQueryParameterQueryRequest(outputFormat, (String[])new String[]{acceptHeader}), (String)"application/sparql-results+xml");
    }

    public void test_connect_getMimeTypeForQueryParameter6() {
        String outputFormat = "sparql-results+json";
        String correctResult = "application/sparql-results+json";
        String acceptHeader = "application/sparql-results+xml";
        TestConneg.assertEquals((String)ConnegUtil.getMimeTypeForQueryParameterQueryRequest((String)"sparql-results+json", (String[])new String[]{"application/sparql-results+xml"}), (String)"application/sparql-results+json");
    }

    public void test_connect_getMimeTypeForQueryParameter7() {
        String outputFormat = "sparql-results+xml";
        String correctResult = "application/sparql-results+xml";
        String acceptHeader = "application/sparql-results+json";
        TestConneg.assertEquals((String)ConnegUtil.getMimeTypeForQueryParameterQueryRequest((String)"sparql-results+xml", (String[])new String[]{"application/sparql-results+json"}), (String)"application/sparql-results+xml");
    }
}

