/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp;

import com.bigdata.journal.BufferMode;
import com.bigdata.journal.IIndexManager;
import com.bigdata.rdf.properties.PropertiesFormat;
import com.bigdata.rdf.properties.PropertiesParserFactory;
import com.bigdata.rdf.properties.PropertiesParserRegistry;
import com.bigdata.rdf.sail.remote.BigdataSailRemoteRepositoryConnection;
import com.bigdata.rdf.sail.webapp.AbstractTestNanoSparqlClient;
import com.bigdata.rdf.sail.webapp.ProxySuiteHelper;
import com.bigdata.rdf.sail.webapp.TestMode;
import com.bigdata.rdf.sail.webapp.client.HttpException;
import com.bigdata.rdf.sail.webapp.client.RemoteRepository;
import java.util.Collections;
import java.util.Properties;
import java.util.UUID;
import junit.framework.Test;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;

public class TestDataLoaderServlet<S extends IIndexManager>
extends AbstractTestNanoSparqlClient<S> {
    static final String BASE = "com/bigdata/rdf/sail/webapp/";

    public TestDataLoaderServlet() {
    }

    public TestDataLoaderServlet(String name) {
        super(name);
    }

    public static Test suite() {
        return ProxySuiteHelper.suiteWhenStandalone(TestDataLoaderServlet.class, "test_load01", Collections.singleton(BufferMode.DiskRW), TestMode.quads);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_load01() throws Exception {
        String kbPropsURL = ((Object)((Object)this)).getClass().getResource("dataloader.props").getFile();
        String dataURL = ((Object)((Object)this)).getClass().getResource("sample-data.ttl").getFile();
        PropertiesFormat format = PropertiesFormat.XML;
        PropertiesParserFactory parserFactory = (PropertiesParserFactory)PropertiesParserRegistry.getInstance().get((Object)format);
        Properties loaderProps = parserFactory.getParser().parse(((Object)((Object)this)).getClass().getResourceAsStream("dataloader.xml"));
        String randomNS = "kb" + UUID.randomUUID();
        try {
            this.m_mgr.getRepositoryProperties(randomNS);
            TestDataLoaderServlet.fail((String)("Should not exist: " + randomNS));
        }
        catch (HttpException ex) {
            TestDataLoaderServlet.assertEquals((int)404, (int)ex.getStatusCode());
        }
        loaderProps.setProperty("namespace", randomNS);
        loaderProps.setProperty("quiet", "true");
        loaderProps.setProperty("verbose", "0");
        loaderProps.setProperty("propertyFile", kbPropsURL);
        loaderProps.setProperty("fileOrDirs", dataURL);
        this.m_mgr.doDataLoader(loaderProps);
        RemoteRepository repo = this.m_mgr.getRepositoryForNamespace(randomNS);
        Properties p = this.m_mgr.getRepositoryProperties(randomNS);
        TestDataLoaderServlet.assertNotNull((Object)p);
        log.warn((Object)("Found properties for namespace " + randomNS));
        try (BigdataSailRemoteRepositoryConnection cxn = repo.getBigdataSailRemoteRepository().getConnection();){
            String queryStr = "select * where { ?s ?p ?o }";
            TupleQuery tq = cxn.prepareTupleQuery(QueryLanguage.SPARQL, queryStr);
            try (TupleQueryResult tqr = tq.evaluate();){
                int cnt = 0;
                while (tqr.hasNext()) {
                    tqr.next();
                    ++cnt;
                }
                if (cnt == 0) {
                    TestDataLoaderServlet.fail((String)"DataLoaderServlet did not add any statements.");
                }
                TestDataLoaderServlet.assertTrue((cnt > 0 ? 1 : 0) != 0);
            }
        }
    }
}

