/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp;

import com.bigdata.journal.BufferMode;
import com.bigdata.journal.IIndexManager;
import com.bigdata.journal.Options;
import com.bigdata.rdf.sail.remote.BigdataSailRemoteRepositoryConnection;
import com.bigdata.rdf.sail.sparql.Bigdata2ASTSPARQLParser;
import com.bigdata.rdf.sail.webapp.AbstractTestNanoSparqlClient;
import com.bigdata.rdf.sail.webapp.ProxySuiteHelper;
import com.bigdata.rdf.sail.webapp.TestMode;
import com.bigdata.rdf.sail.webapp.client.HttpException;
import com.bigdata.rdf.sail.webapp.client.RemoteRepository;
import com.bigdata.rdf.sparql.ast.ASTContainer;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.bigdata.rdf.sparql.ast.service.ServiceRegistry;
import com.bigdata.rdf.store.AbstractTripleStore;
import info.aduna.io.IOUtil;
import info.aduna.iteration.Iteration;
import info.aduna.iteration.Iterations;
import info.aduna.text.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import junit.framework.Test;
import junit.util.PropertyUtil;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.model.util.ModelUtil;
import org.openrdf.model.vocabulary.FOAF;
import org.openrdf.query.BindingSet;
import org.openrdf.query.GraphQuery;
import org.openrdf.query.GraphQueryResult;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.QueryResultUtil;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.dawg.DAWGTestResultSetUtil;
import org.openrdf.query.impl.MutableTupleQueryResult;
import org.openrdf.query.impl.TupleQueryResultBuilder;
import org.openrdf.query.resultio.QueryResultIO;
import org.openrdf.query.resultio.TupleQueryResultFormat;
import org.openrdf.query.resultio.TupleQueryResultParser;
import org.openrdf.repository.RepositoryException;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.Rio;
import org.openrdf.rio.helpers.StatementCollector;

public class TestFederatedQuery<S extends IIndexManager>
extends AbstractTestNanoSparqlClient<S> {
    public static final String TEST_RESOURCE_PATH = "/com/bigdata/rdf/sail/webapp/openrdf-service/";

    public TestFederatedQuery() {
    }

    public TestFederatedQuery(String name) {
        super(name);
    }

    public static Test suite() {
        return ProxySuiteHelper.suiteWhenStandalone(TestFederatedQuery.class, "test.*", TestMode.quads);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Properties p = this.getProperties();
        p.setProperty(Options.BUFFER_MODE, BufferMode.DiskRW.toString());
        p.setProperty(Options.CREATE_TEMP_FILE, "true");
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    private String getNamespace(int i) {
        if (i < 1) {
            throw new IllegalArgumentException();
        }
        return this.namespace + "_" + i;
    }

    private String getRepositoryUrl(int i) {
        return this.getRepositoryUrlBase() + i + "/sparql";
    }

    private String getRepositoryUrlBase() {
        return this.m_serviceURL + "/namespace/" + this.namespace + "_";
    }

    private RemoteRepository getRepository(int i) throws Exception {
        String ns = this.getNamespace(i);
        try {
            Properties p;
            boolean found;
            block6: {
                found = true;
                try {
                    p = this.m_mgr.getRepositoryProperties(ns);
                    assert (p != null);
                    found = true;
                }
                catch (HttpException ex) {
                    if (ex.getStatusCode() != 404) break block6;
                    found = false;
                }
            }
            if (!found) {
                p = PropertyUtil.flatCopy((Properties)this.getProperties());
                p.setProperty("com.bigdata.rdf.sail.namespace", ns);
                this.m_mgr.createRepository(ns, p);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return this.m_mgr.getRepositoryForNamespace(ns);
    }

    private void prepareTest(String localData, List<String> endpointData) throws Exception {
        if (localData != null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Loading: " + localData + " into local repository"));
            }
            this.loadDataSet(this.m_repo, localData);
        }
        int i = 1;
        for (String s : endpointData) {
            RemoteRepository repo = this.getRepository(i);
            if (log.isInfoEnabled()) {
                log.info((Object)("Loading: " + s + " into " + this.getRepositoryUrl(i) + " as " + repo));
            }
            this.loadDataSet(repo, s);
            ++i;
        }
    }

    private void loadDataSet(RemoteRepository rep, String datasetFile) throws Exception {
        URL datasetUri = TestFederatedQuery.class.getClass().getResource(TEST_RESOURCE_PATH + datasetFile);
        if (log.isInfoEnabled()) {
            log.info((Object)("datasetFile: " + datasetFile));
            log.info((Object)("datasetUri: " + datasetUri));
        }
        rep.add(new RemoteRepository.AddOp(datasetUri.toExternalForm()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSimpleServiceQuery() throws Exception {
        String EX_NS = "http://example.org/";
        ValueFactoryImpl f = new ValueFactoryImpl();
        URI bob = f.createURI("http://example.org/", "bob");
        URI alice = f.createURI("http://example.org/", "alice");
        URI william = f.createURI("http://example.org/", "william");
        this.prepareTest("simple-default-graph.ttl", Arrays.asList("simple.ttl"));
        StringBuilder qb = new StringBuilder();
        qb.append(" SELECT * \n");
        qb.append(" WHERE { \n");
        qb.append("     SERVICE <" + this.getRepositoryUrl(1) + "> { \n");
        qb.append("             ?X <" + FOAF.NAME + "> ?Y \n ");
        qb.append("     } \n ");
        qb.append("     ?X a <" + FOAF.PERSON + "> . \n");
        qb.append(" } \n");
        try (BigdataSailRemoteRepositoryConnection conn = this.m_repo.getBigdataSailRemoteRepository().getConnection();){
            TupleQuery tq = conn.prepareTupleQuery(QueryLanguage.SPARQL, qb.toString());
            TupleQueryResult tqr = tq.evaluate();
            TestFederatedQuery.assertNotNull((Object)tqr);
            TestFederatedQuery.assertTrue((String)"No solutions.", (boolean)tqr.hasNext());
            int count = 0;
            while (tqr.hasNext()) {
                BindingSet bs = (BindingSet)tqr.next();
                ++count;
                Value x = bs.getValue("X");
                Value y = bs.getValue("Y");
                TestFederatedQuery.assertFalse((boolean)william.equals((Object)x));
                TestFederatedQuery.assertTrue((bob.equals((Object)x) || alice.equals((Object)x) ? 1 : 0) != 0);
                if (bob.equals((Object)x)) {
                    f.createLiteral("Bob").equals((Object)y);
                    continue;
                }
                if (!alice.equals((Object)x)) continue;
                f.createLiteral("Alice").equals((Object)y);
            }
            TestFederatedQuery.assertEquals((int)2, (int)count);
        }
    }

    public void test1() throws Exception {
        this.prepareTest("data01.ttl", Arrays.asList("data01endpoint.ttl"));
        this.execute("service01.rq", "service01.srx", false);
    }

    public void test2() throws Exception {
        this.prepareTest(null, Arrays.asList("data02endpoint1.ttl", "data02endpoint2.ttl"));
        this.execute("service02.rq", "service02.srx", false);
    }

    public void test3() throws Exception {
        this.prepareTest(null, Arrays.asList("data03endpoint1.ttl", "data03endpoint2.ttl"));
        this.execute("service03.rq", "service03.srx", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test5() throws Exception {
        URIImpl serviceURI1 = new URIImpl(this.getRepositoryUrl(1));
        URIImpl serviceURI2 = new URIImpl(this.getRepositoryUrl(2));
        URIImpl serviceURI1_alias = new URIImpl("http://localhost:18080/openrdf/repositories/endpoint1");
        URIImpl serviceURI2_alias = new URIImpl("http://localhost:18080/openrdf/repositories/endpoint2");
        try {
            ServiceRegistry.getInstance().addAlias((URI)serviceURI1, (URI)serviceURI1_alias);
            ServiceRegistry.getInstance().addAlias((URI)serviceURI2, (URI)serviceURI2_alias);
            this.prepareTest("data05.ttl", Arrays.asList("data05endpoint1.ttl", "data05endpoint2.ttl"));
            this.execute("service05.rq", "service05.srx", false);
        }
        finally {
            ServiceRegistry.getInstance().remove((URI)serviceURI1_alias);
            ServiceRegistry.getInstance().remove((URI)serviceURI2_alias);
        }
    }

    public void test6() throws Exception {
        this.prepareTest(null, Arrays.asList("data06endpoint1.ttl"));
        this.execute("service06.rq", "service06.srx", false);
    }

    public void test7() throws Exception {
        this.prepareTest("data07.ttl", Collections.emptyList());
        this.execute("service07.rq", "service07.srx", false);
    }

    public void test8() throws Exception {
        this.prepareTest("data08.ttl", Arrays.asList("data08endpoint.ttl"));
        this.execute("service08.rq", "service08.srx", false);
    }

    public void test9() throws Exception {
        this.prepareTest(null, Arrays.asList("data09endpoint.ttl"));
        this.execute("service09.rq", "service09.srx", false);
    }

    public void test10() throws Exception {
        this.prepareTest("data10.ttl", Arrays.asList("data10endpoint.ttl"));
        this.execute("service10.rq", "service10.srx", false);
    }

    public void test10b() throws Exception {
        this.prepareTest("data10.ttl", Arrays.asList("data10endpoint.ttl"));
        this.execute("service10b.rq", "service10.srx", false);
    }

    public void test11() throws Exception {
        this.prepareTest("data11.ttl", Arrays.asList("data11endpoint.ttl"));
        this.execute("service11.rq", "service11.srx", false);
    }

    public void test13b() throws Exception {
        this.prepareTest(null, Arrays.asList("data13.ttl"));
        this.execute("service13b.rq", "service13.srx", false);
    }

    public void testEmptyServiceBlock() throws Exception {
        this.prepareTest(null, Arrays.asList("data13.ttl"));
        this.execute("service14.rq", "service14.srx", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void execute(String queryFile, String expectedResultFile, boolean checkOrder) throws Exception {
        try (BigdataSailRemoteRepositoryConnection conn = this.m_repo.getBigdataSailRemoteRepository().getConnection();){
            String baseURI = this.getRepositoryUrlBase();
            String queryString = this.readQueryString(queryFile);
            queryString = queryString.replace("http://localhost:18080/openrdf/repositories/endpoint", baseURI);
            AbstractTripleStore tripleStore = (AbstractTripleStore)this.getIndexManager().getResourceLocator().locate(this.namespace, -1L);
            ASTContainer astContainer = new Bigdata2ASTSPARQLParser().parseQuery2(queryString, baseURI);
            QueryType queryType = astContainer.getOriginalAST().getQueryType();
            switch (queryType) {
                case ASK: {
                    throw new RuntimeException("Not yet supported (boolean) " + queryString);
                }
                case CONSTRUCT: 
                case DESCRIBE: {
                    GraphQuery query = conn.prepareGraphQuery(QueryLanguage.SPARQL, queryString);
                    GraphQueryResult gqr = query.evaluate();
                    Set queryResult = Iterations.asSet((Iteration)gqr);
                    Set<Statement> expectedResult = this.readExpectedGraphQueryResult(expectedResultFile);
                    this.compareGraphs(queryResult, expectedResult);
                    return;
                }
                case SELECT: {
                    GraphQuery query = conn.prepareTupleQuery(QueryLanguage.SPARQL, queryString);
                    TupleQueryResult queryResult = ((TupleQuery)query).evaluate();
                    TupleQueryResult expectedResult = this.readExpectedTupleQueryResult(expectedResultFile);
                    this.compareTupleQueryResults(queryResult, expectedResult, checkOrder);
                    return;
                }
                default: {
                    throw new RuntimeException("Unexpected query type: " + queryString);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readQueryString(String queryResource) throws RepositoryException, IOException {
        try (InputStream stream = TestFederatedQuery.class.getResourceAsStream(TEST_RESOURCE_PATH + queryResource);){
            String string = IOUtil.readString((Reader)new InputStreamReader(stream, "UTF-8"));
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TupleQueryResult readExpectedTupleQueryResult(String resultFile) throws Exception {
        TupleQueryResultFormat tqrFormat = QueryResultIO.getParserFormatForFileName((String)resultFile);
        if (tqrFormat != null) {
            try (InputStream in = TestFederatedQuery.class.getResourceAsStream(TEST_RESOURCE_PATH + resultFile);){
                TupleQueryResultParser parser = QueryResultIO.createParser((TupleQueryResultFormat)tqrFormat);
                parser.setValueFactory((ValueFactory)ValueFactoryImpl.getInstance());
                TupleQueryResultBuilder qrBuilder = new TupleQueryResultBuilder();
                parser.setTupleQueryResultHandler((TupleQueryResultHandler)qrBuilder);
                parser.parse(in);
                TupleQueryResult tupleQueryResult = qrBuilder.getQueryResult();
                return tupleQueryResult;
            }
        }
        Set<Statement> resultGraph = this.readExpectedGraphQueryResult(resultFile);
        return DAWGTestResultSetUtil.toTupleQueryResult(resultGraph);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Statement> readExpectedGraphQueryResult(String resultFile) throws Exception {
        RDFFormat rdfFormat = Rio.getParserFormatForFileName((String)resultFile);
        if (rdfFormat != null) {
            RDFParser parser = Rio.createParser((RDFFormat)rdfFormat);
            parser.setDatatypeHandling(RDFParser.DatatypeHandling.IGNORE);
            parser.setPreserveBNodeIDs(true);
            parser.setValueFactory((ValueFactory)ValueFactoryImpl.getInstance());
            LinkedHashSet<Statement> result = new LinkedHashSet<Statement>();
            parser.setRDFHandler((RDFHandler)new StatementCollector(result));
            try (InputStream in = TestFederatedQuery.class.getResourceAsStream(TEST_RESOURCE_PATH + resultFile);){
                parser.parse(in, null);
            }
            return result;
        }
        throw new RuntimeException("Unable to determine file type of results file");
    }

    private void compareTupleQueryResults(TupleQueryResult queryResult, TupleQueryResult expectedResult, boolean checkOrder) throws Exception {
        MutableTupleQueryResult queryResultTable = new MutableTupleQueryResult(queryResult);
        MutableTupleQueryResult expectedResultTable = new MutableTupleQueryResult(expectedResult);
        boolean resultsEqual = QueryResultUtil.equals((TupleQueryResult)queryResultTable, (TupleQueryResult)expectedResultTable);
        if (checkOrder) {
            queryResultTable.beforeFirst();
            expectedResultTable.beforeFirst();
            while (queryResultTable.hasNext()) {
                BindingSet expectedBs;
                BindingSet bs = queryResultTable.next();
                if (bs.equals((Object)(expectedBs = expectedResultTable.next()))) continue;
                resultsEqual = false;
                break;
            }
        }
        if (!resultsEqual) {
            queryResultTable.beforeFirst();
            expectedResultTable.beforeFirst();
            List queryBindings = Iterations.asList((Iteration)queryResultTable);
            List expectedBindings = Iterations.asList((Iteration)expectedResultTable);
            ArrayList missingBindings = new ArrayList(expectedBindings);
            missingBindings.removeAll(queryBindings);
            ArrayList unexpectedBindings = new ArrayList(queryBindings);
            unexpectedBindings.removeAll(expectedBindings);
            StringBuilder message = new StringBuilder(128);
            message.append("\n============ ");
            message.append(this.getName());
            message.append(" =======================\n");
            if (!missingBindings.isEmpty()) {
                message.append("Missing bindings: \n");
                for (BindingSet bs : missingBindings) {
                    message.append(bs);
                    message.append("\n");
                }
                message.append("=============");
                StringUtil.appendN((char)'=', (int)this.getName().length(), (StringBuilder)message);
                message.append("========================\n");
            }
            if (!unexpectedBindings.isEmpty()) {
                message.append("Unexpected bindings: \n");
                for (BindingSet bs : unexpectedBindings) {
                    message.append(bs);
                    message.append("\n");
                }
                message.append("=============");
                StringUtil.appendN((char)'=', (int)this.getName().length(), (StringBuilder)message);
                message.append("========================\n");
            }
            if (checkOrder && missingBindings.isEmpty() && unexpectedBindings.isEmpty()) {
                message.append("Results are not in expected order.\n");
                message.append(" =======================\n");
                message.append("query result: \n");
                for (BindingSet bs : queryBindings) {
                    message.append(bs);
                    message.append("\n");
                }
                message.append(" =======================\n");
                message.append("expected result: \n");
                for (BindingSet bs : expectedBindings) {
                    message.append(bs);
                    message.append("\n");
                }
                message.append(" =======================\n");
                System.out.print(message.toString());
            }
            log.error((Object)message.toString());
            TestFederatedQuery.fail((String)message.toString());
        }
    }

    private void compareGraphs(Set<Statement> queryResult, Set<Statement> expectedResult) throws Exception {
        if (!ModelUtil.equals(expectedResult, queryResult)) {
            StringBuilder message = new StringBuilder(128);
            message.append("\n============ ");
            message.append(this.getName());
            message.append(" =======================\n");
            message.append("Expected result: \n");
            for (Statement st : expectedResult) {
                message.append(st.toString());
                message.append("\n");
            }
            message.append("=============");
            StringUtil.appendN((char)'=', (int)this.getName().length(), (StringBuilder)message);
            message.append("========================\n");
            message.append("Query result: \n");
            for (Statement st : queryResult) {
                message.append(st.toString());
                message.append("\n");
            }
            message.append("=============");
            StringUtil.appendN((char)'=', (int)this.getName().length(), (StringBuilder)message);
            message.append("========================\n");
            log.error((Object)message.toString());
            TestFederatedQuery.fail((String)message.toString());
        }
    }
}

