/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp;

import com.bigdata.journal.BufferMode;
import com.bigdata.journal.IIndexManager;
import com.bigdata.journal.Journal;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.webapp.AbstractTestNanoSparqlClient;
import com.bigdata.rdf.sail.webapp.MultiTenancyServlet;
import com.bigdata.rdf.sail.webapp.ProxySuiteHelper;
import com.bigdata.rdf.sail.webapp.TestMode;
import com.bigdata.rdf.sail.webapp.client.HttpException;
import com.bigdata.rdf.sail.webapp.client.RemoteRepository;
import com.bigdata.rdf.vocab.decls.DCTermsVocabularyDecl;
import com.bigdata.rdf.vocab.decls.VoidVocabularyDecl;
import com.bigdata.relation.RelationSchema;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.UUID;
import junit.framework.Test;
import org.eclipse.jetty.util.IO;
import org.openrdf.model.Graph;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.query.GraphQueryResult;
import org.openrdf.query.TupleQueryResult;

public class TestMultiTenancyAPI<S extends IIndexManager>
extends AbstractTestNanoSparqlClient<S> {
    public TestMultiTenancyAPI() {
    }

    public TestMultiTenancyAPI(String name) {
        super(name);
    }

    public static Test suite() {
        return ProxySuiteHelper.suiteWhenStandalone(TestMultiTenancyAPI.class, "test.*", Collections.singleton(BufferMode.DiskRW), TestMode.quads);
    }

    protected static Map<String, VoidSummary> indexOnNamespace(Collection<VoidSummary> c) {
        TreeMap<String, VoidSummary> map = new TreeMap<String, VoidSummary>();
        for (VoidSummary x : c) {
            map.put(x.namespace.stringValue(), x);
        }
        return map;
    }

    protected Map<Resource, VoidSummary> getRepositoryDescriptions() throws Exception {
        Statement[] a;
        LinkedHashMap<Resource, VoidSummary> summaries = new LinkedHashMap<Resource, VoidSummary>();
        Graph g = RemoteRepository.asGraph((GraphQueryResult)this.m_mgr.getRepositoryDescriptions());
        for (Statement x : a = TestMultiTenancyAPI.getMatches(g, null, RDF.TYPE, (Value)VoidVocabularyDecl.Dataset)) {
            Resource dataset = x.getSubject();
            summaries.put(dataset, new VoidSummary(dataset, g));
        }
        return summaries;
    }

    public void test_describeDataSets01() throws Exception {
        Map<Resource, VoidSummary> summaries = this.getRepositoryDescriptions();
        if (summaries.isEmpty()) {
            TestMultiTenancyAPI.fail((String)"No repository descriptions");
        }
        for (Map.Entry<Resource, VoidSummary> e : summaries.entrySet()) {
            Resource namespaceName = e.getKey();
            VoidSummary summary = e.getValue();
            String namespaceStr = summary.namespace.stringValue();
            TestMultiTenancyAPI.assertEquals((Object)new LiteralImpl(namespaceStr), (Object)summary.namespace);
            TestMultiTenancyAPI.assertFalse((boolean)summary.sparqlEndpoint.isEmpty());
        }
    }

    public void test_getRepositoryProperties01() throws Exception {
        Properties p = this.m_mgr.getRepositoryProperties(this.namespace);
        TestMultiTenancyAPI.assertEquals((String)this.namespace, (String)p.getProperty(RelationSchema.NAMESPACE));
    }

    public void test_getPreparedPropertiesCompatibility() throws Exception {
        String namespace = "newNamespace";
        Properties properties = new Properties();
        properties.put("com.bigdata.rdf.sail.namespace", namespace);
        Properties p = this.m_mgr.getPreparedProperties(namespace, properties);
        properties.put("com.bigdata.rdf.sail.truthMaintenance", "true");
        properties.put("com.bigdata.rdf.store.AbstractTripleStore.quads", "true");
        try {
            this.m_mgr.getPreparedProperties(namespace, properties);
            TestMultiTenancyAPI.fail((String)"Expecting: 500");
        }
        catch (HttpException ex) {
            TestMultiTenancyAPI.assertEquals((int)500, (int)ex.getStatusCode());
        }
    }

    public void test_PreparedPropertiesContainNewValues() throws Exception {
        String namespace = "newNamespace";
        Properties properties = new Properties();
        properties.put("com.bigdata.rdf.sail.namespace", namespace);
        properties.put("com.bigdata.namespace.kb.spo.com.bigdata.btree.BTree.branchingFactor", "1024");
        properties.put("com.bigdata.namespace.kb.lex.com.bigdata.btree.BTree.branchingFactor", "400");
        Properties p = this.m_mgr.getPreparedProperties(namespace, properties);
        TestMultiTenancyAPI.assertTrue((boolean)p.containsKey("com.bigdata.namespace." + namespace + ".spo.com.bigdata.btree.BTree.branchingFactor"));
        TestMultiTenancyAPI.assertTrue((boolean)p.containsKey("com.bigdata.namespace." + namespace + ".lex.com.bigdata.btree.BTree.branchingFactor"));
    }

    public void test_PreparedPropertiesNotContainOldValues() throws Exception {
        String namespace = "newNamespace";
        Properties properties = new Properties();
        properties.put("com.bigdata.rdf.sail.namespace", namespace);
        properties.put("com.bigdata.namespace.kb.spo.com.bigdata.btree.BTree.branchingFactor", "1024");
        properties.put("com.bigdata.namespace.kb.lex.com.bigdata.btree.BTree.branchingFactor", "400");
        Properties p = this.m_mgr.getPreparedProperties(namespace, properties);
        TestMultiTenancyAPI.assertFalse((boolean)p.containsKey("com.bigdata.namespace.kb.spo.com.bigdata.btree.BTree.branchingFactor"));
        TestMultiTenancyAPI.assertFalse((boolean)p.containsKey("com.bigdata.namespace.kb.lex.com.bigdata.btree.BTree.branchingFactor"));
    }

    public void test_PropertiesBlackList() throws Exception {
        String namespace = "newNamespace";
        Properties properties = new Properties();
        properties.put("com.bigdata.rdf.sail.namespace", namespace);
        TestMultiTenancyAPI.assertTrue((boolean)MultiTenancyServlet.PROPERTIES_BLACK_LIST.contains(Journal.Options.FILE));
        properties.put(Journal.Options.FILE, Boolean.TRUE.toString());
        Properties p = this.m_mgr.getPreparedProperties(namespace, properties);
        for (String property : MultiTenancyServlet.PROPERTIES_BLACK_LIST) {
            TestMultiTenancyAPI.assertFalse((boolean)p.containsKey(property));
        }
    }

    public void test_create01() throws Exception {
        String namespace2 = "kb2-" + UUID.randomUUID();
        this.doTestCreate(namespace2);
    }

    public void test_create02() throws Exception {
        String namespace2 = "kb2-" + UUID.randomUUID() + "-&<>-foo";
        this.doTestCreate(namespace2);
    }

    public void test_create03() throws Exception {
        List<String> incorrectNamespaces = Arrays.asList("", "te.st");
        for (String incorrectNamespace : incorrectNamespaces) {
            try {
                this.doTestCreate(incorrectNamespace);
                TestMultiTenancyAPI.fail((String)"Expecting: 500");
            }
            catch (HttpException ex) {
                TestMultiTenancyAPI.assertEquals((int)500, (int)ex.getStatusCode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTestCreate(String namespace2) throws Exception {
        log.warn((Object)("DO_TEST_CREATE - default namespace " + this.namespace));
        this.m_mgr.getRepositoryProperties(this.namespace);
        log.warn((Object)("Got properties for " + this.namespace));
        Properties properties = new Properties();
        properties.setProperty(BigdataSail.Options.NAMESPACE, namespace2);
        try {
            this.m_mgr.getRepositoryProperties(namespace2);
            TestMultiTenancyAPI.fail((String)("Should not exist: " + namespace2));
        }
        catch (HttpException ex) {
            TestMultiTenancyAPI.assertEquals((int)404, (int)ex.getStatusCode());
        }
        this.m_mgr.createRepository(namespace2, properties);
        Properties p = this.m_mgr.getRepositoryProperties(namespace2);
        TestMultiTenancyAPI.assertNotNull((Object)p);
        log.warn((Object)("Found properties for namespace " + namespace2));
        try {
            this.m_mgr.createRepository(namespace2, properties);
            TestMultiTenancyAPI.fail((String)"Expecting: 409");
        }
        catch (HttpException ex) {
            TestMultiTenancyAPI.assertEquals((int)409, (int)ex.getStatusCode());
        }
        Map<String, VoidSummary> summaries = TestMultiTenancyAPI.indexOnNamespace(this.getRepositoryDescriptions().values());
        if (summaries.size() < 2) {
            TestMultiTenancyAPI.fail((String)("Expecting at least 2 summaries, but only have " + summaries.size()));
        }
        VoidSummary defaultKb = summaries.get(this.namespace);
        TestMultiTenancyAPI.assertNotNull((Object)defaultKb);
        TestMultiTenancyAPI.assertFalse((boolean)defaultKb.sparqlEndpoint.isEmpty());
        VoidSummary otherKb = summaries.get(namespace2);
        TestMultiTenancyAPI.assertNotNull((Object)otherKb);
        TestMultiTenancyAPI.assertFalse((boolean)otherKb.sparqlEndpoint.isEmpty());
        log.warn((Object)("Found summaries for namespaces: " + this.namespace + " & " + namespace2));
        Iterator<Map.Entry<String, VoidSummary>> itr = summaries.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<String, VoidSummary> e = itr.next();
            if (e.getKey().equals(this.namespace) || e.getKey().equals(namespace2)) continue;
            itr.remove();
        }
        TestMultiTenancyAPI.assertEquals((int)2, (int)summaries.size());
        int ndatasets = summaries.size();
        int nsindex = 0;
        for (VoidSummary summary : summaries.values()) {
            String ns = summary.namespace.stringValue();
            log.warn((Object)("Looking for namespace " + nsindex++ + " " + ns));
            Properties p2 = null;
            try {
                log.warn((Object)("Fetching properties " + ns));
                p2 = this.m_mgr.getRepositoryProperties(ns);
            }
            catch (Throwable t) {
                log.warn((Object)("Couldn't get properties for " + ns), t);
                TestMultiTenancyAPI.fail((String)"Couldn't get the properties", (Throwable)t);
            }
            TestMultiTenancyAPI.assertEquals((String)ns, (String)p2.getProperty(RelationSchema.NAMESPACE));
            log.warn((Object)("Found schema for " + ns));
            RemoteRepository tmp = this.m_mgr.getRepositoryForNamespace(ns);
            RemoteRepository.asGraph((GraphQueryResult)tmp.getServiceDescription());
            TupleQueryResult result = tmp.prepareTupleQuery("SELECT (COUNT(*) as ?count) {?s ?p ?o}").evaluate();
            long nresults = TestMultiTenancyAPI.countResults(result);
            if (log.isInfoEnabled()) {
                log.info((Object)("namespace=" + ns + ", triples=" + nresults));
            }
            tmp.prepareUpdate("PREFIX : <http://www.bigdata.com> \nINSERT DATA {:a :b :c}").evaluate();
            this.m_mgr.deleteRepository(ns);
            log.warn((Object)("Removing repository: " + ns));
            --ndatasets;
            Map<String, VoidSummary> summaries2 = TestMultiTenancyAPI.indexOnNamespace(this.getRepositoryDescriptions().values());
            TestMultiTenancyAPI.assertNull((Object)summaries2.get(ns));
            try {
                this.m_mgr.getRepositoryProperties(ns);
                TestMultiTenancyAPI.fail((String)"Expecting 404");
            }
            catch (HttpException ex) {
                TestMultiTenancyAPI.assertEquals((int)404, (int)ex.getStatusCode());
            }
            try {
                tmp.getServiceDescription();
                TestMultiTenancyAPI.fail((String)"Expecting 404");
            }
            catch (HttpException ex) {
                TestMultiTenancyAPI.assertEquals((int)404, (int)ex.getStatusCode());
            }
            result = null;
            try {
                result = tmp.prepareTupleQuery("SELECT (COUNT(*) as ?count) {?s ?p ?o}").evaluate();
                TestMultiTenancyAPI.fail((String)"Expecting 404");
            }
            catch (HttpException ex) {
                TestMultiTenancyAPI.assertEquals((int)404, (int)ex.getStatusCode());
            }
            finally {
                if (result != null) {
                    result.close();
                }
            }
            try {
                tmp.prepareUpdate("PREFIX : <http://www.bigdata.com> \nINSERT DATA {:a :b :c}").evaluate();
                TestMultiTenancyAPI.fail((String)"Expecting 404");
            }
            catch (HttpException ex) {
                TestMultiTenancyAPI.assertEquals((int)404, (int)ex.getStatusCode());
            }
        }
    }

    public void testEOFStreams() throws IOException {
        InputStream closed = IO.getClosedStream();
        TestMultiTenancyAPI.assertTrue((closed.read() == -1 ? 1 : 0) != 0);
    }

    static class VoidSummary {
        final Graph g;
        final Resource dataset;
        final List<Literal> title = new LinkedList<Literal>();
        final Literal namespace;
        final List<URI> sparqlEndpoint = new LinkedList<URI>();

        public VoidSummary(Resource dataset, Graph g) {
            this.dataset = dataset;
            this.g = g;
            for (Statement x : AbstractTestNanoSparqlClient.getMatches(g, dataset, DCTermsVocabularyDecl.title, null)) {
                this.title.add((Literal)x.getObject());
            }
            Literal namespace = null;
            for (Statement x : AbstractTestNanoSparqlClient.getMatches(g, dataset, DCTermsVocabularyDecl.title, null)) {
                if (namespace != null) {
                    throw new RuntimeException("Multiple declarations of the namespace?");
                }
                namespace = (Literal)x.getObject();
            }
            this.namespace = namespace;
            for (Statement x : AbstractTestNanoSparqlClient.getMatches(g, dataset, VoidVocabularyDecl.sparqlEndpoint, null)) {
                this.sparqlEndpoint.add((URI)x.getObject());
            }
        }
    }
}

