/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp;

import com.bigdata.rdf.sail.webapp.client.EntityContentProvider;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.entity.mime.FormBodyPart;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ByteArrayBody;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.message.BasicNameValuePair;
import org.eclipse.jetty.client.api.ContentProvider;

public class TestMultipartContent
extends TestCase {
    public void testSimpleFormContent() throws UnsupportedEncodingException {
        ArrayList<BasicNameValuePair> formparams = new ArrayList<BasicNameValuePair>();
        formparams.add(new BasicNameValuePair("First Name", "Martyn"));
        formparams.add(new BasicNameValuePair("Last Name", "Cutcher"));
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(formparams, "UTF-8");
        EntityContentProvider content = new EntityContentProvider((HttpEntity)entity);
        System.out.println(new String(entity.getContentType().toString()));
    }

    private HttpEntity getUpdateEntity() {
        Random r = new Random();
        byte[] data = new byte[256];
        MultipartEntity entity = new MultipartEntity();
        r.nextBytes(data);
        entity.addPart(new FormBodyPart("remove", (ContentBody)new ByteArrayBody(data, "application/xml", "remove")));
        r.nextBytes(data);
        entity.addPart(new FormBodyPart("add", (ContentBody)new ByteArrayBody(data, "application/xml", "add")));
        return entity;
    }

    public void testApacheUpdate() throws UnsupportedOperationException, IOException {
        HttpEntity entity = this.getUpdateEntity();
        ByteArrayOutputStream outstr = new ByteArrayOutputStream();
        entity.writeTo((OutputStream)outstr);
        System.out.println(new String(outstr.toByteArray()));
    }

    public void testJettyUpdate() throws UnsupportedOperationException, IOException {
        HttpEntity entity = this.getUpdateEntity();
        EntityContentProvider cp = new EntityContentProvider(entity);
        ByteArrayOutputStream outstr = new ByteArrayOutputStream();
        for (ByteBuffer bb : cp) {
            outstr.write(bb.array());
        }
        System.out.println(new String(outstr.toByteArray()));
    }

    void display(ContentProvider cp) {
        Iterator iter = cp.iterator();
        while (iter.hasNext()) {
            System.out.println(new String(((ByteBuffer)iter.next()).array()));
        }
    }
}

