/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp;

import com.bigdata.BigdataStatics;
import com.bigdata.journal.AbstractJournal;
import com.bigdata.journal.BufferMode;
import com.bigdata.journal.IIndexManager;
import com.bigdata.journal.Journal;
import com.bigdata.journal.Options;
import com.bigdata.journal.RWStrategy;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.webapp.AbstractIndexManagerTestCase;
import com.bigdata.rdf.sail.webapp.HashDistinctNamedGraphUpdateTest;
import com.bigdata.rdf.sail.webapp.NativeDistinctNamedGraphUpdateTest;
import com.bigdata.rdf.sail.webapp.ProxySuiteHelper;
import com.bigdata.rdf.sail.webapp.StressTestConcurrentRestApiRequests;
import com.bigdata.rdf.sail.webapp.StressTest_REST_MultiTenancy;
import com.bigdata.rdf.sail.webapp.TestBackupServlet;
import com.bigdata.rdf.sail.webapp.TestBigdataSailRemoteRepository;
import com.bigdata.rdf.sail.webapp.TestCBD731;
import com.bigdata.rdf.sail.webapp.TestDataLoaderServlet;
import com.bigdata.rdf.sail.webapp.TestFederatedQuery;
import com.bigdata.rdf.sail.webapp.TestInsertFilterFalse727;
import com.bigdata.rdf.sail.webapp.TestMode;
import com.bigdata.rdf.sail.webapp.TestMultiTenancyAPI;
import com.bigdata.rdf.sail.webapp.TestNanoSparqlClient;
import com.bigdata.rdf.sail.webapp.TestProtocolAll;
import com.bigdata.rdf.sail.webapp.TestRDROperations;
import com.bigdata.rdf.sail.webapp.TestRWStoreTxBehaviors;
import com.bigdata.rdf.sail.webapp.TestRebuildTextIndex;
import com.bigdata.rdf.sail.webapp.TestService794;
import com.bigdata.rdf.sail.webapp.TestSparqlUpdate;
import com.bigdata.rdf.sail.webapp.TestSparqlUpdateSuppressTruthMaintenance;
import com.bigdata.rdf.sail.webapp.Test_REST_ASK;
import com.bigdata.rdf.sail.webapp.Test_REST_DELETE_BY_ACCESS_PATH;
import com.bigdata.rdf.sail.webapp.Test_REST_DELETE_WITH_BODY;
import com.bigdata.rdf.sail.webapp.Test_REST_DESCRIBE;
import com.bigdata.rdf.sail.webapp.Test_REST_ESTCARD;
import com.bigdata.rdf.sail.webapp.Test_REST_HASSTMT;
import com.bigdata.rdf.sail.webapp.Test_REST_ServiceDescription;
import com.bigdata.rdf.sail.webapp.Test_REST_Structure;
import com.bigdata.rdf.sail.webapp.Test_REST_TX_API;
import com.bigdata.rdf.sail.webapp.Test_Ticket_1207;
import com.bigdata.rdf.sail.webapp.Test_Ticket_1893;
import com.bigdata.rdf.sail.webapp.Test_Ticket_605;
import com.bigdata.service.AbstractDistributedFederation;
import com.bigdata.service.AbstractScaleOutClient;
import com.bigdata.service.IBigdataFederation;
import com.bigdata.service.ScaleOutClientFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import junit.extensions.proxy.ProxyTestSuite;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import junit.textui.ResultPrinter;

public class TestNanoSparqlServerWithProxyIndexManager<S extends IIndexManager>
extends AbstractIndexManagerTestCase<S> {
    private IIndexManager m_indexManager;
    private TestMode testMode;

    public TestNanoSparqlServerWithProxyIndexManager() {
        this(null, (IIndexManager)TestNanoSparqlServerWithProxyIndexManager.getTemporaryJournal(BufferMode.DiskRW), TestMode.triples);
    }

    public TestNanoSparqlServerWithProxyIndexManager(String name) {
        this(name, (IIndexManager)TestNanoSparqlServerWithProxyIndexManager.getTemporaryJournal(BufferMode.DiskRW), TestMode.triples);
    }

    static Journal getTemporaryJournal() {
        return TestNanoSparqlServerWithProxyIndexManager.getTemporaryJournal(BufferMode.Transient);
    }

    static Journal getTemporaryJournal(BufferMode bufferMode) {
        if (bufferMode == null) {
            throw new IllegalArgumentException();
        }
        Properties properties = new Properties();
        properties.setProperty(Options.BUFFER_MODE, bufferMode.toString());
        properties.setProperty(Journal.Options.GROUP_COMMIT, "false");
        if (bufferMode.isStable()) {
            properties.setProperty(Options.CREATE_TEMP_FILE, "true");
            properties.setProperty(Options.DELETE_ON_CLOSE, "true");
        } else if (bufferMode.isFullyBuffered()) {
            properties.setProperty(Options.INITIAL_EXTENT, "1048576");
        }
        Journal jnl = new Journal(properties);
        return jnl;
    }

    private TestNanoSparqlServerWithProxyIndexManager(String name, IIndexManager indexManager, TestMode testMode) {
        super(name == null ? TestNanoSparqlServerWithProxyIndexManager.class.getName() : name);
        this.m_indexManager = indexManager;
        this.testMode = testMode;
    }

    public static Test suite() {
        return TestNanoSparqlServerWithProxyIndexManager.suite(TestMode.triples);
    }

    public static Test suite(TestMode testMode) {
        return TestNanoSparqlServerWithProxyIndexManager.suite((IIndexManager)TestNanoSparqlServerWithProxyIndexManager.getTemporaryJournal(), testMode);
    }

    public static TestSuite suite(IIndexManager indexManager, TestMode testMode) {
        boolean RWStoreMode = indexManager instanceof AbstractJournal && ((AbstractJournal)indexManager).getBufferStrategy() instanceof RWStrategy;
        ProxyTestSuite suite = TestNanoSparqlServerWithProxyIndexManager.createProxyTestSuite(indexManager, testMode);
        if (RWStoreMode) {
            suite.addTestSuite(TestRWStoreTxBehaviors.class);
            suite.addTestSuite(TestBackupServlet.class);
        } else {
            suite.addTest(TestProtocolAll.suite());
            suite.addTestSuite(Test_REST_Structure.class);
            suite.addTestSuite(Test_REST_ASK.class);
            suite.addTestSuite(Test_REST_DESCRIBE.class);
            suite.addTestSuite(Test_REST_ESTCARD.class);
            if (BigdataStatics.runKnownBadTests) {
                suite.addTestSuite(Test_REST_ESTCARD.ReadWriteTx.class);
            }
            suite.addTestSuite(Test_REST_HASSTMT.class);
            if (BigdataStatics.runKnownBadTests) {
                suite.addTestSuite(Test_REST_HASSTMT.ReadWriteTx.class);
            }
            if (testMode.isTruthMaintenanceSupported()) {
                suite.addTestSuite(Test_REST_HASSTMT.TruthMaintenance.class);
            }
            if (testMode == TestMode.triplesPlusTruthMaintenance) {
                suite.addTestSuite(Test_Ticket_1207.class);
                suite.addTestSuite(TestSparqlUpdateSuppressTruthMaintenance.class);
            }
            suite.addTestSuite(Test_REST_ServiceDescription.class);
            suite.addTestSuite(Test_REST_DELETE_BY_ACCESS_PATH.class);
            suite.addTestSuite(Test_REST_DELETE_WITH_BODY.class);
            suite.addTestSuite(TestNanoSparqlClient.class);
            suite.addTestSuite(TestMultiTenancyAPI.class);
            suite.addTestSuite(TestDataLoaderServlet.class);
            suite.addTestSuite(Test_REST_TX_API.class);
            suite.addTestSuite(Test_REST_TX_API.NoReadWriteTx.class);
            suite.addTestSuite(Test_REST_TX_API.ReadWriteTx.class);
            suite.addTestSuite(TestBigdataSailRemoteRepository.class);
            suite.addTestSuite(TestBigdataSailRemoteRepository.ReadWriteTx.class);
            suite.addTestSuite(TestInsertFilterFalse727.class);
            suite.addTestSuite(TestCBD731.class);
            suite.addTestSuite(Test_Ticket_605.class);
            suite.addTestSuite(TestService794.class);
            suite.addTestSuite(TestRebuildTextIndex.class);
            suite.addTestSuite(Test_Ticket_1893.class);
            if (testMode == TestMode.sids) {
                suite.addTestSuite(TestRDROperations.class);
            }
            if (testMode == TestMode.quads) {
                suite.addTestSuite(TestSparqlUpdate.class);
                suite.addTestSuite(StressTestConcurrentRestApiRequests.class);
                suite.addTestSuite(NativeDistinctNamedGraphUpdateTest.class);
                suite.addTestSuite(HashDistinctNamedGraphUpdateTest.class);
            }
            suite.addTestSuite(StressTest_REST_MultiTenancy.class);
            suite.addTestSuite(StressTestConcurrentRestApiRequests.class);
            suite.addTestSuite(TestFederatedQuery.class);
        }
        return suite;
    }

    static ProxyTestSuite createProxyTestSuite(IIndexManager indexManager, TestMode testMode) {
        TestNanoSparqlServerWithProxyIndexManager delegate = new TestNanoSparqlServerWithProxyIndexManager(null, indexManager, testMode);
        ProxyTestSuite suite = new ProxyTestSuite(delegate, "NanoSparqlServer Proxied Test Suite: indexManager=" + indexManager.getClass().getSimpleName() + ", testMode=" + (Object)((Object)testMode) + ", bufferMode=" + (indexManager instanceof Journal ? ((Journal)indexManager).getBufferStrategy().getBufferMode() : ""));
        return suite;
    }

    @Override
    public S getIndexManager() {
        return (S)this.m_indexManager;
    }

    @Override
    public Properties getProperties() {
        if (this.testMode == null) {
            throw new IllegalStateException();
        }
        return this.testMode.getProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IIndexManager openIndexManager(String propertyFile) {
        IBigdataFederation indexManager;
        block13: {
            File file = new File(propertyFile);
            if (!file.exists()) {
                throw new RuntimeException("Could not find file: " + file);
            }
            boolean isJini = false;
            if (propertyFile.endsWith(".config")) {
                isJini = true;
            } else if (propertyFile.endsWith(".properties")) {
                isJini = false;
            } else {
                throw new RuntimeException("File must have '.config' or '.properties' extension: " + file);
            }
            try {
                if (isJini) {
                    AbstractScaleOutClient jiniClient = ScaleOutClientFactory.getJiniClient((String[])new String[]{propertyFile});
                    indexManager = jiniClient.connect();
                    break block13;
                }
                Properties properties = new Properties();
                try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(propertyFile));){
                    properties.load(is);
                }
                if (System.getProperty(BigdataSail.Options.FILE) != null) {
                    properties.setProperty(BigdataSail.Options.FILE, System.getProperty(BigdataSail.Options.FILE));
                }
                if (properties.getProperty(Options.FILE) == null) {
                    properties.setProperty(Options.BUFFER_MODE, BufferMode.Transient.toString());
                    properties.setProperty(Options.INITIAL_EXTENT, "1048576");
                }
                indexManager = new Journal(properties);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return indexManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("(triples|sids|quads) (propertyFile|configFile) (tm)?");
            System.exit(1);
        }
        TestMode testMode = TestMode.valueOf(args[0]);
        File propertyFile = new File(args[1]);
        if (!propertyFile.exists()) {
            TestNanoSparqlServerWithProxyIndexManager.fail((String)("No such file: " + propertyFile));
        }
        TestResult result = new TestResult();
        result.addListener((TestListener)new ResultPrinter(System.out));
        result.addListener(new TestListener(){

            public void startTest(Test arg0) {
                log.info((Object)arg0);
            }

            public void endTest(Test arg0) {
                log.info((Object)arg0);
            }

            public void addFailure(Test arg0, AssertionFailedError arg1) {
                log.error((Object)arg0, (Throwable)arg1);
            }

            public void addError(Test arg0, Throwable arg1) {
                log.error((Object)arg0, arg1);
            }
        });
        IIndexManager indexManager = TestNanoSparqlServerWithProxyIndexManager.openIndexManager(propertyFile.getAbsolutePath());
        try {
            TestSuite test = TestNanoSparqlServerWithProxyIndexManager.suite(indexManager, testMode);
            test.run(result);
        }
        finally {
            if (indexManager instanceof AbstractDistributedFederation) {
                ((AbstractDistributedFederation)indexManager).shutdownNow();
            } else {
                ((Journal)indexManager).destroy();
            }
        }
        String msg = "nerrors=" + result.errorCount() + ", nfailures=" + result.failureCount() + ", nrun=" + result.runCount();
        if (result.errorCount() > 0 || result.failureCount() > 0) {
            TestNanoSparqlServerWithProxyIndexManager.fail((String)msg);
        }
        System.out.println(msg);
    }

    @Override
    public void tearDownAfterSuite() {
        this.m_indexManager.destroy();
        this.m_indexManager = null;
    }

    static {
        ProxySuiteHelper.proxyIndexManagerTestingHasStarted = true;
    }

    public static class Test_NSS_sids
    extends TestCase {
        public static Test suite() {
            return TestNanoSparqlServerWithProxyIndexManager.suite((IIndexManager)TestNanoSparqlServerWithProxyIndexManager.getTemporaryJournal(), TestMode.sids);
        }
    }

    public static class Test_NSS_quads
    extends TestCase {
        public static Test suite() {
            return TestNanoSparqlServerWithProxyIndexManager.suite((IIndexManager)TestNanoSparqlServerWithProxyIndexManager.getTemporaryJournal(), TestMode.quads);
        }
    }

    public static class test_NSS_RWStore
    extends TestCase {
        public static Test suite() {
            return TestNanoSparqlServerWithProxyIndexManager.suite((IIndexManager)TestNanoSparqlServerWithProxyIndexManager.getTemporaryJournal(BufferMode.DiskRW), TestMode.triples);
        }
    }

    public static class test_NSS_triples
    extends TestCase {
        public static Test suite() {
            return TestNanoSparqlServerWithProxyIndexManager.suite((IIndexManager)TestNanoSparqlServerWithProxyIndexManager.getTemporaryJournal(), TestMode.triples);
        }
    }
}

