/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp;

import com.bigdata.journal.BufferMode;
import com.bigdata.journal.IIndexManager;
import com.bigdata.journal.Journal;
import com.bigdata.journal.Options;
import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.webapp.AbstractIndexManagerTestCase;
import com.bigdata.rdf.sail.webapp.ProxySuiteHelper;
import com.bigdata.rdf.sail.webapp.TestDataLoaderServlet;
import com.bigdata.rdf.sail.webapp.TestMode;
import com.bigdata.rdf.sail.webapp.TestMultiTenancyAPI;
import com.bigdata.rdf.sail.webapp.TestProtocolAll;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.vocab.NoVocabulary;
import com.bigdata.service.AbstractDistributedFederation;
import com.bigdata.service.AbstractScaleOutClient;
import com.bigdata.service.IBigdataFederation;
import com.bigdata.service.ScaleOutClientFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import junit.extensions.proxy.ProxyTestSuite;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.textui.ResultPrinter;

public class TestNanoSparqlServerWithProxyIndexManager2<S extends IIndexManager>
extends AbstractIndexManagerTestCase<S> {
    private IIndexManager m_indexManager;
    private TestMode testMode;

    public TestNanoSparqlServerWithProxyIndexManager2() {
        this(null, (IIndexManager)TestNanoSparqlServerWithProxyIndexManager2.getTemporaryJournal(), TestMode.triples);
    }

    public TestNanoSparqlServerWithProxyIndexManager2(String name) {
        this(name, (IIndexManager)TestNanoSparqlServerWithProxyIndexManager2.getTemporaryJournal(), TestMode.triples);
    }

    private static Journal getTemporaryJournal() {
        Properties properties = new Properties();
        properties.setProperty(Options.BUFFER_MODE, BufferMode.Transient.toString());
        properties.setProperty(Options.INITIAL_EXTENT, "1048576");
        return new Journal(properties);
    }

    private TestNanoSparqlServerWithProxyIndexManager2(String name, IIndexManager indexManager, TestMode testMode) {
        super(name == null ? TestNanoSparqlServerWithProxyIndexManager2.class.getName() : name);
        this.m_indexManager = indexManager;
        this.testMode = testMode;
    }

    public static Test suite() {
        return TestNanoSparqlServerWithProxyIndexManager2.suite(TestMode.triples);
    }

    public static Test suite(TestMode testMode) {
        return TestNanoSparqlServerWithProxyIndexManager2.suite((IIndexManager)TestNanoSparqlServerWithProxyIndexManager2.getTemporaryJournal(), testMode);
    }

    public static Test suite(IIndexManager indexManager, TestMode testMode) {
        TestNanoSparqlServerWithProxyIndexManager2 delegate = new TestNanoSparqlServerWithProxyIndexManager2(null, indexManager, testMode);
        ProxyTestSuite suite = new ProxyTestSuite(delegate, "NanoSparqlServer Proxied Test Suite");
        suite.addTest(TestProtocolAll.suite());
        suite.addTestSuite(TestMultiTenancyAPI.class);
        suite.addTestSuite(TestDataLoaderServlet.class);
        return suite;
    }

    @Override
    public S getIndexManager() {
        return (S)this.m_indexManager;
    }

    @Override
    public Properties getProperties() {
        Properties properties = new Properties();
        switch (this.testMode) {
            case quads: {
                properties.setProperty(AbstractTripleStore.Options.QUADS_MODE, "true");
                properties.setProperty(BigdataSail.Options.TRUTH_MAINTENANCE, "false");
                properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
                properties.setProperty(AbstractTripleStore.Options.VOCABULARY_CLASS, NoVocabulary.class.getName());
                properties.setProperty(AbstractTripleStore.Options.STATEMENT_IDENTIFIERS, "false");
                break;
            }
            case triples: {
                properties.setProperty(BigdataSail.Options.TRUTH_MAINTENANCE, "false");
                properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
                properties.setProperty(AbstractTripleStore.Options.VOCABULARY_CLASS, NoVocabulary.class.getName());
                properties.setProperty(AbstractTripleStore.Options.STATEMENT_IDENTIFIERS, "false");
                break;
            }
            case sids: {
                properties.setProperty(BigdataSail.Options.TRUTH_MAINTENANCE, "false");
                properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
                properties.setProperty(AbstractTripleStore.Options.VOCABULARY_CLASS, NoVocabulary.class.getName());
                properties.setProperty(AbstractTripleStore.Options.STATEMENT_IDENTIFIERS, "true");
                break;
            }
            default: {
                TestNanoSparqlServerWithProxyIndexManager2.fail((String)("Unknown mode: " + (Object)((Object)this.testMode)));
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IIndexManager openIndexManager(String propertyFile) {
        IBigdataFederation indexManager;
        block13: {
            File file = new File(propertyFile);
            if (!file.exists()) {
                throw new RuntimeException("Could not find file: " + file);
            }
            boolean isJini = false;
            if (propertyFile.endsWith(".config")) {
                isJini = true;
            } else if (propertyFile.endsWith(".properties")) {
                isJini = false;
            } else {
                throw new RuntimeException("File must have '.config' or '.properties' extension: " + file);
            }
            try {
                if (isJini) {
                    AbstractScaleOutClient jiniClient = ScaleOutClientFactory.getJiniClient((String[])new String[]{propertyFile});
                    indexManager = jiniClient.connect();
                    break block13;
                }
                Properties properties = new Properties();
                try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(propertyFile));){
                    properties.load(is);
                }
                if (System.getProperty(BigdataSail.Options.FILE) != null) {
                    properties.setProperty(BigdataSail.Options.FILE, System.getProperty(BigdataSail.Options.FILE));
                }
                if (properties.getProperty(Options.FILE) == null) {
                    properties.setProperty(Options.BUFFER_MODE, BufferMode.Transient.toString());
                    properties.setProperty(Options.INITIAL_EXTENT, "1048576");
                }
                indexManager = new Journal(properties);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return indexManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("(triples|sids|quads) (propertyFile|configFile) (tm)?");
            System.exit(1);
        }
        TestMode testMode = TestMode.valueOf(args[0]);
        File propertyFile = new File(args[1]);
        if (!propertyFile.exists()) {
            TestNanoSparqlServerWithProxyIndexManager2.fail((String)("No such file: " + propertyFile));
        }
        TestResult result = new TestResult();
        result.addListener((TestListener)new ResultPrinter(System.out));
        result.addListener(new TestListener(){

            public void startTest(Test arg0) {
                log.info((Object)arg0);
            }

            public void endTest(Test arg0) {
                log.info((Object)arg0);
            }

            public void addFailure(Test arg0, AssertionFailedError arg1) {
                log.error((Object)arg0, (Throwable)arg1);
            }

            public void addError(Test arg0, Throwable arg1) {
                log.error((Object)arg0, arg1);
            }
        });
        IIndexManager indexManager = TestNanoSparqlServerWithProxyIndexManager2.openIndexManager(propertyFile.getAbsolutePath());
        try {
            Test test = TestNanoSparqlServerWithProxyIndexManager2.suite(indexManager, testMode);
            test.run(result);
        }
        finally {
            if (indexManager instanceof AbstractDistributedFederation) {
                ((AbstractDistributedFederation)indexManager).shutdownNow();
            } else {
                ((Journal)indexManager).destroy();
            }
        }
        String msg = "nerrors=" + result.errorCount() + ", nfailures=" + result.failureCount() + ", nrun=" + result.runCount();
        if (result.errorCount() > 0 || result.failureCount() > 0) {
            TestNanoSparqlServerWithProxyIndexManager2.fail((String)msg);
        }
        System.out.println(msg);
    }

    static {
        ProxySuiteHelper.proxyIndexManagerTestingHasStarted = true;
    }

    public static class Test_NSS_sids
    extends TestCase {
        public static Test suite() {
            return TestNanoSparqlServerWithProxyIndexManager2.suite((IIndexManager)TestNanoSparqlServerWithProxyIndexManager2.getTemporaryJournal(), TestMode.sids);
        }
    }

    public static class Test_NSS_quads
    extends TestCase {
        public static Test suite() {
            return TestNanoSparqlServerWithProxyIndexManager2.suite((IIndexManager)TestNanoSparqlServerWithProxyIndexManager2.getTemporaryJournal(), TestMode.quads);
        }
    }

    public static class test_NSS_triples
    extends TestCase {
        public static Test suite() {
            return TestNanoSparqlServerWithProxyIndexManager2.suite((IIndexManager)TestNanoSparqlServerWithProxyIndexManager2.getTemporaryJournal(), TestMode.triples);
        }
    }
}

