/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp;

import com.bigdata.rdf.sail.webapp.AbstractProtocolTest;
import com.bigdata.rdf.sail.webapp.ProxySuiteHelper;
import com.bigdata.rdf.sail.webapp.TestMode;
import java.io.IOException;
import junit.framework.Test;

public class TestPostNotURLEncoded
extends AbstractProtocolTest {
    public static Test suite() {
        return ProxySuiteHelper.suiteWhenStandalone(TestPostNotURLEncoded.class, "test.*", TestMode.quads, TestMode.sids, TestMode.triples);
    }

    public TestPostNotURLEncoded(String name) {
        super(name);
    }

    public void testSelectPostXML() throws IOException {
        this.setMethodisPost("application/sparql-query", "SELECT (1 as ?one){}");
        TestPostNotURLEncoded.assertTrue((boolean)this.serviceRequest(new String[0]).contains("</sparql>"));
        TestPostNotURLEncoded.assertEquals((String)"application/sparql-results+xml", (String)this.getResponseContentType());
    }

    public void testSelectPostJSON() throws IOException {
        this.setAccept("application/sparql-results+json");
        this.setMethodisPost("application/sparql-query", "SELECT (1 as ?one){}");
        TestPostNotURLEncoded.assertTrue((boolean)this.serviceRequest(new String[0]).contains("results"));
        TestPostNotURLEncoded.assertEquals((String)"application/sparql-results+json", (String)this.getResponseContentType());
    }

    public void testAskPostXML() throws IOException {
        this.setMethodisPost("application/sparql-query", "ASK WHERE {}");
        TestPostNotURLEncoded.assertTrue((boolean)this.serviceRequest(new String[0]).contains("</sparql>"));
        TestPostNotURLEncoded.assertEquals((String)"application/sparql-results+xml", (String)this.getResponseContentType());
    }

    public void testAskPostJSON() throws IOException {
        this.setAccept("application/sparql-results+json");
        this.setMethodisPost("application/sparql-query", "ASK WHERE {}");
        String response = this.serviceRequest("query", "ASK WHERE {}");
        TestPostNotURLEncoded.assertTrue((String)("Bad response: " + response), (boolean)response.contains("boolean"));
        TestPostNotURLEncoded.assertEquals((String)"application/sparql-results+json", (String)this.getResponseContentType());
    }

    public void testUpdatePost() throws IOException {
        this.checkUpdate(false);
        this.setMethodisPost("application/sparql-update", this.update);
        this.serviceRequest(new String[0]);
        this.checkUpdate(true);
    }
}

